/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple.memory;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.tuple.memory.MemoryBlock;
import org.apache.tajo.tuple.memory.ResizableMemoryBlock;
import org.apache.tajo.tuple.memory.UnSafeTuple;
import org.apache.tajo.util.Deallocatable;

public class DirectBufTuple
extends UnSafeTuple
implements Deallocatable {
    private MemoryBlock memoryBlock;

    public DirectBufTuple(TajoDataTypes.DataType[] types) {
        ByteBuffer bb = ByteBuffer.allocateDirect(this.getLength()).order(ByteOrder.LITTLE_ENDIAN);
        this.memoryBlock = new ResizableMemoryBlock(bb);
        this.set(this.memoryBlock, 0, types);
    }

    @Override
    public void release() {
        this.memoryBlock.release();
    }
}

