/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple.memory;

import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.nio.channels.ScatteringByteChannel;
import org.apache.tajo.annotation.NotThreadSafe;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.exception.NotImplementedException;
import org.apache.tajo.exception.TajoInternalError;
import org.apache.tajo.tuple.RowBlockReader;
import org.apache.tajo.tuple.memory.CompactRowBlockWriter;
import org.apache.tajo.tuple.memory.HeapRowBlockReader;
import org.apache.tajo.tuple.memory.MemoryBlock;
import org.apache.tajo.tuple.memory.OffHeapRowBlockReader;
import org.apache.tajo.tuple.memory.OffHeapRowBlockWriter;
import org.apache.tajo.tuple.memory.ResizableLimitSpec;
import org.apache.tajo.tuple.memory.ResizableMemoryBlock;
import org.apache.tajo.tuple.memory.RowBlock;
import org.apache.tajo.tuple.memory.RowWriter;
import org.apache.tajo.util.Deallocatable;
import org.apache.tajo.util.TUtil;

@NotThreadSafe
public class MemoryRowBlock
implements RowBlock,
Deallocatable {
    public static final int NULL_FIELD_OFFSET = -1;
    private final TajoDataTypes.DataType[] dataTypes;
    private final String dataFormat;
    private int maxRowNum = Integer.MAX_VALUE;
    private int rowNum;
    private RowWriter builder;
    private MemoryBlock memory;

    public MemoryRowBlock(TajoDataTypes.DataType[] dataTypes, ResizableLimitSpec limitSpec, boolean isDirect) {
        this(dataTypes, limitSpec, isDirect, "DRAW");
    }

    public MemoryRowBlock(TajoDataTypes.DataType[] dataTypes, ResizableLimitSpec limitSpec, boolean isDirect, String dataFormat) {
        this.memory = new ResizableMemoryBlock(limitSpec, isDirect);
        this.dataTypes = dataTypes;
        this.dataFormat = dataFormat;
    }

    public MemoryRowBlock(MemoryRowBlock rowBlock) {
        this.memory = TUtil.checkTypeAndGet(rowBlock.getMemory().duplicate(), ResizableMemoryBlock.class);
        this.rowNum = rowBlock.rowNum;
        this.dataTypes = rowBlock.dataTypes;
        this.dataFormat = rowBlock.dataFormat;
    }

    public MemoryRowBlock(TajoDataTypes.DataType[] dataTypes) {
        this(dataTypes, new ResizableLimitSpec(65536L), true);
    }

    public MemoryRowBlock(TajoDataTypes.DataType[] dataTypes, int bytes) {
        this(dataTypes, new ResizableLimitSpec(bytes), true);
    }

    public MemoryRowBlock(TajoDataTypes.DataType[] dataTypes, int bytes, boolean isDirect, String dataFormat) {
        this(dataTypes, new ResizableLimitSpec(bytes), isDirect, dataFormat);
    }

    @Override
    public String getDataFormat() {
        return this.dataFormat;
    }

    @Override
    public void clear() {
        this.reset();
        this.memory.clear();
    }

    private void reset() {
        this.rowNum = 0;
        if (this.builder != null) {
            this.builder.clear();
        }
    }

    @Override
    public int capacity() {
        return this.memory.capacity();
    }

    @Override
    public int usedMem() {
        return this.memory.writerPosition();
    }

    @Override
    public float usage() {
        if (this.usedMem() > 0) {
            return (float)this.usedMem() / (float)this.capacity();
        }
        return 0.0f;
    }

    public int maxRowNum() {
        return this.maxRowNum;
    }

    @Override
    public int rows() {
        return this.rowNum;
    }

    @Override
    public void setRows(int rowNum) {
        this.rowNum = rowNum;
    }

    @Override
    public TajoDataTypes.DataType[] getDataTypes() {
        return this.dataTypes;
    }

    @Override
    public boolean copyFromChannel(ScatteringByteChannel channel) throws IOException {
        switch (this.dataFormat) {
            case "DRAW": {
                return this.fillDrawBuffer(channel);
            }
        }
        throw new TajoInternalError(new NotImplementedException("Heap memory writer not implemented yet"));
    }

    protected boolean fillDrawBuffer(ScatteringByteChannel channel) throws IOException {
        this.reset();
        int readBytes = this.memory.writeBytes(channel);
        if (readBytes > 0) {
            while (this.memory.isReadable()) {
                if (this.memory.readableBytes() < 4) {
                    return true;
                }
                int recordSize = PlatformDependent.getInt((long)(this.memory.address() + (long)this.memory.readerPosition()));
                assert (recordSize > 0);
                if (this.memory.readableBytes() < recordSize) {
                    return true;
                }
                this.memory.readerPosition(this.memory.readerPosition() + recordSize);
                ++this.rowNum;
            }
            return true;
        }
        return false;
    }

    @Override
    public RowWriter getWriter() {
        if (!this.getMemory().hasAddress()) {
            throw new TajoInternalError(new NotImplementedException("Heap memory writer not implemented yet"));
        }
        if (this.builder == null) {
            switch (this.dataFormat) {
                case "DRAW": {
                    this.builder = new OffHeapRowBlockWriter(this);
                    break;
                }
                case "RAW": {
                    this.builder = new CompactRowBlockWriter(this);
                    break;
                }
                default: {
                    throw new TajoInternalError(new NotImplementedException(this.dataFormat + " memory writer not implemented yet"));
                }
            }
        }
        return this.builder;
    }

    @Override
    public MemoryBlock getMemory() {
        return this.memory;
    }

    @Override
    public void release() {
        this.memory.release();
    }

    @Override
    public RowBlockReader getReader() {
        switch (this.dataFormat) {
            case "DRAW": {
                if (!this.getMemory().hasAddress()) {
                    return new HeapRowBlockReader(this);
                }
                return new OffHeapRowBlockReader(this);
            }
        }
        throw new TajoInternalError(new NotImplementedException(this.dataFormat + " memory writer not implemented yet"));
    }
}

