/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple.memory;

import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.exception.TajoInternalError;
import org.apache.tajo.tuple.RowBlockReader;
import org.apache.tajo.tuple.memory.MemoryBlock;
import org.apache.tajo.tuple.memory.MemoryRowBlock;
import org.apache.tajo.tuple.memory.ZeroCopyTuple;

public class OffHeapRowBlockReader
implements RowBlockReader<ZeroCopyTuple> {
    private final TajoDataTypes.DataType[] dataTypes;
    private final MemoryBlock memoryBlock;
    private final int rows;
    private int curRowIdxForRead;
    private int curPosForRead;

    public OffHeapRowBlockReader(MemoryRowBlock rowBlock) {
        this(rowBlock.getMemory(), rowBlock.getDataTypes(), rowBlock.rows());
    }

    public OffHeapRowBlockReader(MemoryBlock memoryBlock, TajoDataTypes.DataType[] dataTypes, int rows) {
        this.memoryBlock = memoryBlock;
        this.dataTypes = dataTypes;
        this.rows = rows;
        if (!memoryBlock.hasAddress()) {
            throw new TajoInternalError(memoryBlock.getClass().getSimpleName() + " does not support to direct memory access");
        }
    }

    @Override
    public long remainForRead() {
        return this.memoryBlock.readableBytes();
    }

    @Override
    public boolean next(ZeroCopyTuple tuple) {
        if (this.curRowIdxForRead < this.rows) {
            tuple.set(this.memoryBlock, this.curPosForRead, this.dataTypes);
            this.curPosForRead += tuple.getLength();
            ++this.curRowIdxForRead;
            this.memoryBlock.readerPosition(this.curPosForRead);
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.curPosForRead = 0;
        this.curRowIdxForRead = 0;
        this.memoryBlock.readerPosition(this.curPosForRead);
    }
}

