/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple.memory;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.datum.IntervalDatum;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.datum.ProtobufDatum;
import org.apache.tajo.datum.ProtobufDatumFactory;
import org.apache.tajo.datum.TextDatum;
import org.apache.tajo.exception.TajoRuntimeException;
import org.apache.tajo.exception.UnsupportedException;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.storage.VTuple;
import org.apache.tajo.tuple.memory.HeapTuple;
import org.apache.tajo.tuple.memory.MemoryBlock;
import org.apache.tajo.tuple.memory.ZeroCopyTuple;
import org.apache.tajo.util.StringUtils;
import org.apache.tajo.util.UnsafeUtil;
import org.apache.tajo.util.datetime.TimeMeta;
import sun.misc.Unsafe;

public class UnSafeTuple
extends ZeroCopyTuple {
    private static final Unsafe UNSAFE = UnsafeUtil.unsafe;
    private MemoryBlock memoryBlock;
    private TajoDataTypes.DataType[] types;

    @Override
    public void set(MemoryBlock memoryBlock, int relativePos, TajoDataTypes.DataType[] types) {
        Preconditions.checkArgument((boolean)memoryBlock.hasAddress());
        this.memoryBlock = memoryBlock;
        this.types = types;
        super.set(relativePos);
    }

    public void set(UnSafeTuple tuple) {
        this.memoryBlock = tuple.memoryBlock;
        this.types = tuple.types;
        super.set(tuple.getRelativePos());
    }

    @Override
    public int size() {
        return this.types.length;
    }

    @Override
    public int getLength() {
        return PlatformDependent.getInt((long)this.address());
    }

    @Override
    public TajoDataTypes.Type type(int fieldId) {
        return this.types[fieldId].getType();
    }

    @Override
    public int size(int fieldId) {
        return PlatformDependent.getInt((long)this.getFieldAddr(fieldId));
    }

    public void writeTo(ByteBuffer bb) {
        if (bb.remaining() < this.getLength()) {
            throw new IndexOutOfBoundsException("remaining length: " + bb.remaining() + ", tuple length: " + this.getLength());
        }
        if (this.getLength() > 0) {
            if (bb.isDirect()) {
                PlatformDependent.copyMemory((long)this.address(), (long)(PlatformDependent.directBufferAddress((ByteBuffer)bb) + (long)bb.position()), (long)this.getLength());
                bb.position(bb.position() + this.getLength());
            } else {
                PlatformDependent.copyMemory((long)this.address(), (byte[])bb.array(), (int)(bb.arrayOffset() + bb.position()), (long)this.getLength());
                bb.position(bb.position() + this.getLength());
            }
        }
    }

    public long address() {
        return this.memoryBlock.address() + (long)this.getRelativePos();
    }

    public HeapTuple toHeapTuple() {
        HeapTuple heapTuple = new HeapTuple();
        byte[] bytes = new byte[this.getLength()];
        PlatformDependent.copyMemory((long)this.address(), (byte[])bytes, (int)0, (long)this.getLength());
        heapTuple.set(bytes, this.types);
        return heapTuple;
    }

    private int getFieldOffset(int fieldId) {
        return PlatformDependent.getInt((long)(this.address() + (long)(4 + fieldId * 4)));
    }

    public long getFieldAddr(int fieldId) {
        int fieldOffset = this.getFieldOffset(fieldId);
        if (fieldOffset < 0 || fieldOffset > this.getLength()) {
            throw new RuntimeException("Invalid Access. Field : " + fieldId + ", Offset:" + fieldOffset + ", Record length:" + this.getLength());
        }
        return this.address() + (long)fieldOffset;
    }

    @Override
    public boolean contains(int fieldid) {
        return this.getFieldOffset(fieldid) > -1;
    }

    @Override
    public boolean isBlank(int fieldid) {
        return this.getFieldOffset(fieldid) == -1;
    }

    @Override
    public boolean isBlankOrNull(int fieldid) {
        return this.getFieldOffset(fieldid) == -1;
    }

    @Override
    public void clear() {
    }

    @Override
    public void put(int fieldId, Datum value) {
        throw new TajoRuntimeException(new UnsupportedException());
    }

    @Override
    public void put(int fieldId, Tuple tuple) {
        throw new TajoRuntimeException(new UnsupportedException());
    }

    @Override
    public void put(Datum[] values) {
        throw new TajoRuntimeException(new UnsupportedException());
    }

    @Override
    public Datum asDatum(int fieldId) {
        if (this.isBlankOrNull(fieldId)) {
            return NullDatum.get();
        }
        switch (this.types[fieldId].getType()) {
            case BOOLEAN: {
                return DatumFactory.createBool(this.getBool(fieldId));
            }
            case BIT: {
                return DatumFactory.createBit(this.getByte(fieldId));
            }
            case INT1: 
            case INT2: {
                return DatumFactory.createInt2(this.getInt2(fieldId));
            }
            case INT4: {
                return DatumFactory.createInt4(this.getInt4(fieldId));
            }
            case INT8: {
                return DatumFactory.createInt8(this.getInt8(fieldId));
            }
            case FLOAT4: {
                return DatumFactory.createFloat4(this.getFloat4(fieldId));
            }
            case FLOAT8: {
                return DatumFactory.createFloat8(this.getFloat8(fieldId));
            }
            case CHAR: {
                return DatumFactory.createChar(this.getBytes(fieldId));
            }
            case TEXT: {
                return DatumFactory.createText(this.getBytes(fieldId));
            }
            case BLOB: {
                return DatumFactory.createBlob(this.getBytes(fieldId));
            }
            case TIMESTAMP: {
                return DatumFactory.createTimestamp(this.getInt8(fieldId));
            }
            case DATE: {
                return DatumFactory.createDate(this.getInt4(fieldId));
            }
            case TIME: {
                return DatumFactory.createTime(this.getInt8(fieldId));
            }
            case INTERVAL: {
                return this.getInterval(fieldId);
            }
            case INET4: {
                return DatumFactory.createInet4(this.getInt4(fieldId));
            }
            case PROTOBUF: {
                return this.getProtobufDatum(fieldId);
            }
            case NULL_TYPE: {
                return NullDatum.get();
            }
        }
        throw new TajoRuntimeException(new UnsupportedException("data type '" + this.types[fieldId] + "'"));
    }

    @Override
    public void clearOffset() {
    }

    @Override
    public void setOffset(long offset) {
    }

    @Override
    public long getOffset() {
        return 0L;
    }

    @Override
    public boolean getBool(int fieldId) {
        return PlatformDependent.getByte((long)this.getFieldAddr(fieldId)) == 1;
    }

    @Override
    public byte getByte(int fieldId) {
        return PlatformDependent.getByte((long)this.getFieldAddr(fieldId));
    }

    @Override
    public char getChar(int fieldId) {
        return UNSAFE.getChar(this.getFieldAddr(fieldId));
    }

    @Override
    public byte[] getBytes(int fieldId) {
        long pos = this.getFieldAddr(fieldId);
        int len = PlatformDependent.getInt((long)pos);
        byte[] bytes = new byte[len];
        PlatformDependent.copyMemory((long)(pos += 4L), (byte[])bytes, (int)0, (long)len);
        return bytes;
    }

    @Override
    public byte[] getTextBytes(int fieldId) {
        return this.asDatum(fieldId).asTextBytes();
    }

    @Override
    public short getInt2(int fieldId) {
        long addr = this.getFieldAddr(fieldId);
        return PlatformDependent.getShort((long)addr);
    }

    @Override
    public int getInt4(int fieldId) {
        return PlatformDependent.getInt((long)this.getFieldAddr(fieldId));
    }

    @Override
    public long getInt8(int fieldId) {
        return PlatformDependent.getLong((long)this.getFieldAddr(fieldId));
    }

    @Override
    public float getFloat4(int fieldId) {
        return Float.intBitsToFloat(PlatformDependent.getInt((long)this.getFieldAddr(fieldId)));
    }

    @Override
    public double getFloat8(int fieldId) {
        return Double.longBitsToDouble(PlatformDependent.getLong((long)this.getFieldAddr(fieldId)));
    }

    @Override
    public String getText(int fieldId) {
        return new String(this.getBytes(fieldId), TextDatum.DEFAULT_CHARSET);
    }

    @Override
    public IntervalDatum getInterval(int fieldId) {
        long pos = this.getFieldAddr(fieldId);
        int months = PlatformDependent.getInt((long)pos);
        long millisecs = PlatformDependent.getLong((long)(pos += 4L));
        return new IntervalDatum(months, millisecs);
    }

    @Override
    public Datum getProtobufDatum(int fieldId) {
        byte[] bytes = this.getBytes(fieldId);
        ProtobufDatumFactory factory = ProtobufDatumFactory.get(this.types[fieldId]);
        Object builder = factory.newBuilder();
        try {
            builder.mergeFrom(bytes);
        }
        catch (InvalidProtocolBufferException e) {
            return NullDatum.get();
        }
        return new ProtobufDatum(builder.build());
    }

    @Override
    public char[] getUnicodeChars(int fieldId) {
        long pos = this.getFieldAddr(fieldId);
        int len = PlatformDependent.getInt((long)pos);
        byte[] bytes = new byte[len];
        PlatformDependent.copyMemory((long)(pos += 4L), (byte[])bytes, (int)0, (long)len);
        return StringUtils.convertBytesToChars(bytes, Charset.forName("UTF-8"));
    }

    @Override
    public TimeMeta getTimeDate(int fieldId) {
        return this.asDatum(fieldId).asTimeMeta();
    }

    @Override
    public Tuple clone() throws CloneNotSupportedException {
        return this.toHeapTuple();
    }

    @Override
    public Datum[] getValues() {
        Datum[] datums = new Datum[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            datums[i] = this.contains(i) ? this.asDatum(i) : NullDatum.get();
        }
        return datums;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getValues());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Tuple) {
            Tuple other = (Tuple)obj;
            return Arrays.equals(this.getValues(), other.getValues());
        }
        return false;
    }

    public String toString() {
        return VTuple.toDisplayString(this.getValues());
    }

    public void release() {
    }
}

