/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BasicFuture<T>
implements Future<T> {
    private T result;
    private Exception exception;
    private boolean finished;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public synchronized boolean isDone() {
        return this.finished;
    }

    @Override
    public synchronized T get() throws InterruptedException, ExecutionException {
        while (!this.finished) {
            this.wait();
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    @Override
    public synchronized T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long current;
        long prev = System.currentTimeMillis();
        for (long remain = unit.toMillis(timeout); !this.finished && remain > 0L; remain -= current - prev) {
            this.wait(remain);
            current = System.currentTimeMillis();
            prev = current;
        }
        if (!this.finished) {
            throw new TimeoutException("Timed-out");
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean done(T result) {
        try {
            if (this.finished) {
                boolean bl = false;
                return bl;
            }
            this.result = result;
            this.finished = true;
            boolean bl = true;
            return bl;
        }
        finally {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean failed(Exception ex) {
        try {
            if (this.finished) {
                boolean bl = false;
                return bl;
            }
            this.exception = ex;
            this.finished = true;
            boolean bl = true;
            return bl;
        }
        finally {
            this.notifyAll();
        }
    }
}

