/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util;

import io.netty.buffer.ByteBuf;
import io.netty.util.internal.StringUtil;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.tajo.util.Bytes;

public class BytesUtils {
    public static int decodeVIntSize(byte value) {
        if (value >= -112) {
            return 1;
        }
        if (value < -120) {
            return -119 - value;
        }
        return -111 - value;
    }

    public static byte[] vlongToBytes(long n) {
        int offset = 0;
        if (n >= -112L && n <= 127L) {
            byte[] result = new byte[1];
            result[offset] = (byte)n;
            return result;
        }
        int len = -112;
        if (n < 0L) {
            n ^= 0xFFFFFFFFFFFFFFFFL;
            len = -120;
        }
        long tmp = n;
        while (tmp != 0L) {
            tmp >>= 8;
            --len;
        }
        int size = BytesUtils.decodeVIntSize((byte)len);
        byte[] result = new byte[size];
        result[offset++] = (byte)len;
        for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
            int shiftbits = (idx - 1) * 8;
            long mask = 255L << shiftbits;
            result[offset++] = (byte)((n & mask) >> shiftbits);
        }
        return result;
    }

    public static void writeVLong(ByteArrayOutputStream byteStream, long l) {
        byte[] vLongBytes = BytesUtils.vlongToBytes(l);
        byteStream.write(vLongBytes, 0, vLongBytes.length);
    }

    static byte[] toASCIIBytes(char[] chars) {
        byte[] buffer = new byte[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            buffer[i] = (byte)chars[i];
        }
        return buffer;
    }

    public static byte[][] splitPreserveAllTokens(byte[] str, char separatorChar, int[] target, int numColumns) {
        return BytesUtils.splitWorker(str, 0, -1, separatorChar, target, numColumns);
    }

    public static byte[][] splitPreserveAllTokens(byte[] str, int offset, int length, byte[] separator, int[] target, int numColumns) {
        return BytesUtils.splitWorker(str, offset, length, separator, target, numColumns);
    }

    public static byte[][] splitPreserveAllTokens(byte[] str, char separatorChar, int numColumns) {
        return BytesUtils.splitWorker(str, 0, -1, separatorChar, null, numColumns);
    }

    private static byte[][] splitWorker(byte[] str, int offset, int length, char separatorChar, int[] target, int numColumns) {
        return BytesUtils.splitWorker(str, offset, length, new byte[]{(byte)separatorChar}, target, numColumns);
    }

    private static byte[][] splitWorker(byte[] str, int offset, int length, byte[] separator, int[] target, int numColumns) {
        if (str == null) {
            return null;
        }
        if (length == 0) {
            return new byte[numColumns][0];
        }
        if (length < 0) {
            length = str.length - offset;
        }
        int indexMax = 0;
        if (target != null) {
            for (int index : target) {
                indexMax = Math.max(indexMax, index + 1);
            }
        } else {
            indexMax = numColumns;
        }
        int[][] indices = BytesUtils.split(str, offset, length, separator, new int[indexMax][]);
        byte[][] result = new byte[numColumns][];
        if (target != null) {
            for (int i : target) {
                int[] index = indices[i];
                result[i] = index == null ? new byte[]{} : Arrays.copyOfRange(str, index[0], index[1]);
            }
        } else {
            for (int i = 0; i < result.length; ++i) {
                int[] index = indices[i];
                result[i] = index == null ? new byte[]{} : Arrays.copyOfRange(str, index[0], index[1]);
            }
        }
        return result;
    }

    public static int[][] split(byte[] str, int offset, int length, byte[] separator, int[][] indices) {
        if (indices.length == 0) {
            return indices;
        }
        int limit = offset + length;
        int start = offset;
        int colIndex = 0;
        int index = offset;
        while (index < limit) {
            if (BytesUtils.onDelimiter(str, index, limit, separator)) {
                indices[colIndex++] = new int[]{start, index};
                if (colIndex >= indices.length) {
                    return indices;
                }
                start = index += separator.length;
                continue;
            }
            ++index;
        }
        if (colIndex < indices.length) {
            indices[colIndex] = new int[]{start, limit};
        }
        return indices;
    }

    private static boolean onDelimiter(byte[] input, int offset, int limit, byte[] delimiter) {
        for (int i = 0; i < delimiter.length; ++i) {
            if (offset + i < limit && input[offset + i] == delimiter[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[][] splitTrivial(byte[] value, byte delimiter) {
        ArrayList<byte[]> split = new ArrayList<byte[]>();
        int prev = 0;
        for (int i = 0; i < value.length; ++i) {
            if (value[i] != delimiter) continue;
            split.add(Arrays.copyOfRange(value, prev, i));
            prev = i + 1;
        }
        if (prev <= value.length) {
            split.add(Arrays.copyOfRange(value, prev, value.length));
        }
        return (byte[][])split.toArray((T[])new byte[split.size()][]);
    }

    public static byte[][] padBytes(byte[] ... bytes) {
        int i;
        byte[][] padded = new byte[bytes.length][];
        int maxLen = Integer.MIN_VALUE;
        for (i = 0; i < bytes.length; ++i) {
            maxLen = Math.max(maxLen, bytes[i].length);
        }
        for (i = 0; i < bytes.length; ++i) {
            int padLen = maxLen - bytes[i].length;
            if (padLen == 0) {
                padded[i] = bytes[i];
                continue;
            }
            if (padLen > 0) {
                padded[i] = Bytes.padTail(bytes[i], padLen);
                continue;
            }
            throw new RuntimeException("maximum length: " + maxLen + ", bytes[" + i + "].length:" + bytes[i].length);
        }
        return padded;
    }

    public static byte[] trimBytes(byte[] bytes) {
        return new String(bytes).trim().getBytes();
    }

    public static int writeUtf8(ByteBuf buffer, char[] chars, boolean ignoreSurrogate) {
        int oldWriterIndex;
        int writerIndex = oldWriterIndex = buffer.writerIndex();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c < '\u0080') {
                buffer.setByte(writerIndex++, (int)((byte)c));
                continue;
            }
            if (c < '\u0800') {
                buffer.setByte(writerIndex++, (int)((byte)(0xC0 | c >> 6)));
                buffer.setByte(writerIndex++, (int)((byte)(0x80 | c & 0x3F)));
                continue;
            }
            if (!ignoreSurrogate && StringUtil.isSurrogate((char)c)) {
                char c2;
                if (!Character.isHighSurrogate(c)) {
                    throw new IllegalArgumentException("Invalid encoding. Expected high (leading) surrogate at index " + i + " but got " + c);
                }
                try {
                    c2 = chars[++i];
                }
                catch (IndexOutOfBoundsException e) {
                    throw new IllegalArgumentException("Underflow. Expected low (trailing) surrogate at index " + i + " but no more characters found.", e);
                }
                if (!Character.isLowSurrogate(c2)) {
                    throw new IllegalArgumentException("Invalid encoding. Expected low (trailing) surrogate at index " + i + " but got " + c2);
                }
                int codePoint = Character.toCodePoint(c, c2);
                buffer.setByte(writerIndex++, (int)((byte)(0xF0 | codePoint >> 18)));
                buffer.setByte(writerIndex++, (int)((byte)(0x80 | codePoint >> 12 & 0x3F)));
                buffer.setByte(writerIndex++, (int)((byte)(0x80 | codePoint >> 6 & 0x3F)));
                buffer.setByte(writerIndex++, (int)((byte)(0x80 | codePoint & 0x3F)));
                continue;
            }
            buffer.setByte(writerIndex++, (int)((byte)(0xE0 | c >> 12)));
            buffer.setByte(writerIndex++, (int)((byte)(0x80 | c >> 6 & 0x3F)));
            buffer.setByte(writerIndex++, (int)((byte)(0x80 | c & 0x3F)));
        }
        buffer.writerIndex(writerIndex);
        return writerIndex - oldWriterIndex;
    }
}

