/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util;

import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.tajo.ConfigKey;
import org.apache.tajo.OverridableConf;
import org.apache.tajo.SessionVars;
import org.apache.tajo.conf.TajoConf;

public class CommonTestingUtil {
    private static OverridableConf userSessionVars;

    public static OverridableConf getSessionVarsForTest() {
        return userSessionVars;
    }

    public static Path getTestDir(String dir) throws IOException {
        Path path = new Path(dir);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
        CommonTestingUtil.cleanupTestDir(dir);
        fs.mkdirs(path);
        return fs.makeQualified(path);
    }

    public static void cleanupTestDir(String dir) throws IOException {
        Path path = new Path(dir);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
        if (fs.exists(path)) {
            fs.delete(path, true);
        }
    }

    public static Path getTestDir() throws IOException {
        String randomStr = UUID.randomUUID().toString();
        Path path = new Path("target/test-data", randomStr);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
        if (fs.exists(path)) {
            fs.delete(path, true);
        }
        fs.mkdirs(path);
        return fs.makeQualified(path);
    }

    static {
        System.setProperty("tajo.test.enabled", Boolean.TRUE.toString());
        userSessionVars = new OverridableConf(new TajoConf(), ConfigKey.ConfigType.SESSION);
        for (SessionVars var : SessionVars.values()) {
            String value = System.getProperty(var.keyname());
            if (value == null) continue;
            userSessionVars.put(var, value);
        }
    }
}

