/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util;

import java.io.IOException;
import org.apache.tajo.TajoProtos;
import org.apache.tajo.exception.UnsupportedException;
import org.iq80.snappy.Snappy;

public class CompressionUtil {
    public static byte[] compress(TajoProtos.CodecType type, byte[] uncompressed) throws IOException {
        switch (type) {
            case SNAPPY: {
                return SnappyCodec.compress(uncompressed);
            }
        }
        throw new IOException(new UnsupportedException("Cannot support " + (Object)((Object)type)));
    }

    public static byte[] decompress(TajoProtos.CodecType type, byte[] compressed) throws IOException {
        switch (type) {
            case SNAPPY: {
                return SnappyCodec.uncompress(compressed);
            }
        }
        throw new IOException(new UnsupportedException("Cannot support " + (Object)((Object)type)));
    }

    public static int maxCompressedLength(TajoProtos.CodecType type, int byteSize) throws IOException {
        switch (type) {
            case SNAPPY: {
                return SnappyCodec.maxCompressedLength(byteSize);
            }
        }
        throw new IOException(new UnsupportedException("Cannot support " + (Object)((Object)type)));
    }

    static class SnappyCodec {
        SnappyCodec() {
        }

        static byte[] compress(byte[] uncompressed) throws IOException {
            return Snappy.compress((byte[])uncompressed);
        }

        static byte[] uncompress(byte[] compressed) throws IOException {
            return Snappy.uncompress((byte[])compressed, (int)0, (int)compressed.length);
        }

        static int maxCompressedLength(int byteSize) throws IOException {
            return Snappy.maxCompressedLength((int)byteSize);
        }
    }
}

