/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util;

import io.netty.buffer.ByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.tajo.util.Bytes;
import org.apache.tajo.util.BytesUtils;

public class NumberUtil {
    public static final double[] powersOf10 = new double[]{10.0, 100.0, 10000.0, 1.0E8, 1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
    private static final int maxExponent = 511;
    public static final String UTF8_ENCODING = "UTF-8";
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    public static final int SIZEOF_BOOLEAN = 1;
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_DOUBLE = 8;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_SHORT = 2;

    public static long unsigned32(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static int unsigned16(short n) {
        return n & 0xFFFF;
    }

    public static byte[] toAsciiBytes(Number i) {
        return BytesUtils.toASCIIBytes(String.valueOf(i).toCharArray());
    }

    public static byte[] toAsciiBytes(short i) {
        return BytesUtils.toASCIIBytes(String.valueOf(i).toCharArray());
    }

    public static byte[] toAsciiBytes(int i) {
        return BytesUtils.toASCIIBytes(String.valueOf(i).toCharArray());
    }

    public static byte[] toAsciiBytes(long i) {
        return BytesUtils.toASCIIBytes(String.valueOf(i).toCharArray());
    }

    public static byte[] toAsciiBytes(float i) {
        return BytesUtils.toASCIIBytes(String.valueOf(i).toCharArray());
    }

    public static byte[] toAsciiBytes(double i) {
        return BytesUtils.toASCIIBytes(String.valueOf(i).toCharArray());
    }

    static int digit(int b, int radix) {
        int r = -1;
        if (b >= 48 && b <= 57) {
            r = b - 48;
        } else if (b >= 65 && b <= 90) {
            r = b - 65 + 10;
        } else if (b >= 97 && b <= 122) {
            r = b - 97 + 10;
        }
        if (r >= radix) {
            r = -1;
        }
        return r;
    }

    private static boolean isDigit(int b) {
        return b >= 48 && b <= 57;
    }

    public static double parseDouble(byte[] bytes, int start, int length) {
        int fracExponent;
        int offset;
        if (bytes == null) {
            throw new NumberFormatException("String is null");
        }
        if (length == 0) {
            throw new NumberFormatException("Empty byte array!");
        }
        int end = start + length;
        for (offset = start; offset < end && bytes[offset] == 32; ++offset) {
        }
        if (offset == end) {
            throw new NumberFormatException("blank byte array!");
        }
        boolean sign = false;
        if (bytes[offset] == 45) {
            sign = true;
            ++offset;
        } else if (bytes[offset] == 43) {
            ++offset;
        }
        if (offset == end) {
            throw new NumberFormatException("the byte array only has a sign!");
        }
        int mantSize = 0;
        int decicalOffset = -1;
        while (offset < end) {
            if (!NumberUtil.isDigit(bytes[offset])) {
                if (bytes[offset] != 46 || decicalOffset >= 0) break;
                decicalOffset = mantSize;
            }
            ++mantSize;
            ++offset;
        }
        int exponentOffset = offset;
        offset -= mantSize;
        if (decicalOffset < 0) {
            decicalOffset = mantSize;
        } else {
            --mantSize;
        }
        if (mantSize > 18) {
            fracExponent = decicalOffset - 18;
            mantSize = 18;
        } else {
            fracExponent = decicalOffset - mantSize;
        }
        if (mantSize == 0) {
            return 0.0;
        }
        int frac1 = 0;
        while (mantSize > 9) {
            byte b = bytes[offset];
            ++offset;
            if (b == 46) {
                b = bytes[offset];
                ++offset;
            }
            frac1 = 10 * frac1 + (b - 48);
            --mantSize;
        }
        int frac2 = 0;
        while (mantSize > 0) {
            byte b = bytes[offset];
            ++offset;
            if (b == 46) {
                b = bytes[offset];
                ++offset;
            }
            frac2 = 10 * frac2 + (b - 48);
            --mantSize;
        }
        double fraction = 1.0E9 * (double)frac1 + (double)frac2;
        int exponent = 0;
        offset = exponentOffset;
        boolean expSign = false;
        if (offset < end) {
            if (bytes[offset] != 69 && bytes[offset] != 101) {
                throw new NumberFormatException(new String(bytes, start, length));
            }
            if (bytes[++offset] == 45) {
                expSign = true;
                ++offset;
            } else if (bytes[offset] == 43) {
                ++offset;
            }
            while (offset < end) {
                if (!NumberUtil.isDigit(bytes[offset])) {
                    throw new NumberFormatException(new String(bytes, start, length));
                }
                exponent = exponent * 10 + (bytes[offset] - 48);
                ++offset;
            }
        }
        int n = exponent = expSign ? fracExponent - exponent : fracExponent + exponent;
        if (exponent < 0) {
            expSign = true;
            exponent = -exponent;
        } else {
            expSign = false;
        }
        if (exponent > 511) {
            throw new NumberFormatException(new String(bytes, start, length));
        }
        double dblExp = 1.0;
        int i = 0;
        while (exponent != 0) {
            if ((exponent & 1) == 1) {
                dblExp *= powersOf10[i];
            }
            exponent >>= 1;
            ++i;
        }
        fraction = expSign ? fraction / dblExp : fraction * dblExp;
        return sign ? -fraction : fraction;
    }

    public static int parseInt(byte[] bytes, int start, int length) {
        return NumberUtil.parseInt(bytes, start, length, 10);
    }

    public static int parseInt(byte[] bytes, int start, int length, int radix) {
        boolean negative;
        if (bytes == null) {
            throw new NumberFormatException("String is null");
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("Invalid radix: " + radix);
        }
        if (length == 0) {
            throw new NumberFormatException("Empty byte array!");
        }
        int offset = start;
        boolean bl = negative = bytes[start] == 45;
        if (negative || bytes[start] == 43) {
            ++offset;
            if (length == 1) {
                throw new NumberFormatException(new String(bytes, start, length));
            }
        }
        return NumberUtil.parseIntInternal(bytes, start, length, offset, radix, negative);
    }

    private static int parseIntInternal(byte[] bytes, int start, int length, int offset, int radix, boolean negative) {
        int digit;
        byte separator = 46;
        int max = Integer.MIN_VALUE / radix;
        int result = 0;
        int end = start + length;
        while (offset < end) {
            if ((digit = NumberUtil.digit(bytes[offset++], radix)) == -1) {
                if (bytes[offset - 1] == separator) break;
                throw new NumberFormatException(new String(bytes, start, length));
            }
            if (max > result) {
                throw new NumberFormatException(new String(bytes, start, length));
            }
            int next = result * radix - digit;
            if (next > result) {
                throw new NumberFormatException(new String(bytes, start, length));
            }
            result = next;
        }
        while (offset < end) {
            if ((digit = NumberUtil.digit(bytes[offset++], radix)) != -1) continue;
            throw new NumberFormatException(new String(bytes, start, length));
        }
        if (!negative && (result = -result) < 0) {
            throw new NumberFormatException(new String(bytes, start, length));
        }
        return result;
    }

    public static long parseLong(byte[] bytes, int start, int length) {
        return NumberUtil.parseLong(bytes, start, length, 10);
    }

    public static long parseLong(byte[] bytes, int start, int length, int radix) {
        boolean negative;
        if (bytes == null) {
            throw new NumberFormatException("String is null");
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("Invalid radix: " + radix);
        }
        if (length == 0) {
            throw new NumberFormatException("Empty string!");
        }
        int offset = start;
        boolean bl = negative = bytes[start] == 45;
        if (negative || bytes[start] == 43) {
            ++offset;
            if (length == 1) {
                throw new NumberFormatException(new String(bytes, start, length));
            }
        }
        return NumberUtil.parseLongInternal(bytes, start, length, offset, radix, negative);
    }

    private static long parseLongInternal(byte[] bytes, int start, int length, int offset, int radix, boolean negative) {
        int digit;
        byte separator = 46;
        long max = Long.MIN_VALUE / (long)radix;
        long result = 0L;
        long end = start + length;
        while ((long)offset < end) {
            if ((digit = NumberUtil.digit(bytes[offset++], radix)) == -1 || max > result) {
                if (bytes[offset - 1] == separator) break;
                throw new NumberFormatException(new String(bytes, start, length));
            }
            long next = result * (long)radix - (long)digit;
            if (next > result) {
                throw new NumberFormatException(new String(bytes, start, length));
            }
            result = next;
        }
        while ((long)offset < end) {
            if ((digit = NumberUtil.digit(bytes[offset++], radix)) != -1) continue;
            throw new NumberFormatException(new String(bytes, start, length));
        }
        if (!negative && (result = -result) < 0L) {
            throw new NumberFormatException(new String(bytes, start, length));
        }
        return result;
    }

    public static void writeUTF8(OutputStream out, int i) throws IOException {
        boolean negative;
        if (i == 0) {
            out.write(48);
            return;
        }
        boolean bl = negative = i < 0;
        if (negative) {
            out.write(45);
        } else {
            i = -i;
        }
        int start = 1000000000;
        while (i / start == 0) {
            start /= 10;
        }
        while (start > 0) {
            out.write(48 - i / start % 10);
            start /= 10;
        }
    }

    public static void writeUTF8(OutputStream out, long i) throws IOException {
        boolean negative;
        if (i == 0L) {
            out.write(48);
            return;
        }
        boolean bl = negative = i < 0L;
        if (negative) {
            out.write(45);
        } else {
            i = -i;
        }
        long start = 1000000000000000000L;
        while (i / start == 0L) {
            start /= 10L;
        }
        while (start > 0L) {
            out.write(48 - (int)(i / start % 10L));
            start /= 10L;
        }
    }

    public static double parseDouble(ByteBuf bytes) {
        return NumberUtil.parseDouble(bytes, bytes.readerIndex(), bytes.readableBytes());
    }

    public static double parseDouble(ByteBuf bytes, int start, int length) {
        int fracExponent;
        int offset;
        if (bytes == null) {
            throw new NumberFormatException("String is null");
        }
        if (!bytes.hasMemoryAddress()) {
            return NumberUtil.parseDouble(bytes.array(), start, length);
        }
        if (length == 0 || bytes.writerIndex() < start + length) {
            throw new NumberFormatException("Empty string or Invalid buffer!");
        }
        long memoryAddress = bytes.memoryAddress();
        int end = start + length;
        for (offset = start; offset < end && PlatformDependent.getByte((long)(memoryAddress + (long)offset)) == 32; ++offset) {
        }
        if (offset == end) {
            throw new NumberFormatException("blank byte array!");
        }
        boolean sign = false;
        if (PlatformDependent.getByte((long)(memoryAddress + (long)offset)) == 45) {
            sign = true;
            ++offset;
        } else if (PlatformDependent.getByte((long)(memoryAddress + (long)offset)) == 43) {
            ++offset;
        }
        if (offset == end) {
            throw new NumberFormatException("the byte array only has a sign!");
        }
        int mantSize = 0;
        int decicalOffset = -1;
        while (offset < end) {
            if (!NumberUtil.isDigit(PlatformDependent.getByte((long)(memoryAddress + (long)offset)))) {
                if (PlatformDependent.getByte((long)(memoryAddress + (long)offset)) != 46 || decicalOffset >= 0) break;
                decicalOffset = mantSize;
            }
            ++mantSize;
            ++offset;
        }
        int exponentOffset = offset;
        offset -= mantSize;
        if (decicalOffset < 0) {
            decicalOffset = mantSize;
        } else {
            --mantSize;
        }
        if (mantSize > 18) {
            fracExponent = decicalOffset - 18;
            mantSize = 18;
        } else {
            fracExponent = decicalOffset - mantSize;
        }
        if (mantSize == 0) {
            return 0.0;
        }
        int frac1 = 0;
        while (mantSize > 9) {
            byte b = PlatformDependent.getByte((long)(memoryAddress + (long)offset));
            ++offset;
            if (b == 46) {
                b = PlatformDependent.getByte((long)(memoryAddress + (long)offset));
                ++offset;
            }
            frac1 = 10 * frac1 + (b - 48);
            --mantSize;
        }
        int frac2 = 0;
        while (mantSize > 0) {
            byte b = PlatformDependent.getByte((long)(memoryAddress + (long)offset));
            ++offset;
            if (b == 46) {
                b = PlatformDependent.getByte((long)(memoryAddress + (long)offset));
                ++offset;
            }
            frac2 = 10 * frac2 + (b - 48);
            --mantSize;
        }
        double fraction = 1.0E9 * (double)frac1 + (double)frac2;
        int exponent = 0;
        offset = exponentOffset;
        boolean expSign = false;
        if (offset < end) {
            if (PlatformDependent.getByte((long)(memoryAddress + (long)offset)) != 69 && PlatformDependent.getByte((long)(memoryAddress + (long)offset)) != 101) {
                throw new NumberFormatException(bytes.toString(start, length, Charset.defaultCharset()));
            }
            if (PlatformDependent.getByte((long)(memoryAddress + (long)(++offset))) == 45) {
                expSign = true;
                ++offset;
            } else if (PlatformDependent.getByte((long)(memoryAddress + (long)offset)) == 43) {
                ++offset;
            }
            while (offset < end) {
                if (!NumberUtil.isDigit(PlatformDependent.getByte((long)(memoryAddress + (long)offset)))) {
                    throw new NumberFormatException(bytes.toString(start, length, Charset.defaultCharset()));
                }
                exponent = exponent * 10 + (PlatformDependent.getByte((long)(memoryAddress + (long)offset)) - 48);
                ++offset;
            }
        }
        int n = exponent = expSign ? fracExponent - exponent : fracExponent + exponent;
        if (exponent < 0) {
            expSign = true;
            exponent = -exponent;
        } else {
            expSign = false;
        }
        if (exponent > 511) {
            throw new NumberFormatException(bytes.toString(start, length, Charset.defaultCharset()));
        }
        double dblExp = 1.0;
        int i = 0;
        while (exponent != 0) {
            if ((exponent & 1) == 1) {
                dblExp *= powersOf10[i];
            }
            exponent >>= 1;
            ++i;
        }
        fraction = expSign ? fraction / dblExp : fraction * dblExp;
        return sign ? -fraction : fraction;
    }

    public static int parseInt(ByteBuf bytes) {
        return NumberUtil.parseInt(bytes, bytes.readerIndex(), bytes.readableBytes());
    }

    public static int parseInt(ByteBuf bytes, int start, int length) {
        return NumberUtil.parseInt(bytes, start, length, 10);
    }

    public static int parseInt(ByteBuf bytes, int start, int length, int radix) {
        boolean negative;
        if (bytes == null) {
            throw new NumberFormatException("String is null");
        }
        if (!bytes.hasMemoryAddress()) {
            return NumberUtil.parseInt(bytes.array(), start, length);
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("Invalid radix: " + radix);
        }
        if (length == 0 || bytes.writerIndex() < start + length) {
            throw new NumberFormatException("Empty string or Invalid buffer!");
        }
        long memoryAddress = bytes.memoryAddress();
        int offset = start;
        boolean bl = negative = PlatformDependent.getByte((long)(memoryAddress + (long)start)) == 45;
        if (negative || PlatformDependent.getByte((long)(memoryAddress + (long)start)) == 43) {
            ++offset;
            if (length == 1) {
                throw new NumberFormatException(bytes.toString(start, length, Charset.defaultCharset()));
            }
        }
        return NumberUtil.parseIntInternal(bytes, memoryAddress, start, length, offset, radix, negative);
    }

    private static int parseIntInternal(ByteBuf bytes, long memoryAddress, int start, int length, int offset, int radix, boolean negative) {
        int digit;
        byte separator = 46;
        int max = Integer.MIN_VALUE / radix;
        int result = 0;
        int end = start + length;
        while (offset < end) {
            if ((digit = NumberUtil.digit(PlatformDependent.getByte((long)(memoryAddress + (long)offset++)), radix)) == -1) {
                if (PlatformDependent.getByte((long)(memoryAddress + (long)offset - 1L)) == separator) break;
                throw new NumberFormatException(bytes.toString(start, length, Charset.defaultCharset()));
            }
            if (max > result) {
                throw new NumberFormatException(bytes.toString(start, length, Charset.defaultCharset()));
            }
            int next = result * radix - digit;
            if (next > result) {
                throw new NumberFormatException(bytes.toString(start, length, Charset.defaultCharset()));
            }
            result = next;
        }
        while (offset < end) {
            if ((digit = NumberUtil.digit(PlatformDependent.getByte((long)(memoryAddress + (long)offset++)), radix)) != -1) continue;
            throw new NumberFormatException(bytes.toString(start, length, Charset.defaultCharset()));
        }
        if (!negative && (result = -result) < 0) {
            throw new NumberFormatException(bytes.toString(start, length, Charset.defaultCharset()));
        }
        return result;
    }

    public static long parseLong(ByteBuf bytes) {
        return NumberUtil.parseLong(bytes, bytes.readerIndex(), bytes.readableBytes());
    }

    public static long parseLong(ByteBuf bytes, int start, int length) {
        return NumberUtil.parseLong(bytes, start, length, 10);
    }

    public static long parseLong(ByteBuf bytes, int start, int length, int radix) {
        boolean negative;
        if (bytes == null) {
            throw new NumberFormatException("String is null");
        }
        if (!bytes.hasMemoryAddress()) {
            return NumberUtil.parseInt(bytes.array(), start, length);
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("Invalid radix: " + radix);
        }
        if (length == 0 || bytes.writerIndex() < start + length) {
            throw new NumberFormatException("Empty string or Invalid buffer!");
        }
        long memoryAddress = bytes.memoryAddress();
        int offset = start;
        boolean bl = negative = PlatformDependent.getByte((long)(memoryAddress + (long)start)) == 45;
        if (negative || PlatformDependent.getByte((long)(memoryAddress + (long)start)) == 43) {
            ++offset;
            if (length == 1) {
                throw new NumberFormatException(bytes.toString(start, length, Charset.defaultCharset()));
            }
        }
        return NumberUtil.parseLongInternal(bytes, memoryAddress, start, length, offset, radix, negative);
    }

    private static long parseLongInternal(ByteBuf bytes, long memoryAddress, int start, int length, int offset, int radix, boolean negative) {
        int digit;
        byte separator = 46;
        long max = Long.MIN_VALUE / (long)radix;
        long result = 0L;
        long end = start + length;
        while ((long)offset < end) {
            if ((digit = NumberUtil.digit(PlatformDependent.getByte((long)(memoryAddress + (long)offset++)), radix)) == -1 || max > result) {
                if (PlatformDependent.getByte((long)(memoryAddress + (long)offset - 1L)) == separator) break;
                throw new NumberFormatException(bytes.toString(start, length, Charset.defaultCharset()));
            }
            long next = result * (long)radix - (long)digit;
            if (next > result) {
                throw new NumberFormatException(bytes.toString(start, length, Charset.defaultCharset()));
            }
            result = next;
        }
        while ((long)offset < end) {
            if ((digit = NumberUtil.digit(PlatformDependent.getByte((long)(memoryAddress + (long)offset++)), radix)) != -1) continue;
            throw new NumberFormatException(bytes.toString(start, length, Charset.defaultCharset()));
        }
        if (!negative && (result = -result) < 0L) {
            throw new NumberFormatException(bytes.toString(start, length, Charset.defaultCharset()));
        }
        return result;
    }

    public static Number numberValue(Class<?> numberClazz, String value) {
        Number returnNumber = null;
        if (numberClazz == null && value == null) {
            return returnNumber;
        }
        if (Number.class.isAssignableFrom(numberClazz)) {
            try {
                Constructor<?> constructor = numberClazz.getConstructor(String.class);
                returnNumber = (Number)constructor.newInstance(value);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return returnNumber;
    }

    public static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int putBytes(byte[] tgtBytes, int tgtOffset, byte[] srcBytes, int srcOffset, int srcLength) {
        System.arraycopy(srcBytes, srcOffset, tgtBytes, tgtOffset, srcLength);
        return tgtOffset + srcLength;
    }

    public static byte[] toBytes(ByteBuffer buf) {
        ByteBuffer dup = buf.duplicate();
        dup.position(0);
        return NumberUtil.readBytes(dup);
    }

    private static byte[] readBytes(ByteBuffer buf) {
        byte[] result = new byte[buf.remaining()];
        buf.get(result);
        return result;
    }

    public static byte[] toBytes(String s) {
        return s.getBytes(UTF8_CHARSET);
    }

    public static byte[] toBytes(boolean b) {
        return new byte[]{b ? (byte)-1 : 0};
    }

    public static boolean toBoolean(byte[] b) {
        if (b.length != 1) {
            throw new IllegalArgumentException("Array has wrong size: " + b.length);
        }
        return b[0] != 0;
    }

    public static byte[] toBytes(long val) {
        byte[] b = new byte[8];
        for (int i = 7; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static long toLong(byte[] bytes) {
        return NumberUtil.toLong(bytes, 0, 8);
    }

    public static long toLong(byte[] bytes, int offset) {
        return NumberUtil.toLong(bytes, offset, 8);
    }

    public static long toLong(byte[] bytes, int offset, int length) {
        if (length != 8 || offset + length > bytes.length) {
            throw NumberUtil.explainWrongLengthOrOffset(bytes, offset, length, 8);
        }
        long l = 0L;
        for (int i = offset; i < offset + length; ++i) {
            l <<= 8;
            l ^= (long)(bytes[i] & 0xFF);
        }
        return l;
    }

    private static IllegalArgumentException explainWrongLengthOrOffset(byte[] bytes, int offset, int length, int expectedLength) {
        String reason = length != expectedLength ? "Wrong length: " + length + ", expected " + expectedLength : "offset (" + offset + ") + length (" + length + ") exceed the" + " capacity of the array: " + bytes.length;
        return new IllegalArgumentException(reason);
    }

    public static int putLong(byte[] bytes, int offset, long val) {
        if (bytes.length - offset < 8) {
            throw new IllegalArgumentException("Not enough room to put a long at offset " + offset + " in a " + bytes.length + " byte array");
        }
        for (int i = offset + 7; i > offset; --i) {
            bytes[i] = (byte)val;
            val >>>= 8;
        }
        bytes[offset] = (byte)val;
        return offset + 8;
    }

    public static float toFloat(byte[] bytes) {
        return NumberUtil.toFloat(bytes, 0);
    }

    public static float toFloat(byte[] bytes, int offset) {
        return Float.intBitsToFloat(NumberUtil.toInt(bytes, offset, 4));
    }

    public static int putFloat(byte[] bytes, int offset, float f) {
        return NumberUtil.putInt(bytes, offset, Float.floatToRawIntBits(f));
    }

    public static byte[] toBytes(float f) {
        return Bytes.toBytes(Float.floatToRawIntBits(f));
    }

    public static double toDouble(byte[] bytes) {
        return NumberUtil.toDouble(bytes, 0);
    }

    public static double toDouble(byte[] bytes, int offset) {
        return Double.longBitsToDouble(NumberUtil.toLong(bytes, offset, 8));
    }

    public static int putDouble(byte[] bytes, int offset, double d) {
        return NumberUtil.putLong(bytes, offset, Double.doubleToLongBits(d));
    }

    public static byte[] toBytes(double d) {
        return Bytes.toBytes(Double.doubleToRawLongBits(d));
    }

    public static byte[] toBytes(int val) {
        byte[] b = new byte[4];
        for (int i = 3; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static int toInt(byte[] bytes) {
        return NumberUtil.toInt(bytes, 0, 4);
    }

    public static int toInt(byte[] bytes, int offset) {
        return NumberUtil.toInt(bytes, offset, 4);
    }

    public static int toInt(byte[] bytes, int offset, int length) {
        if (length != 4 || offset + length > bytes.length) {
            throw NumberUtil.explainWrongLengthOrOffset(bytes, offset, length, 4);
        }
        int n = 0;
        for (int i = offset; i < offset + length; ++i) {
            n <<= 8;
            n ^= bytes[i] & 0xFF;
        }
        return n;
    }

    public static int readAsInt(byte[] bytes, int offset, int length) {
        if (offset + length > bytes.length) {
            throw new IllegalArgumentException("offset (" + offset + ") + length (" + length + ") exceed the" + " capacity of the array: " + bytes.length);
        }
        int n = 0;
        for (int i = offset; i < offset + length; ++i) {
            n <<= 8;
            n ^= bytes[i] & 0xFF;
        }
        return n;
    }

    public static int putInt(byte[] bytes, int offset, int val) {
        if (bytes.length - offset < 4) {
            throw new IllegalArgumentException("Not enough room to put an int at offset " + offset + " in a " + bytes.length + " byte array");
        }
        for (int i = offset + 3; i > offset; --i) {
            bytes[i] = (byte)val;
            val >>>= 8;
        }
        bytes[offset] = (byte)val;
        return offset + 4;
    }

    public static byte[] toBytes(short val) {
        byte[] b = new byte[2];
        b[1] = (byte)val;
        val = (short)(val >> 8);
        b[0] = (byte)val;
        return b;
    }

    public static short toShort(byte[] bytes) {
        return NumberUtil.toShort(bytes, 0, 2);
    }

    public static short toShort(byte[] bytes, int offset) {
        return NumberUtil.toShort(bytes, offset, 2);
    }

    public static short toShort(byte[] bytes, int offset, int length) {
        if (length != 2 || offset + length > bytes.length) {
            throw NumberUtil.explainWrongLengthOrOffset(bytes, offset, length, 2);
        }
        short n = 0;
        n = (short)(n ^ bytes[offset] & 0xFF);
        n = (short)(n << 8);
        n = (short)(n ^ bytes[offset + 1] & 0xFF);
        return n;
    }

    public static byte[] getBytes(ByteBuffer buf) {
        return NumberUtil.readBytes(buf.duplicate());
    }

    public static int putShort(byte[] bytes, int offset, short val) {
        if (bytes.length - offset < 2) {
            throw new IllegalArgumentException("Not enough room to put a short at offset " + offset + " in a " + bytes.length + " byte array");
        }
        bytes[offset + 1] = (byte)val;
        val = (short)(val >> 8);
        bytes[offset] = (byte)val;
        return offset + 2;
    }

    public static int putAsShort(byte[] bytes, int offset, int val) {
        if (bytes.length - offset < 2) {
            throw new IllegalArgumentException("Not enough room to put a short at offset " + offset + " in a " + bytes.length + " byte array");
        }
        bytes[offset + 1] = (byte)val;
        bytes[offset] = (byte)(val >>= 8);
        return offset + 2;
    }

    public static byte[] toBytes(BigDecimal val) {
        byte[] valueBytes = val.unscaledValue().toByteArray();
        byte[] result = new byte[valueBytes.length + 4];
        int offset = NumberUtil.putInt(result, 0, val.scale());
        NumberUtil.putBytes(result, offset, valueBytes, 0, valueBytes.length);
        return result;
    }

    public static BigDecimal toBigDecimal(byte[] bytes) {
        return NumberUtil.toBigDecimal(bytes, 0, bytes.length);
    }

    public static BigDecimal toBigDecimal(byte[] bytes, int offset, int length) {
        if (bytes == null || length < 5 || offset + length > bytes.length) {
            return null;
        }
        int scale = NumberUtil.toInt(bytes, offset);
        byte[] tcBytes = new byte[length - 4];
        System.arraycopy(bytes, offset + 4, tcBytes, 0, length - 4);
        return new BigDecimal(new BigInteger(tcBytes), scale);
    }

    public static int putBigDecimal(byte[] bytes, int offset, BigDecimal val) {
        if (bytes == null) {
            return offset;
        }
        byte[] valueBytes = val.unscaledValue().toByteArray();
        byte[] result = new byte[valueBytes.length + 4];
        offset = NumberUtil.putInt(result, offset, val.scale());
        return NumberUtil.putBytes(result, offset, valueBytes, 0, valueBytes.length);
    }
}

