/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tajo.conf.TajoConf;

public class ReflectionUtil {
    public static final Class<?>[] EMPTY_PARAM = new Class[0];
    public static final Object[] EMPTY_OBJECT = new Object[0];
    public static final Class<?>[] CONF_PARAM = new Class[]{TajoConf.class};
    private static final Map<Class<?>, Constructor<?>> EMPTY_CONSTRUCTOR_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, Constructor<?>> CONF_CONSTRUCTOR_CACHE = new ConcurrentHashMap();

    public static <T> T newInstance(Class<? extends T> clazz) {
        try {
            Constructor<Object> constructor;
            if (EMPTY_CONSTRUCTOR_CACHE.containsKey(clazz)) {
                constructor = EMPTY_CONSTRUCTOR_CACHE.get(clazz);
            } else {
                constructor = clazz.getConstructor(EMPTY_PARAM);
                EMPTY_CONSTRUCTOR_CACHE.put(clazz, constructor);
            }
            return (T)constructor.newInstance(EMPTY_OBJECT);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static <T> T newInstance(Class<? extends T> clazz, TajoConf conf) {
        try {
            Constructor<Object> constructor;
            if (CONF_CONSTRUCTOR_CACHE.containsKey(clazz)) {
                constructor = CONF_CONSTRUCTOR_CACHE.get(clazz);
            } else {
                constructor = clazz.getConstructor(CONF_PARAM);
                CONF_CONSTRUCTOR_CACHE.put(clazz, constructor);
            }
            return (T)constructor.newInstance(new Object[]{conf});
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

