/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util;

import com.google.common.base.Objects;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TUtil {
    public static boolean checkEquals(Object s1, Object s2) {
        return Objects.equal((Object)s1, (Object)s2);
    }

    public static boolean checkEquals(Collection<?> s1, Collection<?> s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.size() == 0 && s2.size() == 0) {
            return true;
        }
        if (s1.size() == s2.size()) {
            Iterator<?> it1 = s1.iterator();
            Iterator<?> it2 = s2.iterator();
            Object o1 = it1.next();
            Object o2 = it2.next();
            while (it1.hasNext() && it2.hasNext()) {
                if (!o1.equals(o2)) {
                    return false;
                }
                o1 = it1.next();
                o2 = it2.next();
            }
        }
        return true;
    }

    public static boolean checkEquals(Object[] s1, Object[] s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null && s2 == null) {
            return true;
        }
        return Arrays.equals(s1, s2);
    }

    public static boolean checkEquals(int[] s1, int[] s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null && s2 == null) {
            return true;
        }
        return Arrays.equals(s1, s2);
    }

    public static <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static <T> T[] concatAll(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static <T> Set<T> newHashSet() {
        return new HashSet();
    }

    public static <T> Set<T> newHashSet(T ... items) {
        return new HashSet<T>(Arrays.asList(items));
    }

    public static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> newHashMap(Map<K, V> map) {
        return new HashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> newHashMap(K k, V v) {
        HashMap<K, V> newMap = new HashMap<K, V>();
        newMap.put(k, v);
        return newMap;
    }

    public static <K, V> Map<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> newLinkedHashMap(K k, V v) {
        LinkedHashMap<K, V> newMap = new LinkedHashMap<K, V>();
        newMap.put(k, v);
        return newMap;
    }

    public static <K, V> Map<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <T> List<T> newList() {
        return new ArrayList();
    }

    public static <T> List<T> newList(T ... items) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : items) {
            list.add(t);
        }
        return list;
    }

    public static <T> List<T> newList(Collection<T> items) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : items) {
            list.add(t);
        }
        return list;
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <KEY1, VALUE> void putToNestedList(Map<KEY1, List<VALUE>> map, KEY1 k1, VALUE value) {
        if (map.containsKey(k1)) {
            map.get(k1).add(value);
        } else {
            map.put(k1, TUtil.newList(value));
        }
    }

    public static <KEY1, VALUE> void putCollectionToNestedList(Map<KEY1, List<VALUE>> map, KEY1 k1, Collection<VALUE> list) {
        if (map.containsKey(k1)) {
            map.get(k1).addAll(list);
        } else {
            map.put(k1, TUtil.newList(list));
        }
    }

    public static <KEY1, KEY2, VALUE> void putToNestedMap(Map<KEY1, Map<KEY2, VALUE>> map, KEY1 k1, KEY2 k2, VALUE value) {
        if (map.containsKey(k1)) {
            map.get(k1).put(k2, value);
        } else {
            map.put(k1, TUtil.newLinkedHashMap(k2, value));
        }
    }

    public static <KEY1, KEY2, VALUE> boolean containsInNestedMap(Map<KEY1, Map<KEY2, VALUE>> map, KEY1 k1, KEY2 k2) {
        return map.containsKey(k1) && map.get(k1).containsKey(k2);
    }

    public static <KEY1, KEY2, VALUE> VALUE getFromNestedMap(Map<KEY1, Map<KEY2, VALUE>> map, KEY1 k1, KEY2 k2) {
        if (map.containsKey(k1)) {
            return map.get(k1).get(k2);
        }
        return null;
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> type) {
        Object array = Array.newInstance(type, collection.size());
        return collection.toArray((Object[])array);
    }

    public static int[] toArray(Collection<Integer> collection) {
        int[] array = new int[collection.size()];
        int index = 0;
        for (Integer eachInt : collection) {
            array[index++] = eachInt;
        }
        return array;
    }

    public static String getCurrentCodePoint(int depth) {
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        StackTraceElement element = ste[2 + depth];
        return element.getClassName() + ":" + element.getMethodName() + "(" + element.getLineNumber() + ")";
    }

    public static URI stringToURI(String str) {
        try {
            return new URI(str);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Cannot convert " + str + " to the URI type", e);
        }
    }

    public static <T> T checkTypeAndGet(Object instance, Class<T> type) {
        if (!type.isInstance(instance)) {
            throw new IllegalArgumentException(instance.getClass().getSimpleName() + " must be a " + type.getSimpleName() + " type");
        }
        return (T)instance;
    }
}

