/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util;

import com.google.common.primitives.UnsignedBytes;
import com.google.common.primitives.UnsignedLongs;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Comparator;
import sun.misc.Unsafe;

public class UnsafeComparer
implements Comparator<byte[]> {
    public static final UnsafeComparer INSTANCE = new UnsafeComparer();
    static final boolean littleEndian = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
    static final Unsafe theUnsafe = (Unsafe)AccessController.doPrivileged(new PrivilegedAction<Object>(){

        @Override
        public Object run() {
            try {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                return f.get(null);
            }
            catch (NoSuchFieldException e) {
                throw new Error();
            }
            catch (IllegalAccessException e) {
                throw new Error();
            }
        }
    });
    static final int BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);

    public Comparator<byte[]> get() {
        return INSTANCE;
    }

    private UnsafeComparer() {
    }

    public static int compareStatic(byte[] left, byte[] right) {
        return INSTANCE.compare(left, right);
    }

    @Override
    public int compare(byte[] left, byte[] right) {
        int i;
        int minLength = Math.min(left.length, right.length);
        int minWords = minLength / 8;
        for (i = 0; i < minWords * 8; i += 8) {
            int y;
            long rw;
            long lw = theUnsafe.getLong(left, (long)BYTE_ARRAY_BASE_OFFSET + (long)i);
            long diff = lw ^ (rw = theUnsafe.getLong(right, (long)BYTE_ARRAY_BASE_OFFSET + (long)i));
            if (diff == 0L) continue;
            if (!littleEndian) {
                return UnsignedLongs.compare((long)lw, (long)rw);
            }
            int n = 0;
            int x = (int)diff;
            if (x == 0) {
                x = (int)(diff >>> 32);
                n = 32;
            }
            if ((y = x << 16) == 0) {
                n += 16;
            } else {
                x = y;
            }
            y = x << 8;
            if (y == 0) {
                n += 8;
            }
            return (int)((lw >>> n & 0xFFL) - (rw >>> n & 0xFFL));
        }
        for (i = minWords * 8; i < minLength; ++i) {
            int result = UnsignedBytes.compare((byte)left[i], (byte)right[i]);
            if (result == 0) continue;
            return result;
        }
        return left.length - right.length;
    }

    static {
        if (theUnsafe.arrayIndexScale(byte[].class) != 1) {
            throw new AssertionError();
        }
    }
}

