/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util.datetime;

import java.util.TimeZone;
import org.apache.tajo.util.datetime.DateTimeConstants;
import org.apache.tajo.util.datetime.DateTimeUtil;

public class TimeMeta
implements Comparable<TimeMeta> {
    public int fsecs;
    public int secs;
    public int minutes;
    public int hours;
    public int dayOfMonth;
    public int dayOfYear;
    public int monthOfYear;
    public int years;
    public boolean isDST;
    public int dayOfWeek;
    public int timeZone = Integer.MAX_VALUE;

    public String toString() {
        return DateTimeUtil.encodeDateTime(this, DateTimeConstants.DateStyle.ISO_DATES);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dayOfMonth;
        result = 31 * result + this.dayOfWeek;
        result = 31 * result + this.dayOfYear;
        result = 31 * result + this.fsecs;
        result = 31 * result + this.hours;
        result = 31 * result + (this.isDST ? 1231 : 1237);
        result = 31 * result + this.minutes;
        result = 31 * result + this.monthOfYear;
        result = 31 * result + this.secs;
        result = 31 * result + this.timeZone;
        result = 31 * result + this.years;
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TimeMeta)) {
            return false;
        }
        TimeMeta other = (TimeMeta)o;
        return this.fsecs == other.fsecs && this.secs == other.secs && this.minutes == other.minutes && this.hours == other.hours && this.dayOfMonth == other.dayOfMonth && this.dayOfYear == other.dayOfYear && this.monthOfYear == other.monthOfYear && this.years == other.years && this.isDST == other.isDST;
    }

    public void plusMonths(int months) {
        int yearToUse;
        if (months == 0) {
            return;
        }
        int thisYear = this.years;
        int thisMonth = this.monthOfYear;
        int monthToUse = thisMonth - 1 + months;
        if (monthToUse >= 0) {
            yearToUse = thisYear + monthToUse / 12;
            monthToUse = monthToUse % 12 + 1;
        } else {
            yearToUse = thisYear + monthToUse / 12 - 1;
            int remMonthToUse = (monthToUse = Math.abs(monthToUse)) % 12;
            if (remMonthToUse == 0) {
                remMonthToUse = 12;
            }
            if ((monthToUse = 12 - remMonthToUse + 1) == 1) {
                ++yearToUse;
            }
        }
        int dayToUse = this.dayOfMonth;
        int maxDay = DateTimeUtil.getDaysInYearMonth(yearToUse, monthToUse);
        if (dayToUse > maxDay) {
            dayToUse = maxDay;
        }
        this.years = yearToUse;
        this.monthOfYear = monthToUse;
        this.dayOfMonth = dayToUse;
    }

    public void plusDays(int days) {
        long timestamp = DateTimeUtil.toJulianTimestamp(this);
        DateTimeUtil.toJulianTimeMeta(timestamp += (long)days * 86400000000L, this);
    }

    public void plusMillis(long millis) {
        this.plusTime(millis * 1000L);
    }

    public void convertToUTC(TimeZone zone) {
        long timestamp = DateTimeUtil.toJulianTimestamp(this);
        timestamp -= (long)this.getZonedOffset(timestamp, zone) * 1000L;
        DateTimeUtil.toJulianTimeMeta(timestamp, this);
    }

    public void convertToLocalTime(TimeZone zone) {
        long timestamp = DateTimeUtil.toJulianTimestamp(this);
        timestamp += (long)this.getZonedOffset(timestamp, zone) * 1000L;
        DateTimeUtil.toJulianTimeMeta(timestamp, this);
    }

    public int getZonedOffset(long julianTimestamp, TimeZone zone) {
        return zone.getOffset(DateTimeUtil.julianTimeToJavaTime(julianTimestamp));
    }

    public void plusTime(long time) {
        long timestamp = DateTimeUtil.toJulianTimestamp(this);
        DateTimeUtil.toJulianTimeMeta(timestamp += time, this);
    }

    public void plusInterval(int months, long milliseconds) {
        if (months != 0) {
            this.plusMonths(months);
        }
        if (milliseconds != 0L) {
            this.plusMillis(milliseconds);
        }
    }

    public int getCenturyOfEra() {
        return DateTimeUtil.getCenturyOfEra(this.years);
    }

    public int getDayOfYear() {
        int dayOfYear = 0;
        for (int i = 0; i < this.monthOfYear - 1; ++i) {
            dayOfYear += DateTimeUtil.getDaysInYearMonth(this.years, i + 1);
        }
        return dayOfYear + this.dayOfMonth;
    }

    public int getWeekOfYear() {
        return DateTimeUtil.date2isoweek(this.years, this.monthOfYear, this.dayOfMonth);
    }

    public int getWeekyear() {
        return DateTimeUtil.date2isoyear(this.years, this.monthOfYear, this.dayOfMonth);
    }

    public int getISODayOfWeek() {
        int dow = this.getDayOfWeek();
        if (dow == 0) {
            return 7;
        }
        return dow;
    }

    public int getDayOfWeek() {
        return (DateTimeUtil.date2j(this.years, this.monthOfYear, this.dayOfMonth) + 1) % 7;
    }

    @Override
    public int compareTo(TimeMeta o) {
        int result = 1;
        if (o != null) {
            long leftjulianTimestamp = DateTimeUtil.toJulianTimestamp(this);
            long rightjulianTimestamp = DateTimeUtil.toJulianTimestamp(o);
            result = (int)Math.signum(leftjulianTimestamp - rightjulianTimestamp);
        }
        return result;
    }
}

