/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.validation;

import java.util.Collection;
import java.util.Collections;
import org.apache.tajo.validation.AbstractValidator;
import org.apache.tajo.validation.Validator;

public class BooleanValidator
extends AbstractValidator {
    @Override
    protected <T> String getErrorMessage(T object) {
        return object + " is not a valid boolean representation.";
    }

    @Override
    protected <T> boolean validateInternal(T object) {
        boolean result = false;
        if (object != null) {
            if (object instanceof Boolean) {
                result = true;
            } else if (object instanceof CharSequence) {
                String valueString = object.toString();
                if (Boolean.FALSE.toString().equalsIgnoreCase(valueString) || Boolean.TRUE.toString().equalsIgnoreCase(valueString)) {
                    result = true;
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    @Override
    protected Collection<Validator> getDependantValidators() {
        return Collections.emptySet();
    }
}

