/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.validation;

import java.util.Collection;
import java.util.Collections;
import org.apache.tajo.validation.AbstractValidator;
import org.apache.tajo.validation.Validator;

public class LengthValidator
extends AbstractValidator {
    private final int maxLength;

    public LengthValidator(int maxLen) {
        this.maxLength = maxLen;
    }

    @Override
    protected <T> String getErrorMessage(T object) {
        return "Length of " + object + " is greater than " + this.maxLength;
    }

    @Override
    protected <T> boolean validateInternal(T object) {
        boolean result = false;
        if (object != null) {
            if (object instanceof CharSequence) {
                result = ((CharSequence)object).length() <= this.maxLength;
            }
        } else {
            result = true;
        }
        return result;
    }

    @Override
    protected Collection<Validator> getDependantValidators() {
        return Collections.emptySet();
    }
}

