/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.validation;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.tajo.validation.AbstractValidator;
import org.apache.tajo.validation.Validator;

public class MaxValidator
extends AbstractValidator {
    private final String maxValue;

    public MaxValidator(String maxValue) {
        if (!NumberUtils.isNumber((String)maxValue)) {
            throw new IllegalArgumentException(maxValue + " is not a Java number.");
        }
        this.maxValue = maxValue;
    }

    @Override
    protected <T> String getErrorMessage(T object) {
        return object + " should be less than " + this.maxValue;
    }

    @Override
    protected <T> boolean validateInternal(T object) {
        boolean result = false;
        if (object != null) {
            if (object instanceof Byte || object instanceof Short || object instanceof Integer) {
                Integer maxInteger;
                Integer objInteger = Integer.decode(object.toString());
                result = objInteger.compareTo(maxInteger = Integer.decode(this.maxValue)) <= 0;
            } else if (object instanceof Long) {
                Long maxLong;
                Long objLong = Long.decode(object.toString());
                result = objLong.compareTo(maxLong = Long.decode(this.maxValue)) <= 0;
            } else if (object instanceof Float || object instanceof Double) {
                Double maxDouble;
                Double objDouble = Double.valueOf(object.toString());
                result = objDouble.compareTo(maxDouble = Double.valueOf(this.maxValue)) <= 0;
            } else if (object instanceof BigInteger) {
                BigInteger objInteger = (BigInteger)object;
                BigInteger maxInteger = new BigInteger(this.maxValue);
                result = objInteger.compareTo(maxInteger) <= 0;
            } else if (object instanceof BigDecimal) {
                BigDecimal objDecimal = (BigDecimal)object;
                BigDecimal maxDecimal = new BigDecimal(this.maxValue);
                result = objDecimal.compareTo(maxDecimal) <= 0;
            }
        } else {
            result = true;
        }
        return result;
    }

    @Override
    protected Collection<Validator> getDependantValidators() {
        return Collections.emptySet();
    }
}

