/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.validation;

import java.util.Collection;
import java.util.Collections;
import org.apache.tajo.validation.AbstractValidator;
import org.apache.tajo.validation.MaxValidator;
import org.apache.tajo.validation.MinValidator;
import org.apache.tajo.validation.Validator;

public class RangeValidator
extends AbstractValidator {
    private final String minValue;
    private final AbstractValidator minValidator;
    private final String maxValue;
    private final AbstractValidator maxValidator;

    public RangeValidator(String minValue, String maxValue) {
        this.minValue = minValue;
        this.minValidator = new MinValidator(minValue);
        this.maxValue = maxValue;
        this.maxValidator = new MaxValidator(maxValue);
    }

    @Override
    protected <T> String getErrorMessage(T object) {
        return object + " is not a range of " + this.minValue + " and " + this.maxValue;
    }

    @Override
    protected <T> boolean validateInternal(T object) {
        return this.minValidator.validateInternal(object) && this.maxValidator.validateInternal(object);
    }

    @Override
    protected Collection<Validator> getDependantValidators() {
        return Collections.emptySet();
    }
}

