/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.validation;

import org.apache.tajo.util.TUtil;
import org.apache.tajo.validation.BooleanValidator;
import org.apache.tajo.validation.ClassValidator;
import org.apache.tajo.validation.GroupValidator;
import org.apache.tajo.validation.JavaStringValidator;
import org.apache.tajo.validation.LengthValidator;
import org.apache.tajo.validation.MaxValidator;
import org.apache.tajo.validation.MinValidator;
import org.apache.tajo.validation.NetworkAddressValidator;
import org.apache.tajo.validation.NotNullValidator;
import org.apache.tajo.validation.PathListValidator;
import org.apache.tajo.validation.PathValidator;
import org.apache.tajo.validation.PatternValidator;
import org.apache.tajo.validation.RangeValidator;
import org.apache.tajo.validation.ShellVariableValidator;
import org.apache.tajo.validation.Validator;

public class Validators {
    public static Validator groups(Validator ... validators) {
        return new GroupValidator(TUtil.newHashSet(validators));
    }

    public static Validator length(int maxLength) {
        return new LengthValidator(maxLength);
    }

    public static Validator max(String maxValue) {
        return new MaxValidator(maxValue);
    }

    public static Validator min(String minValue) {
        return new MinValidator(minValue);
    }

    public static Validator notNull() {
        return new NotNullValidator();
    }

    public static Validator patternMatch(String regex) {
        return new PatternValidator(regex);
    }

    public static Validator range(String minValue, String maxValue) {
        return new RangeValidator(minValue, maxValue);
    }

    public static Validator pathUrl() {
        return new PathValidator();
    }

    public static Validator pathUrlList() {
        return new PathListValidator();
    }

    public static Validator shellVar() {
        return new ShellVariableValidator();
    }

    public static Validator networkAddr() {
        return new NetworkAddressValidator();
    }

    public static Validator bool() {
        return new BooleanValidator();
    }

    public static Validator clazz() {
        return new ClassValidator();
    }

    public static Validator javaString() {
        return new JavaStringValidator();
    }
}

