/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Request;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.jk.common.MsgAjp;
import org.apache.jk.core.JkChannel;
import org.apache.jk.core.JkHandler;
import org.apache.jk.core.Msg;
import org.apache.jk.core.MsgContext;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.threads.ThreadPool;
import org.apache.tomcat.util.threads.ThreadPoolRunnable;

public class ChannelNioSocket
extends JkHandler
implements NotificationBroadcaster,
JkChannel {
    private static Log log = LogFactory.getLog(ChannelNioSocket.class);
    private int startPort = 8009;
    private int maxPort = 8019;
    private int port = this.startPort;
    private InetAddress inet;
    private int serverTimeout = 0;
    private boolean tcpNoDelay = true;
    private int linger = 100;
    private int socketTimeout = 0;
    private boolean nioIsBroken = false;
    private Selector selector = null;
    private int bufferSize = 8192;
    private int packetSize = 8192;
    private long requestCount = 0L;
    ThreadPool tp = ThreadPool.createThreadPool(true);
    ServerSocket sSocket;
    final int socketNote = 1;
    final int isNote = 2;
    final int osNote = 3;
    final int notifNote = 4;
    boolean paused = false;
    ObjectName tpOName;
    ObjectName rgOName;
    RequestGroupInfo global = new RequestGroupInfo();
    int JMXRequestNote;
    protected boolean running = true;
    private NotificationBroadcasterSupport nSupport = null;
    MBeanNotificationInfo[] notifInfo = new MBeanNotificationInfo[0];

    public ThreadPool getThreadPool() {
        return this.tp;
    }

    public long getRequestCount() {
        return this.requestCount;
    }

    public void setPort(int port) {
        this.startPort = port;
        this.port = port;
        this.maxPort = port + 10;
    }

    public int getPort() {
        return this.port;
    }

    public void setAddress(InetAddress inet) {
        this.inet = inet;
    }

    public void setBufferSize(int bs) {
        if (bs > 8192) {
            this.bufferSize = bs;
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setPacketSize(int ps) {
        if (ps < 8192) {
            ps = 8192;
        }
        this.packetSize = ps;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public void setAddress(String inet) {
        try {
            this.inet = InetAddress.getByName(inet);
        }
        catch (Exception ex) {
            log.error((Object)("Error parsing " + inet), (Throwable)ex);
        }
    }

    public String getAddress() {
        if (this.inet != null) {
            return this.inet.toString();
        }
        return "/0.0.0.0";
    }

    public void setServerTimeout(int timeout) {
        this.serverTimeout = timeout;
    }

    public int getServerTimeout() {
        return this.serverTimeout;
    }

    public void setTcpNoDelay(boolean b) {
        this.tcpNoDelay = b;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setSoLinger(int i) {
        this.linger = i;
    }

    public int getSoLinger() {
        return this.linger;
    }

    public void setSoTimeout(int i) {
        this.socketTimeout = i;
    }

    public int getSoTimeout() {
        return this.socketTimeout;
    }

    public void setMaxPort(int i) {
        this.maxPort = i;
    }

    public int getMaxPort() {
        return this.maxPort;
    }

    public int getInstanceId() {
        return this.port - this.startPort;
    }

    public void setDaemon(boolean b) {
        this.tp.setDaemon(b);
    }

    public boolean getDaemon() {
        return this.tp.getDaemon();
    }

    public void setMaxThreads(int i) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting maxThreads " + i));
        }
        this.tp.setMaxThreads(i);
    }

    public void setMinSpareThreads(int i) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting minSpareThreads " + i));
        }
        this.tp.setMinSpareThreads(i);
    }

    public void setMaxSpareThreads(int i) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting maxSpareThreads " + i));
        }
        this.tp.setMaxSpareThreads(i);
    }

    public int getMaxThreads() {
        return this.tp.getMaxThreads();
    }

    public int getMinSpareThreads() {
        return this.tp.getMinSpareThreads();
    }

    public int getMaxSpareThreads() {
        return this.tp.getMaxSpareThreads();
    }

    public void setBacklog(int i) {
    }

    public void setNioIsBroken(boolean nib) {
        this.nioIsBroken = nib;
    }

    public boolean getNioIsBroken() {
        return this.nioIsBroken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() throws Exception {
        ChannelNioSocket channelNioSocket = this;
        synchronized (channelNioSocket) {
            this.paused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        ChannelNioSocket channelNioSocket = this;
        synchronized (channelNioSocket) {
            this.paused = false;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(MsgContext ep) throws IOException {
        if (this.sSocket == null) {
            return;
        }
        ChannelNioSocket channelNioSocket = this;
        synchronized (channelNioSocket) {
            while (this.paused) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {}
            }
        }
        SocketChannel sc = this.sSocket.getChannel().accept();
        Socket s = sc.socket();
        ep.setNote(1, s);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Accepted socket " + s + " channel " + sc.isBlocking()));
        }
        try {
            this.setSocketOptions(s);
        }
        catch (SocketException sex) {
            log.debug((Object)"Error initializing Socket Options", (Throwable)sex);
        }
        ++this.requestCount;
        sc.configureBlocking(false);
        SocketInputStream is = new SocketInputStream(sc);
        SocketOutputStream os = new SocketOutputStream(sc);
        ep.setNote(2, is);
        ep.setNote(3, os);
        ep.setControl(this.tp);
    }

    private void setSocketOptions(Socket s) throws SocketException {
        if (this.socketTimeout > 0) {
            s.setSoTimeout(this.socketTimeout);
        }
        s.setTcpNoDelay(this.tcpNoDelay);
        if (this.linger > 0) {
            s.setSoLinger(true, this.linger);
        }
    }

    public void resetCounters() {
        this.requestCount = 0L;
    }

    public void reinit() throws IOException {
        this.destroy();
        this.init();
    }

    public void init() throws IOException {
        if (this.startPort == 0) {
            this.port = 0;
            if (log.isInfoEnabled()) {
                log.info((Object)"JK: ajp13 disabling channelNioSocket");
            }
            this.running = true;
            return;
        }
        if (this.maxPort < this.startPort) {
            this.maxPort = this.startPort;
        }
        ServerSocketChannel ssc = ServerSocketChannel.open();
        ssc.configureBlocking(false);
        for (int i = this.startPort; i <= this.maxPort; ++i) {
            try {
                InetSocketAddress iddr = null;
                iddr = this.inet == null ? new InetSocketAddress(i) : new InetSocketAddress(this.inet, i);
                this.sSocket = ssc.socket();
                this.sSocket.bind(iddr);
                this.port = i;
                break;
            }
            catch (IOException ex) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Port busy " + i + " " + ex.toString()));
                }
                this.sSocket = null;
                continue;
            }
        }
        if (this.sSocket == null) {
            log.error((Object)("Can't find free port " + this.startPort + " " + this.maxPort));
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("JK: ajp13 listening on " + this.getAddress() + ":" + this.port));
        }
        this.selector = Selector.open();
        ssc.register(this.selector, 16);
        if ("channelNioSocket".equals(this.name) && this.port != this.startPort && this.wEnv.getLocalId() == 0) {
            this.wEnv.setLocalId(this.port - this.startPort);
        }
        if (this.next == null && this.wEnv != null) {
            if (this.nextName != null) {
                this.setNext(this.wEnv.getHandler(this.nextName));
            }
            if (this.next == null) {
                this.next = this.wEnv.getHandler("dispatch");
            }
            if (this.next == null) {
                this.next = this.wEnv.getHandler("request");
            }
        }
        this.JMXRequestNote = this.wEnv.getNoteId(0, "requestNote");
        this.running = true;
        if (this.domain != null) {
            try {
                this.tpOName = new ObjectName(this.domain + ":type=ThreadPool,name=" + this.getChannelName());
                Registry.getRegistry(null, null).registerComponent((Object)this.tp, this.tpOName, null);
                this.rgOName = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getChannelName());
                Registry.getRegistry(null, null).registerComponent((Object)this.global, this.rgOName, null);
            }
            catch (Exception e) {
                log.error((Object)"Can't register threadpool");
            }
        }
        this.tp.start();
        Poller pollAjp = new Poller();
        this.tp.runIt(pollAjp);
    }

    public void start() throws IOException {
        if (this.sSocket == null) {
            this.init();
        }
        this.resume();
    }

    public void stop() throws IOException {
        this.destroy();
    }

    public void registerRequest(Request req, MsgContext ep, int count) {
        if (this.domain != null) {
            try {
                RequestInfo rp = req.getRequestProcessor();
                rp.setGlobalProcessor(this.global);
                ObjectName roname = new ObjectName(this.getDomain() + ":type=RequestProcessor,worker=" + this.getChannelName() + ",name=JkRequest" + count);
                ep.setNote(this.JMXRequestNote, roname);
                Registry.getRegistry(null, null).registerComponent((Object)rp, roname, null);
            }
            catch (Exception ex) {
                log.warn((Object)"Error registering request");
            }
        }
    }

    public void open(MsgContext ep) throws IOException {
    }

    public void close(MsgContext ep) throws IOException {
        Socket s = (Socket)ep.getNote(1);
        SelectionKey key = s.getChannel().keyFor(this.selector);
        if (key != null) {
            key.cancel();
        }
        s.close();
    }

    public void destroy() throws IOException {
        block5: {
            this.running = false;
            try {
                if (this.port == 0) {
                    return;
                }
                this.tp.shutdown();
                this.selector.wakeup().close();
                this.sSocket.close();
                if (this.tpOName != null) {
                    Registry.getRegistry(null, null).unregisterComponent(this.tpOName);
                }
                if (this.rgOName != null) {
                    Registry.getRegistry(null, null).unregisterComponent(this.rgOName);
                }
            }
            catch (Exception e) {
                log.info((Object)("Error shutting down the channel " + this.port + " " + e.toString()));
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)"Trace", (Throwable)e);
            }
        }
    }

    public int send(Msg msg, MsgContext ep) throws IOException {
        msg.end();
        byte[] buf = msg.getBuffer();
        int len = msg.getLen();
        if (log.isTraceEnabled()) {
            log.trace((Object)("send() " + len + " " + buf[4]));
        }
        OutputStream os = (OutputStream)ep.getNote(3);
        os.write(buf, 0, len);
        return len;
    }

    public int flush(Msg msg, MsgContext ep) throws IOException {
        OutputStream os = (OutputStream)ep.getNote(3);
        os.flush();
        return 0;
    }

    public int receive(Msg msg, MsgContext ep) throws IOException {
        int hlen;
        byte[] buf;
        int rd;
        if (log.isTraceEnabled()) {
            log.trace((Object)"receive() ");
        }
        if ((rd = this.read(ep, buf = msg.getBuffer(), 0, hlen = msg.getHeaderLength())) < 0) {
            return rd;
        }
        msg.processHeader();
        int blen = msg.getLen();
        int total_read = 0;
        total_read = this.read(ep, buf, hlen, blen);
        if (total_read <= 0 && blen > 0) {
            log.warn((Object)("can't read body, waited #" + blen));
            return -1;
        }
        if (total_read != blen) {
            log.warn((Object)("incomplete read, waited #" + blen + " got only " + total_read));
            return -2;
        }
        return total_read;
    }

    public int read(MsgContext ep, byte[] b, int offset, int len) throws IOException {
        int pos;
        int got;
        InputStream is = (InputStream)ep.getNote(2);
        for (pos = 0; pos < len; pos += got) {
            try {
                got = is.read(b, pos + offset, len - pos);
            }
            catch (ClosedChannelException sex) {
                if (pos > 0) {
                    log.info((Object)("Error reading data after " + pos + "bytes"), (Throwable)sex);
                } else {
                    log.debug((Object)"Error reading data", (Throwable)sex);
                }
                got = -1;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("read() " + b + " " + (b == null ? 0 : b.length) + " " + offset + " " + len + " = " + got));
            }
            if (got > 0) continue;
            return -3;
        }
        return pos;
    }

    void acceptConnections() {
        block4: {
            if (this.running) {
                try {
                    MsgContext ep = this.createMsgContext(this.packetSize);
                    ep.setSource(this);
                    ep.setWorkerEnv(this.wEnv);
                    this.accept(ep);
                    if (!this.running) {
                        return;
                    }
                    SocketConnection ajpConn = new SocketConnection(ep);
                    ajpConn.register(ep);
                }
                catch (Exception ex) {
                    if (!this.running) break block4;
                    log.warn((Object)"Exception executing accept", (Throwable)ex);
                }
            }
        }
    }

    public int invoke(Msg msg, MsgContext ep) throws IOException {
        int type = ep.getType();
        switch (type) {
            case 10: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"RECEIVE_PACKET ?? ");
                }
                return this.receive(msg, ep);
            }
            case 11: {
                return this.send(msg, ep);
            }
            case 12: {
                return this.flush(msg, ep);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Call next " + type + " " + this.next));
        }
        if (this.nSupport != null) {
            Notification notif = (Notification)ep.getNote(4);
            if (notif == null) {
                notif = new Notification("channelNioSocket.message", ep, this.requestCount);
                ep.setNote(4, notif);
            }
            this.nSupport.sendNotification(notif);
        }
        if (this.next != null) {
            return this.next.invoke(msg, ep);
        }
        log.info((Object)"No next ");
        return 0;
    }

    public boolean isSameAddress(MsgContext ep) {
        Socket s = (Socket)ep.getNote(1);
        return ChannelNioSocket.isSameAddress(s.getLocalAddress(), s.getInetAddress());
    }

    public String getChannelName() {
        String encodedAddr = "";
        if (this.inet != null && !"0.0.0.0".equals(this.inet.getHostAddress())) {
            encodedAddr = this.getAddress();
            if (encodedAddr.startsWith("/")) {
                encodedAddr = encodedAddr.substring(1);
            }
            encodedAddr = URLEncoder.encode(encodedAddr) + "-";
        }
        return "jk-" + encodedAddr + this.port;
    }

    public static boolean isSameAddress(InetAddress server, InetAddress client) {
        int i;
        byte[] clientAddr;
        byte[] serverAddr = server.getAddress();
        if (serverAddr.length != (clientAddr = client.getAddress()).length) {
            return false;
        }
        boolean match = true;
        for (i = 0; i < serverAddr.length; ++i) {
            if (serverAddr[i] == clientAddr[i]) continue;
            match = false;
            break;
        }
        if (match) {
            return true;
        }
        for (i = 0; i < serverAddr.length; ++i) {
            if (serverAddr[i] == clientAddr[serverAddr.length - 1 - i]) continue;
            return false;
        }
        return true;
    }

    public void sendNewMessageNotification(Notification notification) {
        if (this.nSupport != null) {
            this.nSupport.sendNotification(notification);
        }
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        if (this.nSupport == null) {
            this.nSupport = new NotificationBroadcasterSupport();
        }
        this.nSupport.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (this.nSupport != null) {
            this.nSupport.removeNotificationListener(listener);
        }
    }

    public void setNotificationInfo(MBeanNotificationInfo[] info) {
        this.notifInfo = info;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.notifInfo;
    }

    protected class SocketOutputStream
    extends OutputStream {
        ByteBuffer buffer;
        SocketChannel channel;

        SocketOutputStream(SocketChannel channel) {
            this.buffer = ByteBuffer.allocateDirect(ChannelNioSocket.this.bufferSize);
            this.channel = channel;
        }

        public void write(int b) throws IOException {
            if (!this.checkAvailable(1)) {
                this.flush();
            }
            this.buffer.put((byte)b);
        }

        public void write(byte[] data) throws IOException {
            this.write(data, 0, data.length);
        }

        public void write(byte[] data, int offset, int len) throws IOException {
            if (!this.checkAvailable(len)) {
                this.flush();
            }
            this.buffer.put(data, offset, len);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            this.buffer.flip();
            while (this.buffer.hasRemaining()) {
                int count = this.channel.write(this.buffer);
                if (count != 0) continue;
                SocketOutputStream socketOutputStream = this;
                synchronized (socketOutputStream) {
                    SelectionKey key = this.channel.keyFor(ChannelNioSocket.this.selector);
                    key.interestOps(4);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Blocking for channel write: " + this.buffer.remaining()));
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException iex) {
                        // empty catch block
                    }
                    key.interestOps(1);
                }
            }
            this.buffer.clear();
        }

        private boolean checkAvailable(int len) {
            return this.buffer.remaining() >= len;
        }
    }

    protected class SocketInputStream
    extends InputStream {
        final int BUFFER_SIZE = 8200;
        private ByteBuffer buffer = ByteBuffer.allocateDirect(8200);
        private SocketChannel channel;
        private boolean blocking = false;
        private boolean isClosed = false;
        private volatile boolean dataAvailable = false;

        SocketInputStream(SocketChannel channel) {
            this.channel = channel;
            this.buffer.limit(0);
        }

        public int available() {
            return this.buffer.remaining();
        }

        public void mark(int readlimit) {
            this.buffer.mark();
        }

        public boolean markSupported() {
            return true;
        }

        public void reset() {
            this.buffer.reset();
        }

        public synchronized int read() throws IOException {
            if (!this.checkAvailable(1)) {
                this.block(1);
            }
            return this.buffer.get();
        }

        private boolean checkAvailable(int nbyte) throws IOException {
            if (this.isClosed) {
                throw new ClosedChannelException();
            }
            return this.buffer.remaining() >= nbyte;
        }

        private int fill(int nbyte) throws IOException {
            int rem = nbyte;
            int read = 0;
            boolean eof = false;
            byte[] oldData = null;
            if (this.buffer.remaining() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Saving old buffer: " + this.buffer.remaining()));
                }
                oldData = new byte[this.buffer.remaining()];
                this.buffer.get(oldData);
            }
            this.buffer.clear();
            if (oldData != null) {
                this.buffer.put(oldData);
            }
            while (rem > 0) {
                int count = this.channel.read(this.buffer);
                if (count < 0) {
                    eof = true;
                    break;
                }
                if (count == 0) {
                    log.debug((Object)"Failed to recieve signaled read: ");
                    break;
                }
                read += count;
                rem -= count;
            }
            this.buffer.flip();
            return eof ? -1 : read;
        }

        synchronized boolean readAvailable() {
            if (this.blocking) {
                this.dataAvailable = true;
                this.notify();
            } else if (this.dataAvailable) {
                log.debug((Object)"Race Condition");
            } else {
                int nr = 0;
                try {
                    nr = this.fill(1);
                }
                catch (ClosedChannelException cce) {
                    log.debug((Object)"Channel is closed", (Throwable)cce);
                    nr = -1;
                }
                catch (IOException iex) {
                    log.warn((Object)"Exception processing read", (Throwable)iex);
                    nr = -1;
                }
                if (nr < 0) {
                    this.closeIt();
                    return false;
                }
                if (nr == 0 && !ChannelNioSocket.this.nioIsBroken) {
                    this.dataAvailable = this.buffer.remaining() <= 0;
                }
            }
            return true;
        }

        synchronized void closeIt() {
            this.isClosed = true;
            if (this.blocking) {
                this.notify();
            }
        }

        public int read(byte[] data) throws IOException {
            return this.read(data, 0, data.length);
        }

        public synchronized int read(byte[] data, int offset, int len) throws IOException {
            int olen = len;
            while (!this.checkAvailable(len)) {
                int avail = this.buffer.remaining();
                if (avail > 0) {
                    this.buffer.get(data, offset, avail);
                }
                offset += avail;
                this.block(len -= avail);
            }
            this.buffer.get(data, offset, len);
            return olen;
        }

        private void block(int len) throws IOException {
            if (len <= 0) {
                return;
            }
            if (!this.dataAvailable) {
                this.blocking = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Waiting for " + len + " bytes to be available"));
                }
                try {
                    this.wait(ChannelNioSocket.this.socketTimeout);
                }
                catch (InterruptedException iex) {
                    log.debug((Object)"Interrupted", (Throwable)iex);
                }
                this.blocking = false;
            }
            if (this.dataAvailable) {
                this.dataAvailable = false;
                if (this.fill(len) < 0) {
                    this.isClosed = true;
                }
            } else if (!this.isClosed) {
                throw new SocketTimeoutException("Read request timed out");
            }
        }
    }

    protected class Poller
    implements ThreadPoolRunnable {
        Poller() {
        }

        public Object[] getInitData() {
            return null;
        }

        public void runIt(Object[] perTh) {
            while (ChannelNioSocket.this.running) {
                try {
                    int ns = ChannelNioSocket.this.selector.select(ChannelNioSocket.this.serverTimeout);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Selecting " + ns + " channels"));
                    }
                    if (ns <= 0) continue;
                    Set<SelectionKey> sels = ChannelNioSocket.this.selector.selectedKeys();
                    Iterator<SelectionKey> it = sels.iterator();
                    while (it.hasNext()) {
                        SelectionKey sk = it.next();
                        if (sk.isAcceptable()) {
                            ChannelNioSocket.this.acceptConnections();
                        } else {
                            SocketConnection sc = (SocketConnection)sk.attachment();
                            sc.process(sk);
                        }
                        it.remove();
                    }
                }
                catch (ClosedSelectorException cse) {
                    log.debug((Object)"Selector is closed");
                    return;
                }
                catch (CancelledKeyException cke) {
                    log.debug((Object)"Key Cancelled", (Throwable)cke);
                }
                catch (IOException iex) {
                    log.warn((Object)"IO Error in select", (Throwable)iex);
                }
                catch (Exception ex) {
                    log.warn((Object)"Error processing select", (Throwable)ex);
                }
            }
        }
    }

    protected class SocketConnection
    implements ThreadPoolRunnable {
        MsgContext ep;
        MsgAjp recv;
        boolean inProgress;

        SocketConnection(MsgContext ep) {
            this.recv = new MsgAjp(ChannelNioSocket.this.packetSize);
            this.inProgress = false;
            this.ep = ep;
        }

        public Object[] getInitData() {
            return null;
        }

        public void runIt(Object[] perTh) {
            if (!this.processConnection(this.ep)) {
                this.unregister(this.ep);
            }
        }

        public boolean isRunning() {
            return this.inProgress;
        }

        public void setFinished() {
            this.inProgress = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        boolean processConnection(MsgContext ep) {
            try {
                InputStream sis = (InputStream)ep.getNote(2);
                boolean haveInput = true;
                while (haveInput) {
                    if (!ChannelNioSocket.this.running) return false;
                    if (ChannelNioSocket.this.paused) {
                        return false;
                    }
                    int status = ChannelNioSocket.this.receive(this.recv, ep);
                    if (status <= 0) {
                        if (status == -3) {
                            log.debug((Object)"server has been restarted or reset this connection");
                            return false;
                        }
                        log.warn((Object)("Closing ajp connection " + status));
                        return false;
                    }
                    ep.setLong(0, System.currentTimeMillis());
                    ep.setType(0);
                    status = ChannelNioSocket.this.invoke(this.recv, ep);
                    if (status != 0) {
                        log.warn((Object)("processCallbacks status " + status));
                        ep.action(ActionCode.ACTION_CLOSE, ep.getRequest().getResponse());
                        return false;
                    }
                    SocketConnection socketConnection = this;
                    // MONITORENTER : socketConnection
                    InputStream inputStream = sis;
                    // MONITORENTER : inputStream
                    haveInput = sis.available() > 0;
                    // MONITOREXIT : inputStream
                    if (!haveInput) {
                        this.setFinished();
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("KeepAlive: " + sis.available()));
                    }
                    // MONITOREXIT : socketConnection
                }
                return true;
            }
            catch (Exception ex) {
                String msg = ex.getMessage();
                if (msg != null && msg.indexOf("Connection reset") >= 0) {
                    log.debug((Object)"Server has been restarted or reset this connection");
                    return false;
                }
                if (msg != null && msg.indexOf("Read timed out") >= 0) {
                    log.debug((Object)"connection timeout reached");
                    return false;
                }
                log.error((Object)"Error, processing connection", (Throwable)ex);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void process(SelectionKey sk) {
            if (!sk.isValid()) {
                SocketInputStream sis = (SocketInputStream)this.ep.getNote(2);
                sis.closeIt();
                return;
            }
            if (sk.isReadable()) {
                SocketInputStream sis = (SocketInputStream)this.ep.getNote(2);
                boolean isok = sis.readAvailable();
                if (!this.inProgress) {
                    if (isok) {
                        if (sis.available() > 0 || !ChannelNioSocket.this.nioIsBroken) {
                            this.inProgress = true;
                            ChannelNioSocket.this.tp.runIt(this);
                        }
                    } else {
                        this.unregister(this.ep);
                        return;
                    }
                }
            }
            if (sk.isWritable()) {
                Object os;
                Object object = os = this.ep.getNote(3);
                synchronized (object) {
                    os.notify();
                }
            }
        }

        synchronized void unregister(MsgContext ep) {
            try {
                ChannelNioSocket.this.close(ep);
            }
            catch (Exception e) {
                log.error((Object)"Error closing connection", (Throwable)e);
            }
            try {
                Request req = ep.getRequest();
                if (req != null) {
                    ObjectName roname = (ObjectName)ep.getNote(ChannelNioSocket.this.JMXRequestNote);
                    if (roname != null) {
                        Registry.getRegistry(null, null).unregisterComponent(roname);
                    }
                    req.getRequestProcessor().setGlobalProcessor(null);
                }
            }
            catch (Exception ee) {
                log.error((Object)"Error, releasing connection", (Throwable)ee);
            }
        }

        void register(MsgContext ep) {
            Socket s = (Socket)ep.getNote(1);
            try {
                s.getChannel().register(ChannelNioSocket.this.selector, 1, this);
            }
            catch (IOException iex) {
                log.error((Object)"Unable to register connection", (Throwable)iex);
                this.unregister(ep);
            }
        }
    }
}

