/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDerivedKeyTokenPrincipal;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.ConversationConstants;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.conversation.dkalgo.AlgoFactory;
import org.apache.ws.security.conversation.dkalgo.DerivationAlgorithm;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerivedKeyToken {
    private static Log log = LogFactory.getLog(DerivedKeyToken.class);
    protected Element element = null;
    protected Element elementSecurityTokenReference = null;
    protected Element elementProperties = null;
    protected Element elementGeneration = null;
    protected Element elementOffset = null;
    protected Element elementLength = null;
    protected Element elementLabel = null;
    protected Element elementNonce = null;
    private String ns;
    private boolean bspCompliant = true;

    public DerivedKeyToken(Document doc) throws ConversationException {
        this(1, doc);
    }

    public DerivedKeyToken(int version, Document doc) throws ConversationException {
        log.debug((Object)"DerivedKeyToken: created");
        this.ns = ConversationConstants.getWSCNs(version);
        this.element = doc.createElementNS(this.ns, "wsc:DerivedKeyToken");
        WSSecurityUtil.setNamespace(this.element, this.ns, "wsc");
    }

    public DerivedKeyToken(Element elem) throws WSSecurityException {
        this(elem, true);
    }

    public DerivedKeyToken(Element elem, boolean bspCompliant) throws WSSecurityException {
        log.debug((Object)"DerivedKeyToken: created : element constructor");
        this.element = elem;
        this.bspCompliant = bspCompliant;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(ConversationConstants.DERIVED_KEY_TOKEN_QNAME_05_02) && !el.equals(ConversationConstants.DERIVED_KEY_TOKEN_QNAME_05_12)) {
            throw new WSSecurityException(4);
        }
        this.elementSecurityTokenReference = WSSecurityUtil.getDirectChildElement(this.element, "SecurityTokenReference", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        this.ns = el.getNamespaceURI();
        this.elementProperties = WSSecurityUtil.getDirectChildElement(this.element, "Properties", this.ns);
        this.elementGeneration = WSSecurityUtil.getDirectChildElement(this.element, "Generation", this.ns);
        this.elementOffset = WSSecurityUtil.getDirectChildElement(this.element, "Offset", this.ns);
        this.elementLength = WSSecurityUtil.getDirectChildElement(this.element, "Length", this.ns);
        this.elementLabel = WSSecurityUtil.getDirectChildElement(this.element, "Label", this.ns);
        this.elementNonce = WSSecurityUtil.getDirectChildElement(this.element, "Nonce", this.ns);
    }

    public void addWSUNamespace() {
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
    }

    public void setSecurityTokenReference(SecurityTokenReference ref) {
        this.elementSecurityTokenReference = ref.getElement();
        WSSecurityUtil.prependChildElement(this.element, ref.getElement());
    }

    public void setSecurityTokenReference(Element elem) {
        this.elementSecurityTokenReference = elem;
        WSSecurityUtil.prependChildElement(this.element, elem);
    }

    public SecurityTokenReference getSecurityTokenReference() throws WSSecurityException {
        if (this.elementSecurityTokenReference != null) {
            return new SecurityTokenReference(this.elementSecurityTokenReference, this.bspCompliant);
        }
        return null;
    }

    public Element getSecurityTokenReferenceElement() {
        return this.elementSecurityTokenReference;
    }

    private void addProperty(String propName, String propValue) {
        if (this.elementProperties == null) {
            this.elementProperties = this.element.getOwnerDocument().createElementNS(this.ns, "wsc:Properties");
            this.element.appendChild(this.elementProperties);
        }
        Element tempElement = this.element.getOwnerDocument().createElementNS(this.ns, "wsc:" + propName);
        tempElement.appendChild(this.element.getOwnerDocument().createTextNode(propValue));
        this.elementProperties.appendChild(tempElement);
    }

    public void setProperties(String name, String label, String nonce) {
        HashMap<String, String> table = new HashMap<String, String>();
        table.put("Name", name);
        table.put("Label", label);
        table.put("Nonce", nonce);
        this.setProperties(table);
    }

    public void setProperties(Map<String, String> properties) {
        for (String key : properties.keySet()) {
            String propertyName = properties.get(key);
            Element node = WSSecurityUtil.findElement(this.elementProperties, propertyName, this.ns);
            if (node != null) {
                Text node1 = this.getFirstNode(node);
                node1.setData(properties.get(propertyName));
                continue;
            }
            this.addProperty(propertyName, properties.get(propertyName));
        }
    }

    public Map<String, String> getProperties() {
        if (this.elementProperties != null) {
            HashMap<String, String> table = new HashMap<String, String>();
            for (Node node = this.elementProperties.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (1 != node.getNodeType()) continue;
                Text text = this.getFirstNode((Element)node);
                table.put(node.getNodeName(), text.getData());
            }
        }
        return null;
    }

    public void setLength(int length) {
        this.elementLength = this.element.getOwnerDocument().createElementNS(this.ns, "wsc:Length");
        this.elementLength.appendChild(this.element.getOwnerDocument().createTextNode(Long.toString(length)));
        this.element.appendChild(this.elementLength);
    }

    public int getLength() {
        if (this.elementLength != null) {
            return Integer.parseInt(this.getFirstNode(this.elementLength).getData());
        }
        return 32;
    }

    public void setOffset(int offset) throws ConversationException {
        if (this.elementGeneration != null) {
            throw new ConversationException("Offset cannot be set along with generation - generation is already set");
        }
        this.elementOffset = this.element.getOwnerDocument().createElementNS(this.ns, "wsc:Offset");
        this.elementOffset.appendChild(this.element.getOwnerDocument().createTextNode(Integer.toString(offset)));
        this.element.appendChild(this.elementOffset);
    }

    public int getOffset() {
        if (this.elementOffset != null) {
            return Integer.parseInt(this.getFirstNode(this.elementOffset).getData());
        }
        return 0;
    }

    public void setGeneration(int generation) throws ConversationException {
        if (this.elementOffset != null) {
            throw new ConversationException("Generation cannot be set along with offset - Offset is already set");
        }
        this.elementGeneration = this.element.getOwnerDocument().createElementNS(this.ns, "wsc:Generation");
        this.elementGeneration.appendChild(this.element.getOwnerDocument().createTextNode(Integer.toString(generation)));
        this.element.appendChild(this.elementGeneration);
    }

    public int getGeneration() {
        if (this.elementGeneration != null) {
            return Integer.parseInt(this.getFirstNode(this.elementGeneration).getData());
        }
        return -1;
    }

    public void setLabel(String label) {
        this.elementLabel = this.element.getOwnerDocument().createElementNS(this.ns, "wsc:Label");
        this.elementLabel.appendChild(this.element.getOwnerDocument().createTextNode(label));
        this.element.appendChild(this.elementLabel);
    }

    public void setNonce(String nonce) {
        this.elementNonce = this.element.getOwnerDocument().createElementNS(this.ns, "wsc:Nonce");
        this.elementNonce.appendChild(this.element.getOwnerDocument().createTextNode(nonce));
        this.element.appendChild(this.elementNonce);
    }

    public String getLabel() {
        if (this.elementLabel != null) {
            return this.getFirstNode(this.elementLabel).getData();
        }
        return null;
    }

    public String getNonce() {
        if (this.elementNonce != null) {
            return this.getFirstNode(this.elementNonce).getData();
        }
        return null;
    }

    private Text getFirstNode(Element e) {
        Node node = e.getFirstChild();
        return node != null && 3 == node.getNodeType() ? (Text)node : null;
    }

    public Element getElement() {
        return this.element;
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    public String getID() {
        return this.element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    public void setID(String id) {
        this.element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", id);
    }

    public String getAlgorithm() {
        String algo = this.element.getAttributeNS(this.ns, "Algorithm");
        if (algo == null || algo.equals("")) {
            return "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
        }
        return algo;
    }

    public Principal createPrincipal() throws WSSecurityException {
        WSDerivedKeyTokenPrincipal principal = new WSDerivedKeyTokenPrincipal(this.getID());
        principal.setNonce(this.getNonce());
        principal.setLabel(this.getLabel());
        principal.setLength(this.getLength());
        principal.setOffset(this.getOffset());
        principal.setAlgorithm(this.getAlgorithm());
        String basetokenId = null;
        SecurityTokenReference securityTokenReference = this.getSecurityTokenReference();
        if (securityTokenReference.containsReference()) {
            basetokenId = securityTokenReference.getReference().getURI();
            if (basetokenId.charAt(0) == '#') {
                basetokenId = basetokenId.substring(1);
            }
        } else {
            basetokenId = securityTokenReference.getKeyIdentifierValue();
        }
        principal.setBasetokenId(basetokenId);
        return principal;
    }

    public void setAlgorithm(String algo) {
        if (algo != null) {
            this.element.setAttributeNS(this.ns, "Algorithm", algo);
        }
    }

    public byte[] deriveKey(int length, byte[] secret) throws WSSecurityException {
        try {
            DerivationAlgorithm algo = AlgoFactory.getInstance(this.getAlgorithm());
            byte[] labelBytes = null;
            String label = this.getLabel();
            labelBytes = label == null || label.length() == 0 ? "WS-SecureConversationWS-SecureConversation".getBytes("UTF-8") : label.getBytes("UTF-8");
            byte[] nonce = Base64.decode(this.getNonce());
            byte[] seed = new byte[labelBytes.length + nonce.length];
            System.arraycopy(labelBytes, 0, seed, 0, labelBytes.length);
            System.arraycopy(nonce, 0, seed, labelBytes.length, nonce.length);
            if (length <= 0) {
                length = this.getLength();
            }
            return algo.createKey(secret, seed, this.getOffset(), length);
        }
        catch (Exception e) {
            throw new WSSecurityException(0, null, null, e);
        }
    }

    public int hashCode() {
        String nonce;
        String label;
        int length;
        int offset;
        int generation;
        int result = 17;
        String algorithm = this.getAlgorithm();
        if (algorithm != null) {
            result = 31 * result + algorithm.hashCode();
        }
        try {
            SecurityTokenReference tokenReference = this.getSecurityTokenReference();
            if (tokenReference != null) {
                result = 31 * result + tokenReference.hashCode();
            }
        }
        catch (WSSecurityException e) {
            log.error((Object)e);
        }
        Map<String, String> properties = this.getProperties();
        if (properties != null) {
            result = 31 * result + properties.hashCode();
        }
        if ((generation = this.getGeneration()) != -1) {
            result = 31 * result + generation;
        }
        if ((offset = this.getOffset()) != -1) {
            result = 31 * result + offset;
        }
        if ((length = this.getLength()) != -1) {
            result = 31 * result + length;
        }
        if ((label = this.getLabel()) != null) {
            result = 31 * result + label.hashCode();
        }
        if ((nonce = this.getNonce()) != null) {
            result = 31 * result + nonce.hashCode();
        }
        return result;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DerivedKeyToken)) {
            return false;
        }
        DerivedKeyToken token = (DerivedKeyToken)object;
        if (!this.compare(this.getAlgorithm(), token.getAlgorithm())) {
            return false;
        }
        try {
            if (!this.getSecurityTokenReference().equals(token.getSecurityTokenReference())) {
                return false;
            }
        }
        catch (WSSecurityException e) {
            log.error((Object)e);
            return false;
        }
        if (!this.compare(this.getProperties(), token.getProperties())) {
            return false;
        }
        if (this.getGeneration() != token.getGeneration()) {
            return false;
        }
        if (this.getOffset() != token.getOffset()) {
            return false;
        }
        if (this.getLength() != token.getLength()) {
            return false;
        }
        if (!this.compare(this.getLabel(), token.getLabel())) {
            return false;
        }
        return this.compare(this.getNonce(), token.getNonce());
    }

    private boolean compare(String item1, String item2) {
        if (item1 == null && item2 != null) {
            return false;
        }
        return item1 == null || item1.equals(item2);
    }

    private boolean compare(Map<String, String> item1, Map<String, String> item2) {
        if (item1 == null && item2 != null) {
            return false;
        }
        return item1 == null || item1.equals(item2);
    }
}

