/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.vm4brwsr;

import java.io.IOException;
import java.io.InputStream;
import org.apidesign.bck2brwsr.core.JavaScriptBody;
import org.apidesign.vm4brwsr.ByteCodeParser;
import org.apidesign.vm4brwsr.ExportedSymbols;
import org.apidesign.vm4brwsr.LocalsMapper;
import org.apidesign.vm4brwsr.StackMapper;
import org.apidesign.vm4brwsr.StringArray;
import org.apidesign.vm4brwsr.VarType;
import org.apidesign.vm4brwsr.Variable;

abstract class ByteCodeToJavaScript
implements Appendable {
    private ByteCodeParser.ClassData jc;
    private final Appendable out;
    private final StringArray classRefs = new StringArray();
    private boolean outChanged;
    private boolean callbacks;

    protected ByteCodeToJavaScript(Appendable out) {
        this.out = out;
    }

    @Override
    public final Appendable append(CharSequence csq) throws IOException {
        this.out.append(csq);
        this.outChanged = true;
        return this;
    }

    @Override
    public final Appendable append(CharSequence csq, int start, int end) throws IOException {
        this.out.append(csq, start, end);
        this.outChanged = true;
        return this;
    }

    @Override
    public final Appendable append(char c) throws IOException {
        this.out.append(c);
        this.outChanged = true;
        return this;
    }

    protected abstract boolean requireReference(String var1);

    protected abstract void requireScript(String var1) throws IOException;

    protected abstract void requireResource(String var1) throws IOException;

    String assignClass(String className) {
        return className + " = ";
    }

    String accessClass(String classOperation) {
        return classOperation;
    }

    final String accessClassFalse(String classOperation) {
        if (ByteCodeToJavaScript.mangleClassName(this.jc.getClassName()).equals(classOperation)) {
            return "c";
        }
        this.classRefs.addIfMissing(classOperation);
        return "(refs_" + classOperation + " || (refs_" + classOperation + " = " + this.accessClass(classOperation) + "(false)))";
    }

    protected String accessField(String object, String mangledName, String[] fieldInfoName) throws IOException {
        return object + "." + mangledName;
    }

    protected String accessStaticMethod(String object, String mangledName, String[] fieldInfoName) throws IOException {
        return object + "." + mangledName;
    }

    protected String accessVirtualMethod(String object, String mangledName, String[] fieldInfoName, int params) throws IOException {
        return object + "." + mangledName + '(';
    }

    protected void declaredClass(ByteCodeParser.ClassData classData, String mangledName) throws IOException {
    }

    protected void declaredField(ByteCodeParser.FieldData fieldData, String destObject, String mangledName) throws IOException {
    }

    protected void declaredMethod(ByteCodeParser.MethodData methodData, String destObject, String mangledName) throws IOException {
    }

    boolean debug(String msg) throws IOException {
        this.append(msg);
        return true;
    }

    public String compile(InputStream classFile) throws IOException {
        return this.compile(new ByteCodeParser.ClassData(classFile));
    }

    protected String compile(ByteCodeParser.ClassData classData) throws IOException {
        this.jc = classData;
        String cn = this.jc.getClassName();
        try {
            return this.compileImpl(cn);
        }
        catch (IOException ex) {
            throw new IOException("Cannot compile " + cn + ":", ex);
        }
    }

    private String compileImpl(String cn) throws IOException {
        String jsResource;
        String[] arr;
        this.callbacks = cn.endsWith("/$JsCallbacks$");
        if (this.jc.getMajor_version() < 50 && !cn.endsWith("/package-info")) {
            throw new IOException("Can't compile " + cn + ". Class file version " + this.jc.getMajor_version() + "." + this.jc.getMinor_version() + " - recompile with -target 1.6 (at least).");
        }
        byte[] arrData = this.jc.findAnnotationData(true);
        String[] arr2 = ByteCodeToJavaScript.findAnnotation(arrData, this.jc, "org.apidesign.bck2brwsr.core.ExtraJavaScript", "resource", "processByteCode");
        if (arr2 != null) {
            if (!arr2[0].isEmpty()) {
                this.requireScript(arr2[0]);
            }
            if ("0".equals(arr2[1])) {
                return null;
            }
        }
        if ((arr = ByteCodeToJavaScript.findAnnotation(arrData, this.jc, "net.java.html.js.JavaScriptResource", "value")) != null) {
            if (arr[0].startsWith("/")) {
                jsResource = arr[0];
            } else {
                int last = cn.lastIndexOf(47);
                jsResource = cn.substring(0, last + 1).replace('.', '/') + arr[0];
            }
        } else {
            jsResource = null;
        }
        String[] proto = ByteCodeToJavaScript.findAnnotation(arrData, this.jc, "org.apidesign.bck2brwsr.core.JavaScriptPrototype", "container", "prototype");
        StringArray toInitilize = new StringArray();
        String className = ByteCodeToJavaScript.className(this.jc);
        this.append("\n\n").append(this.assignClass(className));
        this.append("function ").append(className).append("() {");
        this.append("\n  var m;");
        this.append("\n  var CLS = ").append(className).append(';');
        this.append("\n  if (!CLS.$class) {");
        if (proto == null) {
            String sc = this.jc.getSuperClassName();
            this.append("\n    var pp = ").append(this.accessClass(ByteCodeToJavaScript.mangleClassName(sc))).append("(true);");
            this.append("\n    var p = CLS.prototype = pp;");
            this.append("\n    var c = p;");
            this.append("\n    var sprcls = pp.constructor.$class;");
        } else {
            this.append("\n    var p = CLS.prototype = ").append(proto[1]).append(";");
            if (proto[0] == null) {
                proto[0] = "p";
            }
            this.append("\n    var c = ").append(proto[0]).append(";");
            this.append("\n    var sprcls = null;");
        }
        for (ByteCodeParser.FieldData v : this.jc.getFields()) {
            if (v.isStatic()) {
                if ((v.access & 0x10) != 0 && v.hasConstantValue() && (v.getInternalSig().length() == 1 || v.getInternalSig().equals("Ljava/lang/String;"))) continue;
                this.append("\n  CLS.fld_").append(v.getName()).append(this.initField(v));
                this.append("\n  m = c._").append(v.getName()).append(" = function (v) {").append("  if (arguments.length == 1) CLS.fld_").append(v.getName()).append(" = v; return CLS.fld_").append(v.getName()).append("; };");
            } else {
                this.append("\n  m = c._").append(v.getName()).append(" = function (v) {").append("  if (arguments.length == 1) this.fld_").append(className).append('_').append(v.getName()).append(" = v; return this.fld_").append(className).append('_').append(v.getName()).append("; };");
            }
            this.declaredField(v, "c", "_" + v.getName());
        }
        for (ByteCodeParser.MethodData m : this.jc.getMethods()) {
            String mn;
            String destObject;
            byte[] onlyArr = m.findAnnotationData(true);
            if (this.javaScriptOnly(onlyArr)) continue;
            this.append("\n    ");
            if (m.isStatic()) {
                destObject = "c";
                mn = this.generateStaticMethod(destObject, m, toInitilize);
            } else if (m.isConstructor()) {
                destObject = "CLS";
                mn = this.generateInstanceMethod(destObject, m);
            } else {
                destObject = "c";
                mn = this.generateInstanceMethod(destObject, m);
            }
            this.declaredMethod(m, destObject, mn);
            byte[] runAnno = m.findAnnotationData(false);
            if (runAnno != null) {
                this.append("\n    m.anno = {");
                this.generateAnno(this.jc, runAnno);
                this.append("\n    };");
            }
            this.append("\n    m.access = " + m.getAccess()).append(";");
            this.append("\n    m.cls = CLS;");
        }
        this.append("\n    c.constructor = CLS;");
        this.append("\n    function ").append(className).append("fillInstOf(x) {");
        String instOfName = "$instOf_" + className;
        this.append("\n        Object.defineProperty(x, '").append(instOfName).append("', { value : true });");
        if (this.jc.isInterface()) {
            for (ByteCodeParser.MethodData m : this.jc.getMethods()) {
                if ((m.getAccess() & 0x400) != 0 || (m.getAccess() & 8) != 0 || (m.getAccess() & 2) != 0) continue;
                String mn = ByteCodeToJavaScript.findMethodName(m, new StringBuilder());
                this.append("\n        if (!x['").append(mn).append("']) Object.defineProperty(x, '").append(mn).append("', { value : c['").append(mn).append("']});");
            }
        }
        for (String superInterface : this.jc.getSuperInterfaces()) {
            String intrfc = ByteCodeToJavaScript.mangleClassName(superInterface);
            this.append("\n      vm.").append(intrfc).append("(false)['fillInstOf'](x);");
            this.requireReference(superInterface);
        }
        this.append("\n    }");
        this.append("\n    if (!c.hasOwnProperty('fillInstOf')) Object.defineProperty(c, 'fillInstOf', { value: ").append(className).append("fillInstOf });");
        this.append("\n    ").append(className).append("fillInstOf(c);");
        this.append("\n    CLS.$class = 'temp';");
        this.append("\n    CLS.$class = ");
        this.append(this.accessClass("java_lang_Class(true);"));
        this.append("\n    CLS.$class.jvmName = '").append(cn).append("';");
        this.append("\n    CLS.$class.superclass = sprcls;");
        this.append("\n    CLS.$class.interfaces = function() { return [");
        boolean first = true;
        for (String intrfc : this.jc.getSuperInterfaces()) {
            if (!first) {
                this.append(",");
            }
            this.requireReference(intrfc);
            String mangledIface = ByteCodeToJavaScript.mangleClassName(intrfc);
            this.append("\n        ");
            this.append(this.accessClass(mangledIface)).append("(false).constructor.$class");
            first = false;
        }
        this.append("\n    ]; };");
        this.append("\n    CLS.$class.access = ").append(this.jc.getAccessFlags() + ";");
        this.append("\n    CLS.$class.cnstr = CLS;");
        byte[] classAnno = this.jc.findAnnotationData(false);
        if (classAnno != null) {
            this.append("\n    CLS.$class.anno = {");
            this.generateAnno(this.jc, classAnno);
            this.append("\n    };");
        }
        for (String init : toInitilize.toArray()) {
            this.append("\n    ").append(init).append("();");
        }
        for (String ref : this.classRefs.toArray()) {
            this.append("\n    var refs_").append(ref).append(";");
        }
        this.classRefs.clear();
        if (jsResource != null) {
            this.requireResource(jsResource);
        }
        this.append("\n  }");
        this.append("\n  if (arguments.length === 0) {");
        this.append("\n    if (!(this instanceof CLS)) {");
        this.append("\n      return new CLS();");
        this.append("\n    }");
        for (ByteCodeParser.FieldData v : this.jc.getFields()) {
            byte[] onlyArr = v.findAnnotationData(true);
            if (this.javaScriptOnly(onlyArr) || v.isStatic()) continue;
            this.append("\n    this.fld_").append(className).append('_').append(v.getName()).append(this.initField(v));
        }
        this.append("\n    return this;");
        this.append("\n  }");
        this.append("\n  return arguments[0] ? new CLS() : CLS.prototype;");
        this.append("\n};");
        this.declaredClass(this.jc, className);
        return "";
    }

    private boolean javaScriptOnly(byte[] anno) throws IOException {
        String[] only = ByteCodeToJavaScript.findAnnotation(anno, this.jc, "org.apidesign.bck2brwsr.core.JavaScriptOnly", "name", "value");
        if (only != null) {
            if (only[0] != null && only[1] != null) {
                this.append("\n    p.").append(only[0]).append(" = ").append(only[1]).append(";");
            }
            if (ExportedSymbols.isMarkedAsExported(anno, this.jc)) {
                this.append("\n    p['").append(only[0]).append("'] = p.").append(only[0]).append(";");
            }
            return true;
        }
        return false;
    }

    private String generateStaticMethod(String destObject, ByteCodeParser.MethodData m, StringArray toInitilize) throws IOException {
        String jsb = this.javaScriptBody(destObject, m, true);
        if (jsb != null) {
            return jsb;
        }
        String mn = ByteCodeToJavaScript.findMethodName(m, new StringBuilder());
        boolean defineProp = this.generateMethod(destObject, mn, m);
        if (mn.equals("class__V")) {
            if (defineProp) {
                toInitilize.add(this.accessClassFalse(ByteCodeToJavaScript.className(this.jc)) + "['" + mn + "']");
            } else {
                toInitilize.add(this.accessClassFalse(ByteCodeToJavaScript.className(this.jc)) + "." + mn);
            }
        }
        return mn;
    }

    private String generateInstanceMethod(String destObject, ByteCodeParser.MethodData m) throws IOException {
        String jsb = this.javaScriptBody(destObject, m, false);
        if (jsb != null) {
            return jsb;
        }
        String mn = ByteCodeToJavaScript.findMethodName(m, new StringBuilder());
        this.generateMethod(destObject, mn, m);
        return mn;
    }

    private boolean generateMethod(String destObject, String name, ByteCodeParser.MethodData m) throws IOException {
        int lastStackFrame;
        boolean didBranches;
        boolean defineProp;
        ByteCodeParser.StackMapIterator stackMapIterator = m.createStackMapIterator();
        ByteCodeParser.TrapDataIterator trap = m.getTrapDataIterator();
        LocalsMapper lmapper = new LocalsMapper(stackMapIterator.getArguments());
        boolean bl = defineProp = "java/lang/Object".equals(this.jc.getClassName()) || "java/lang/reflect/Array".equals(this.jc.getClassName());
        if (defineProp) {
            this.append("Object.defineProperty(").append(destObject).append(", '").append(name).append("', { configurable: true, writable: true, value: m = function(");
        } else {
            this.append("m = ").append(destObject).append(".").append(name).append(" = function(");
        }
        lmapper.outputArguments(this, m.isStatic());
        this.append(") {").append("\n");
        byte[] byteCodes = m.getCode();
        if (byteCodes == null) {
            if (this.debug("  throw 'no code found for ")) {
                this.append(this.jc.getClassName()).append('.').append(m.getName()).append("';\n");
            }
            if (defineProp) {
                this.append("}});");
            } else {
                this.append("};");
            }
            return defineProp;
        }
        StackMapper smapper = new StackMapper();
        if (!m.isStatic()) {
            this.append("  var ").append(" lcA0 = this;\n");
        }
        ByteCodeParser.TrapData[] previousTrap = null;
        boolean wide = false;
        if (stackMapIterator.isEmpty()) {
            didBranches = false;
            lastStackFrame = 0;
        } else {
            didBranches = true;
            lastStackFrame = -1;
            this.append("\n  var gt = 0;\n");
        }
        int openBraces = 0;
        int topMostLabel = 0;
        for (int i = 0; i < byteCodes.length; ++i) {
            int c;
            int prev = i;
            this.outChanged = false;
            stackMapIterator.advanceTo(i);
            boolean changeInCatch = trap.advanceTo(i);
            if ((changeInCatch || lastStackFrame != stackMapIterator.getFrameIndex()) && previousTrap != null) {
                this.generateCatch(previousTrap, i, topMostLabel);
                previousTrap = null;
            }
            if (lastStackFrame != stackMapIterator.getFrameIndex()) {
                smapper.flush(this);
                if (i != 0) {
                    this.append("    }\n");
                }
                if (openBraces > 64) {
                    for (c = 0; c < 64; ++c) {
                        this.append("break;}\n");
                    }
                    openBraces = 1;
                    topMostLabel = i;
                }
                lastStackFrame = stackMapIterator.getFrameIndex();
                lmapper.syncWithFrameLocals(stackMapIterator.getFrameLocals());
                smapper.syncWithFrameStack(stackMapIterator.getFrameStack());
                this.append("    X_" + i).append(": for (;;) { IF: if (gt <= " + i + ") {\n");
                ++openBraces;
                changeInCatch = true;
            } else {
                this.debug("    /* " + i + " */ ");
            }
            if (changeInCatch && trap.useTry()) {
                this.append("try {");
                previousTrap = trap.current();
            }
            c = ByteCodeToJavaScript.readUByte(byteCodes, i);
            switch (c) {
                case 42: {
                    smapper.assign(this, 4, lmapper.getA(0));
                    break;
                }
                case 26: {
                    smapper.assign(this, 0, lmapper.getI(0));
                    break;
                }
                case 30: {
                    smapper.assign(this, 1, lmapper.getL(0));
                    break;
                }
                case 34: {
                    smapper.assign(this, 2, lmapper.getF(0));
                    break;
                }
                case 38: {
                    smapper.assign(this, 3, lmapper.getD(0));
                    break;
                }
                case 43: {
                    smapper.assign(this, 4, lmapper.getA(1));
                    break;
                }
                case 27: {
                    smapper.assign(this, 0, lmapper.getI(1));
                    break;
                }
                case 31: {
                    smapper.assign(this, 1, lmapper.getL(1));
                    break;
                }
                case 35: {
                    smapper.assign(this, 2, lmapper.getF(1));
                    break;
                }
                case 39: {
                    smapper.assign(this, 3, lmapper.getD(1));
                    break;
                }
                case 44: {
                    smapper.assign(this, 4, lmapper.getA(2));
                    break;
                }
                case 28: {
                    smapper.assign(this, 0, lmapper.getI(2));
                    break;
                }
                case 32: {
                    smapper.assign(this, 1, lmapper.getL(2));
                    break;
                }
                case 36: {
                    smapper.assign(this, 2, lmapper.getF(2));
                    break;
                }
                case 40: {
                    smapper.assign(this, 3, lmapper.getD(2));
                    break;
                }
                case 45: {
                    smapper.assign(this, 4, lmapper.getA(3));
                    break;
                }
                case 29: {
                    smapper.assign(this, 0, lmapper.getI(3));
                    break;
                }
                case 33: {
                    smapper.assign(this, 1, lmapper.getL(3));
                    break;
                }
                case 37: {
                    smapper.assign(this, 2, lmapper.getF(3));
                    break;
                }
                case 41: {
                    smapper.assign(this, 3, lmapper.getD(3));
                    break;
                }
                case 21: {
                    ++i;
                    int indx = wide ? ByteCodeToJavaScript.readUShort(byteCodes, i++) : ByteCodeToJavaScript.readUByte(byteCodes, i);
                    wide = false;
                    smapper.assign(this, 0, lmapper.getI(indx));
                    break;
                }
                case 22: {
                    ++i;
                    int indx = wide ? ByteCodeToJavaScript.readUShort(byteCodes, i++) : ByteCodeToJavaScript.readUByte(byteCodes, i);
                    wide = false;
                    smapper.assign(this, 1, lmapper.getL(indx));
                    break;
                }
                case 23: {
                    ++i;
                    int indx = wide ? ByteCodeToJavaScript.readUShort(byteCodes, i++) : ByteCodeToJavaScript.readUByte(byteCodes, i);
                    wide = false;
                    smapper.assign(this, 2, lmapper.getF(indx));
                    break;
                }
                case 24: {
                    ++i;
                    int indx = wide ? ByteCodeToJavaScript.readUShort(byteCodes, i++) : ByteCodeToJavaScript.readUByte(byteCodes, i);
                    wide = false;
                    smapper.assign(this, 3, lmapper.getD(indx));
                    break;
                }
                case 25: {
                    ++i;
                    int indx = wide ? ByteCodeToJavaScript.readUShort(byteCodes, i++) : ByteCodeToJavaScript.readUByte(byteCodes, i);
                    wide = false;
                    smapper.assign(this, 4, lmapper.getA(indx));
                    break;
                }
                case 54: {
                    ++i;
                    int indx = wide ? ByteCodeToJavaScript.readUShort(byteCodes, i++) : ByteCodeToJavaScript.readUByte(byteCodes, i);
                    wide = false;
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setI(indx), smapper.popI());
                    break;
                }
                case 55: {
                    ++i;
                    int indx = wide ? ByteCodeToJavaScript.readUShort(byteCodes, i++) : ByteCodeToJavaScript.readUByte(byteCodes, i);
                    wide = false;
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setL(indx), smapper.popL());
                    break;
                }
                case 56: {
                    ++i;
                    int indx = wide ? ByteCodeToJavaScript.readUShort(byteCodes, i++) : ByteCodeToJavaScript.readUByte(byteCodes, i);
                    wide = false;
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setF(indx), smapper.popF());
                    break;
                }
                case 57: {
                    ++i;
                    int indx = wide ? ByteCodeToJavaScript.readUShort(byteCodes, i++) : ByteCodeToJavaScript.readUByte(byteCodes, i);
                    wide = false;
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setD(indx), smapper.popD());
                    break;
                }
                case 58: {
                    ++i;
                    int indx = wide ? ByteCodeToJavaScript.readUShort(byteCodes, i++) : ByteCodeToJavaScript.readUByte(byteCodes, i);
                    wide = false;
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setA(indx), smapper.popA());
                    break;
                }
                case 75: {
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setA(0), smapper.popA());
                    break;
                }
                case 59: {
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setI(0), smapper.popI());
                    break;
                }
                case 63: {
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setL(0), smapper.popL());
                    break;
                }
                case 67: {
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setF(0), smapper.popF());
                    break;
                }
                case 71: {
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setD(0), smapper.popD());
                    break;
                }
                case 76: {
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setA(1), smapper.popA());
                    break;
                }
                case 60: {
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setI(1), smapper.popI());
                    break;
                }
                case 64: {
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setL(1), smapper.popL());
                    break;
                }
                case 68: {
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setF(1), smapper.popF());
                    break;
                }
                case 72: {
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setD(1), smapper.popD());
                    break;
                }
                case 77: {
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setA(2), smapper.popA());
                    break;
                }
                case 61: {
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setI(2), smapper.popI());
                    break;
                }
                case 65: {
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setL(2), smapper.popL());
                    break;
                }
                case 69: {
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setF(2), smapper.popF());
                    break;
                }
                case 73: {
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setD(2), smapper.popD());
                    break;
                }
                case 78: {
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setA(3), smapper.popA());
                    break;
                }
                case 62: {
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setI(3), smapper.popI());
                    break;
                }
                case 66: {
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setL(3), smapper.popL());
                    break;
                }
                case 70: {
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setF(3), smapper.popF());
                    break;
                }
                case 74: {
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", lmapper.setD(3), smapper.popD());
                    break;
                }
                case 96: {
                    smapper.replace(this, 0, "(@1).add32(@2)", smapper.getI(1), smapper.popI());
                    break;
                }
                case 97: {
                    smapper.replace(this, 1, "(@1).add64(@2)", smapper.getL(1), smapper.popL());
                    break;
                }
                case 98: {
                    smapper.replace(this, 2, "(@1 + @2)", smapper.getF(1), smapper.popF());
                    break;
                }
                case 99: {
                    smapper.replace(this, 3, "(@1 + @2)", smapper.getD(1), smapper.popD());
                    break;
                }
                case 100: {
                    smapper.replace(this, 0, "(@1).sub32(@2)", smapper.getI(1), smapper.popI());
                    break;
                }
                case 101: {
                    smapper.replace(this, 1, "(@1).sub64(@2)", smapper.getL(1), smapper.popL());
                    break;
                }
                case 102: {
                    smapper.replace(this, 2, "(@1 - @2)", smapper.getF(1), smapper.popF());
                    break;
                }
                case 103: {
                    smapper.replace(this, 3, "(@1 - @2)", smapper.getD(1), smapper.popD());
                    break;
                }
                case 104: {
                    smapper.replace(this, 0, "(@1).mul32(@2)", smapper.getI(1), smapper.popI());
                    break;
                }
                case 105: {
                    smapper.replace(this, 1, "(@1).mul64(@2)", smapper.getL(1), smapper.popL());
                    break;
                }
                case 106: {
                    smapper.replace(this, 2, "(@1 * @2)", smapper.getF(1), smapper.popF());
                    break;
                }
                case 107: {
                    smapper.replace(this, 3, "(@1 * @2)", smapper.getD(1), smapper.popD());
                    break;
                }
                case 108: {
                    smapper.replace(this, 0, "(@1).div32(@2)", smapper.getI(1), smapper.popI());
                    break;
                }
                case 109: {
                    smapper.replace(this, 1, "(@1).div64(@2)", smapper.getL(1), smapper.popL());
                    break;
                }
                case 110: {
                    smapper.replace(this, 2, "(@1 / @2)", smapper.getF(1), smapper.popF());
                    break;
                }
                case 111: {
                    smapper.replace(this, 3, "(@1 / @2)", smapper.getD(1), smapper.popD());
                    break;
                }
                case 112: {
                    smapper.replace(this, 0, "(@1).mod32(@2)", smapper.getI(1), smapper.popI());
                    break;
                }
                case 113: {
                    smapper.replace(this, 1, "(@1).mod64(@2)", smapper.getL(1), smapper.popL());
                    break;
                }
                case 114: {
                    smapper.replace(this, 2, "(@1 % @2)", smapper.getF(1), smapper.popF());
                    break;
                }
                case 115: {
                    smapper.replace(this, 3, "(@1 % @2)", smapper.getD(1), smapper.popD());
                    break;
                }
                case 126: {
                    smapper.replace(this, 0, "(@1 & @2)", smapper.getI(1), smapper.popI());
                    break;
                }
                case 127: {
                    smapper.replace(this, 1, "(@1).and64(@2)", smapper.getL(1), smapper.popL());
                    break;
                }
                case 128: {
                    smapper.replace(this, 0, "(@1 | @2)", smapper.getI(1), smapper.popI());
                    break;
                }
                case 129: {
                    smapper.replace(this, 1, "(@1).or64(@2)", smapper.getL(1), smapper.popL());
                    break;
                }
                case 130: {
                    smapper.replace(this, 0, "(@1 ^ @2)", smapper.getI(1), smapper.popI());
                    break;
                }
                case 131: {
                    smapper.replace(this, 1, "(@1).xor64(@2)", smapper.getL(1), smapper.popL());
                    break;
                }
                case 116: {
                    smapper.replace(this, 0, "(@1).neg32()", smapper.getI(0));
                    break;
                }
                case 117: {
                    smapper.replace(this, 1, "(@1).neg64()", smapper.getL(0));
                    break;
                }
                case 118: {
                    smapper.replace(this, 2, "(-@1)", smapper.getF(0));
                    break;
                }
                case 119: {
                    smapper.replace(this, 3, "(-@1)", smapper.getD(0));
                    break;
                }
                case 120: {
                    smapper.replace(this, 0, "(@1 << @2)", smapper.getI(1), smapper.popI());
                    break;
                }
                case 121: {
                    smapper.replace(this, 1, "(@1).shl64(@2)", smapper.getL(1), smapper.popI());
                    break;
                }
                case 122: {
                    smapper.replace(this, 0, "(@1 >> @2)", smapper.getI(1), smapper.popI());
                    break;
                }
                case 123: {
                    smapper.replace(this, 1, "(@1).shr64(@2)", smapper.getL(1), smapper.popI());
                    break;
                }
                case 124: {
                    smapper.replace(this, 0, "(@1 >>> @2)", smapper.getI(1), smapper.popI());
                    break;
                }
                case 125: {
                    smapper.replace(this, 1, "(@1).ushr64(@2)", smapper.getL(1), smapper.popI());
                    break;
                }
                case 132: {
                    ++i;
                    int varIndx = wide ? ByteCodeToJavaScript.readUShort(byteCodes, i++) : ByteCodeToJavaScript.readUByte(byteCodes, i);
                    ++i;
                    int incrBy = wide ? ByteCodeToJavaScript.readShort(byteCodes, i++) : byteCodes[i];
                    wide = false;
                    if (incrBy == 1) {
                        ByteCodeToJavaScript.emit(smapper, this, "@1++;", lmapper.getI(varIndx));
                        break;
                    }
                    ByteCodeToJavaScript.emit(smapper, this, "@1 += @2;", lmapper.getI(varIndx), Integer.toString(incrBy));
                    break;
                }
                case 177: {
                    ByteCodeToJavaScript.emit(smapper, this, "return;", new CharSequence[0]);
                    break;
                }
                case 172: {
                    ByteCodeToJavaScript.emit(smapper, this, "return @1;", smapper.popI());
                    break;
                }
                case 173: {
                    ByteCodeToJavaScript.emit(smapper, this, "return @1;", smapper.popL());
                    break;
                }
                case 174: {
                    ByteCodeToJavaScript.emit(smapper, this, "return @1;", smapper.popF());
                    break;
                }
                case 175: {
                    ByteCodeToJavaScript.emit(smapper, this, "return @1;", smapper.popD());
                    break;
                }
                case 176: {
                    ByteCodeToJavaScript.emit(smapper, this, "return @1;", smapper.popA());
                    break;
                }
                case 133: {
                    smapper.replace(this, 1, "@1", smapper.getI(0));
                    break;
                }
                case 134: {
                    smapper.replace(this, 2, "@1", smapper.getI(0));
                    break;
                }
                case 135: {
                    smapper.replace(this, 3, "@1", smapper.getI(0));
                    break;
                }
                case 136: {
                    smapper.replace(this, 0, "(@1).toInt32()", smapper.getL(0));
                    break;
                }
                case 137: {
                    smapper.replace(this, 2, "(@1).toFP()", smapper.getL(0));
                    break;
                }
                case 138: {
                    smapper.replace(this, 3, "(@1).toFP()", smapper.getL(0));
                    break;
                }
                case 141: {
                    smapper.replace(this, 3, "@1", smapper.getF(0));
                    break;
                }
                case 144: {
                    smapper.replace(this, 2, "@1", smapper.getD(0));
                    break;
                }
                case 139: {
                    smapper.replace(this, 0, "(@1).toInt32()", smapper.getF(0));
                    break;
                }
                case 140: {
                    smapper.replace(this, 1, "(@1).toLong()", smapper.getF(0));
                    break;
                }
                case 142: {
                    smapper.replace(this, 0, "(@1).toInt32()", smapper.getD(0));
                    break;
                }
                case 143: {
                    smapper.replace(this, 1, "(@1).toLong()", smapper.getD(0));
                    break;
                }
                case 145: {
                    smapper.replace(this, 0, "(@1).toInt8()", smapper.getI(0));
                    break;
                }
                case 146: 
                case 147: {
                    smapper.replace(this, 0, "(@1).toInt16()", smapper.getI(0));
                    break;
                }
                case 1: {
                    smapper.assign(this, 4, "null");
                    break;
                }
                case 2: {
                    smapper.assign(this, 0, "-1");
                    break;
                }
                case 3: {
                    smapper.assign(this, 0, "0");
                    break;
                }
                case 14: {
                    smapper.assign(this, 3, "0");
                    break;
                }
                case 9: {
                    smapper.assign(this, 1, "0");
                    break;
                }
                case 11: {
                    smapper.assign(this, 2, "0");
                    break;
                }
                case 4: {
                    smapper.assign(this, 0, "1");
                    break;
                }
                case 10: {
                    smapper.assign(this, 1, "1");
                    break;
                }
                case 12: {
                    smapper.assign(this, 2, "1");
                    break;
                }
                case 15: {
                    smapper.assign(this, 3, "1");
                    break;
                }
                case 5: {
                    smapper.assign(this, 0, "2");
                    break;
                }
                case 13: {
                    smapper.assign(this, 2, "2");
                    break;
                }
                case 6: {
                    smapper.assign(this, 0, "3");
                    break;
                }
                case 7: {
                    smapper.assign(this, 0, "4");
                    break;
                }
                case 8: {
                    smapper.assign(this, 0, "5");
                    break;
                }
                case 18: {
                    int indx = ByteCodeToJavaScript.readUByte(byteCodes, ++i);
                    String v = this.encodeConstant(indx);
                    int type = VarType.fromConstantType(this.jc.getTag(indx));
                    smapper.assign(this, type, v);
                    break;
                }
                case 19: 
                case 20: {
                    int indx = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
                    i += 2;
                    String v = this.encodeConstant(indx);
                    int type = VarType.fromConstantType(this.jc.getTag(indx));
                    if (type == 1) {
                        Long lv = new Long(v);
                        int low = (int)(lv & 0xFFFFFFFFFFFFFFFFL);
                        int hi = (int)(lv >> 32);
                        if (hi == 0) {
                            smapper.assign(this, 1, "0x" + Integer.toHexString(low));
                            break;
                        }
                        smapper.assign(this, 1, "0x" + Integer.toHexString(hi) + ".next32(0x" + Integer.toHexString(low) + ")");
                        break;
                    }
                    smapper.assign(this, type, v);
                    break;
                }
                case 148: {
                    smapper.replace(this, 0, "(@2).compare64(@1)", smapper.popL(), smapper.getL(0));
                    break;
                }
                case 149: 
                case 150: {
                    ByteCodeToJavaScript.emit(smapper, this, "var @3 = (@2 == @1) ? 0 : ((@2 < @1) ? -1 : 1);", smapper.popF(), smapper.popF(), smapper.pushI());
                    break;
                }
                case 151: 
                case 152: {
                    ByteCodeToJavaScript.emit(smapper, this, "var @3 = (@2 == @1) ? 0 : ((@2 < @1) ? -1 : 1);", smapper.popD(), smapper.popD(), smapper.pushI());
                    break;
                }
                case 165: {
                    i = this.generateIf(smapper, byteCodes, i, smapper.popA(), smapper.popA(), "===", topMostLabel);
                    break;
                }
                case 166: {
                    i = this.generateIf(smapper, byteCodes, i, smapper.popA(), smapper.popA(), "!==", topMostLabel);
                    break;
                }
                case 159: {
                    i = this.generateIf(smapper, byteCodes, i, smapper.popI(), smapper.popI(), "==", topMostLabel);
                    break;
                }
                case 153: {
                    int indx = i + ByteCodeToJavaScript.readShortArg(byteCodes, i);
                    ByteCodeToJavaScript.emitIf(smapper, this, "if ((@1) == 0) ", smapper.popI(), i, indx, topMostLabel);
                    i += 2;
                    break;
                }
                case 154: {
                    int indx = i + ByteCodeToJavaScript.readShortArg(byteCodes, i);
                    ByteCodeToJavaScript.emitIf(smapper, this, "if ((@1) != 0) ", smapper.popI(), i, indx, topMostLabel);
                    i += 2;
                    break;
                }
                case 155: {
                    int indx = i + ByteCodeToJavaScript.readShortArg(byteCodes, i);
                    ByteCodeToJavaScript.emitIf(smapper, this, "if ((@1) < 0) ", smapper.popI(), i, indx, topMostLabel);
                    i += 2;
                    break;
                }
                case 158: {
                    int indx = i + ByteCodeToJavaScript.readShortArg(byteCodes, i);
                    ByteCodeToJavaScript.emitIf(smapper, this, "if ((@1) <= 0) ", smapper.popI(), i, indx, topMostLabel);
                    i += 2;
                    break;
                }
                case 157: {
                    int indx = i + ByteCodeToJavaScript.readShortArg(byteCodes, i);
                    ByteCodeToJavaScript.emitIf(smapper, this, "if ((@1) > 0) ", smapper.popI(), i, indx, topMostLabel);
                    i += 2;
                    break;
                }
                case 156: {
                    int indx = i + ByteCodeToJavaScript.readShortArg(byteCodes, i);
                    ByteCodeToJavaScript.emitIf(smapper, this, "if ((@1) >= 0) ", smapper.popI(), i, indx, topMostLabel);
                    i += 2;
                    break;
                }
                case 199: {
                    int indx = i + ByteCodeToJavaScript.readShortArg(byteCodes, i);
                    ByteCodeToJavaScript.emitIf(smapper, this, "if ((@1) !== null) ", smapper.popA(), i, indx, topMostLabel);
                    i += 2;
                    break;
                }
                case 198: {
                    int indx = i + ByteCodeToJavaScript.readShortArg(byteCodes, i);
                    ByteCodeToJavaScript.emitIf(smapper, this, "if ((@1) === null) ", smapper.popA(), i, indx, topMostLabel);
                    i += 2;
                    break;
                }
                case 160: {
                    i = this.generateIf(smapper, byteCodes, i, smapper.popI(), smapper.popI(), "!=", topMostLabel);
                    break;
                }
                case 161: {
                    i = this.generateIf(smapper, byteCodes, i, smapper.popI(), smapper.popI(), "<", topMostLabel);
                    break;
                }
                case 164: {
                    i = this.generateIf(smapper, byteCodes, i, smapper.popI(), smapper.popI(), "<=", topMostLabel);
                    break;
                }
                case 163: {
                    i = this.generateIf(smapper, byteCodes, i, smapper.popI(), smapper.popI(), ">", topMostLabel);
                    break;
                }
                case 162: {
                    i = this.generateIf(smapper, byteCodes, i, smapper.popI(), smapper.popI(), ">=", topMostLabel);
                    break;
                }
                case 167: {
                    smapper.flush(this);
                    int indx = i + ByteCodeToJavaScript.readShortArg(byteCodes, i);
                    ByteCodeToJavaScript.goTo(this, i, indx, topMostLabel);
                    i += 2;
                    break;
                }
                case 171: {
                    i = this.generateLookupSwitch(i, byteCodes, smapper, topMostLabel);
                    break;
                }
                case 170: {
                    i = this.generateTableSwitch(i, byteCodes, smapper, topMostLabel);
                    break;
                }
                case 185: {
                    i = this.invokeVirtualMethod(byteCodes, i, smapper) + 2;
                    break;
                }
                case 182: {
                    i = this.invokeVirtualMethod(byteCodes, i, smapper);
                    break;
                }
                case 183: {
                    i = this.invokeStaticMethod(byteCodes, i, smapper, false);
                    break;
                }
                case 184: {
                    i = this.invokeStaticMethod(byteCodes, i, smapper, true);
                    break;
                }
                case 186: {
                    int indx = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
                    ByteCodeToJavaScript.println("invoke dynamic: " + indx);
                    ByteCodeParser.CPX2 c2 = this.jc.getCpoolEntry(indx);
                    ByteCodeParser.BootMethodData bm = this.jc.getBootMethod(c2.cpx1);
                    ByteCodeParser.CPX2 methodHandle = this.jc.getCpoolEntry(bm.method);
                    ByteCodeToJavaScript.println("  type: " + methodHandle.cpx1);
                    String[] mi = this.jc.getFieldInfoName(methodHandle.cpx2);
                    String mcn = ByteCodeToJavaScript.mangleClassName(mi[0]);
                    char[] returnType = new char[]{'V'};
                    StringBuilder cnt = new StringBuilder();
                    String mn = ByteCodeToJavaScript.findMethodName(mi, cnt, returnType);
                    StringBuilder sb = new StringBuilder();
                    sb.append("We don't handle invokedynamic, need to preprocess ahead-of-time:\n");
                    sb.append("  mi[0]: ").append(mi[0]).append("\n");
                    sb.append("  mi[1]: ").append(mi[1]).append("\n");
                    sb.append("  mi[2]: ").append(mi[2]).append("\n");
                    sb.append("  mn   : ").append(mn).append("\n");
                    sb.append("  name and type: ").append(this.jc.stringValue(c2.cpx2, true)).append("\n");
                    throw new IOException(sb.toString());
                }
                case 187: {
                    int indx = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
                    String ci = this.jc.getClassName(indx);
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = new @2;", smapper.pushA(), this.accessClass(ByteCodeToJavaScript.mangleClassName(ci)));
                    this.addReference(ci);
                    i += 2;
                    break;
                }
                case 188: {
                    int atype = ByteCodeToJavaScript.readUByte(byteCodes, ++i);
                    this.generateNewArray(atype, smapper);
                    break;
                }
                case 189: {
                    int type = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
                    i += 2;
                    this.generateANewArray(type, smapper);
                    break;
                }
                case 197: {
                    int type = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
                    i += 2;
                    i = this.generateMultiANewArray(type, byteCodes, i, smapper);
                    break;
                }
                case 190: {
                    smapper.replace(this, 0, "(@1).length", smapper.getA(0));
                    break;
                }
                case 80: {
                    ByteCodeToJavaScript.emit(smapper, this, "Array.at(@3, @2, @1);", smapper.popL(), smapper.popI(), smapper.popA());
                    break;
                }
                case 81: {
                    ByteCodeToJavaScript.emit(smapper, this, "Array.at(@3, @2, @1);", smapper.popF(), smapper.popI(), smapper.popA());
                    break;
                }
                case 82: {
                    ByteCodeToJavaScript.emit(smapper, this, "Array.at(@3, @2, @1);", smapper.popD(), smapper.popI(), smapper.popA());
                    break;
                }
                case 83: {
                    ByteCodeToJavaScript.emit(smapper, this, "Array.at(@3, @2, @1);", smapper.popA(), smapper.popI(), smapper.popA());
                    break;
                }
                case 79: 
                case 84: 
                case 85: 
                case 86: {
                    ByteCodeToJavaScript.emit(smapper, this, "Array.at(@3, @2, @1);", smapper.popI(), smapper.popI(), smapper.popA());
                    break;
                }
                case 47: {
                    smapper.replace(this, 1, "Array.at(@2, @1)", smapper.popI(), smapper.getA(0));
                    break;
                }
                case 48: {
                    smapper.replace(this, 2, "Array.at(@2, @1)", smapper.popI(), smapper.getA(0));
                    break;
                }
                case 49: {
                    smapper.replace(this, 3, "Array.at(@2, @1)", smapper.popI(), smapper.getA(0));
                    break;
                }
                case 50: {
                    smapper.replace(this, 4, "Array.at(@2, @1)", smapper.popI(), smapper.getA(0));
                    break;
                }
                case 46: 
                case 51: 
                case 52: 
                case 53: {
                    smapper.replace(this, 0, "Array.at(@2, @1)", smapper.popI(), smapper.getA(0));
                    break;
                }
                case 87: 
                case 88: {
                    smapper.pop(1);
                    this.debug("/* pop */");
                    break;
                }
                case 89: {
                    Variable v = smapper.get(0);
                    if (smapper.isDirty()) {
                        ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", smapper.pushT(v.getType()), v);
                        break;
                    }
                    smapper.assign(this, v.getType(), v);
                    break;
                }
                case 92: {
                    Variable vi1 = smapper.get(0);
                    if (vi1.isCategory2()) {
                        ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2;", smapper.pushT(vi1.getType()), vi1);
                        break;
                    }
                    Variable vi2 = smapper.get(1);
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2, @3 = @4;", smapper.pushT(vi2.getType()), vi2, smapper.pushT(vi1.getType()), vi1);
                    break;
                }
                case 90: {
                    Variable vi1 = smapper.pop(this);
                    Variable vi2 = smapper.pop(this);
                    Variable vo3 = smapper.pushT(vi1.getType());
                    Variable vo2 = smapper.pushT(vi2.getType());
                    Variable vo1 = smapper.pushT(vi1.getType());
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2, @3 = @4, @5 = @6;", vo1, vi1, vo2, vi2, vo3, vo1);
                    break;
                }
                case 93: {
                    Variable vi1 = smapper.pop(this);
                    Variable vi2 = smapper.pop(this);
                    if (vi1.isCategory2()) {
                        Variable vo3 = smapper.pushT(vi1.getType());
                        Variable vo2 = smapper.pushT(vi2.getType());
                        Variable vo1 = smapper.pushT(vi1.getType());
                        ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2, @3 = @4, @5 = @6;", vo1, vi1, vo2, vi2, vo3, vo1);
                        break;
                    }
                    Variable vi3 = smapper.pop(this);
                    Variable vo5 = smapper.pushT(vi2.getType());
                    Variable vo4 = smapper.pushT(vi1.getType());
                    Variable vo3 = smapper.pushT(vi3.getType());
                    Variable vo22 = smapper.pushT(vi2.getType());
                    Variable vo12 = smapper.pushT(vi1.getType());
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2, @3 = @4, @5 = @6,", vo12, vi1, vo22, vi2, vo3, vi3);
                    ByteCodeToJavaScript.emit(smapper, this, " @1 = @2, @3 = @4;", vo4, vo12, vo5, vo22);
                    break;
                }
                case 91: {
                    Variable vi1 = smapper.pop(this);
                    Variable vi2 = smapper.pop(this);
                    if (vi2.isCategory2()) {
                        Variable vo3 = smapper.pushT(vi1.getType());
                        Variable vo2 = smapper.pushT(vi2.getType());
                        Variable vo1 = smapper.pushT(vi1.getType());
                        ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2, @3 = @4, @5 = @6;", vo1, vi1, vo2, vi2, vo3, vo1);
                        break;
                    }
                    Variable vi3 = smapper.pop(this);
                    Variable vo4 = smapper.pushT(vi1.getType());
                    Variable vo3 = smapper.pushT(vi3.getType());
                    Variable vo2 = smapper.pushT(vi2.getType());
                    Variable vo1 = smapper.pushT(vi1.getType());
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2, @3 = @4, @5 = @6, @7 = @8;", vo1, vi1, vo2, vi2, vo3, vi3, vo4, vo1);
                    break;
                }
                case 94: {
                    Variable vo1;
                    Variable vo2;
                    Variable vo12;
                    Variable vo22;
                    Variable vo3;
                    Variable vi1 = smapper.pop(this);
                    Variable vi2 = smapper.pop(this);
                    if (vi1.isCategory2()) {
                        if (vi2.isCategory2()) {
                            Variable vo32 = smapper.pushT(vi1.getType());
                            Variable vo23 = smapper.pushT(vi2.getType());
                            Variable vo13 = smapper.pushT(vi1.getType());
                            ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2, @3 = @4, @5 = @6;", vo13, vi1, vo23, vi2, vo32, vo13);
                            break;
                        }
                        Variable vi3 = smapper.pop(this);
                        Variable vo4 = smapper.pushT(vi1.getType());
                        Variable vo33 = smapper.pushT(vi3.getType());
                        vo2 = smapper.pushT(vi2.getType());
                        vo1 = smapper.pushT(vi1.getType());
                        ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2, @3 = @4, @5 = @6, @7 = @8;", vo1, vi1, vo2, vi2, vo33, vi3, vo4, vo1);
                        break;
                    }
                    Variable vi3 = smapper.pop(this);
                    if (vi3.isCategory2()) {
                        Variable vo5 = smapper.pushT(vi2.getType());
                        Variable vo4 = smapper.pushT(vi1.getType());
                        vo3 = smapper.pushT(vi3.getType());
                        vo22 = smapper.pushT(vi2.getType());
                        vo12 = smapper.pushT(vi1.getType());
                        ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2, @3 = @4, @5 = @6,", vo12, vi1, vo22, vi2, vo3, vi3);
                        ByteCodeToJavaScript.emit(smapper, this, " @1 = @2, @3 = @4;", vo4, vo12, vo5, vo22);
                        break;
                    }
                    Variable vi4 = smapper.pop(this);
                    Variable vo6 = smapper.pushT(vi2.getType());
                    Variable vo5 = smapper.pushT(vi1.getType());
                    Variable vo4 = smapper.pushT(vi4.getType());
                    Variable vo34 = smapper.pushT(vi3.getType());
                    Variable vo24 = smapper.pushT(vi2.getType());
                    Variable vo14 = smapper.pushT(vi1.getType());
                    ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2, @3 = @4, @5 = @6, @7 = @8,", vo14, vi1, vo24, vi2, vo34, vi3, vo4, vi4);
                    ByteCodeToJavaScript.emit(smapper, this, " @1 = @2, @3 = @4;", vo5, vo14, vo6, vo24);
                    break;
                }
                case 95: {
                    Variable vi1 = smapper.get(0);
                    Variable vi2 = smapper.get(1);
                    if (vi1.getType() == vi2.getType()) {
                        Variable tmp = smapper.pushT(vi1.getType());
                        ByteCodeToJavaScript.emit(smapper, this, "var @1 = @2, @2 = @3, @3 = @1;", tmp, vi1, vi2);
                        smapper.pop(1);
                        break;
                    }
                    smapper.pop(2);
                    smapper.pushT(vi1.getType());
                    smapper.pushT(vi2.getType());
                    break;
                }
                case 16: {
                    smapper.assign(this, 0, "(" + Integer.toString(byteCodes[++i]) + ")");
                    break;
                }
                case 17: {
                    smapper.assign(this, 0, "(" + Integer.toString(ByteCodeToJavaScript.readShortArg(byteCodes, i)) + ")");
                    i += 2;
                    break;
                }
                case 180: {
                    int indx = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
                    String[] fi = this.jc.getFieldInfoName(indx);
                    int type = VarType.fromFieldType(fi[2].charAt(0));
                    String mangleClass = ByteCodeToJavaScript.mangleClassName(fi[0]);
                    String mangleClassAccess = this.accessClassFalse(mangleClass);
                    smapper.replace(this, type, "@2.call(@1)", smapper.getA(0), this.accessField(mangleClassAccess, "_" + fi[1], fi));
                    i += 2;
                    this.addReference(fi[0]);
                    break;
                }
                case 181: {
                    int indx = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
                    String[] fi = this.jc.getFieldInfoName(indx);
                    int type = VarType.fromFieldType(fi[2].charAt(0));
                    String mangleClass = ByteCodeToJavaScript.mangleClassName(fi[0]);
                    String mangleClassAccess = this.accessClassFalse(mangleClass);
                    ByteCodeToJavaScript.emit(smapper, this, "@3.call(@2, @1);", smapper.popT(type), smapper.popA(), this.accessField(mangleClassAccess, "_" + fi[1], fi));
                    i += 2;
                    this.addReference(fi[0]);
                    break;
                }
                case 178: {
                    int indx = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
                    String[] fi = this.jc.getFieldInfoName(indx);
                    int type = VarType.fromFieldType(fi[2].charAt(0));
                    String ac = this.accessClassFalse(ByteCodeToJavaScript.mangleClassName(fi[0]));
                    String af = this.accessField(ac, "_" + fi[1], fi);
                    smapper.assign(this, type, af + "()");
                    i += 2;
                    this.addReference(fi[0]);
                    break;
                }
                case 179: {
                    int indx = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
                    String[] fi = this.jc.getFieldInfoName(indx);
                    int type = VarType.fromFieldType(fi[2].charAt(0));
                    ByteCodeToJavaScript.emit(smapper, this, "@1._@2(@3);", this.accessClassFalse(ByteCodeToJavaScript.mangleClassName(fi[0])), fi[1], smapper.popT(type));
                    i += 2;
                    this.addReference(fi[0]);
                    break;
                }
                case 192: {
                    int indx = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
                    this.generateCheckcast(indx, smapper);
                    i += 2;
                    break;
                }
                case 193: {
                    int indx = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
                    this.generateInstanceOf(indx, smapper);
                    i += 2;
                    break;
                }
                case 191: {
                    CharSequence v = smapper.popA();
                    smapper.clear();
                    ByteCodeToJavaScript.emit(smapper, this, "{ var @1 = @2; throw @2; }", smapper.pushA(), v);
                    break;
                }
                case 194: {
                    this.debug("/* monitor enter */");
                    smapper.popA();
                    break;
                }
                case 195: {
                    this.debug("/* monitor exit */");
                    smapper.popA();
                    break;
                }
                case 196: {
                    wide = true;
                    break;
                }
                default: {
                    wide = false;
                    ByteCodeToJavaScript.emit(smapper, this, "throw 'unknown bytecode @1';", Integer.toString(c));
                }
            }
            if (this.debug(" //")) {
                this.generateByteCodeComment(prev, i, byteCodes);
            }
            if (!this.outChanged) continue;
            this.append("\n");
        }
        if (previousTrap != null) {
            this.generateCatch(previousTrap, byteCodes.length, topMostLabel);
        }
        if (didBranches) {
            this.append("\n    }\n");
        }
        while (openBraces-- > 0) {
            this.append('}');
        }
        if (defineProp) {
            this.append("\n}});");
        } else {
            this.append("\n};");
        }
        return defineProp;
    }

    private int generateIf(StackMapper mapper, byte[] byteCodes, int i, CharSequence v2, CharSequence v1, String test, int topMostLabel) throws IOException {
        mapper.flush(this);
        int indx = i + ByteCodeToJavaScript.readShortArg(byteCodes, i);
        this.append("if ((").append(v1).append(") ").append(test).append(" (").append(v2).append(")) ");
        ByteCodeToJavaScript.goTo(this, i, indx, topMostLabel);
        return i + 2;
    }

    private int readInt4(byte[] byteCodes, int offset) {
        int d = byteCodes[offset + 0] << 24;
        int c = byteCodes[offset + 1] << 16;
        int b = byteCodes[offset + 2] << 8;
        byte a = byteCodes[offset + 3];
        return d & 0xFF000000 | c & 0xFF0000 | b & 0xFF00 | a & 0xFF;
    }

    private static int readUByte(byte[] byteCodes, int offset) {
        return byteCodes[offset] & 0xFF;
    }

    private static int readUShort(byte[] byteCodes, int offset) {
        return (byteCodes[offset] & 0xFF) << 8 | byteCodes[offset + 1] & 0xFF;
    }

    private static int readUShortArg(byte[] byteCodes, int offsetInstruction) {
        return ByteCodeToJavaScript.readUShort(byteCodes, offsetInstruction + 1);
    }

    private static int readShort(byte[] byteCodes, int offset) {
        byte signed = byteCodes[offset];
        byte b0 = signed;
        return b0 << 8 | byteCodes[offset + 1] & 0xFF;
    }

    private static int readShortArg(byte[] byteCodes, int offsetInstruction) {
        return ByteCodeToJavaScript.readShort(byteCodes, offsetInstruction + 1);
    }

    private static void countArgs(String descriptor, char[] returnType, StringBuilder sig, StringBuilder cnt) {
        int i = 0;
        Boolean count = null;
        boolean array = false;
        sig.append("__");
        int firstPos = sig.length();
        block8: while (i < descriptor.length()) {
            char ch = descriptor.charAt(i++);
            switch (ch) {
                case '(': {
                    count = true;
                    continue block8;
                }
                case ')': {
                    count = false;
                    continue block8;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    if (count.booleanValue()) {
                        if (array) {
                            sig.append("_3");
                        }
                        sig.append(ch);
                        if (ch == 'J' || ch == 'D') {
                            cnt.append('1');
                        } else {
                            cnt.append('0');
                        }
                    } else {
                        sig.insert(firstPos, ch);
                        if (array) {
                            returnType[0] = 91;
                            sig.insert(firstPos, "_3");
                        } else {
                            returnType[0] = ch;
                        }
                    }
                    array = false;
                    continue block8;
                }
                case 'V': {
                    assert (!count.booleanValue());
                    returnType[0] = 86;
                    sig.insert(firstPos, 'V');
                    continue block8;
                }
                case 'L': {
                    int next = descriptor.indexOf(59, i);
                    String realSig = ByteCodeToJavaScript.mangleSig(descriptor, i - 1, next + 1);
                    if (count.booleanValue()) {
                        if (array) {
                            sig.append("_3");
                        }
                        sig.append(realSig);
                        cnt.append('0');
                    } else {
                        sig.insert(firstPos, realSig);
                        if (array) {
                            sig.insert(firstPos, "_3");
                        }
                        returnType[0] = 76;
                    }
                    i = next + 1;
                    array = false;
                    continue block8;
                }
                case '[': {
                    array = true;
                    continue block8;
                }
            }
            throw new IllegalStateException("Invalid char: " + ch);
        }
    }

    static String mangleSig(String sig) {
        return ByteCodeToJavaScript.mangleSig(sig, 0, sig.length());
    }

    private static String mangleMethodName(String name) {
        StringBuilder sb = new StringBuilder(name.length() * 2);
        int last = name.length();
        block3: for (int i = 0; i < last; ++i) {
            char ch = name.charAt(i);
            switch (ch) {
                case '_': {
                    sb.append("_1");
                    continue block3;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private static String mangleSig(String txt, int first, int last) {
        StringBuilder sb = new StringBuilder((last - first) * 2);
        block6: for (int i = first; i < last; ++i) {
            char ch = txt.charAt(i);
            switch (ch) {
                case '/': {
                    sb.append('_');
                    continue block6;
                }
                case '_': {
                    sb.append("_1");
                    continue block6;
                }
                case ';': {
                    sb.append("_2");
                    continue block6;
                }
                case '[': {
                    sb.append("_3");
                    continue block6;
                }
                default: {
                    if (Character.isJavaIdentifierPart(ch)) {
                        sb.append(ch);
                        continue block6;
                    }
                    sb.append("_0");
                    String hex = Integer.toHexString(ch).toLowerCase();
                    for (int m = hex.length(); m < 4; ++m) {
                        sb.append("0");
                    }
                    sb.append(hex);
                }
            }
        }
        return sb.toString();
    }

    private static String mangleClassName(String name) {
        return ByteCodeToJavaScript.mangleSig(name);
    }

    private static String findMethodName(ByteCodeParser.MethodData m, StringBuilder cnt) {
        StringBuilder name = new StringBuilder();
        if ("<init>".equals(m.getName())) {
            name.append("cons");
        } else if ("<clinit>".equals(m.getName())) {
            name.append("class");
        } else {
            name.append(ByteCodeToJavaScript.mangleMethodName(m.getName()));
        }
        ByteCodeToJavaScript.countArgs(m.getInternalSig(), new char[1], name, cnt);
        return name.toString();
    }

    static String findMethodName(String[] mi, StringBuilder cnt, char[] returnType) {
        StringBuilder name = new StringBuilder();
        String descr = mi[2];
        String nm = mi[1];
        if ("<init>".equals(nm)) {
            name.append("cons");
        } else {
            name.append(ByteCodeToJavaScript.mangleMethodName(nm));
        }
        ByteCodeToJavaScript.countArgs(descr, returnType, name, cnt);
        return name.toString();
    }

    private int invokeStaticMethod(byte[] byteCodes, int i, StackMapper mapper, boolean isStatic) throws IOException {
        String field;
        int methodIndex = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
        String[] mi = this.jc.getFieldInfoName(methodIndex);
        char[] returnType = new char[]{'V'};
        StringBuilder cnt = new StringBuilder();
        String mn = ByteCodeToJavaScript.findMethodName(mi, cnt, returnType);
        int numArguments = isStatic ? cnt.length() : cnt.length() + 1;
        CharSequence[] vars = new CharSequence[numArguments];
        for (int j = numArguments - 1; j >= 0; --j) {
            vars[j] = mapper.popValue();
        }
        if (("newUpdater__Ljava_util_concurrent_atomic_AtomicIntegerFieldUpdater_2Ljava_lang_Class_2Ljava_lang_String_2".equals(mn) && "java/util/concurrent/atomic/AtomicIntegerFieldUpdater".equals(mi[0]) || "newUpdater__Ljava_util_concurrent_atomic_AtomicLongFieldUpdater_2Ljava_lang_Class_2Ljava_lang_String_2".equals(mn) && "java/util/concurrent/atomic/AtomicLongFieldUpdater".equals(mi[0])) && vars[1] instanceof String && (field = vars[1].toString()).length() > 2 && field.charAt(0) == '\"' && field.charAt(field.length() - 1) == '\"') {
            vars[1] = "c._" + field.substring(1, field.length() - 1);
        }
        if ("newUpdater__Ljava_util_concurrent_atomic_AtomicReferenceFieldUpdater_2Ljava_lang_Class_2Ljava_lang_Class_2Ljava_lang_String_2".equals(mn) && "java/util/concurrent/atomic/AtomicReferenceFieldUpdater".equals(mi[0]) && vars[1] instanceof String && (field = vars[2].toString()).length() > 2 && field.charAt(0) == '\"' && field.charAt(field.length() - 1) == '\"') {
            vars[2] = "c._" + field.substring(1, field.length() - 1);
        }
        if (returnType[0] != 'V') {
            mapper.flush(this);
            this.append("var ").append(mapper.pushT(VarType.fromFieldType(returnType[0]))).append(" = ");
        }
        String in = mi[0];
        String mcn = this.callbacks && (in.equals("org/apidesign/html/boot/spi/Fn") || in.equals("org/netbeans/html/boot/spi/Fn")) ? "java_lang_Class" : ByteCodeToJavaScript.mangleClassName(in);
        String object = this.accessClassFalse(mcn);
        if (mn.startsWith("cons_")) {
            object = object + ".constructor";
        }
        this.append(this.accessStaticMethod(object, mn, mi));
        if (isStatic) {
            this.append('(');
        } else {
            this.append(".call(");
        }
        if (numArguments > 0) {
            this.append(vars[0]);
            for (int j = 1; j < numArguments; ++j) {
                this.append(", ");
                this.append(vars[j]);
            }
        }
        this.append(");");
        this.addReference(in);
        return i += 2;
    }

    private int invokeVirtualMethod(byte[] byteCodes, int i, StackMapper mapper) throws IOException {
        int methodIndex = ByteCodeToJavaScript.readUShortArg(byteCodes, i);
        String[] mi = this.jc.getFieldInfoName(methodIndex);
        char[] returnType = new char[]{'V'};
        StringBuilder cnt = new StringBuilder();
        String mn = ByteCodeToJavaScript.findMethodName(mi, cnt, returnType);
        int numArguments = cnt.length() + 1;
        CharSequence[] vars = new CharSequence[numArguments];
        for (int j = numArguments - 1; j >= 0; --j) {
            vars[j] = mapper.popValue();
        }
        if (returnType[0] != 'V') {
            mapper.flush(this);
            this.append("var ").append(mapper.pushT(VarType.fromFieldType(returnType[0]))).append(" = ");
        }
        this.append(this.accessVirtualMethod(vars[0].toString(), mn, mi, numArguments));
        String sep = "";
        for (int j = 1; j < numArguments; ++j) {
            this.append(sep);
            this.append(vars[j]);
            sep = ", ";
        }
        this.append(");");
        return i += 2;
    }

    private void addReference(String cn) throws IOException {
        if (this.requireReference(cn)) {
            this.debug(" /* needs " + cn + " */");
        }
    }

    private void outType(String d, StringBuilder out) {
        boolean arr = false;
        while (d.charAt(0) == '[') {
            out.append('A');
            d = d.substring(1);
        }
        if (d.charAt(0) == 'L') {
            assert (d.charAt(d.length() - 1) == ';');
            out.append(ByteCodeToJavaScript.mangleClassName(d).substring(0, d.length() - 1));
        } else {
            out.append(d);
        }
    }

    private String encodeConstant(int entryIndex) throws IOException {
        String[] classRef = new String[]{null};
        String s = this.jc.stringValue(entryIndex, classRef);
        if (classRef[0] != null) {
            if (classRef[0].startsWith("[")) {
                s = this.accessClass("java_lang_Class") + "(false)['forName__Ljava_lang_Class_2Ljava_lang_String_2']('" + classRef[0] + "')";
            } else {
                this.addReference(classRef[0]);
                s = this.accessClassFalse(ByteCodeToJavaScript.mangleClassName(s)) + ".constructor.$class";
            }
        }
        return s;
    }

    private String javaScriptBody(String destObject, ByteCodeParser.MethodData m, boolean isStatic) throws IOException {
        byte[] arr = m.findAnnotationData(true);
        if (arr == null) {
            return null;
        }
        String jvmType = "Lorg/apidesign/bck2brwsr/core/JavaScriptBody;";
        String htmlType = "Lnet/java/html/js/JavaScriptBody;";
        class P
        extends ByteCodeParser.AnnotationParser {
            int cnt;
            String[] args;
            String body;
            boolean javacall;
            boolean html4j;

            public P() {
                super(false, true);
                this.args = new String[30];
            }

            @Override
            protected void visitAttr(String type, String attr, String at, String value) {
                if (type.equals("Lorg/apidesign/bck2brwsr/core/JavaScriptBody;")) {
                    if ("body".equals(attr)) {
                        this.body = value;
                    } else if ("args".equals(attr)) {
                        this.args[this.cnt++] = value;
                    } else {
                        throw new IllegalArgumentException(attr);
                    }
                }
                if (type.equals("Lnet/java/html/js/JavaScriptBody;")) {
                    this.html4j = true;
                    if ("body".equals(attr)) {
                        this.body = value;
                    } else if ("args".equals(attr)) {
                        this.args[this.cnt++] = value;
                    } else if ("javacall".equals(attr)) {
                        this.javacall = "1".equals(value);
                    } else if (!"wait4js".equals(attr)) {
                        throw new IllegalArgumentException(attr);
                    }
                }
            }
        }
        P p = new P();
        p.parse(arr, this.jc);
        if (p.body == null) {
            return null;
        }
        StringBuilder cnt = new StringBuilder();
        String mn = ByteCodeToJavaScript.findMethodName(m, cnt);
        this.append("m = ").append(destObject).append(".").append(mn);
        this.append(" = function(");
        String space = "";
        int index = 0;
        StringBuilder toValue = new StringBuilder();
        for (int i = 0; i < cnt.length(); ++i) {
            this.append(space);
            space = ByteCodeToJavaScript.outputArg(this, p.args, index);
            if (p.html4j && space.length() > 0) {
                toValue.append("\n  ").append(p.args[index]).append(" = ").append(this.accessClass("java_lang_Class")).append("(false).toJS(").append(p.args[index]).append(");");
            }
            ++index;
        }
        this.append(") {").append("\n");
        this.append(toValue.toString());
        if (p.javacall) {
            int lastSlash = this.jc.getClassName().lastIndexOf(47);
            String pkg = this.jc.getClassName().substring(0, lastSlash);
            this.append(ByteCodeToJavaScript.mangleCallbacks(pkg, p.body));
            this.requireReference(pkg + "/$JsCallbacks$");
        } else {
            this.append(p.body);
        }
        this.append("\n}\n");
        return mn;
    }

    private static CharSequence mangleCallbacks(String pkgName, String body) {
        int next;
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        while (true) {
            if ((next = body.indexOf(".@", pos)) == -1) break;
            int ident = next;
            while (ident > 0) {
                if (Character.isJavaIdentifierPart(body.charAt(--ident))) continue;
                ++ident;
                break;
            }
            String refId = body.substring(ident, next);
            sb.append(body.substring(pos, ident));
            int sigBeg = body.indexOf(40, next);
            int sigEnd = body.indexOf(41, sigBeg);
            int colon4 = body.indexOf("::", next);
            if (sigBeg == -1 || sigEnd == -1 || colon4 == -1) {
                throw new IllegalStateException("Malformed body " + body);
            }
            String fqn = body.substring(next + 2, colon4);
            String method = body.substring(colon4 + 2, sigBeg);
            String params = body.substring(sigBeg, sigEnd + 1);
            int paramBeg = body.indexOf(40, sigEnd + 1);
            sb.append("vm.").append(ByteCodeToJavaScript.mangleClassName(pkgName)).append("_$JsCallbacks$(false)._VM().");
            sb.append(ByteCodeToJavaScript.mangleJsCallbacks(fqn, method, params, false));
            sb.append("(").append(refId);
            if (body.charAt(paramBeg + 1) != ')') {
                sb.append(",");
            }
            pos = paramBeg + 1;
        }
        sb.append(body.substring(pos));
        body = sb.toString();
        sb = null;
        pos = 0;
        while (true) {
            if ((next = body.indexOf("@", pos)) == -1) {
                if (sb == null) {
                    return body;
                }
                sb.append(body.substring(pos));
                return sb;
            }
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(body.substring(pos, next));
            int sigBeg = body.indexOf(40, next);
            int sigEnd = body.indexOf(41, sigBeg);
            int colon4 = body.indexOf("::", next);
            if (sigBeg == -1 || sigEnd == -1 || colon4 == -1) {
                throw new IllegalStateException("Malformed body " + body);
            }
            String fqn = body.substring(next + 1, colon4);
            String method = body.substring(colon4 + 2, sigBeg);
            String params = body.substring(sigBeg, sigEnd + 1);
            int paramBeg = body.indexOf(40, sigEnd + 1);
            sb.append("vm.").append(ByteCodeToJavaScript.mangleClassName(pkgName)).append("_$JsCallbacks$(false)._VM().");
            sb.append(ByteCodeToJavaScript.mangleJsCallbacks(fqn, method, params, true));
            sb.append("(");
            pos = paramBeg + 1;
        }
    }

    static String mangleJsCallbacks(String fqn, String method, String params, boolean isStatic) {
        if (params.startsWith("(")) {
            params = params.substring(1);
        }
        if (params.endsWith(")")) {
            params = params.substring(0, params.length() - 1);
        }
        StringBuilder sb = new StringBuilder();
        String fqnu = fqn.replace('.', '_');
        String rfqn = ByteCodeToJavaScript.mangleClassName(fqnu);
        String rm = ByteCodeToJavaScript.mangleMethodName(method);
        StringBuilder pb = new StringBuilder();
        int len = params.length();
        int indx = 0;
        while (indx < len) {
            char ch = params.charAt(indx);
            if (ch == '[' || ch == 'L') {
                String real;
                int column = params.indexOf(59, indx) + 1;
                if (column > indx && "Ljava/lang/String;".equals(real = params.substring(indx, column))) {
                    pb.append("Ljava/lang/String;");
                    indx = column;
                    continue;
                }
                pb.append("Ljava/lang/Object;");
                indx = column;
                continue;
            }
            pb.append(ch);
            ++indx;
        }
        String srp = ByteCodeToJavaScript.mangleSig(pb.toString());
        String rp = ByteCodeToJavaScript.mangleSig(params);
        String mrp = ByteCodeToJavaScript.mangleMethodName(rp);
        sb.append(rfqn).append("$").append(rm).append('$').append(mrp).append("__Ljava_lang_Object_2");
        if (!isStatic) {
            sb.append('L').append(fqnu).append("_2");
        }
        sb.append(srp);
        return sb.toString();
    }

    private static String className(ByteCodeParser.ClassData jc) {
        return ByteCodeToJavaScript.mangleClassName(jc.getClassName());
    }

    private static String[] findAnnotation(byte[] arr, ByteCodeParser.ClassData cd, String className, final String ... attrNames) throws IOException {
        if (arr == null) {
            return null;
        }
        final String[] values = new String[attrNames.length];
        final boolean[] found = new boolean[]{false};
        final String jvmType = "L" + className.replace('.', '/') + ";";
        ByteCodeParser.AnnotationParser ap = new ByteCodeParser.AnnotationParser(false, true){

            @Override
            protected void visitAttr(String type, String attr, String at, String value) {
                if (type.equals(jvmType)) {
                    found[0] = true;
                    for (int i = 0; i < attrNames.length; ++i) {
                        if (!attrNames[i].equals(attr)) continue;
                        values[i] = value;
                    }
                }
            }
        };
        ap.parse(arr, cd);
        return found[0] ? values : null;
    }

    private CharSequence initField(ByteCodeParser.FieldData v) {
        String is = v.getInternalSig();
        if (is.length() == 1) {
            switch (is.charAt(0)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    return " = 0;";
                }
                case 'D': 
                case 'F': {
                    return " = 0.0;";
                }
            }
            throw new IllegalStateException(is);
        }
        return " = null;";
    }

    private void generateAnno(ByteCodeParser.ClassData cd, byte[] data) throws IOException {
        ByteCodeParser.AnnotationParser ap = new ByteCodeParser.AnnotationParser(true, false){
            int[] cnt;
            int depth;
            {
                this.cnt = new int[32];
            }

            @Override
            protected void visitAnnotationStart(String attrType, boolean top) throws IOException {
                String slashType = attrType.substring(1, attrType.length() - 1);
                ByteCodeToJavaScript.this.requireReference(slashType);
                int n = this.depth;
                int n2 = this.cnt[n];
                this.cnt[n] = n2 + 1;
                if (n2 > 0) {
                    ByteCodeToJavaScript.this.append(",");
                }
                if (top) {
                    ByteCodeToJavaScript.this.append('\"').append(attrType).append("\" : ");
                }
                ByteCodeToJavaScript.this.append("{\n");
                this.cnt[++this.depth] = 0;
            }

            @Override
            protected void visitAnnotationEnd(String type, boolean top) throws IOException {
                ByteCodeToJavaScript.this.append("\n}\n");
                --this.depth;
            }

            @Override
            protected void visitValueStart(String attrName, char type) throws IOException {
                int n = this.depth;
                int n2 = this.cnt[n];
                this.cnt[n] = n2 + 1;
                if (n2 > 0) {
                    ByteCodeToJavaScript.this.append(",\n");
                }
                this.cnt[++this.depth] = 0;
                if (attrName != null) {
                    ByteCodeToJavaScript.this.append('\"').append(attrName).append("\" : ");
                }
                if (type == '[') {
                    ByteCodeToJavaScript.this.append("[");
                }
            }

            @Override
            protected void visitValueEnd(String attrName, char type) throws IOException {
                if (type == '[') {
                    ByteCodeToJavaScript.this.append("]");
                }
                --this.depth;
            }

            @Override
            protected void visitAttr(String type, String attr, String attrType, String value) throws IOException {
                if (attr == null && value == null) {
                    return;
                }
                ByteCodeToJavaScript.this.append(value);
            }

            @Override
            protected void visitEnumAttr(String type, String attr, String attrType, String value) throws IOException {
                String slashType = attrType.substring(1, attrType.length() - 1);
                ByteCodeToJavaScript.this.requireReference(slashType);
                String cn = ByteCodeToJavaScript.mangleClassName(slashType);
                ByteCodeToJavaScript.this.append(ByteCodeToJavaScript.this.accessClassFalse(cn)).append("['valueOf__L").append(cn).append("_2Ljava_lang_String_2']('").append(value).append("')");
            }
        };
        ap.parse(data, cd);
    }

    private static String outputArg(Appendable out, String[] args, int indx) throws IOException {
        String name = args[indx];
        if (name == null) {
            return "";
        }
        if (name.contains(",")) {
            throw new IOException("Wrong parameter with ',': " + name);
        }
        out.append(name);
        return ",";
    }

    final void emitNoFlush(StackMapper sm, String format, CharSequence ... params) throws IOException {
        ByteCodeToJavaScript.emitImpl(this, format, params);
    }

    static final void emit(StackMapper sm, Appendable out, String format, CharSequence ... params) throws IOException {
        sm.flush(out);
        ByteCodeToJavaScript.emitImpl(out, format, params);
    }

    static void emitImpl(Appendable out, String format, CharSequence ... params) throws IOException {
        int length = format.length();
        int processed = 0;
        int paramOffset = format.indexOf(64);
        while (paramOffset != -1 && paramOffset < length - 1) {
            char paramChar = format.charAt(paramOffset + 1);
            if (paramChar >= '1' && paramChar <= '9') {
                int paramIndex = paramChar - 48 - 1;
                out.append(format, processed, paramOffset);
                out.append(params[paramIndex]);
                processed = ++paramOffset + 1;
            }
            paramOffset = format.indexOf(64, paramOffset + 1);
        }
        out.append(format, processed, length);
    }

    private void generateCatch(ByteCodeParser.TrapData[] traps, int current, int topMostLabel) throws IOException {
        this.append("} catch (e) {\n");
        int finallyPC = -1;
        for (ByteCodeParser.TrapData e : traps) {
            if (e == null) break;
            if (e.catch_cpx != 0) {
                String classInternalName = this.jc.getClassName(e.catch_cpx);
                this.addReference(classInternalName);
                this.append("e = vm.java_lang_Class(false).bck2BrwsrThrwrbl(e);");
                this.append("if (e['$instOf_" + ByteCodeToJavaScript.mangleClassName(classInternalName) + "']) {");
                this.append("var stA0 = e;");
                ByteCodeToJavaScript.goTo(this, current, e.handler_pc, topMostLabel);
                this.append("}\n");
                continue;
            }
            finallyPC = e.handler_pc;
        }
        if (finallyPC == -1) {
            this.append("throw e;");
        } else {
            this.append("var stA0 = e;");
            ByteCodeToJavaScript.goTo(this, current, finallyPC, topMostLabel);
        }
        this.append("\n}");
    }

    private static void goTo(Appendable out, int current, int to, int canBack) throws IOException {
        if (to < current) {
            if (canBack < to) {
                out.append("{ gt = 0; continue X_" + to + "; }");
            } else {
                out.append("{ gt = " + to + "; continue X_0; }");
            }
        } else {
            out.append("{ gt = " + to + "; break IF; }");
        }
    }

    private static void emitIf(StackMapper sm, Appendable out, String pattern, CharSequence param, int current, int to, int canBack) throws IOException {
        sm.flush(out);
        ByteCodeToJavaScript.emitImpl(out, pattern, param);
        ByteCodeToJavaScript.goTo(out, current, to, canBack);
    }

    private void generateNewArray(int atype, StackMapper smapper) throws IOException, IllegalStateException {
        String jvmType;
        switch (atype) {
            case 4: {
                jvmType = "[Z";
                break;
            }
            case 5: {
                jvmType = "[C";
                break;
            }
            case 6: {
                jvmType = "[F";
                break;
            }
            case 7: {
                jvmType = "[D";
                break;
            }
            case 8: {
                jvmType = "[B";
                break;
            }
            case 9: {
                jvmType = "[S";
                break;
            }
            case 10: {
                jvmType = "[I";
                break;
            }
            case 11: {
                jvmType = "[J";
                break;
            }
            default: {
                throw new IllegalStateException("Array type: " + atype);
            }
        }
        ByteCodeToJavaScript.emit(smapper, this, "var @2 = Array.prototype['newArray__Ljava_lang_Object_2ZLjava_lang_String_2Ljava_lang_Object_2I'](true, '@3', null, @1);", smapper.popI(), smapper.pushA(), jvmType);
    }

    private void generateANewArray(int type, StackMapper smapper) throws IOException {
        String typeName = this.jc.getClassName(type);
        String ref = "null";
        if (typeName.startsWith("[")) {
            typeName = "'[" + typeName + "'";
        } else {
            ref = "vm." + ByteCodeToJavaScript.mangleClassName(typeName);
            typeName = "'[L" + typeName + ";'";
        }
        ByteCodeToJavaScript.emit(smapper, this, "var @2 = Array.prototype['newArray__Ljava_lang_Object_2ZLjava_lang_String_2Ljava_lang_Object_2I'](false, @3, @4, @1);", smapper.popI(), smapper.pushA(), typeName, ref);
    }

    private int generateMultiANewArray(int type, byte[] byteCodes, int i, StackMapper smapper) throws IOException {
        String typeName = this.jc.getClassName(type);
        int dim = ByteCodeToJavaScript.readUByte(byteCodes, ++i);
        StringBuilder dims = new StringBuilder();
        dims.append('[');
        for (int d = 0; d < dim; ++d) {
            if (d != 0) {
                dims.insert(1, ",");
            }
            dims.insert(1, smapper.popI());
        }
        dims.append(']');
        String fn = "null";
        if (typeName.charAt(dim) == 'L') {
            fn = "vm." + ByteCodeToJavaScript.mangleClassName(typeName.substring(dim + 1, typeName.length() - 1));
        }
        ByteCodeToJavaScript.emit(smapper, this, "var @2 = Array.prototype['multiNewArray__Ljava_lang_Object_2Ljava_lang_String_2_3ILjava_lang_Object_2']('@3', @1, @4);", dims.toString(), smapper.pushA(), typeName, fn);
        return i;
    }

    private int generateTableSwitch(int i, byte[] byteCodes, StackMapper smapper, int topMostLabel) throws IOException {
        int table = i / 4 * 4 + 4;
        int dflt = i + this.readInt4(byteCodes, table);
        int high = this.readInt4(byteCodes, table += 4);
        table += 4;
        CharSequence swVar = smapper.popValue();
        smapper.flush(this);
        this.append("switch (").append(swVar).append(") {\n");
        for (int low = this.readInt4(byteCodes, table += 4); low <= high; ++low) {
            int offset = i + this.readInt4(byteCodes, table);
            table += 4;
            this.append("  case " + low).append(":");
            ByteCodeToJavaScript.goTo(this, i, offset, topMostLabel);
            this.append('\n');
        }
        this.append("  default: ");
        ByteCodeToJavaScript.goTo(this, i, dflt, topMostLabel);
        this.append("\n}");
        i = table - 1;
        return i;
    }

    private int generateLookupSwitch(int i, byte[] byteCodes, StackMapper smapper, int topMostLabel) throws IOException {
        int table = i / 4 * 4 + 4;
        int dflt = i + this.readInt4(byteCodes, table);
        int n = this.readInt4(byteCodes, table += 4);
        table += 4;
        CharSequence swVar = smapper.popValue();
        smapper.flush(this);
        this.append("switch (").append(swVar).append(") {\n");
        while (n-- > 0) {
            int cnstnt = this.readInt4(byteCodes, table);
            int offset = i + this.readInt4(byteCodes, table += 4);
            table += 4;
            this.append("  case " + cnstnt).append(": ");
            ByteCodeToJavaScript.goTo(this, i, offset, topMostLabel);
            this.append('\n');
        }
        this.append("  default: ");
        ByteCodeToJavaScript.goTo(this, i, dflt, topMostLabel);
        this.append("\n}");
        i = table - 1;
        return i;
    }

    private void generateInstanceOf(int indx, StackMapper smapper) throws IOException {
        String type = this.jc.getClassName(indx);
        if (!type.startsWith("[")) {
            ByteCodeToJavaScript.emit(smapper, this, "var @2 = @1 != null && @1['$instOf_@3'] ? 1 : 0;", smapper.popA(), smapper.pushI(), ByteCodeToJavaScript.mangleClassName(type));
        } else {
            int cnt = 0;
            while (type.charAt(cnt) == '[') {
                ++cnt;
            }
            if (type.charAt(cnt) == 'L') {
                String component = type.substring(cnt + 1, type.length() - 1);
                this.requireReference(component);
                type = "vm." + ByteCodeToJavaScript.mangleClassName(component);
                ByteCodeToJavaScript.emit(smapper, this, "var @2 = Array.prototype['isInstance__ZLjava_lang_Object_2ILjava_lang_Object_2'](@1, @4, @3);", smapper.popA(), smapper.pushI(), type, "" + cnt);
            } else {
                ByteCodeToJavaScript.emit(smapper, this, "var @2 = Array.prototype['isInstance__ZLjava_lang_Object_2Ljava_lang_String_2'](@1, '@3');", smapper.popA(), smapper.pushI(), type);
            }
        }
    }

    private void generateCheckcast(int indx, StackMapper smapper) throws IOException {
        String type = this.jc.getClassName(indx);
        if (!type.startsWith("[")) {
            this.emitNoFlush(smapper, "if (@1 !== null && !@1['$instOf_@2']) vm.java_lang_Class(false).castEx();", smapper.getT(0, 4, false), ByteCodeToJavaScript.mangleClassName(type));
        } else {
            int cnt = 0;
            while (type.charAt(cnt) == '[') {
                ++cnt;
            }
            if (type.charAt(cnt) == 'L') {
                String component = type.substring(cnt + 1, type.length() - 1);
                this.requireReference(component);
                type = "vm." + ByteCodeToJavaScript.mangleClassName(component);
                this.emitNoFlush(smapper, "if (@1 !== null && !Array.prototype['isInstance__ZLjava_lang_Object_2ILjava_lang_Object_2'](@1, @3, @2)) vm.java_lang_Class(false).castEx();", smapper.getT(0, 4, false), type, "" + cnt);
            } else {
                this.emitNoFlush(smapper, "if (@1 !== null && !Array.prototype['isInstance__ZLjava_lang_Object_2Ljava_lang_String_2'](@1, '@2')) vm.java_lang_Class(false).castEx();", smapper.getT(0, 4, false), type);
            }
        }
    }

    private void generateByteCodeComment(int prev, int i, byte[] byteCodes) throws IOException {
        for (int j = prev; j <= i; ++j) {
            this.append(" ");
            int cc = ByteCodeToJavaScript.readUByte(byteCodes, j);
            this.append(Integer.toString(cc));
        }
    }

    @JavaScriptBody(args={"msg"}, body="")
    private static void println(String msg) {
        System.err.println(msg);
    }
}

