/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.vm4brwsr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apidesign.bck2brwsr.core.Exported;
import org.apidesign.bck2brwsr.core.JavaScriptBody;
import org.apidesign.vm4brwsr.Bck2Brwsr;
import org.apidesign.vm4brwsr.ParseMan;

final class ClassPath {
    private static boolean doingToZip;

    private ClassPath() {
    }

    public static void init() {
    }

    @JavaScriptBody(args={"arr"}, body="return arr.length;")
    private static native int length(Object var0);

    @JavaScriptBody(args={"arr", "index"}, body="return arr[index];")
    private static native Object at(Object var0, int var1);

    @JavaScriptBody(args={"arr", "index", "value"}, body="arr[index] = value; return value;")
    private static native Object set(Object var0, int var1, Object var2);

    static byte[] loadBytes(String resource, Object classpath, int skip) throws IOException, ClassNotFoundException {
        for (int i = 0; i < ClassPath.length(classpath); ++i) {
            byte[] arr = ClassPath.loadBytes(resource, classpath, i, skip);
            if (arr == null) continue;
            return arr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Exported
    static byte[] loadBytes(String resource, Object classpath, int i, int skip) throws IOException, ClassNotFoundException {
        byte[] checkRes;
        Object c = ClassPath.at(classpath, i);
        if (c instanceof String && !doingToZip) {
            try {
                doingToZip = true;
                String url = (String)c;
                Bck2Brwsr.Resources z = ClassPath.toZip(url);
                c = ClassPath.set(classpath, i, z);
                byte[] man = ClassPath.readBytes(z, "META-INF/MANIFEST.MF");
                if (man != null) {
                    String string = ClassPath.processClassPathAttr(man, url, classpath);
                }
            }
            catch (IOException ex) {
                ClassPath.set(classpath, i, ex);
                ClassPath.log("Cannot load " + c + " - " + ex.getClass().getName() + ":" + ex.getMessage());
            }
            finally {
                doingToZip = false;
            }
        }
        if (resource != null && (c instanceof Bck2Brwsr.Resources ? (checkRes = ClassPath.readBytes((Bck2Brwsr.Resources)c, resource)) != null && --skip < 0 : (checkRes = ClassPath.callFunction(c, resource, skip)) != null)) {
            return checkRes;
        }
        return null;
    }

    @JavaScriptBody(args={"fn", "res", "skip"}, body="if (typeof fn === 'function') return fn(res, skip);\nreturn null;")
    private static native byte[] callFunction(Object var0, String var1, int var2);

    @JavaScriptBody(args={"msg"}, body="if (typeof console !== 'undefined') console.log(msg.toString());")
    private static native void log(String var0);

    private static String processClassPathAttr(byte[] man, String url, Object classpath) throws IOException {
        try (ParseMan is = new ParseMan(new ByteArrayInputStream(man));){
            String cp = is.toString();
            if (cp != null) {
                cp = cp.trim();
                int p = 0;
                while (p < cp.length()) {
                    int n = cp.indexOf(32, p);
                    if (n == -1) {
                        n = cp.length();
                    }
                    String el = cp.substring(p, n);
                    URL u = new URL(new URL(url), el);
                    classpath = ClassPath.addToArray(classpath, u.toString());
                    p = n + 1;
                }
            }
            String string = is.getMainClass();
            return string;
        }
    }

    private static Object addToArray(Object arr, String value) {
        int last = ClassPath.length(arr);
        Object ret = ClassPath.enlargeArray(arr, last + 1);
        ClassPath.set(ret, last, value);
        return ret;
    }

    @JavaScriptBody(args={"arr", "len"}, body="while (arr.length < len) arr.push(null); return arr;")
    private static native Object enlargeArray(Object var0, int var1);

    private static Bck2Brwsr.Resources toZip(String path) throws IOException {
        URL u = new URL(path);
        byte[] zipData = (byte[])u.getContent(new Class[]{byte[].class});
        try {
            Class<?> fastJar = Class.forName("org.apidesign.bck2brwsr.vmzip.ZipResources");
            return (Bck2Brwsr.Resources)fastJar.getConstructor(byte[].class).newInstance(new Object[]{zipData});
        }
        catch (Exception ex) {
            ClassPath.log("Reading JARs is only possible with enum.zip module included: " + ex.getMessage());
            ex.printStackTrace();
            throw new IOException(ex);
        }
    }

    private static byte[] readBytes(Bck2Brwsr.Resources r, String res) throws IOException {
        int len;
        InputStream is = r.get(res);
        if (is == null) {
            return null;
        }
        byte[] arr = new byte[is.available()];
        int off = 0;
        while ((len = is.read(arr, off, arr.length - off)) != -1) {
            off += len;
        }
        is.close();
        return arr;
    }
}

