/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.vm4brwsr;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apidesign.bck2brwsr.core.ExtraJavaScript;
import org.apidesign.vm4brwsr.Bck2Brwsr;
import org.apidesign.vm4brwsr.ByteCodeParser;
import org.apidesign.vm4brwsr.StringArray;

@ExtraJavaScript(processByteCode=false, resource="")
final class ExportedSymbols {
    private final Bck2Brwsr.Resources resources;
    private final StringArray exported;
    private final Map<Object, Boolean> isMarkedAsExportedCache;

    ExportedSymbols(Bck2Brwsr.Resources resources, StringArray explicitlyExported) {
        this.resources = resources;
        this.exported = explicitlyExported;
        this.isMarkedAsExportedCache = new HashMap<Object, Boolean>();
    }

    boolean isExported(ByteCodeParser.ClassData classData) throws IOException {
        if (this.exported.contains(classData.getClassName())) {
            return true;
        }
        return classData.isPublic() && this.isMarkedAsExportedPackage(classData.getPkgName()) || this.isMarkedAsExported(classData);
    }

    boolean isExported(ByteCodeParser.MethodData methodData) throws IOException {
        return ExportedSymbols.isAccessible(methodData.access) && this.isExported(methodData.cls) || this.isMarkedAsExported(methodData);
    }

    boolean isExported(ByteCodeParser.FieldData fieldData) throws IOException {
        if (ExportedSymbols.isAccessible(fieldData.access) && this.isExported(fieldData.cls) || this.isMarkedAsExported(fieldData)) {
            return true;
        }
        return fieldData.isStatic() && fieldData.getName().equals("$VALUES") && "java/lang/Enum".equals(fieldData.cls.getSuperClassName());
    }

    private boolean isMarkedAsExportedPackage(String pkgName) {
        if (pkgName == null) {
            return false;
        }
        if (pkgName.startsWith("java/")) {
            return true;
        }
        Boolean cachedValue = this.isMarkedAsExportedCache.get(pkgName);
        if (cachedValue != null) {
            return cachedValue;
        }
        boolean newValue = this.resolveIsMarkedAsExportedPackage(pkgName);
        this.isMarkedAsExportedCache.put(pkgName, newValue);
        return newValue;
    }

    private boolean isMarkedAsExported(ByteCodeParser.ClassData classData) throws IOException {
        Boolean cachedValue = this.isMarkedAsExportedCache.get(classData);
        if (cachedValue != null) {
            return cachedValue;
        }
        boolean newValue = ExportedSymbols.isMarkedAsExported(classData.findAnnotationData(true), classData);
        this.isMarkedAsExportedCache.put(classData, newValue);
        return newValue;
    }

    private boolean isMarkedAsExported(ByteCodeParser.MethodData methodData) throws IOException {
        return ExportedSymbols.isMarkedAsExported(methodData.findAnnotationData(true), methodData.cls);
    }

    private boolean isMarkedAsExported(ByteCodeParser.FieldData fieldData) throws IOException {
        return ExportedSymbols.isMarkedAsExported(fieldData.findAnnotationData(true), fieldData.cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resolveIsMarkedAsExportedPackage(String pkgName) {
        boolean bl;
        if (this.exported.contains(pkgName + '/')) {
            return true;
        }
        InputStream is = this.resources.get(pkgName + "/package-info.class");
        if (is == null) {
            return false;
        }
        try {
            ByteCodeParser.ClassData pkgInfoClass = new ByteCodeParser.ClassData(is);
            bl = ExportedSymbols.isMarkedAsExported(pkgInfoClass.findAnnotationData(true), pkgInfoClass);
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        is.close();
        return bl;
    }

    static boolean isMarkedAsExported(byte[] arrData, ByteCodeParser.ClassData cd) throws IOException {
        if (arrData == null) {
            return false;
        }
        final boolean[] found = new boolean[]{false};
        ByteCodeParser.AnnotationParser annotationParser = new ByteCodeParser.AnnotationParser(false, false){

            @Override
            protected void visitAnnotationStart(String type, boolean top) {
                if (top && type.equals("Lorg/apidesign/bck2brwsr/core/Exported;")) {
                    found[0] = true;
                }
            }
        };
        annotationParser.parse(arrData, cd);
        return found[0];
    }

    private static boolean isAccessible(int access) {
        return (access & 5) != 0;
    }
}

