/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.vm4brwsr;

import java.io.IOException;
import org.apidesign.vm4brwsr.ByteCodeParser;
import org.apidesign.vm4brwsr.VarType;
import org.apidesign.vm4brwsr.Variable;

final class LocalsMapper {
    private final ByteCodeParser.TypeArray argTypeRecords;
    private final ByteCodeParser.TypeArray localTypeRecords;

    public LocalsMapper(ByteCodeParser.TypeArray stackMapArgs) {
        ByteCodeParser.TypeArray initTypeRecords = new ByteCodeParser.TypeArray();
        LocalsMapper.updateRecords(initTypeRecords, stackMapArgs);
        this.argTypeRecords = initTypeRecords;
        this.localTypeRecords = new ByteCodeParser.TypeArray(initTypeRecords);
    }

    public void outputArguments(Appendable out, boolean isStatic) throws IOException {
        int first;
        int argRecordCount = this.argTypeRecords.getSize();
        int n = first = isStatic ? 0 : 1;
        if (argRecordCount > first) {
            Variable variable = LocalsMapper.getVariable(this.argTypeRecords, first);
            out.append(variable);
            for (int i = first + (variable.isCategory2() ? 2 : 1); i < argRecordCount; i += variable.isCategory2() ? 2 : 1) {
                variable = LocalsMapper.getVariable(this.argTypeRecords, i);
                out.append(", ");
                out.append(variable);
            }
        }
    }

    public void syncWithFrameLocals(ByteCodeParser.TypeArray frameLocals) {
        LocalsMapper.updateRecords(this.localTypeRecords, frameLocals);
    }

    public Variable setI(int index) {
        return this.setT(index, 0);
    }

    public Variable setL(int index) {
        return this.setT(index, 1);
    }

    public Variable setF(int index) {
        return this.setT(index, 2);
    }

    public Variable setD(int index) {
        return this.setT(index, 3);
    }

    public Variable setA(int index) {
        return this.setT(index, 4);
    }

    public Variable setT(int index, int type) {
        LocalsMapper.updateRecord(this.localTypeRecords, index, type);
        return Variable.getLocalVariable(type, index);
    }

    public Variable getI(int index) {
        return this.getT(index, 0);
    }

    public Variable getL(int index) {
        return this.getT(index, 1);
    }

    public Variable getF(int index) {
        return this.getT(index, 2);
    }

    public Variable getD(int index) {
        return this.getT(index, 3);
    }

    public Variable getA(int index) {
        return this.getT(index, 4);
    }

    public Variable getT(int index, int type) {
        int oldRecordValue = this.localTypeRecords.get(index);
        if ((oldRecordValue & 0xFF) != type) {
            throw new IllegalStateException("Type mismatch");
        }
        return Variable.getLocalVariable(type, index);
    }

    private static void updateRecords(ByteCodeParser.TypeArray typeRecords, ByteCodeParser.TypeArray stackMapTypes) {
        int srcSize = stackMapTypes.getSize();
        int dstIndex = 0;
        for (int i = 0; i < srcSize; ++i) {
            int smType = stackMapTypes.get(i);
            if (smType == 0) {
                ++dstIndex;
                continue;
            }
            int varType = VarType.fromStackMapType(smType);
            LocalsMapper.updateRecord(typeRecords, dstIndex, varType);
            dstIndex += VarType.isCategory2(varType) ? 2 : 1;
        }
    }

    private static void updateRecord(ByteCodeParser.TypeArray typeRecords, int index, int type) {
        if (typeRecords.getSize() < index + 1) {
            typeRecords.setSize(index + 1);
        }
        int oldRecordValue = typeRecords.get(index);
        int usedTypesMask = oldRecordValue >> 8 | 1 << type;
        typeRecords.set(index, usedTypesMask << 8 | type);
    }

    private static Variable getVariable(ByteCodeParser.TypeArray typeRecords, int index) {
        return Variable.getLocalVariable(typeRecords.get(index) & 0xFF, index);
    }
}

