/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.vm4brwsr;

import java.io.IOException;
import org.apidesign.vm4brwsr.ByteCodeParser;
import org.apidesign.vm4brwsr.ByteCodeToJavaScript;
import org.apidesign.vm4brwsr.StringArray;
import org.apidesign.vm4brwsr.VarType;
import org.apidesign.vm4brwsr.Variable;

final class StackMapper {
    private final ByteCodeParser.TypeArray stackTypeIndexPairs = new ByteCodeParser.TypeArray();
    private final StringArray stackValues = new StringArray();
    private boolean dirty;

    public void clear() {
        this.stackTypeIndexPairs.clear();
        this.stackValues.clear();
        this.dirty = false;
    }

    public void syncWithFrameStack(ByteCodeParser.TypeArray frameStack) {
        this.clear();
        int size = frameStack.getSize();
        for (int i = 0; i < size; ++i) {
            this.pushTypeImpl(VarType.fromStackMapType(frameStack.get(i)));
        }
    }

    public Variable pushI() {
        return this.pushT(0);
    }

    public Variable pushL() {
        return this.pushT(1);
    }

    public Variable pushF() {
        return this.pushT(2);
    }

    public Variable pushD() {
        return this.pushT(3);
    }

    public Variable pushA() {
        return this.pushT(4);
    }

    public Variable pushT(int type) {
        return this.getVariable(this.pushTypeImpl(type));
    }

    void assign(Appendable out, int varType, CharSequence s) throws IOException {
        this.pushTypeAndValue(varType, s);
    }

    void replace(Appendable out, int varType, String format, CharSequence ... arr) throws IOException {
        StringBuilder sb = new StringBuilder();
        ByteCodeToJavaScript.emitImpl(sb, format, arr);
        String[] values = this.stackValues.toArray();
        int last = this.stackTypeIndexPairs.getSize() - 1;
        values[last] = sb.toString();
        this.dirty = true;
        int value = last << 8 | varType & 0xFF;
        this.stackTypeIndexPairs.set(last, value);
    }

    void flush(Appendable out) throws IOException {
        int count = this.stackTypeIndexPairs.getSize();
        for (int i = 0; i < count; ++i) {
            String val = this.stackValues.getAndClear(i, true);
            if (val == null) continue;
            Variable var = this.getVariable(this.stackTypeIndexPairs.get(i));
            ByteCodeToJavaScript.emitImpl(out, "var @1 = @2;", var, val);
        }
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public CharSequence popI() {
        return this.popT(0);
    }

    public CharSequence popL() {
        return this.popT(1);
    }

    public CharSequence popF() {
        return this.popT(2);
    }

    public CharSequence popD() {
        return this.popT(3);
    }

    public CharSequence popA() {
        return this.popT(4);
    }

    public CharSequence popT(int type) {
        CharSequence variable = this.getT(0, type);
        this.popImpl(1);
        return variable;
    }

    public CharSequence popValue() {
        CharSequence variable = this.getT(0, -1);
        this.popImpl(1);
        return variable;
    }

    public Variable pop(Appendable out) throws IOException {
        this.flush(out);
        Variable variable = this.get(0);
        this.popImpl(1);
        return variable;
    }

    public void pop(int count) {
        int stackSize = this.stackTypeIndexPairs.getSize();
        if (count > stackSize) {
            throw new IllegalStateException("Stack underflow");
        }
        this.popImpl(count);
    }

    public CharSequence getI(int indexFromTop) {
        return this.getT(indexFromTop, 0);
    }

    public CharSequence getL(int indexFromTop) {
        return this.getT(indexFromTop, 1);
    }

    public CharSequence getF(int indexFromTop) {
        return this.getT(indexFromTop, 2);
    }

    public CharSequence getD(int indexFromTop) {
        return this.getT(indexFromTop, 3);
    }

    public CharSequence getA(int indexFromTop) {
        return this.getT(indexFromTop, 4);
    }

    public CharSequence getT(int indexFromTop, int type) {
        return this.getT(indexFromTop, type, true);
    }

    public CharSequence getT(int indexFromTop, int type, boolean clear) {
        int stackSize = this.stackTypeIndexPairs.getSize();
        if (indexFromTop >= stackSize) {
            throw new IllegalStateException("Stack underflow");
        }
        int stackValue = this.stackTypeIndexPairs.get(stackSize - indexFromTop - 1);
        if (type != -1 && (stackValue & 0xFF) != type) {
            throw new IllegalStateException("Type mismatch");
        }
        String value = this.stackValues.getAndClear(stackSize - indexFromTop - 1, clear);
        if (value != null) {
            return value;
        }
        return this.getVariable(stackValue);
    }

    public Variable get(int indexFromTop) {
        int stackSize = this.stackTypeIndexPairs.getSize();
        if (indexFromTop >= stackSize) {
            throw new IllegalStateException("Stack underflow");
        }
        int stackValue = this.stackTypeIndexPairs.get(stackSize - indexFromTop - 1);
        return this.getVariable(stackValue);
    }

    private int pushTypeImpl(int type) {
        int count = this.stackTypeIndexPairs.getSize();
        int value = count << 8 | type & 0xFF;
        this.stackTypeIndexPairs.add(value);
        this.addStackValue(count, null);
        return value;
    }

    private void pushTypeAndValue(int type, CharSequence v) {
        int count = this.stackTypeIndexPairs.getSize();
        int value = count << 8 | type & 0xFF;
        this.stackTypeIndexPairs.add(value);
        String val = v.toString();
        this.addStackValue(count, val);
    }

    private void addStackValue(int at, String val) {
        String[] arr = this.stackValues.toArray();
        if (arr.length > at) {
            arr[at] = val;
        } else {
            this.stackValues.add(val);
        }
        this.dirty = true;
    }

    private void popImpl(int count) {
        int stackSize = this.stackTypeIndexPairs.getSize();
        this.stackTypeIndexPairs.setSize(stackSize - count);
    }

    public Variable getVariable(int typeAndIndex) {
        int type = typeAndIndex & 0xFF;
        int index = typeAndIndex >> 8;
        return Variable.getStackVariable(type, index);
    }
}

