/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.vm4brwsr;

class StringArray {
    private String[] arr;

    public StringArray() {
    }

    private StringArray(String[] arr) {
        this.arr = arr;
    }

    public void add(String s) {
        this.add(s, false);
    }

    private boolean add(String s, boolean check) {
        if (this.arr == null) {
            this.arr = new String[1];
        } else {
            String[] tmp = new String[this.arr.length + 1];
            for (int i = 0; i < this.arr.length; ++i) {
                if (check && s.equals(this.arr[i])) {
                    return false;
                }
                tmp[i] = this.arr[i];
            }
            this.arr = tmp;
        }
        this.arr[this.arr.length - 1] = s;
        return true;
    }

    StringArray addAndNew(String ... values) {
        int i;
        int j;
        String[] tmp;
        if (this.arr == null) {
            tmp = new String[values.length];
            j = 0;
        } else {
            tmp = new String[this.arr.length + values.length];
            for (i = 0; i < this.arr.length; ++i) {
                tmp[i] = this.arr[i];
            }
            j = this.arr.length;
        }
        i = 0;
        while (i < values.length) {
            tmp[j++] = values[i++];
        }
        return new StringArray(tmp);
    }

    public String[] toArray() {
        return this.arr == null ? new String[]{} : this.arr;
    }

    static StringArray asList(String ... names) {
        return new StringArray(names);
    }

    void reverse() {
        int j = this.arr.length;
        for (int i = 0; i < j; ++i) {
            String s = this.arr[i];
            this.arr[i] = this.arr[--j];
            this.arr[j] = s;
        }
    }

    boolean contains(String n) {
        if (this.arr == null) {
            return false;
        }
        for (int i = 0; i < this.arr.length; ++i) {
            if (!n.equals(this.arr[i])) continue;
            return true;
        }
        return false;
    }

    void delete(int indx) {
        if (this.arr == null || indx < 0 || indx >= this.arr.length) {
            return;
        }
        String[] tmp = new String[this.arr.length - 1];
        int j = 0;
        for (int i = 0; i < this.arr.length; ++i) {
            if (i == indx) continue;
            tmp[j++] = this.arr[i];
        }
        this.arr = tmp;
    }

    void remove(String item) {
        int f = this.indexOf(item);
        if (f != -1) {
            this.delete(f);
        }
    }

    int indexOf(String ic) {
        if (this.arr != null) {
            for (int i = 0; i < this.arr.length; ++i) {
                if (!ic.equals(this.arr[i])) continue;
                return i;
            }
        }
        return -1;
    }

    String getAndClear(int count, boolean clear) {
        String s = this.arr[count];
        if (clear) {
            this.arr[count] = null;
        }
        return s;
    }

    void clear() {
        this.arr = null;
    }

    boolean addIfMissing(String s) {
        return this.add(s, true);
    }
}

