/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.vm4brwsr;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.DatatypeConverter;
import org.apidesign.bck2brwsr.core.JavaScriptBody;
import org.apidesign.vm4brwsr.Bck2Brwsr;
import org.apidesign.vm4brwsr.ByteCodeParser;
import org.apidesign.vm4brwsr.ByteCodeToJavaScript;
import org.apidesign.vm4brwsr.ClassDataCache;
import org.apidesign.vm4brwsr.ClassPath;
import org.apidesign.vm4brwsr.ExportedSymbols;
import org.apidesign.vm4brwsr.StringArray;
import org.apidesign.vm4brwsr.VMLazy;

abstract class VM
extends ByteCodeToJavaScript {
    protected final ClassDataCache classDataCache;
    private final Bck2Brwsr.Resources resources;
    private final ExportedSymbols exportedSymbols;
    private final StringBuilder invokerMethods;
    private final StringArray asBinary;
    int exportedCount;
    private StringArray scripts = new StringArray();
    private StringArray references = new StringArray();

    private VM(Appendable out, Bck2Brwsr.Resources resources, StringArray explicitlyExported, StringArray asBinary) {
        super(out);
        this.resources = resources;
        this.classDataCache = new ClassDataCache(resources);
        this.exportedSymbols = new ExportedSymbols(resources, explicitlyExported);
        this.invokerMethods = new StringBuilder();
        this.asBinary = asBinary;
    }

    @Override
    boolean debug(String msg) throws IOException {
        return false;
    }

    static void compile(Appendable out, Bck2Brwsr config) throws IOException {
        VM vm;
        String[] both = config.classes().toArray();
        StringArray fixedNames = new StringArray();
        fixedNames.add(Object.class.getName().replace('.', '/'));
        fixedNames.add(Class.class.getName().replace('.', '/'));
        fixedNames.add(ArithmeticException.class.getName().replace('.', '/'));
        if (config.isExtension()) {
            fixedNames.add(VM.class.getName().replace('.', '/'));
            vm = new Extension(out, config.getResources(), both, config.exported(), config.allResources(), config.classpath());
        } else {
            if (config.includeVM()) {
                fixedNames.add(VM.class.getName().replace('.', '/'));
            }
            vm = new Standalone(out, config.getResources(), config.exported(), config.allResources());
        }
        super.doCompile(fixedNames.addAndNew(both));
    }

    private void doCompile(StringArray names) throws IOException {
        this.generatePrologue();
        this.append("\n  var invoker = {};");
        this.generateBody(names);
        this.append(this.invokerMethods);
        for (String r : this.asBinary.toArray()) {
            this.append("\n  ").append(this.getExportsObject()).append("['registerResource']('");
            this.append(r).append("', '");
            InputStream is = this.resources.get(r);
            byte[] arr = new byte[is.available()];
            int offset = 0;
            while (true) {
                int len;
                if (offset == arr.length) {
                    byte[] tmp = new byte[arr.length * 2];
                    System.arraycopy(arr, 0, tmp, 0, arr.length);
                    arr = tmp;
                }
                if ((len = is.read(arr, offset, arr.length - offset)) == -1) break;
                offset += len;
            }
            if (offset != arr.length) {
                byte[] tmp = new byte[offset];
                System.arraycopy(arr, 0, tmp, 0, offset);
                arr = tmp;
            }
            this.append(VM.btoa(arr));
            this.append("');");
        }
        this.append("\n");
        this.generateEpilogue();
    }

    @JavaScriptBody(args={"arr"}, body="return btoa(arr);")
    private static String btoa(byte[] arr) {
        return DatatypeConverter.printBase64Binary((byte[])arr);
    }

    protected abstract void generatePrologue() throws IOException;

    protected abstract void generateEpilogue() throws IOException;

    protected abstract String getExportsObject();

    protected abstract boolean isExternalClass(String var1);

    protected abstract void lazyReference(Appendable var1, String var2) throws IOException;

    @Override
    protected final void declaredClass(ByteCodeParser.ClassData classData, String mangledName) throws IOException {
        if (this.exportedSymbols.isExported(classData)) {
            this.append("\n").append(this.getExportsObject()).append("['").append(mangledName).append("'] = ").append(this.accessClass(mangledName)).append(";\n");
            ++this.exportedCount;
        }
    }

    protected String generateClass(String className) throws IOException {
        ByteCodeParser.ClassData classData = this.classDataCache.getClassData(className);
        if (classData == null) {
            throw new IOException("Can't find class " + className);
        }
        return this.compile(classData);
    }

    @Override
    protected void declaredField(ByteCodeParser.FieldData fieldData, String destObject, String mangledName) throws IOException {
        if (this.exportedSymbols.isExported(fieldData)) {
            this.exportMember(destObject, mangledName);
        }
    }

    @Override
    protected void declaredMethod(ByteCodeParser.MethodData methodData, String destObject, String mangledName) throws IOException {
        if (this.isHierarchyExported(methodData)) {
            this.exportMember(destObject, mangledName);
        }
    }

    private void exportMember(String destObject, String memberName) throws IOException {
        this.append("\n").append(destObject).append("['").append(memberName).append("'] = m;\n");
    }

    private void generateBody(StringArray names) throws IOException {
        StringArray processed = new StringArray();
        StringArray initCode = new StringArray();
        StringArray skipClass = new StringArray();
        for (String baseClass : names.toArray()) {
            this.references.add(baseClass);
            while (true) {
                String name = null;
                for (String n : this.references.toArray()) {
                    if (skipClass.contains(n) || processed.contains(n)) continue;
                    name = n;
                }
                if (name == null) break;
                InputStream is = this.resources.get(name + ".class");
                if (is == null) {
                    this.lazyReference(this, name);
                    skipClass.add(name);
                    continue;
                }
                try {
                    String ic = this.generateClass(name);
                    processed.add(name);
                    initCode.add(ic == null ? "" : ic);
                }
                catch (RuntimeException ex) {
                    throw new IOException("Error while compiling " + name + "\n", ex);
                }
            }
            for (String resource : this.scripts.toArray()) {
                while (resource.startsWith("/")) {
                    resource = resource.substring(1);
                }
                this.requireResourceImpl(resource);
                this.asBinary.remove(resource);
            }
            this.scripts = new StringArray();
            StringArray toInit = StringArray.asList(this.references.toArray());
            toInit.reverse();
            for (String ic : toInit.toArray()) {
                int indx = processed.indexOf(ic);
                if (indx < 0) continue;
                String theCode = initCode.toArray()[indx];
                if (!theCode.isEmpty()) {
                    this.append(theCode).append("\n");
                }
                initCode.toArray()[indx] = "";
            }
        }
    }

    final void requireResourceImpl(String resource) throws IOException {
        InputStream emul = this.resources.get(resource);
        if (emul == null) {
            throw new IOException("Can't find " + resource);
        }
        this.append("\n// resource from ").append(resource).append("\n");
        VM.readResource(emul, this);
        this.append("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readResource(InputStream emul, Appendable out) throws IOException {
        try {
            int ch;
            boolean state = false;
            while ((ch = emul.read()) != -1) {
                if (ch < 0 || ch > 255) {
                    throw new IOException("Invalid char in emulation " + ch);
                }
                out.append((char)ch);
            }
        }
        finally {
            emul.close();
        }
    }

    static String toString(String name) throws IOException {
        StringBuilder sb = new StringBuilder();
        return sb.toString().toString();
    }

    @Override
    protected boolean requireReference(String cn) {
        return this.references.addIfMissing(cn);
    }

    @Override
    protected void requireScript(String resourcePath) {
        this.scripts.add(resourcePath);
    }

    @Override
    String assignClass(String className) {
        return "vm." + className + " = ";
    }

    @Override
    String accessClass(String className) {
        return "vm." + className;
    }

    @Override
    protected String accessField(String object, String mangledName, String[] fieldInfoName) throws IOException {
        ByteCodeParser.FieldData field = this.classDataCache.findField(fieldInfoName[0], fieldInfoName[1], fieldInfoName[2]);
        return this.accessNonVirtualMember(object, mangledName, field != null ? field.cls : null);
    }

    @Override
    protected String accessStaticMethod(String object, String mangledName, String[] fieldInfoName) throws IOException {
        ByteCodeParser.MethodData method = this.classDataCache.findMethod(fieldInfoName[0], fieldInfoName[1], fieldInfoName[2]);
        return this.accessNonVirtualMember(object, mangledName, method != null ? method.cls : null);
    }

    @Override
    protected String accessVirtualMethod(String object, String mangledName, String[] fieldInfoName, int params) throws IOException {
        ByteCodeParser.ClassData referencedClass = this.classDataCache.getClassData(fieldInfoName[0]);
        ByteCodeParser.MethodData method = this.classDataCache.findMethod(referencedClass, fieldInfoName[1], fieldInfoName[2]);
        if (!(method == null || this.isExternalClass(method.cls.getClassName()) || (method.access & 0x10) == 0 && (referencedClass.getAccessFlags() & 0x10) == 0 && this.isHierarchyExported(method))) {
            return object + "." + mangledName + '(';
        }
        return this.accessThroughInvoker(object, mangledName, params);
    }

    private String accessThroughInvoker(String object, String mangledName, int params) throws IOException {
        String def = "\n  invoker." + mangledName + " = function(target";
        if (this.invokerMethods.indexOf(def) == -1) {
            int j;
            this.invokerMethods.append(def);
            for (j = 0; j < params; ++j) {
                this.invokerMethods.append(", p").append(j);
            }
            this.invokerMethods.append(") {\n    return target['").append(mangledName).append("'](");
            for (j = 0; j < params; ++j) {
                if (j > 0) {
                    this.invokerMethods.append(",");
                }
                this.invokerMethods.append("p").append(j);
            }
            this.invokerMethods.append(");\n  };");
        }
        return "invoker." + mangledName + '(' + object + (params > 1 ? "," : "");
    }

    private boolean isHierarchyExported(ByteCodeParser.MethodData methodData) throws IOException {
        if (this.exportedSymbols.isExported(methodData)) {
            return true;
        }
        if ((methodData.access & 0xA) != 0) {
            return false;
        }
        ExportedMethodFinder exportedMethodFinder = new ExportedMethodFinder(this.exportedSymbols);
        this.classDataCache.findMethods(methodData.cls, methodData.getName(), methodData.getInternalSig(), exportedMethodFinder);
        return exportedMethodFinder.getFound() != null;
    }

    private String accessNonVirtualMember(String object, String mangledName, ByteCodeParser.ClassData declaringClass) {
        if (declaringClass == null) {
            return object + "['" + mangledName + "']";
        }
        String className = declaringClass.getClassName();
        if ("java/lang/Object".equals(className) || "java/lang/reflect/Array".equals(className) || this.isExternalClass(className)) {
            return object + "['" + mangledName + "']";
        }
        return object + "." + mangledName;
    }

    static {
        boolean assertsOn = false;
        if (!$assertionsDisabled) {
            assertsOn = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertsOn) {
            VMLazy.init();
            ClassPath.init();
        }
    }

    private static final class Extension
    extends VM {
        private final StringArray extensionClasses;
        private final StringArray classpath;

        private Extension(Appendable out, Bck2Brwsr.Resources resources, String[] extClassesArray, StringArray explicitlyExported, StringArray asBinary, StringArray classpath) throws IOException {
            super(out, resources, explicitlyExported, asBinary);
            this.extensionClasses = StringArray.asList(extClassesArray);
            this.classpath = classpath;
        }

        @Override
        protected void generatePrologue() throws IOException {
            this.append("bck2brwsr.register({\n  'magic' : 'kaf\u00ed\u010dko'");
            if (this.classpath != null && this.classpath.toArray().length > 0) {
                this.append(",\n  'classpath' : [\n");
                String sep = "    ";
                for (String s : this.classpath.toArray()) {
                    this.append(sep).append("'").append(s).append("'");
                    sep = ",\n    ";
                }
                this.append("\n  ]");
            }
            this.append("\n}, function(exports) {\n  var vm = {};\n");
            this.append("  function link(n, assign) {\n    return function() {\n      var no_ = n['replace__Ljava_lang_String_2Ljava_lang_CharSequence_2Ljava_lang_CharSequence_2']('_', '_1').toString();\n      var cls = no_['replace__Ljava_lang_String_2CC']('/', '_').toString();\n      var dot = n['replace__Ljava_lang_String_2CC']('/', '.').toString();\n      exports.loadClass(dot);\n      assign(exports[cls]);\n      return exports[cls](arguments);\n    };\n  };\n");
        }

        @Override
        protected void generateEpilogue() throws IOException {
            this.append("});");
            if (this.exportedCount == 0) {
                throw new IOException("Creating library without any exported symbols is useless!");
            }
        }

        @Override
        protected String generateClass(String className) throws IOException {
            if (this.isExternalClass(className)) {
                String cls = className.replace("_", "_1").replace('/', '_');
                this.append("\n").append(this.assignClass(cls)).append("link('").append(className).append("', function(f) { ").append(this.assignClass(cls)).append(" f; });");
                return null;
            }
            return super.generateClass(className);
        }

        @Override
        protected String getExportsObject() {
            return "exports";
        }

        @Override
        protected boolean isExternalClass(String className) {
            return !this.extensionClasses.contains(className);
        }

        @Override
        protected void lazyReference(Appendable out, String n) throws IOException {
            String cls = n.replace('/', '_');
            out.append("\nvm.").append(cls).append(" = function() {");
            out.append("\n  var instance = arguments.length == 0 || arguments[0] === true;");
            out.append("\n  delete vm.").append(cls).append(";");
            out.append("\n  return link('").append(n).append("', function(f) { vm.");
            out.append(cls).append(" = f;})(instance);");
            out.append("\n}");
        }

        @Override
        protected void requireResource(String resourcePath) throws IOException {
            this.requireResourceImpl(resourcePath);
            ((VM)this).asBinary.remove(resourcePath);
        }
    }

    private static final class Standalone
    extends VM {
        private Standalone(Appendable out, Bck2Brwsr.Resources resources, StringArray explicitlyExported, StringArray asBinary) {
            super(out, resources, explicitlyExported, asBinary);
        }

        @Override
        protected void generatePrologue() throws IOException {
            this.append("(function VM(global) {var fillInVMSkeleton = function(vm) {");
        }

        @Override
        protected void generateEpilogue() throws IOException {
            this.append("  return vm;\n  };\n  var extensions = [];\n  function replaceAll(s, target, replacement) {\n    var pos = 0;\n    for (;;) {\n      var indx = s.indexOf(target, pos);\n      if (indx === -1) {\n        return s;\n      }\n      pos = indx + replacement.length;\n      s = s.substring(0, indx) + replacement + s.substring(indx + target.length);\n    }\n  }\n  function mangleClass(name) {\n    name = replaceAll(name, '_', '_1');\n    name = replaceAll(name, '.', '_');\n    return name;\n  };\n  var pending = [];\n  var pendingClasses = [];\n  function extensionLoaded(ev) {\n    var at = pending.indexOf(ev.target);\n    pending.splice(at, 1);\n    if (pending.length === 0) {\n      for (var i = 0; i < pendingClasses.length; i += 3) {\n        invokeMethod(pendingClasses[i], pendingClasses[i + 1], pendingClasses[i + 2]);\n      }\n      pendingClasses = [];\n    }\n  }\n  function invokeMethod(vm, n, args) {\n    var clazz = vm.loadClass(n);\n    if (args) {\n      var seek = args[0];\n      var prefix = seek.indexOf('__') == -1 ? seek + '__' : seek;\n      args = Array.prototype.slice.call(args, 1);\n      var found = '';\n      for (var m in clazz) {\n        if (m.indexOf(prefix) === 0) {\n          return clazz[m].apply(null, args);\n        }\n        found += m.toString() + '\\n'\n      }\n      throw 'Cannot find ' + seek + ' in ' + n + ' found:\\n' + found;\n    }\n  }\n  function extensionError(ev) {\n    console.log('error loading ' + ev.target.src);\n    extensionLoaded(ev);\n  }\n  function loadExtension(url) {\n      if (url.substring(url.length - 4) == '.jar')\n        url = url.substring(0, url.length - 4) + '.js';\n      var script = document.createElement('script');\n      script.type = 'text/javascript';\n      script.src = url;\n      script.onload = extensionLoaded;\n      script.onerror = extensionError;\n      document.getElementsByTagName('head')[0].appendChild(script);\n      pending.push(script);\n  }\n  global.bck2brwsr = function() {\n    var args = Array.prototype.slice.apply(arguments);\n    var resources = {};\n    function registerResource(n, a64) {\n      var frm = atob || window.atob;\n      var str = frm(a64);\n      var arr = [];\n      for (var i = 0; i < str.length; i++) {\n        var ch = str.charCodeAt(i) & 0xff;\n        if (ch > 127) ch -= 256;\n        arr.push(ch);\n      }\n      if (!resources[n]) resources[n] = [arr];\n      else resources[n].push(arr);\n    }\n    var vm = fillInVMSkeleton({ 'registerResource' : registerResource });\n    function initVM() {\n      var clsArray = vm['java_lang_reflect_Array'];\n      if (clsArray) clsArray(false);\n    }\n    for (var i = 0; i < extensions.length; ++i) {\n      extensions[i](vm);\n    }\n    vm['registerResource'] = null;\n    var knownExtensions = extensions.length;\n    var loader = {};\n    var loadBytes = function(name, skip) {\n      skip = typeof skip == 'number' ? skip : 0;\n      var arr = resources[name];\n      if (arr) {\n        var arrSize = arr.length;\n        if (skip < arrSize) return arr[skip];\n        skip -= arrSize;\n      } else {\n        var arrSize = 0;\n      };\n      for (var i = 0; i < args.length; i++) {\n        var at = args[i];\n        if(!at) continue;\n        var ret;\n        if (typeof at === 'string' && at.substring(at.length - 3) === '.js') {\n          loadExtension(at);\n          args[i] = null;\n        } else if (typeof at === 'function') ret = at(name, skip);\n        else {\n          var cp = vm['org_apidesign_vm4brwsr_ClassPath'];\n          if (!cp) throw 'Core Java library not registered. Cannot load from ' + at;\n          ret = cp(false).\n            loadBytes___3BLjava_lang_String_2Ljava_lang_Object_2II(name, args, i, skip);\n        }\n        if (ret) return ret;\n      }\n      while (knownExtensions < extensions.length) {\n        vm['registerResource'] = registerResource;\n        extensions[knownExtensions++](vm);\n        vm['registerResource'] = null;\n        initVM();\n      }\n      var arr = resources[name];\n      return (arr && arr.length > arrSize) ? arr[arrSize] : null;\n    }\n    var reload = function(name, arr, keep) {\n      if (!arr) throw 'Cannot find ' + name;\n      var lazy = vm['org_apidesign_vm4brwsr_VMLazy'];\n      if (!lazy) throw 'No bck2brwsr VM module to compile ' + name;\n      if (!keep) {\n        var attr = mangleClass(name);\n        delete vm[attr];\n      }\n      return lazy(false)\n        ['load__Ljava_lang_Object_2Ljava_lang_Object_2Ljava_lang_String_2_3Ljava_lang_Object_2_3B']\n        (vm, name, args, arr);\n    };\n    var loadClass = function(name) {\n      var attr = mangleClass(name);\n      var fn = vm[attr];\n      if (fn) return fn(false);\n      try {\n        var arr = loadBytes(replaceAll(name, '.', '/') + '.class');\n        return reload(name, arr, true);\n      } catch (err) {\n        fn = vm[attr];\n        if (fn) return fn(false);\n        throw err;\n      }\n    }\n    if (vm['loadClass']) {\n      throw 'Cannot initialize the bck2brwsr VM twice!';\n    }\n    vm['loadClass'] = loadClass;\n    vm['_reload'] = reload;\n    vm['loadBytes'] = loadBytes;\n    initVM();\n    loader.loadClass = function(name) {\n      if (pending.length === 0) {\n        try {\n          var c = loadClass(name);\n          c['invoke'] = function() {\n            return invokeMethod(vm, name, arguments);\n          };\n          return c;\n        } catch (err) {\n          if (pending.length === 0) throw err;\n        }\n      }\n      pendingClasses.push(vm);\n      pendingClasses.push(name);\n      pendingClasses.push(null);\n      return {\n        'invoke' : function() {\n          if (pending.length === 0) {\n            invokeMethod(vm, name, arguments);\n            return;\n          }\n          pendingClasses.push(vm);\n          pendingClasses.push(name);\n          pendingClasses.push(arguments);\n        }\n      };\n    }\n    return loader;\n  };\n");
            this.append("  global.bck2brwsr.register = function(config, extension) {\n    if (!config || config['magic'] !== 'kaf\u00ed\u010dko') {\n      console.log('Will not register: ' + extension);\n      return false;\n    }\n    extensions.push(extension);\n    var cp = config['classpath'];\n    if (cp) for (var i = 0; i < cp.length; i++) {\n      loadExtension(cp[i]);\n    }\n    return null;\n  };\n");
            this.append("}(this));");
        }

        @Override
        protected String getExportsObject() {
            return "vm";
        }

        @Override
        protected boolean isExternalClass(String className) {
            return false;
        }

        @Override
        protected void lazyReference(Appendable out, String n) throws IOException {
            String cls = n.replace('/', '_');
            String dot = n.replace('/', '.');
            out.append("\nvm.").append(cls).append(" = function() {");
            out.append("\n  var instance = arguments.length == 0 || arguments[0] === true;");
            out.append("\n  delete vm.").append(cls).append(";");
            out.append("\n  var c = vm.loadClass('").append(dot).append("');");
            out.append("\n  return vm.").append(cls).append("(instance);");
            out.append("\n}");
        }

        @Override
        protected void requireResource(String resourcePath) throws IOException {
            this.requireResourceImpl(resourcePath);
            ((VM)this).asBinary.remove(resourcePath);
        }
    }

    private final class ExportedMethodFinder
    implements ClassDataCache.TraversalCallback<ByteCodeParser.MethodData> {
        private final ExportedSymbols exportedSymbols;
        private ByteCodeParser.MethodData found;

        public ExportedMethodFinder(ExportedSymbols exportedSymbols) {
            this.exportedSymbols = exportedSymbols;
        }

        @Override
        public boolean traverse(ByteCodeParser.MethodData methodData) {
            try {
                if (this.exportedSymbols.isExported(methodData) || VM.this.isExternalClass(methodData.cls.getClassName())) {
                    this.found = methodData;
                    return false;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }

        public ByteCodeParser.MethodData getFound() {
            return this.found;
        }
    }
}

