/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.vm4brwsr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apidesign.bck2brwsr.core.Exported;
import org.apidesign.bck2brwsr.core.JavaScriptBody;
import org.apidesign.vm4brwsr.ByteCodeToJavaScript;
import org.apidesign.vm4brwsr.ClassPath;

final class VMLazy {
    private final Object vm;
    private final Object[] args;

    private VMLazy(Object vm, Object[] args) {
        this.vm = vm;
        this.args = args;
    }

    static void init() {
    }

    @Exported
    static Object load(Object loader, String name, Object[] arguments, byte[] arr) throws IOException, ClassNotFoundException {
        if (arr == null) {
            throw new ClassNotFoundException(name);
        }
        return new VMLazy(loader, arguments).defineClass(arr, name, false);
    }

    @Exported
    Object load(String name, boolean instance) throws IOException, ClassNotFoundException {
        String res = name.replace('.', '/') + ".class";
        byte[] arr = ClassPath.loadBytes(res, this.args, 0);
        if (arr == null) {
            throw new ClassNotFoundException(name);
        }
        return this.defineClass(arr, name, instance);
    }

    private Object defineClass(byte[] arr, String name, boolean instance) throws IOException {
        StringBuilder out = new StringBuilder(65535);
        out.append("var vm = arguments[0];\n");
        int prelude = out.length();
        String initCode = new Gen(this, out).compile(new ByteArrayInputStream(arr));
        String code = out.toString().toString();
        String under = name.replace('.', '_');
        Object fn = VMLazy.applyCode(this.vm, under, code, instance);
        if (!initCode.isEmpty()) {
            out.setLength(prelude);
            out.append(initCode);
            code = out.toString().toString();
            VMLazy.applyCode(this.vm, null, code, false);
        }
        return fn;
    }

    @JavaScriptBody(args={"vm", "name", "script", "instance"}, body="try {\n  new Function(script)(vm, name);\n} catch (ex) {\n  throw 'Cannot compile ' + name + ' ' + ex + ' line: ' + ex.lineNumber + ' script:\\n' + script;\n}\nreturn name != null ? vm[name](instance) : null;\n")
    private static native Object applyCode(Object var0, String var1, String var2, boolean var3);

    private static final class Gen
    extends ByteCodeToJavaScript {
        private final VMLazy lazy;

        public Gen(VMLazy vm, Appendable out) {
            super(out);
            this.lazy = vm;
        }

        @Override
        @JavaScriptBody(args={"n"}, body="var cls = n.replace__Ljava_lang_String_2CC('/','_').toString();\nvar dot = n.replace__Ljava_lang_String_2CC('/','.').toString();\nvar lazy = this._lazy();\nvar vm = lazy._vm();\nif (vm[cls]) return false;\nvm[cls] = function() {\n  var instance = arguments.length == 0 || arguments[0] === true;\n  return lazy.load__Ljava_lang_Object_2Ljava_lang_String_2Z(dot, instance);\n};\nreturn true;")
        protected boolean requireReference(String internalClassName) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void requireScript(String resourcePath) throws IOException {
            if (!resourcePath.startsWith("/")) {
                resourcePath = "/" + resourcePath;
            }
            String code = this.readCode(resourcePath);
            VMLazy.applyCode(this.lazy.vm, null, code, false);
        }

        private String readCode(String resourcePath) throws IOException {
            int ch;
            InputStream is = this.getClass().getResourceAsStream(resourcePath);
            StringBuilder sb = new StringBuilder();
            while ((ch = is.read()) != -1) {
                sb.append((char)ch);
            }
            return sb.toString();
        }

        @Override
        String assignClass(String className) {
            return "vm[arguments[1]]=";
        }

        @Override
        String accessClass(String classOperation) {
            return "vm." + classOperation;
        }

        @Override
        protected void requireResource(String resourcePath) throws IOException {
            this.requireReference(resourcePath);
        }
    }
}

