/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.vm4brwsr;

final class VarType {
    public static final int INTEGER = 0;
    public static final int LONG = 1;
    public static final int FLOAT = 2;
    public static final int DOUBLE = 3;
    public static final int REFERENCE = 4;
    public static final int LAST = 4;

    private VarType() {
    }

    public static boolean isCategory2(int varType) {
        return varType == 1 || varType == 3;
    }

    public static int fromStackMapType(int smType) {
        switch (smType & 0xFF) {
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 1;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 4;
            }
        }
        throw new IllegalStateException("Unhandled stack map type");
    }

    public static int fromConstantType(byte constantTag) {
        switch (constantTag) {
            case 3: {
                return 0;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 3;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                return 4;
            }
        }
        throw new IllegalStateException("Unhandled constant tag");
    }

    public static int fromFieldType(char fieldType) {
        switch (fieldType) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return 0;
            }
            case 'J': {
                return 1;
            }
            case 'F': {
                return 2;
            }
            case 'D': {
                return 3;
            }
            case 'L': 
            case '[': {
                return 4;
            }
        }
        throw new IllegalStateException("Unhandled field type");
    }

    public static String toString(int varType) {
        switch (varType) {
            case 0: {
                return "int";
            }
            case 1: {
                return "long";
            }
            case 2: {
                return "float";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "ref";
            }
        }
        throw new IllegalStateException("Unhandled field type");
    }
}

