/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.vm4brwsr;

import org.apidesign.vm4brwsr.VarType;

final class Variable
implements CharSequence {
    private static final String STACK_VAR_PREFIX = "st";
    private static final String LOCAL_VAR_PREFIX = "lc";
    private final String name;
    private final int type;
    private final int index;
    private static final char[] TYPE_IDS = new char[]{'I', 'L', 'F', 'D', 'A'};

    private Variable(String prefix, int type, int index) {
        this.name = prefix + TYPE_IDS[type] + index;
        this.type = type;
        this.index = index;
    }

    public static Variable getStackVariable(int type, int index) {
        return new Variable(STACK_VAR_PREFIX, type, index);
    }

    public static Variable getLocalVariable(int type, int index) {
        return new Variable(LOCAL_VAR_PREFIX, type, index);
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isCategory2() {
        return VarType.isCategory2(this.type);
    }

    @Override
    public int length() {
        return this.name.length();
    }

    @Override
    public char charAt(int index) {
        return this.name.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.name.subSequence(start, end);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Variable)) {
            return false;
        }
        return this.name.equals(((Variable)other).name);
    }

    @Override
    public String toString() {
        return this.name;
    }
}

