/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.ast.impl;

import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.jruby.ast.impl.BlockImpl;
import org.asciidoctor.jruby.ast.impl.CellImpl;
import org.asciidoctor.jruby.ast.impl.ColumnImpl;
import org.asciidoctor.jruby.ast.impl.ContentNodeImpl;
import org.asciidoctor.jruby.ast.impl.DescriptionListEntryImpl;
import org.asciidoctor.jruby.ast.impl.DescriptionListImpl;
import org.asciidoctor.jruby.ast.impl.DocumentImpl;
import org.asciidoctor.jruby.ast.impl.ListImpl;
import org.asciidoctor.jruby.ast.impl.ListItemImpl;
import org.asciidoctor.jruby.ast.impl.NodeCache;
import org.asciidoctor.jruby.ast.impl.PhraseNodeImpl;
import org.asciidoctor.jruby.ast.impl.SectionImpl;
import org.asciidoctor.jruby.ast.impl.TableImpl;
import org.asciidoctor.jruby.internal.RubyObjectWrapper;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.java.proxies.RubyObjectHolderProxy;
import org.jruby.runtime.builtin.IRubyObject;

public final class NodeConverter {
    private NodeConverter() {
    }

    public static ContentNode createASTNode(Ruby runtime, NodeType nodeType, IRubyObject ... args) {
        IRubyObject node = nodeType.getRubyClass(runtime).callMethod(runtime.getCurrentContext(), "new", args);
        return NodeConverter.createASTNode(node);
    }

    public static ContentNode createASTNode(Object object) {
        if (object instanceof IRubyObject || object instanceof RubyObjectHolderProxy) {
            ContentNodeImpl ret;
            IRubyObject rubyObject = NodeConverter.asRubyObject(object);
            if (rubyObject.isNil()) {
                return null;
            }
            NodeCache nodeCache = NodeCache.get(rubyObject);
            ContentNode cachedNode = nodeCache.getASTNode();
            if (cachedNode != null) {
                return cachedNode;
            }
            switch (NodeType.getNodeType(rubyObject)) {
                case BLOCK_CLASS: {
                    ret = new BlockImpl(rubyObject);
                    break;
                }
                case SECTION_CLASS: {
                    ret = new SectionImpl(rubyObject);
                    break;
                }
                case DOCUMENT_CLASS: {
                    ret = new DocumentImpl(rubyObject);
                    break;
                }
                case INLINE_CLASS: {
                    ret = new PhraseNodeImpl(rubyObject);
                    break;
                }
                case LIST_CLASS: {
                    ret = new ListImpl(rubyObject);
                    break;
                }
                case LIST_ITEM_CLASS: {
                    ret = new ListItemImpl(rubyObject);
                    break;
                }
                case DEFINITIONLIST_CLASS: {
                    ret = new DescriptionListImpl(rubyObject);
                    break;
                }
                case DEFINITIONLIST_ITEM_CLASS: {
                    ret = new DescriptionListEntryImpl(rubyObject);
                    break;
                }
                case TABLE_CLASS: {
                    ret = new TableImpl(rubyObject);
                    break;
                }
                case TABLE_COLUMN_CLASS: {
                    ret = new ColumnImpl(rubyObject);
                    break;
                }
                case TABLE_CELL_CLASS: {
                    ret = new CellImpl(rubyObject);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Don't know what to do with a " + rubyObject);
                }
            }
            nodeCache.setASTNode(ret);
            return ret;
        }
        if (object instanceof ContentNode) {
            return (ContentNode)object;
        }
        throw new IllegalArgumentException(object != null ? object.toString() : "null");
    }

    public static IRubyObject asRubyObject(Object o) {
        if (o instanceof IRubyObject) {
            return (IRubyObject)o;
        }
        if (o instanceof RubyObjectHolderProxy) {
            return ((RubyObjectHolderProxy)o).__ruby_object();
        }
        throw new IllegalArgumentException(o.getClass() + " is not a IRubyObject nor a RubyObjectHolderProxy!");
    }

    public static enum NodeType {
        BLOCK_CLASS("Asciidoctor", "Block"),
        SECTION_CLASS("Asciidoctor", "Section"),
        DOCUMENT_CLASS("Asciidoctor", "Document"),
        INLINE_CLASS("Asciidoctor", "Inline"),
        LIST_CLASS(new String[]{"Asciidoctor", "List"}){

            @Override
            public boolean isInstance(IRubyObject object) {
                return super.isInstance(object) && !"dlist".equals(new RubyObjectWrapper(object).getString("context", new Object[0]));
            }
        }
        ,
        DEFINITIONLIST_CLASS(new String[]{"Asciidoctor", "List"}){

            @Override
            public boolean isInstance(IRubyObject object) {
                return super.isInstance(object) && "dlist".equals(new RubyObjectWrapper(object).getString("context", new Object[0]));
            }
        }
        ,
        DEFINITIONLIST_ITEM_CLASS(new String[]{"Array"}){

            @Override
            public boolean isInstance(IRubyObject object) {
                if (!super.isInstance(object)) {
                    return false;
                }
                RubyArray array = (RubyArray)object;
                boolean ret = array.size() == 2 && object.getRuntime().getArray().isInstance((IRubyObject)array.get(0)) && (null == array.get(1) || LIST_ITEM_CLASS.isInstance((IRubyObject)array.get(1)));
                return ret;
            }
        }
        ,
        LIST_ITEM_CLASS("Asciidoctor", "ListItem"),
        TABLE_CLASS("Asciidoctor", "Table"),
        TABLE_COLUMN_CLASS("Asciidoctor", "Table", "Column"),
        TABLE_CELL_CLASS("Asciidoctor", "Table", "Cell");

        private String[] path;

        private NodeType(String ... path) {
            this.path = path;
        }

        public RubyClass getRubyClass(Ruby runtime) {
            if (this.path.length == 1) {
                return runtime.getClass(this.path[0]);
            }
            RubyModule object = runtime.getModule(this.path[0]);
            RubyClass rubyClass = object.getClass(this.path[1]);
            if (this.path.length == 2) {
                return rubyClass;
            }
            return rubyClass.getClass(this.path[2]);
        }

        private static NodeType getNodeType(IRubyObject rubyObject) {
            for (NodeType nodeType : NodeType.values()) {
                if (!nodeType.isInstance(rubyObject)) continue;
                return nodeType;
            }
            throw new IllegalArgumentException("Don't know what to do with a " + rubyObject.getMetaClass());
        }

        public boolean isInstance(IRubyObject object) {
            Ruby rubyRuntime = object.getRuntime();
            return this.getRubyClass(rubyRuntime).equals((Object)object.getMetaClass().getRealClass());
        }
    }
}

