/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.internal.BuildConfigListener;
import org.aspectj.ajde.internal.BuildConfigManager;
import org.aspectj.ajde.internal.LstBuildConfigFileParser;
import org.aspectj.ajde.internal.LstBuildConfigFileUpdater;
import org.aspectj.ajde.ui.BuildConfigModel;
import org.aspectj.ajde.ui.BuildConfigNode;
import org.aspectj.ajdt.ajc.ConfigParser;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.util.FileUtil;

public class LstBuildConfigManager
implements BuildConfigManager {
    private List<String> allBuildConfigFiles;
    private List<BuildConfigListener> listeners = new ArrayList<BuildConfigListener>();
    private LstBuildConfigFileUpdater fileUpdater = new LstBuildConfigFileUpdater();
    protected String currConfigFilePath = null;
    private static final FilenameFilter SOURCE_FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return FileUtil.hasSourceSuffix(name) || name.endsWith(".lst");
        }
    };
    private static final FileFilter DIR_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    private static final Comparator<BuildConfigNode> ALPHABETICAL_COMPARATOR = new Comparator<BuildConfigNode>(){

        @Override
        public int compare(BuildConfigNode n1, BuildConfigNode n2) {
            return n1.getName().compareTo(n2.getName());
        }
    };

    @Override
    public BuildConfigModel buildModel(String configFilePath) {
        File configFile = new File(configFilePath);
        String rootPath = configFile.getParent();
        String configFileName = configFile.getName();
        BuildConfigModel model = new BuildConfigModel(configFilePath);
        ArrayList<File> configFiles = new ArrayList();
        List<Object> importedFiles = new ArrayList();
        List<String> badEntries = null;
        try {
            LstBuildConfigFileParser configParser = new LstBuildConfigFileParser(configFilePath);
            configParser.parseConfigFile(new File(configFilePath));
            configFiles = configParser.getFiles();
            importedFiles = configParser.getImportedFiles();
            badEntries = configParser.getProblemEntries();
        }
        catch (ConfigParser.ParseException pe) {
            Message message = new Message(pe.getMessage(), IMessage.ERROR, pe, new SourceLocation(pe.getFile(), pe.getLine(), 1));
            Ajde.getDefault().getMessageHandler().handleMessage(message);
        }
        List<String> relativePaths = this.relativizeFilePaths(configFiles, rootPath);
        BuildConfigNode root = new BuildConfigNode(configFileName, BuildConfigNode.Kind.FILE_LST, rootPath);
        this.buildDirTree(root, rootPath, importedFiles, configFileName);
        model.setRoot(root);
        this.addFilesToDirTree(model, relativePaths, badEntries);
        this.pruneEmptyDirs(root);
        this.sortModel(model.getRoot(), ALPHABETICAL_COMPARATOR);
        this.addProblemEntries(root, badEntries);
        return model;
    }

    private void addProblemEntries(BuildConfigNode root, List<String> badEntries) {
        for (String string : badEntries) {
            root.addChild(new BuildConfigNode(string.toString(), BuildConfigNode.Kind.ERROR, null));
        }
    }

    @Override
    public void writeModel(BuildConfigModel model) {
        List<BuildConfigNode> activeSourceFiles = model.getActiveNodes(BuildConfigNode.Kind.FILE_ASPECTJ);
        activeSourceFiles.addAll(model.getActiveNodes(BuildConfigNode.Kind.FILE_JAVA));
        List<BuildConfigNode> activeImportedFiles = model.getActiveNodes(BuildConfigNode.Kind.FILE_LST);
        this.fileUpdater.writeConfigFile(model.getSourceFile(), activeSourceFiles, activeImportedFiles);
    }

    @Override
    public void writePaths(String configFilePath, List<String> files) {
        this.fileUpdater.writeConfigFile(configFilePath, files);
    }

    @Override
    public void addFilesToConfig(String configFilePath, List paths) {
    }

    @Override
    public void removeFilesFromConfig(String configFilePath, List files) {
    }

    private List<String> relativizeFilePaths(List<File> configFiles, String rootPath) {
        ArrayList<String> relativePathsList = new ArrayList<String>();
        for (File file : configFiles) {
            relativePathsList.add(this.fileUpdater.relativizePath(file.getPath(), rootPath));
        }
        return relativePathsList;
    }

    private void buildDirTree(BuildConfigNode node, String rootPath, List importedFiles, String configFileName) {
        File[] dirs = new File(node.getResourcePath()).listFiles(DIR_FILTER);
        if (dirs == null) {
            return;
        }
        for (File dir2 : dirs) {
            File[] files;
            BuildConfigNode dir = new BuildConfigNode(dir2.getName(), BuildConfigNode.Kind.DIRECTORY, dir2.getPath());
            for (File file2 : files = dir2.listFiles(SOURCE_FILE_FILTER)) {
                if (file2 == null) continue;
                String filePath = this.fileUpdater.relativizePath(file2.getPath(), rootPath);
                BuildConfigNode.Kind kind = BuildConfigNode.Kind.FILE_JAVA;
                if (file2.getName().endsWith(".lst")) continue;
                BuildConfigNode file = new BuildConfigNode(file2.getName(), kind, filePath);
                file.setActive(false);
                dir.addChild(file);
            }
            node.addChild(dir);
            for (File importedFile : importedFiles) {
                if (!importedFile.getParentFile().getAbsolutePath().equals(dir2.getAbsolutePath())) continue;
                BuildConfigNode importedFileNode = new BuildConfigNode(importedFile.getName(), BuildConfigNode.Kind.FILE_LST, this.fileUpdater.relativizePath(importedFile.getPath(), rootPath));
                importedFileNode.setActive(true);
                boolean found = false;
                for (BuildConfigNode buildConfigNode : dir.getChildren()) {
                    if (!buildConfigNode.getName().equals(importedFile.getName())) continue;
                    found = true;
                }
                if (found) continue;
                dir.addChild(importedFileNode);
            }
            this.buildDirTree(dir, rootPath, importedFiles, configFileName);
        }
        if (node.getName().endsWith(".lst")) {
            File[] files = new File(rootPath).listFiles(SOURCE_FILE_FILTER);
            if (files == null) {
                return;
            }
            for (File file2 : files) {
                if (file2 == null || file2.getName().equals(configFileName)) continue;
                BuildConfigNode.Kind kind = BuildConfigNode.Kind.FILE_JAVA;
                if (file2.getName().endsWith(".lst")) {
                    kind = BuildConfigNode.Kind.FILE_LST;
                }
                BuildConfigNode file = new BuildConfigNode(file2.getName(), kind, file2.getName());
                file.setActive(false);
                node.addChild(file);
            }
        }
    }

    private void addFilesToDirTree(BuildConfigModel model, List configFiles, List badEntries) {
        for (String path : configFiles) {
            if (path.startsWith("..")) {
                File file = new File(path);
                BuildConfigNode node = new BuildConfigNode(file.getName(), BuildConfigNode.Kind.FILE_JAVA, path);
                BuildConfigNode upPath = model.getNodeForPath(file.getParentFile().getPath());
                if (upPath == model.getRoot()) {
                    upPath = new BuildConfigNode(file.getParentFile().getPath(), BuildConfigNode.Kind.DIRECTORY, file.getParentFile().getAbsolutePath());
                    model.getRoot().addChild(upPath);
                }
                node.setActive(true);
                upPath.addChild(node);
                continue;
            }
            if (!new File(path).isAbsolute()) {
                BuildConfigNode existingNode = model.getNodeForPath(path);
                existingNode.setActive(true);
                continue;
            }
            badEntries.add("Use relative paths only, omitting: " + path);
        }
    }

    private boolean pruneEmptyDirs(BuildConfigNode node) {
        ArrayList<BuildConfigNode> nodesToRemove = new ArrayList<BuildConfigNode>();
        for (BuildConfigNode currNode : node.getChildren()) {
            boolean hasValidChildren = this.pruneEmptyDirs(currNode);
            if (currNode.isValidResource() || hasValidChildren) continue;
            nodesToRemove.add(currNode);
        }
        for (BuildConfigNode currNode : nodesToRemove) {
            node.removeChild(currNode);
        }
        return node.getChildren().size() > 0;
    }

    @Override
    public String getActiveConfigFile() {
        return this.currConfigFilePath;
    }

    @Override
    public void setActiveConfigFile(String currConfigFilePath) {
        if (currConfigFilePath == null) {
            return;
        }
        this.currConfigFilePath = currConfigFilePath;
        this.notifyConfigChanged();
    }

    @Override
    public void addListener(BuildConfigListener configurationListener) {
        this.listeners.add(configurationListener);
    }

    @Override
    public void removeListener(BuildConfigListener configurationListener) {
        this.listeners.remove(configurationListener);
    }

    private void notifyConfigChanged() {
        for (BuildConfigListener element : this.listeners) {
            element.currConfigChanged(this.currConfigFilePath);
        }
    }

    private void sortModel(BuildConfigNode node, Comparator<BuildConfigNode> comparator) {
        if (node == null || node.getChildren() == null) {
            return;
        }
        Collections.sort(node.getChildren(), comparator);
        for (BuildConfigNode nextNode : node.getChildren()) {
            if (nextNode == null) continue;
            this.sortModel(nextNode, comparator);
        }
    }

    @Override
    public List<String> getAllBuildConfigFiles() {
        if (this.allBuildConfigFiles == null) {
            this.allBuildConfigFiles = new ArrayList<String>();
            if (this.getActiveConfigFile() != null) {
                this.allBuildConfigFiles.add(this.getActiveConfigFile());
            }
        }
        return this.allBuildConfigFiles;
    }
}

