/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.validator;

import jakarta.mail.Address;
import jakarta.mail.MessagingException;
import jakarta.mail.Part;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.cert.jcajce.JcaCertStoreBuilder;
import org.bouncycastle.cert.jcajce.JcaX500NameUtil;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.cms.jcajce.JcaX509CertSelectorConverter;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.bouncycastle.mail.smime.validator.SignedMailValidatorException;
import org.bouncycastle.pkix.jcajce.CertPathReviewerException;
import org.bouncycastle.pkix.jcajce.PKIXCertPathReviewer;
import org.bouncycastle.pkix.util.ErrorBundle;
import org.bouncycastle.pkix.util.filter.TrustedInput;
import org.bouncycastle.pkix.util.filter.UntrustedInput;
import org.bouncycastle.util.Integers;

public class SignedMailValidator {
    private static final String RESOURCE_NAME = "org.bouncycastle.mail.smime.validator.SignedMailValidatorMessages";
    private static final Class DEFAULT_CERT_PATH_REVIEWER = PKIXCertPathReviewer.class;
    private static final int shortKeyLength = 512;
    private static final long THIRTY_YEARS_IN_MILLI_SEC = 946728000000L;
    private static final JcaX509CertSelectorConverter SELECTOR_CONVERTER = new JcaX509CertSelectorConverter();
    private static final int KU_DIGITAL_SIGNATURE = 0;
    private static final int KU_NON_REPUDIATION = 1;
    private static final Locale locale = Locale.getDefault();
    private CertStore certs;
    private SignerInformationStore signers;
    private Map results;
    private String[] fromAddresses;
    private Class certPathReviewerClass;

    public SignedMailValidator(MimeMessage message, PKIXParameters param) throws SignedMailValidatorException {
        this(message, param, DEFAULT_CERT_PATH_REVIEWER);
    }

    public SignedMailValidator(MimeMessage message, PKIXParameters param, Class certPathReviewerClass) throws SignedMailValidatorException {
        this.certPathReviewerClass = certPathReviewerClass;
        boolean isSubclass = DEFAULT_CERT_PATH_REVIEWER.isAssignableFrom(certPathReviewerClass);
        if (!isSubclass) {
            throw new IllegalArgumentException("certPathReviewerClass is not a subclass of " + DEFAULT_CERT_PATH_REVIEWER.getName());
        }
        try {
            SMIMESigned s;
            if (message.isMimeType("multipart/signed")) {
                MimeMultipart mimemp = (MimeMultipart)message.getContent();
                s = new SMIMESigned(mimemp);
            } else if (message.isMimeType("application/pkcs7-mime") || message.isMimeType("application/x-pkcs7-mime")) {
                s = new SMIMESigned((Part)message);
            } else {
                ErrorBundle msg = SignedMailValidator.createErrorBundle("SignedMailValidator.noSignedMessage");
                throw new SignedMailValidatorException(msg);
            }
            this.certs = new JcaCertStoreBuilder().addCertificates(s.getCertificates()).addCRLs(s.getCRLs()).setProvider("BC").build();
            this.signers = s.getSignerInfos();
            Address[] froms = message.getFrom();
            InternetAddress sender = null;
            try {
                if (message.getHeader("Sender") != null) {
                    sender = new InternetAddress(message.getHeader("Sender")[0]);
                }
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
            int fromsLength = froms != null ? froms.length : 0;
            this.fromAddresses = new String[fromsLength + (sender != null ? 1 : 0)];
            for (int i = 0; i < fromsLength; ++i) {
                InternetAddress inetAddr = (InternetAddress)froms[i];
                this.fromAddresses[i] = inetAddr.getAddress();
            }
            if (sender != null) {
                this.fromAddresses[fromsLength] = sender.getAddress();
            }
            this.results = new HashMap();
        }
        catch (Exception e) {
            if (e instanceof SignedMailValidatorException) {
                throw (SignedMailValidatorException)((Object)e);
            }
            ErrorBundle msg = SignedMailValidator.createErrorBundle("SignedMailValidator.exceptionReadingMessage", e);
            throw new SignedMailValidatorException(msg, e);
        }
        this.validateSignatures(param);
    }

    protected void validateSignatures(PKIXParameters pkixParam) {
        JcaSimpleSignerInfoVerifierBuilder signerInfoVerifierBuilder = new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC");
        this.validateSignatures(signerInfoVerifierBuilder, pkixParam);
    }

    protected void validateSignatures(JcaSimpleSignerInfoVerifierBuilder signerInfoVerifierBuilder, PKIXParameters pkixParam) {
        PKIXParameters usedParameters = (PKIXParameters)pkixParam.clone();
        usedParameters.addCertStore(this.certs);
        Collection c = this.signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            ErrorBundle msg;
            Date signTime;
            ErrorBundle msg2;
            Attribute attr;
            boolean validSignature;
            ArrayList<ErrorBundle> errors = new ArrayList<ErrorBundle>();
            ArrayList<ErrorBundle> notifications = new ArrayList<ErrorBundle>();
            SignerInformation signer = (SignerInformation)it.next();
            X509Certificate signerCert = null;
            try {
                X509CertSelector selector = SELECTOR_CONVERTER.getCertSelector(signer.getSID());
                signerCert = SignedMailValidator.findFirstCert(usedParameters.getCertStores(), selector, null);
            }
            catch (CertStoreException cse) {
                ErrorBundle msg3 = SignedMailValidator.createErrorBundle("SignedMailValidator.exceptionRetrievingSignerCert", cse);
                errors.add(msg3);
            }
            if (signerCert == null) {
                ErrorBundle msg4 = SignedMailValidator.createErrorBundle("SignedMailValidator.noSignerCert");
                errors.add(msg4);
                this.results.put(signer, new ValidationResult(null, false, errors, notifications, null));
                continue;
            }
            try {
                SignerInformationVerifier verifier = signerInfoVerifierBuilder.build(signerCert.getPublicKey());
                validSignature = SignedMailValidator.isValidSignature(verifier, signer, errors);
            }
            catch (Exception e) {
                validSignature = false;
                ErrorBundle msg5 = SignedMailValidator.createErrorBundle("SignedMailValidator.exceptionVerifyingSignature", e);
                errors.add(msg5);
            }
            this.checkSignerCert(signerCert, errors, notifications);
            AttributeTable atab = signer.getSignedAttributes();
            if (atab != null && (attr = atab.get(PKCSObjectIdentifiers.id_aa_receiptRequest)) != null) {
                msg2 = SignedMailValidator.createErrorBundle("SignedMailValidator.signedReceiptRequest");
                notifications.add(msg2);
            }
            if ((signTime = SignedMailValidator.getSignatureTime(signer)) == null) {
                msg2 = SignedMailValidator.createErrorBundle("SignedMailValidator.noSigningTime");
                notifications.add(msg2);
                signTime = pkixParam.getDate();
                if (signTime == null) {
                    signTime = new Date();
                }
            } else {
                try {
                    signerCert.checkValidity(signTime);
                }
                catch (CertificateExpiredException e) {
                    msg = SignedMailValidator.createErrorBundle("SignedMailValidator.certExpired", new Object[]{new TrustedInput((Object)signTime), new TrustedInput((Object)signerCert.getNotAfter())});
                    errors.add(msg);
                }
                catch (CertificateNotYetValidException e) {
                    msg = SignedMailValidator.createErrorBundle("SignedMailValidator.certNotYetValid", new Object[]{new TrustedInput((Object)signTime), new TrustedInput((Object)signerCert.getNotBefore())});
                    errors.add(msg);
                }
            }
            usedParameters.setDate(signTime);
            try {
                PKIXCertPathReviewer review;
                ArrayList<CertStore> userCertStores = new ArrayList<CertStore>();
                userCertStores.add(this.certs);
                Object[] cpres = SignedMailValidator.createCertPath(signerCert, usedParameters.getTrustAnchors(), pkixParam.getCertStores(), userCertStores);
                CertPath certPath = (CertPath)cpres[0];
                List userProvidedList = (List)cpres[1];
                try {
                    review = (PKIXCertPathReviewer)this.certPathReviewerClass.newInstance();
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Cannot instantiate object of type " + this.certPathReviewerClass.getName() + ": " + e.getMessage());
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException("Cannot instantiate object of type " + this.certPathReviewerClass.getName() + ": " + e.getMessage());
                }
                review.init(certPath, usedParameters);
                if (!review.isValidCertPath()) {
                    ErrorBundle msg6 = SignedMailValidator.createErrorBundle("SignedMailValidator.certPathInvalid");
                    errors.add(msg6);
                }
                this.results.put(signer, new ValidationResult(review, validSignature, errors, notifications, userProvidedList));
            }
            catch (GeneralSecurityException gse) {
                msg = SignedMailValidator.createErrorBundle("SignedMailValidator.exceptionCreateCertPath", gse);
                errors.add(msg);
                this.results.put(signer, new ValidationResult(null, validSignature, errors, notifications, null));
            }
            catch (CertPathReviewerException cpre) {
                errors.add(cpre.getErrorMessage());
                this.results.put(signer, new ValidationResult(null, validSignature, errors, notifications, null));
            }
        }
    }

    public static Set getEmailAddresses(X509Certificate cert) throws IOException, CertificateEncodingException {
        HashSet<String> addresses = new HashSet<String>();
        RDN[] rdns = JcaX500NameUtil.getSubject((X509Certificate)cert).getRDNs(PKCSObjectIdentifiers.pkcs_9_at_emailAddress);
        for (int i = 0; i < rdns.length; ++i) {
            AttributeTypeAndValue[] atVs = rdns[i].getTypesAndValues();
            for (int j = 0; j != atVs.length; ++j) {
                if (!PKCSObjectIdentifiers.pkcs_9_at_emailAddress.equals((ASN1Primitive)atVs[j].getType())) continue;
                String email = ((ASN1String)atVs[j].getValue()).getString().toLowerCase(locale);
                addresses.add(email);
            }
        }
        byte[] sanExtValue = cert.getExtensionValue(Extension.subjectAlternativeName.getId());
        if (sanExtValue != null) {
            GeneralNames san = GeneralNames.getInstance((Object)JcaX509ExtensionUtils.parseExtensionValue((byte[])sanExtValue));
            GeneralName[] names = san.getNames();
            for (int i = 0; i < names.length; ++i) {
                GeneralName name = names[i];
                if (name.getTagNo() != 1) continue;
                String email = ASN1IA5String.getInstance((Object)name.getName()).getString().toLowerCase(locale);
                addresses.add(email);
            }
        }
        return addresses;
    }

    protected void checkSignerCert(X509Certificate cert, List errors, List notifications) {
        ErrorBundle msg;
        boolean[] keyUsage;
        long validityPeriod;
        PublicKey key = cert.getPublicKey();
        int keyLength = -1;
        if (key instanceof RSAPublicKey) {
            keyLength = ((RSAPublicKey)key).getModulus().bitLength();
        } else if (key instanceof DSAPublicKey) {
            keyLength = ((DSAPublicKey)key).getParams().getP().bitLength();
        }
        if (keyLength != -1 && keyLength <= 512) {
            ErrorBundle msg2 = SignedMailValidator.createErrorBundle("SignedMailValidator.shortSigningKey", new Object[]{Integers.valueOf((int)keyLength)});
            notifications.add(msg2);
        }
        if ((validityPeriod = cert.getNotAfter().getTime() - cert.getNotBefore().getTime()) > 946728000000L) {
            ErrorBundle msg3 = SignedMailValidator.createErrorBundle("SignedMailValidator.longValidity", new Object[]{new TrustedInput((Object)cert.getNotBefore()), new TrustedInput((Object)cert.getNotAfter())});
            notifications.add(msg3);
        }
        if (!SignedMailValidator.supportsKeyUsage(keyUsage = cert.getKeyUsage(), 0) && !SignedMailValidator.supportsKeyUsage(keyUsage, 1)) {
            ErrorBundle msg4 = SignedMailValidator.createErrorBundle("SignedMailValidator.signingNotPermitted");
            errors.add(msg4);
        }
        try {
            ExtendedKeyUsage eku;
            byte[] ekuExtValue = cert.getExtensionValue(Extension.extendedKeyUsage.getId());
            if (ekuExtValue != null && !(eku = ExtendedKeyUsage.getInstance((Object)JcaX509ExtensionUtils.parseExtensionValue((byte[])ekuExtValue))).hasKeyPurposeId(KeyPurposeId.anyExtendedKeyUsage) && !eku.hasKeyPurposeId(KeyPurposeId.id_kp_emailProtection)) {
                ErrorBundle msg5 = SignedMailValidator.createErrorBundle("SignedMailValidator.extKeyUsageNotPermitted");
                errors.add(msg5);
            }
        }
        catch (Exception e) {
            msg = SignedMailValidator.createErrorBundle("SignedMailValidator.extKeyUsageError", e);
            errors.add(msg);
        }
        try {
            Set certEmails = SignedMailValidator.getEmailAddresses(cert);
            if (certEmails.isEmpty()) {
                msg = SignedMailValidator.createErrorBundle("SignedMailValidator.noEmailInCert");
                errors.add(msg);
            } else if (!SignedMailValidator.hasAnyFromAddress(certEmails, this.fromAddresses)) {
                msg = SignedMailValidator.createErrorBundle("SignedMailValidator.emailFromCertMismatch", new Object[]{new UntrustedInput((Object)SignedMailValidator.addressesToString(this.fromAddresses)), new UntrustedInput((Object)certEmails)});
                errors.add(msg);
            }
        }
        catch (Exception e) {
            msg = SignedMailValidator.createErrorBundle("SignedMailValidator.certGetEmailError", e);
            errors.add(msg);
        }
    }

    static boolean hasAnyFromAddress(Set certEmails, String[] fromAddresses) {
        for (int i = 0; i < fromAddresses.length; ++i) {
            if (!certEmails.contains(fromAddresses[i].toLowerCase(locale))) continue;
            return true;
        }
        return false;
    }

    static String addressesToString(Object[] a) {
        if (a == null) {
            return "null";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = 0; i != a.length; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(String.valueOf(a[i]));
        }
        return b.append(']').toString();
    }

    public static Date getSignatureTime(SignerInformation signer) {
        Attribute attr;
        AttributeTable atab = signer.getSignedAttributes();
        if (atab != null && (attr = atab.get(CMSAttributes.signingTime)) != null) {
            Time t = Time.getInstance((Object)attr.getAttrValues().getObjectAt(0));
            return t.getDate();
        }
        return null;
    }

    public static CertPath createCertPath(X509Certificate signerCert, Set trustanchors, List certStores) throws GeneralSecurityException {
        Object[] results = SignedMailValidator.createCertPath(signerCert, trustanchors, certStores, null);
        return (CertPath)results[0];
    }

    public static Object[] createCertPath(X509Certificate signerCert, Set trustAnchors, List systemCertStores, List userCertStores) throws GeneralSecurityException {
        if (signerCert == null) {
            throw new NullPointerException("'signerCert' cannot be null");
        }
        LinkedHashSet<X509Certificate> certSet = new LinkedHashSet<X509Certificate>();
        ArrayList<Boolean> userProvidedList = new ArrayList<Boolean>();
        X509Certificate cert = signerCert;
        boolean certIsSystemProvided = false;
        X509Certificate providedCert = SignedMailValidator.getProvidedCert(trustAnchors, systemCertStores, signerCert);
        if (providedCert != null) {
            cert = providedCert;
            certIsSystemProvided = true;
        }
        TrustAnchor trustAnchor = null;
        do {
            certSet.add(cert);
            userProvidedList.add(!certIsSystemProvided);
            trustAnchor = SignedMailValidator.findTrustAnchorForCert(cert, trustAnchors);
            if (trustAnchor != null) break;
            X509CertSelector issuerSelector = SignedMailValidator.createIssuerSelector(cert);
            boolean bl = certIsSystemProvided = (cert = SignedMailValidator.findFirstCert(systemCertStores, issuerSelector, certSet)) != null;
            if (cert != null || userCertStores == null) continue;
            cert = SignedMailValidator.findFirstCert(userCertStores, issuerSelector, certSet);
        } while (cert != null);
        if (trustAnchor != null) {
            X509Certificate trustedCert = trustAnchor.getTrustedCert();
            if (trustedCert != null && trustedCert.getSubjectX500Principal().equals(trustedCert.getIssuerX500Principal())) {
                if (certSet.add(trustedCert)) {
                    userProvidedList.add(Boolean.FALSE);
                }
            } else {
                X509CertSelector taSelector = new X509CertSelector();
                byte[] certIssuerEncoding = cert.getIssuerX500Principal().getEncoded();
                try {
                    taSelector.setSubject(certIssuerEncoding);
                    taSelector.setIssuer(certIssuerEncoding);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.toString());
                }
                cert = SignedMailValidator.findFirstCert(systemCertStores, taSelector, certSet);
                boolean bl = certIsSystemProvided = cert != null;
                if (cert == null && userCertStores != null) {
                    cert = SignedMailValidator.findFirstCert(userCertStores, taSelector, certSet);
                }
                if (cert != null) {
                    try {
                        cert.verify(cert.getPublicKey(), "BC");
                        certSet.add(cert);
                        userProvidedList.add(!certIsSystemProvided);
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        // empty catch block
                    }
                }
            }
        }
        CertPath certPath = CertificateFactory.getInstance("X.509", "BC").generateCertPath(new ArrayList(certSet));
        return new Object[]{certPath, userProvidedList};
    }

    public CertStore getCertsAndCRLs() {
        return this.certs;
    }

    public SignerInformationStore getSignerInformationStore() {
        return this.signers;
    }

    public ValidationResult getValidationResult(SignerInformation signer) throws SignedMailValidatorException {
        if (this.signers.getSigners(signer.getSID()).isEmpty()) {
            ErrorBundle msg = SignedMailValidator.createErrorBundle("SignedMailValidator.wrongSigner");
            throw new SignedMailValidatorException(msg);
        }
        return (ValidationResult)this.results.get(signer);
    }

    private static ErrorBundle createErrorBundle(String id) {
        ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, id);
        msg.setClassLoader(SignedMailValidator.class.getClassLoader());
        return msg;
    }

    private static ErrorBundle createErrorBundle(String id, Object[] arguments) {
        ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, id, arguments);
        msg.setClassLoader(SignedMailValidator.class.getClassLoader());
        return msg;
    }

    private static ErrorBundle createErrorBundle(String id, Exception e) {
        return SignedMailValidator.createErrorBundle(id, new Object[]{e.getMessage(), e, e.getClass().getName()});
    }

    private static X509CertSelector createIssuerSelector(X509Certificate cert) {
        X509CertSelector selector = new X509CertSelector();
        try {
            selector.setSubject(cert.getIssuerX500Principal().getEncoded());
        }
        catch (IOException e) {
            throw new IllegalStateException(e.toString());
        }
        byte[] akiExtValue = cert.getExtensionValue(Extension.authorityKeyIdentifier.getId());
        if (akiExtValue != null) {
            try {
                AuthorityKeyIdentifier aki = AuthorityKeyIdentifier.getInstance((Object)JcaX509ExtensionUtils.parseExtensionValue((byte[])akiExtValue));
                ASN1OctetString keyIdentifier = aki.getKeyIdentifierObject();
                if (keyIdentifier != null) {
                    selector.setSubjectKeyIdentifier(keyIdentifier.getEncoded("DER"));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return selector;
    }

    private static X509Certificate findFirstCert(List certStores, X509CertSelector selector, Set ignoreCerts) throws CertStoreException {
        X509CertSelector altSelector = null;
        for (CertStore certStore : certStores) {
            Collection<? extends Certificate> certs = certStore.getCertificates(selector);
            if (certs.isEmpty() && selector.getSubjectKeyIdentifier() != null) {
                if (altSelector == null) {
                    altSelector = (X509CertSelector)selector.clone();
                    altSelector.setSubjectKeyIdentifier(null);
                }
                certs = certStore.getCertificates(altSelector);
            }
            for (X509Certificate x509Certificate : certs) {
                if (ignoreCerts != null && ignoreCerts.contains(x509Certificate)) continue;
                return x509Certificate;
            }
        }
        return null;
    }

    private static TrustAnchor findTrustAnchorForCert(X509Certificate cert, Set trustAnchors) {
        Iterator trustAnchorIter = trustAnchors.iterator();
        if (trustAnchorIter.hasNext()) {
            X500Principal certIssuer = cert.getIssuerX500Principal();
            do {
                TrustAnchor trustAnchor = (TrustAnchor)trustAnchorIter.next();
                try {
                    X509Certificate taCert = trustAnchor.getTrustedCert();
                    if (taCert != null) {
                        if (certIssuer.equals(taCert.getSubjectX500Principal())) {
                            cert.verify(taCert.getPublicKey(), "BC");
                            return trustAnchor;
                        }
                    } else if (certIssuer.getName().equals(trustAnchor.getCAName())) {
                        cert.verify(trustAnchor.getCAPublicKey(), "BC");
                        return trustAnchor;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (trustAnchorIter.hasNext());
        }
        return null;
    }

    private static X509Certificate getProvidedCert(Set trustAnchors, List certStores, X509Certificate cert) throws CertStoreException {
        for (TrustAnchor trustAnchor : trustAnchors) {
            X509Certificate taCert = trustAnchor.getTrustedCert();
            if (taCert == null || !taCert.equals(cert)) continue;
            return taCert;
        }
        X509CertSelector selector = new X509CertSelector();
        selector.setCertificate(cert);
        return SignedMailValidator.findFirstCert(certStores, selector, null);
    }

    private static boolean isValidSignature(SignerInformationVerifier verifier, SignerInformation signer, List errors) {
        boolean validSignature = false;
        try {
            validSignature = signer.verify(verifier);
            if (!validSignature) {
                ErrorBundle msg = SignedMailValidator.createErrorBundle("SignedMailValidator.signatureNotVerified");
                errors.add(msg);
            }
        }
        catch (Exception e) {
            ErrorBundle msg = SignedMailValidator.createErrorBundle("SignedMailValidator.exceptionVerifyingSignature", e);
            errors.add(msg);
        }
        return validSignature;
    }

    private static boolean supportsKeyUsage(boolean[] ku, int kuBit) {
        return null == ku || ku.length > kuBit && ku[kuBit];
    }

    public static class ValidationResult {
        private PKIXCertPathReviewer review;
        private List errors;
        private List notifications;
        private List userProvidedCerts;
        private boolean signVerified;

        ValidationResult(PKIXCertPathReviewer review, boolean verified, List errors, List notifications, List userProvidedCerts) {
            this.review = review;
            this.errors = errors;
            this.notifications = notifications;
            this.signVerified = verified;
            this.userProvidedCerts = userProvidedCerts;
        }

        public List getErrors() {
            return this.errors;
        }

        public List getNotifications() {
            return this.notifications;
        }

        public PKIXCertPathReviewer getCertPathReview() {
            return this.review;
        }

        public CertPath getCertPath() {
            return this.review != null ? this.review.getCertPath() : null;
        }

        public List getUserProvidedCerts() {
            return this.userProvidedCerts;
        }

        public boolean isVerifiedSignature() {
            return this.signVerified;
        }

        public boolean isValidSignature() {
            return this.review != null && this.signVerified && this.review.isValidCertPath() && this.errors.isEmpty();
        }
    }
}

