/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.detector.suffixtree;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.detector.ContainsInComparator;
import org.sonar.duplications.detector.suffixtree.Search;
import org.sonar.duplications.detector.suffixtree.TextSet;
import org.sonar.duplications.index.CloneGroup;
import org.sonar.duplications.index.ClonePart;
import org.sonar.duplications.utils.SortedListsUtils;

public class DuplicationsCollector
extends Search.Collector {
    private final TextSet text;
    private final String originResourceId;
    private final List<CloneGroup> filtered = Lists.newArrayList();
    private int length;
    private int count;
    private int[][] blockNumbers;

    public DuplicationsCollector(TextSet text) {
        this.text = text;
        this.originResourceId = text.getBlock(0).getResourceId();
    }

    public List<CloneGroup> getResult() {
        return this.filtered;
    }

    @Override
    public void startOfGroup(int size, int length) {
        this.blockNumbers = new int[size][2];
        this.length = length;
    }

    @Override
    public void part(int start, int end) {
        this.blockNumbers[this.count][0] = start;
        this.blockNumbers[this.count][1] = end - 1;
        ++this.count;
    }

    @Override
    public void endOfGroup() {
        ClonePart origin = null;
        CloneGroup.Builder builder = CloneGroup.builder().setLength(this.length);
        ArrayList parts = Lists.newArrayListWithCapacity((int)this.count);
        for (int[] b : this.blockNumbers) {
            Block firstBlock = this.text.getBlock(b[0]);
            Block lastBlock = this.text.getBlock(b[1]);
            ClonePart part = new ClonePart(firstBlock.getResourceId(), firstBlock.getIndexInFile(), firstBlock.getStartLine(), lastBlock.getEndLine());
            if (this.originResourceId.equals(part.getResourceId())) {
                if (origin == null) {
                    origin = part;
                    builder.setLengthInUnits(lastBlock.getEndUnit() - firstBlock.getStartUnit() + 1);
                } else if (part.getUnitStart() < origin.getUnitStart()) {
                    origin = part;
                }
            }
            parts.add(part);
        }
        Collections.sort(parts, ContainsInComparator.CLONEPART_COMPARATOR);
        builder.setOrigin(origin).setParts(parts);
        this.filter(builder.build());
        this.reset();
    }

    private void reset() {
        this.blockNumbers = null;
        this.count = 0;
    }

    private void filter(CloneGroup current) {
        for (CloneGroup earlier : this.filtered) {
            if (!DuplicationsCollector.containsIn(current, earlier)) continue;
            return;
        }
        this.filtered.add(current);
    }

    private static boolean containsIn(CloneGroup first, CloneGroup second) {
        List<ClonePart> firstParts = first.getCloneParts();
        List<ClonePart> secondParts = second.getCloneParts();
        return SortedListsUtils.contains(secondParts, firstParts, new ContainsInComparator(second.getCloneUnitLength(), first.getCloneUnitLength())) && SortedListsUtils.contains(firstParts, secondParts, ContainsInComparator.RESOURCE_ID_COMPARATOR);
    }
}

