/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreRangeQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.compass.core.Property;
import org.compass.core.engine.SearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.all.AllBoostingTermQuery;
import org.compass.core.lucene.engine.queryparser.QueryParserUtils;
import org.compass.core.lucene.search.ConstantScorePrefixQuery;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.ResourcePropertyLookup;

public class CompassQueryParser
extends QueryParser {
    private static final KeywordAnalyzer KEYWORD_ANALYZER = new KeywordAnalyzer();
    protected final CompassMapping mapping;
    protected final LuceneSearchEngineFactory searchEngineFactory;
    private boolean allowConstantScorePrefixQuery;
    private boolean addAliasQueryWithDotPath = true;
    private boolean forceAnalyzer;
    protected boolean suggestedQuery = false;

    public CompassQueryParser(String f, Analyzer a, CompassMapping mapping, SearchEngineFactory searchEngineFactory, boolean forceAnalyzer) {
        super(f, a);
        this.mapping = mapping;
        this.searchEngineFactory = (LuceneSearchEngineFactory)searchEngineFactory;
        this.forceAnalyzer = forceAnalyzer;
    }

    public void setAllowConstantScorePrefixQuery(boolean allowConstantScorePrefixQuery) {
        this.allowConstantScorePrefixQuery = allowConstantScorePrefixQuery;
    }

    public void setAddAliasQueryWithDotPath(boolean addAliasQueryWithDotPath) {
        this.addAliasQueryWithDotPath = addAliasQueryWithDotPath;
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        ResourcePropertyLookup lookup = null;
        if (field != null) {
            lookup = this.mapping.getResourcePropertyLookup(field);
            lookup.setConvertOnlyWithDotPath(false);
            field = lookup.getPath();
        }
        return QueryParserUtils.andAliasQueryIfNeeded(super.getWildcardQuery(field, termStr), lookup, this.addAliasQueryWithDotPath, this.searchEngineFactory);
    }

    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        ResourcePropertyLookup lookup = null;
        if (field != null) {
            lookup = this.mapping.getResourcePropertyLookup(field);
            lookup.setConvertOnlyWithDotPath(false);
            field = lookup.getPath();
        }
        return QueryParserUtils.andAliasQueryIfNeeded(super.getFuzzyQuery(field, termStr, minSimilarity), lookup, this.addAliasQueryWithDotPath, this.searchEngineFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Query getFieldQuery(String field, String queryText) throws ParseException {
        if (field == null) {
            return super.getFieldQuery(field, queryText);
        }
        if (this.searchEngineFactory.getAliasProperty().equals(field)) {
            return QueryParserUtils.createPolyAliasQuery(this.searchEngineFactory, queryText);
        }
        ResourcePropertyLookup lookup = this.mapping.getResourcePropertyLookup(field);
        lookup.setConvertOnlyWithDotPath(false);
        if (lookup.hasSpecificConverter()) {
            queryText = lookup.attemptNormalizeString(queryText);
        }
        Analyzer origAnalyzer = this.analyzer;
        if (!this.forceAnalyzer) {
            String analyzerName = lookup.getAnalyzer();
            if (analyzerName != null) {
                this.analyzer = this.searchEngineFactory.getAnalyzerManager().getAnalyzerMustExist(analyzerName);
            } else if (lookup.getResourcePropertyMapping() != null && lookup.getResourcePropertyMapping().getIndex() == Property.Index.UN_TOKENIZED) {
                this.analyzer = KEYWORD_ANALYZER;
            }
        }
        try {
            Query query = QueryParserUtils.andAliasQueryIfNeeded(this.getInternalFieldQuery(lookup.getPath(), queryText), lookup, this.addAliasQueryWithDotPath, this.searchEngineFactory);
            return query;
        }
        finally {
            if (origAnalyzer != null) {
                this.analyzer = origAnalyzer;
            }
        }
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean inclusive) throws ParseException {
        if (this.getLowercaseExpandedTerms()) {
            part1 = part1.toLowerCase();
            part2 = part2.toLowerCase();
        }
        ResourcePropertyLookup lookup = this.mapping.getResourcePropertyLookup(field);
        lookup.setConvertOnlyWithDotPath(false);
        if (lookup.hasSpecificConverter()) {
            part1 = "*".equals(part1) ? null : lookup.attemptNormalizeString(part1);
            part2 = "*".equals(part2) ? null : lookup.attemptNormalizeString(part2);
        } else {
            if ("*".equals(part1)) {
                part1 = null;
            }
            if ("*".equals(part2)) {
                part2 = null;
            }
        }
        return QueryParserUtils.andAliasQueryIfNeeded((Query)new ConstantScoreRangeQuery(lookup.getPath(), part1, part2, inclusive, inclusive), lookup, this.addAliasQueryWithDotPath, this.searchEngineFactory);
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        ResourcePropertyLookup lookup = this.mapping.getResourcePropertyLookup(field);
        lookup.setConvertOnlyWithDotPath(false);
        if (!this.allowConstantScorePrefixQuery) {
            return super.getPrefixQuery(lookup.getPath(), termStr);
        }
        if (this.getLowercaseExpandedTerms()) {
            termStr = termStr.toLowerCase();
        }
        Term t = new Term(lookup.getPath(), termStr);
        return QueryParserUtils.andAliasQueryIfNeeded(new ConstantScorePrefixQuery(t), lookup, this.addAliasQueryWithDotPath, this.searchEngineFactory);
    }

    protected Query getInternalFieldQuery(String field, String queryText) throws ParseException {
        Token t;
        boolean boostAll = false;
        if (this.searchEngineFactory.getLuceneSettings().isAllPropertyBoostSupport() && field.equals(this.searchEngineFactory.getLuceneSettings().getAllProperty())) {
            boostAll = true;
        }
        TokenStream source = this.analyzer.tokenStream(field, (Reader)new StringReader(queryText));
        Vector<Token> v = new Vector<Token>();
        int positionCount = 0;
        boolean severalTokensAtSamePosition = false;
        while (true) {
            try {
                t = source.next();
            }
            catch (IOException e) {
                t = null;
            }
            if (t == null) break;
            v.addElement(t);
            if (t.getPositionIncrement() != 0) {
                positionCount += t.getPositionIncrement();
                continue;
            }
            severalTokensAtSamePosition = true;
        }
        try {
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (v.size() == 0) {
            return null;
        }
        if (v.size() == 1) {
            t = (Token)v.elementAt(0);
            if (boostAll) {
                return new AllBoostingTermQuery(this.getTerm(field, t.termText()));
            }
            return new TermQuery(this.getTerm(field, t.termText()));
        }
        if (severalTokensAtSamePosition) {
            if (positionCount == 1) {
                BooleanQuery q = new BooleanQuery(true);
                for (int i = 0; i < v.size(); ++i) {
                    AllBoostingTermQuery currentQuery;
                    t = (Token)v.elementAt(i);
                    if (boostAll) {
                        currentQuery = new AllBoostingTermQuery(this.getTerm(field, t.termText()));
                        q.add((Query)currentQuery, BooleanClause.Occur.SHOULD);
                        continue;
                    }
                    currentQuery = new TermQuery(this.getTerm(field, t.termText()));
                    q.add((Query)currentQuery, BooleanClause.Occur.SHOULD);
                }
                return q;
            }
            MultiPhraseQuery mpq = new MultiPhraseQuery();
            mpq.setSlop(this.phraseSlop);
            ArrayList<Term> multiTerms = new ArrayList<Term>();
            int position = -1;
            for (int i = 0; i < v.size(); ++i) {
                t = (Token)v.elementAt(i);
                if (t.getPositionIncrement() > 0 && multiTerms.size() > 0) {
                    if (this.enablePositionIncrements) {
                        mpq.add(multiTerms.toArray(new Term[0]), position);
                    } else {
                        mpq.add(multiTerms.toArray(new Term[0]));
                    }
                    multiTerms.clear();
                }
                position += t.getPositionIncrement();
                multiTerms.add(this.getTerm(field, t.termText()));
            }
            if (this.enablePositionIncrements) {
                mpq.add(multiTerms.toArray(new Term[0]), position);
            } else {
                mpq.add(multiTerms.toArray(new Term[0]));
            }
            return mpq;
        }
        PhraseQuery pq = new PhraseQuery();
        pq.setSlop(this.phraseSlop);
        int position = -1;
        for (int i = 0; i < v.size(); ++i) {
            t = (Token)v.elementAt(i);
            if (this.enablePositionIncrements) {
                pq.add(this.getTerm(field, t.termText()), position += t.getPositionIncrement());
                continue;
            }
            pq.add(this.getTerm(field, t.termText()));
        }
        return pq;
    }

    protected Term getTerm(String field, String text) throws ParseException {
        return new Term(field, text);
    }

    public void close() {
    }

    public boolean isSuggestedQuery() {
        return this.suggestedQuery;
    }
}

