/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.TokenSources;
import org.compass.core.CompassHighlighter;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineHighlighter;
import org.compass.core.lucene.LuceneResource;
import org.compass.core.lucene.engine.LuceneDelegatedClose;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.analyzer.LuceneAnalyzerManager;
import org.compass.core.lucene.engine.highlighter.LuceneHighlighterManager;
import org.compass.core.lucene.engine.highlighter.LuceneHighlighterSettings;
import org.compass.core.lucene.engine.highlighter.support.TokenOrderingFilter;

public class LuceneSearchEngineHighlighter
implements SearchEngineHighlighter,
LuceneDelegatedClose {
    private IndexReader indexReader;
    private boolean closed;
    private Query query;
    private LuceneHighlighterSettings highlighterSettings;
    private LuceneAnalyzerManager analyzerManager;
    private LuceneHighlighterManager highlighterManager;
    private int maxNumFragments = -1;
    private Analyzer analyzer;
    private String separator;
    private int maxBytesToAnalyze = -1;
    private CompassHighlighter.TextTokenizer textTokenizer;

    public LuceneSearchEngineHighlighter(Query query, IndexReader indexReader, LuceneSearchEngine searchEngine) throws SearchEngineException {
        this.indexReader = indexReader;
        this.highlighterManager = searchEngine.getSearchEngineFactory().getHighlighterManager();
        this.highlighterSettings = this.highlighterManager.getDefaultHighlighterSettings();
        this.analyzerManager = searchEngine.getSearchEngineFactory().getAnalyzerManager();
        if (this.highlighterSettings.isRewriteQuery()) {
            try {
                this.query = query.rewrite(indexReader);
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to rewrite query [" + query + "] for highlighter", e);
            }
        }
        this.clear();
    }

    public SearchEngineHighlighter clear() {
        this.analyzer = this.analyzerManager.getDefaultAnalyzer();
        this.maxNumFragments = -1;
        this.separator = null;
        this.maxBytesToAnalyze = -1;
        return this;
    }

    public SearchEngineHighlighter setMaxNumFragments(int maxNumFragments) throws SearchEngineException {
        this.maxNumFragments = maxNumFragments;
        return this;
    }

    public SearchEngineHighlighter setMaxBytesToAnalyze(int maxBytesToAnalyze) throws SearchEngineException {
        this.maxBytesToAnalyze = maxBytesToAnalyze;
        return this;
    }

    public SearchEngineHighlighter setAnalyzer(String analyzerName) throws SearchEngineException {
        this.analyzer = this.analyzerManager.getAnalyzerMustExist(analyzerName);
        return this;
    }

    public SearchEngineHighlighter setAnalyzer(Resource resource) throws SearchEngineException {
        this.analyzer = this.analyzerManager.getAnalyzerByResource(resource);
        return this;
    }

    public SearchEngineHighlighter setHighlighter(String highlighterName) throws SearchEngineException {
        this.highlighterSettings = this.highlighterManager.getHighlighterSettingsMustExists(highlighterName);
        return this;
    }

    public SearchEngineHighlighter setSeparator(String separator) throws SearchEngineException {
        this.separator = separator;
        return this;
    }

    public SearchEngineHighlighter setTextTokenizer(CompassHighlighter.TextTokenizer textTokenizer) throws SearchEngineException {
        this.textTokenizer = textTokenizer;
        return this;
    }

    public String fragment(Resource resource, String propertyName) throws SearchEngineException {
        return this.fragment(resource, propertyName, this.getTextFromResource(resource, propertyName));
    }

    public String fragment(Resource resource, String propertyName, String text) throws SearchEngineException {
        Highlighter highlighter = this.createHighlighter(propertyName);
        TokenStream tokenStream = this.createTokenStream(resource, propertyName, text);
        try {
            return highlighter.getBestFragment(tokenStream, text);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to highlight fragments for alias [" + resource.getAlias() + "] and property [" + propertyName + "]");
        }
    }

    public String[] fragments(Resource resource, String propertyName) throws SearchEngineException {
        return this.fragments(resource, propertyName, this.getTextFromResource(resource, propertyName));
    }

    public String[] fragments(Resource resource, String propertyName, String text) throws SearchEngineException {
        Highlighter highlighter = this.createHighlighter(propertyName);
        TokenStream tokenStream = this.createTokenStream(resource, propertyName, text);
        try {
            return highlighter.getBestFragments(tokenStream, text, this.getMaxNumFragments());
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to highlight fragments for alias [" + resource.getAlias() + "] and property [" + propertyName + "]");
        }
    }

    public String fragmentsWithSeparator(Resource resource, String propertyName) throws SearchEngineException {
        return this.fragmentsWithSeparator(resource, propertyName, this.getTextFromResource(resource, propertyName));
    }

    public String fragmentsWithSeparator(Resource resource, String propertyName, String text) throws SearchEngineException {
        Highlighter highlighter = this.createHighlighter(propertyName);
        TokenStream tokenStream = this.createTokenStream(resource, propertyName, text);
        try {
            String actualSeparator = this.getActualSeparator();
            return highlighter.getBestFragments(tokenStream, text, this.getMaxNumFragments(), actualSeparator);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to highlight fragments for alias [" + resource.getAlias() + "] and property [" + propertyName + "]");
        }
    }

    public String[] multiValueFragment(Resource resource, String propertyName) throws SearchEngineException {
        return this.multiValueFragment(resource, propertyName, this.getTextsFromResource(resource, propertyName));
    }

    public String[] multiValueFragment(Resource resource, String propertyName, String[] texts) throws SearchEngineException {
        ArrayList<String> fragmentList = new ArrayList<String>();
        Highlighter highlighter = this.createHighlighter(propertyName);
        for (int i = 0; i < texts.length; ++i) {
            String text = texts[i];
            if (text == null || text.length() <= 0) continue;
            TokenStream tokenStream = this.createTokenStreamFromAnalyzer(propertyName, text);
            try {
                String fragment = highlighter.getBestFragment(tokenStream, text);
                if (fragment == null || fragment.length() <= 0) continue;
                fragmentList.add(fragment);
                continue;
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to highlight fragments for alias [" + resource.getAlias() + "] and property [" + propertyName + "]");
            }
        }
        return fragmentList.toArray(new String[fragmentList.size()]);
    }

    public String multiValueFragmentWithSeparator(Resource resource, String propertyName) throws SearchEngineException {
        return this.multiValueFragmentWithSeparator(resource, propertyName, this.getTextsFromResource(resource, propertyName));
    }

    public String multiValueFragmentWithSeparator(Resource resource, String propertyName, String[] texts) throws SearchEngineException {
        String[] fragments = this.multiValueFragment(resource, propertyName, texts);
        String actualSeparator = this.getActualSeparator();
        StringBuffer fragment = new StringBuffer();
        if (fragments.length > 0) {
            for (int i = 0; i < fragments.length - 1; ++i) {
                fragment.append(fragments[i]);
                fragment.append(actualSeparator);
            }
            fragment.append(fragments[fragments.length - 1]);
        }
        return fragment.toString();
    }

    protected TokenStream createTokenStream(Resource resource, String propertyName, String text) throws SearchEngineException {
        CompassHighlighter.TextTokenizer actualTextTokenizer = this.highlighterSettings.getTextTokenizer();
        if (this.textTokenizer != null) {
            actualTextTokenizer = this.textTokenizer;
        }
        if (actualTextTokenizer == CompassHighlighter.TextTokenizer.AUTO) {
            TokenStream tokenStream = this.createTokenStreamFromTermPositions(resource, propertyName);
            if (tokenStream == null) {
                tokenStream = this.createTokenStreamFromAnalyzer(propertyName, text);
            }
            return tokenStream;
        }
        if (actualTextTokenizer == CompassHighlighter.TextTokenizer.ANALYZER) {
            return this.createTokenStreamFromAnalyzer(propertyName, text);
        }
        if (actualTextTokenizer == CompassHighlighter.TextTokenizer.TERM_VECTOR) {
            TokenStream tokenStream = this.createTokenStreamFromTermPositions(resource, propertyName);
            if (tokenStream == null) {
                throw new SearchEngineException("Highlighter configured/set to use term vector, but no term vector is available");
            }
            return tokenStream;
        }
        throw new SearchEngineException("No handling for text tokenizer [" + actualTextTokenizer + "]");
    }

    protected TokenStream createTokenStreamFromAnalyzer(String propertyName, String text) {
        Object tokenStream = this.analyzer.tokenStream(propertyName, (Reader)new StringReader(text));
        if (tokenStream == null) {
            tokenStream = new TokenOrderingFilter((TokenStream)tokenStream, 10);
        }
        return tokenStream;
    }

    protected TokenStream createTokenStreamFromTermPositions(Resource resource, String propertyName) throws SearchEngineException {
        TermFreqVector tfv;
        int docId = ((LuceneResource)resource).getDocNum();
        try {
            tfv = this.indexReader.getTermFreqVector(docId, propertyName);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to read term vector info", e);
        }
        if (tfv != null && tfv instanceof TermPositionVector) {
            return TokenSources.getTokenStream((TermPositionVector)((TermPositionVector)tfv));
        }
        return null;
    }

    protected Highlighter createHighlighter(String propertyName) throws SearchEngineException {
        Highlighter highlighter = new Highlighter(this.highlighterSettings.getFormatter(), this.highlighterSettings.getEncoder(), this.createScorer(propertyName));
        Fragmenter f = this.highlighterSettings.getFragmenter();
        highlighter.setTextFragmenter(f);
        if (this.maxBytesToAnalyze == -1) {
            highlighter.setMaxDocBytesToAnalyze(this.highlighterSettings.getMaxBytesToAnalyze());
        } else {
            highlighter.setMaxDocBytesToAnalyze(this.maxBytesToAnalyze);
        }
        return highlighter;
    }

    protected Scorer createScorer(String propertyName) throws SearchEngineException {
        if (this.highlighterSettings.isComputeIdf()) {
            if (propertyName == null) {
                throw new SearchEngineException("When using a formatter that requires idf or setting the [computeIdf] setting, a resource property name must be provided");
            }
            return new QueryScorer(this.query, this.indexReader, propertyName);
        }
        return new QueryScorer(this.query);
    }

    private String getTextFromResource(Resource resource, String propertyName) {
        String text = resource.getValue(propertyName);
        if (text == null) {
            throw new SearchEngineException("No text is stored for property [" + propertyName + "] and alias [" + resource.getAlias() + "]");
        }
        return text;
    }

    private String[] getTextsFromResource(Resource resource, String propertyName) {
        String[] texts = resource.getValues(propertyName);
        if (texts == null || texts.length == 0) {
            throw new SearchEngineException("No texts are stored for property [" + propertyName + "] and alias [" + resource.getAlias() + "]");
        }
        return texts;
    }

    private int getMaxNumFragments() {
        if (this.maxNumFragments == -1) {
            return this.highlighterSettings.getMaxNumFragments();
        }
        return this.maxNumFragments;
    }

    private String getActualSeparator() {
        String actualSeparator = this.separator;
        if (actualSeparator == null) {
            actualSeparator = this.highlighterSettings.getSeparator();
        }
        return actualSeparator;
    }

    public void close() throws SearchEngineException {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }
}

