/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.spellcheck;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LuceneSubIndexInfo;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.spell.CompassSpellChecker;
import org.apache.lucene.search.spell.HighFrequencyDictionary;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockObtainFailedException;
import org.compass.core.CompassException;
import org.compass.core.CompassQuery;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.spellcheck.SearchEngineSpellCheckSuggestBuilder;
import org.compass.core.impl.DefaultCompassQuery;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSearchEngineInternalSearch;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.engine.queryparser.QueryParserUtils;
import org.compass.core.lucene.engine.spellcheck.DefaultLuceneSearchEngineSpellCheckSuggestBuilder;
import org.compass.core.lucene.engine.spellcheck.InternalLuceneSearchEngineSpellCheckManager;
import org.compass.core.lucene.engine.spellcheck.SpellCheckerCallback;
import org.compass.core.lucene.engine.store.DefaultLuceneSearchEngineStore;
import org.compass.core.lucene.engine.store.LuceneSearchEngineStore;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.SpellCheckType;
import org.compass.core.transaction.InternalCompassTransaction;
import org.compass.core.transaction.context.TransactionContextCallback;
import org.compass.core.transaction.context.TransactionContextCallbackWithTr;
import org.compass.core.transaction.context.TransactionalRunnable;
import org.compass.core.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLuceneSpellCheckManager
implements InternalLuceneSearchEngineSpellCheckManager {
    public static String SPELL_CHECK_VERSION_FILENAME = "spellcheck.version";
    private static final Log log = LogFactory.getLog(DefaultLuceneSpellCheckManager.class);
    private LuceneSearchEngineFactory searchEngineFactory;
    private LuceneSearchEngineStore indexStore;
    private LuceneSearchEngineStore spellCheckStore;
    private String spellIndexSubContext = "spellcheck";
    private CompassSettings spellCheckSettings;
    private Map<String, IndexReader> readerMap = new HashMap<String, IndexReader>();
    private Map<String, IndexSearcher> searcherMap = new HashMap<String, IndexSearcher>();
    private Map<String, Object> indexLocks = new HashMap<String, Object>();
    private String defaultProperty;
    private Map<String, Set<String>> properties = new HashMap<String, Set<String>>();
    private float defaultAccuracy = 0.5f;
    private float defaultDictionaryThreshold;
    private volatile boolean started = false;
    private boolean closeStore;
    private ScheduledFuture refreshCacheFuture;
    private ScheduledFuture rebuildFuture;

    @Override
    public void configure(LuceneSearchEngineFactory searchEngineFactory, CompassSettings settings, CompassMapping mapping) {
        this.searchEngineFactory = searchEngineFactory;
        this.indexStore = searchEngineFactory.getLuceneIndexManager().getStore();
        this.spellCheckSettings = settings.copy();
        for (Object key1 : settings.getProperties().keySet()) {
            String key = (String)key1;
            String value = settings.getSetting(key);
            if (!key.startsWith("compass.engine.spellcheck.")) continue;
            key = "compass." + key.substring("compass.engine.spellcheck.".length());
            this.spellCheckSettings.setSetting(key, value);
        }
        this.spellCheckSettings.setIntSetting("compass.engine.mergeFactor", this.spellCheckSettings.getSettingAsInt("compass.engine.mergeFactor", 3000));
        if (this.spellCheckSettings.getSetting("compass.engine.connection").equals(settings.getSetting("compass.engine.connection"))) {
            this.spellCheckStore = searchEngineFactory.getLuceneIndexManager().getStore();
            this.closeStore = false;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Spell index uses Compass store [" + this.spellCheckSettings.getSetting("compass.engine.connection") + "]"));
            }
        } else {
            this.spellCheckStore = new DefaultLuceneSearchEngineStore();
            this.spellCheckStore.configure(searchEngineFactory, this.spellCheckSettings, mapping);
            this.closeStore = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Spell index uses specialized store [" + this.spellCheckSettings.getSetting("compass.engine.connection") + "]"));
            }
        }
        String[] sharedProps = new String[]{};
        String sSharedProps = this.spellCheckSettings.getSetting("compass.engine.spellcheck.globablIncludeProperties");
        if (sSharedProps != null) {
            sharedProps = StringUtils.tokenizeToStringArray(sSharedProps, ",");
        }
        String[] sharedExcludeProps = new String[]{};
        String sSharedExcludeProps = this.spellCheckSettings.getSetting("compass.engine.spellcheck.globalExcludeProperties");
        if (sSharedExcludeProps != null) {
            sharedExcludeProps = StringUtils.tokenizeToStringArray(sSharedExcludeProps, ",");
        }
        for (String subIndex : this.indexStore.getSubIndexes()) {
            Set<String> subIndexProps = this.properties.get(subIndex);
            if (subIndexProps == null) {
                subIndexProps = new HashSet<String>();
                this.properties.put(subIndex, subIndexProps);
            }
            subIndexProps.addAll(Arrays.asList(sharedProps));
            for (String alias : this.spellCheckStore.getAliasesBySubIndex(subIndex)) {
                ResourceMapping resourceMapping = searchEngineFactory.getMapping().getMappingByAlias(alias);
                for (ResourcePropertyMapping resourcePropertyMapping : resourceMapping.getResourcePropertyMappings()) {
                    if (resourcePropertyMapping.isInternal()) continue;
                    if (resourceMapping.getSpellCheck() == SpellCheckType.INCLUDE && resourcePropertyMapping.getSpellCheck() != SpellCheckType.EXCLUDE) {
                        subIndexProps.add(resourcePropertyMapping.getPath().getPath());
                    }
                    if (resourceMapping.getSpellCheck() != SpellCheckType.EXCLUDE || resourcePropertyMapping.getSpellCheck() != SpellCheckType.INCLUDE) continue;
                    subIndexProps.add(resourcePropertyMapping.getPath().getPath());
                }
                if (resourceMapping.getAllMapping().getSpellCheck() == SpellCheckType.INCLUDE) {
                    subIndexProps.add(resourceMapping.getAllMapping().getProperty());
                }
                if (subIndexProps.size() != 0 || resourceMapping.getSpellCheck() != SpellCheckType.NA || resourceMapping.getAllMapping().getSpellCheck() == SpellCheckType.EXCLUDE) continue;
                subIndexProps.add(settings.getSetting("compass.property.all", "zzz-all"));
            }
            for (String excludeProperty : sharedExcludeProps) {
                subIndexProps.remove(excludeProperty);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Sub index [" + subIndex + "] includes the following properties " + subIndexProps));
        }
        this.defaultProperty = settings.getSetting("compass.engine.spellcheck.defaultProperty", settings.getSetting("compass.property.all", "zzz-all"));
        this.defaultAccuracy = this.spellCheckSettings.getSettingAsFloat("compass.engine.spellcheck.accuracy", 0.5f);
        this.defaultDictionaryThreshold = this.spellCheckSettings.getSettingAsFloat("compass.engine.spellcheck.dictionaryThreshold", 0.0f);
        for (String subIndex : this.indexStore.getSubIndexes()) {
            this.indexLocks.put(subIndex, new Object());
        }
    }

    @Override
    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        for (final String subIndex : this.indexStore.getSubIndexes()) {
            this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Object>(){

                @Override
                public Object doInTransaction() throws CompassException {
                    Directory dir = DefaultLuceneSpellCheckManager.this.spellCheckStore.openDirectory(DefaultLuceneSpellCheckManager.this.spellIndexSubContext, subIndex);
                    DefaultLuceneSpellCheckManager.this.close(subIndex);
                    try {
                        if (!IndexReader.indexExists((Directory)dir)) {
                            IndexWriter writer = new IndexWriter(dir, (Analyzer)new WhitespaceAnalyzer(), true);
                            writer.close();
                        }
                    }
                    catch (IOException e) {
                        throw new SearchEngineException("Failed to verify spell index for sub index [" + subIndex + "]", e);
                    }
                    DefaultLuceneSpellCheckManager.this.refresh(subIndex);
                    return null;
                }
            });
        }
        long cacheRefreshInterval = this.spellCheckSettings.getSettingAsLong("compass.engine.cacheIntervalInvalidation", 5000L);
        this.refreshCacheFuture = this.searchEngineFactory.getExecutorManager().scheduleWithFixedDelay(new TransactionalRunnable(this.searchEngineFactory.getTransactionContext(), new Runnable(){

            public void run() {
                DefaultLuceneSpellCheckManager.this.refresh();
            }
        }), cacheRefreshInterval, cacheRefreshInterval, TimeUnit.MILLISECONDS);
        if (this.spellCheckSettings.getSettingAsBoolean("compass.engine.spellcheck.schedule", true)) {
            this.rebuildFuture = this.searchEngineFactory.getExecutorManager().scheduleWithFixedDelay(new Runnable(){

                public void run() {
                    DefaultLuceneSpellCheckManager.this.rebuild();
                }
            }, this.spellCheckSettings.getSettingAsLong("compass.engine.spellcheck.scheduleInitialDelay", 10L), this.spellCheckSettings.getSettingAsLong("compass.engine.spellcheck.scheduleInterval", 10L) * 60L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        if (this.refreshCacheFuture != null) {
            this.refreshCacheFuture.cancel(true);
        }
        if (this.rebuildFuture != null) {
            this.rebuildFuture.cancel(true);
        }
    }

    @Override
    public void close() {
        this.stop();
        for (String subIndex : this.indexStore.getSubIndexes()) {
            this.close(subIndex);
        }
        if (this.closeStore) {
            this.spellCheckStore.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(String subIndex) {
        Object object = this.indexLocks.get(subIndex);
        synchronized (object) {
            IndexReader reader;
            IndexSearcher searcher = this.searcherMap.remove(subIndex);
            if (searcher != null) {
                try {
                    searcher.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if ((reader = this.readerMap.remove(subIndex)) != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public String getDefaultProperty() {
        return this.defaultProperty;
    }

    @Override
    public float getDefaultAccuracy() {
        return this.defaultAccuracy;
    }

    @Override
    public CompassMapping getMapping() {
        return this.searchEngineFactory.getMapping();
    }

    @Override
    public void concurrentRefresh() throws SearchEngineException {
        this.checkIfStarted();
        ArrayList rebuildTasks = new ArrayList();
        for (String subIndex : this.indexStore.getSubIndexes()) {
            rebuildTasks.add(new RefreshTask(subIndex));
        }
        this.searchEngineFactory.getExecutorManager().invokeAllWithLimitBailOnException(rebuildTasks, Integer.MAX_VALUE);
    }

    @Override
    public void refresh() throws SearchEngineException {
        this.checkIfStarted();
        for (String subIndex : this.indexStore.getSubIndexes()) {
            this.refresh(subIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(String subIndex) throws SearchEngineException {
        this.checkIfStarted();
        Object object = this.indexLocks.get(subIndex);
        synchronized (object) {
            IndexReader reader = this.readerMap.get(subIndex);
            if (reader != null) {
                try {
                    if (reader.isCurrent()) {
                        return;
                    }
                }
                catch (IOException e) {
                    throw new SearchEngineException("Failed to check if spell index is current for sub index [" + subIndex + "]", e);
                }
            }
            try {
                reader = IndexReader.open((Directory)this.spellCheckStore.openDirectory(this.spellIndexSubContext, subIndex));
                this.readerMap.put(subIndex, reader);
                this.searcherMap.put(subIndex, new IndexSearcher(reader));
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to open spell index searcher for sub index [" + subIndex + "]", e);
            }
        }
    }

    @Override
    public boolean isRebuildNeeded() throws SearchEngineException {
        this.checkIfStarted();
        boolean rebulidRequired = false;
        for (String subIndex : this.indexStore.getSubIndexes()) {
            rebulidRequired |= this.isRebuildNeeded(subIndex);
        }
        return rebulidRequired;
    }

    @Override
    public boolean isRebuildNeeded(final String subIndex) throws SearchEngineException {
        this.checkIfStarted();
        return this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Boolean>(){

            @Override
            public Boolean doInTransaction() throws CompassException {
                try {
                    long spellCheckVersion = DefaultLuceneSpellCheckManager.this.readSpellCheckIndexVersion(subIndex);
                    long indexVerion = LuceneSubIndexInfo.getIndexInfo(subIndex, DefaultLuceneSpellCheckManager.this.indexStore).version();
                    return indexVerion != spellCheckVersion;
                }
                catch (IOException e) {
                    throw new SearchEngineException("Failed to read index version for sub index [" + subIndex + "]");
                }
            }
        });
    }

    @Override
    public boolean concurrentRebuild() throws SearchEngineException {
        this.checkIfStarted();
        ArrayList rebuildTasks = new ArrayList();
        for (String subIndex : this.indexStore.getSubIndexes()) {
            rebuildTasks.add(new RebuildTask(subIndex));
        }
        List rebuildResults = this.searchEngineFactory.getExecutorManager().invokeAllWithLimitBailOnException(rebuildTasks, Integer.MAX_VALUE);
        boolean rebuilt = false;
        for (Future rebuildResult : rebuildResults) {
            try {
                rebuilt |= ((Boolean)rebuildResult.get()).booleanValue();
            }
            catch (Exception e) {}
        }
        return rebuilt;
    }

    @Override
    public boolean rebuild() throws SearchEngineException {
        this.checkIfStarted();
        boolean rebuilt = false;
        for (String subIndex : this.indexStore.getSubIndexes()) {
            rebuilt |= this.rebuild(subIndex);
        }
        return rebuilt;
    }

    @Override
    public synchronized boolean rebuild(final String subIndex) throws SearchEngineException {
        this.checkIfStarted();
        return this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallbackWithTr<Boolean>(){

            @Override
            public Boolean doInTransaction(InternalCompassTransaction tr) throws CompassException {
                CompassSpellChecker spellChecker;
                long indexVersion;
                long version = DefaultLuceneSpellCheckManager.this.readSpellCheckIndexVersion(subIndex);
                try {
                    indexVersion = LuceneSubIndexInfo.getIndexInfo(subIndex, DefaultLuceneSpellCheckManager.this.indexStore).version();
                }
                catch (IOException e) {
                    throw new SearchEngineException("Failed to read actual index version for sub index [" + subIndex + "]", e);
                }
                if (version == indexVersion) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("No need to rebuild spell check index, sub index [" + subIndex + "] has not changed"));
                    }
                    return false;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Rebuilding spell index for sub index [" + subIndex + "]"));
                }
                Directory dir = DefaultLuceneSpellCheckManager.this.spellCheckStore.openDirectory(DefaultLuceneSpellCheckManager.this.spellIndexSubContext, subIndex);
                try {
                    spellChecker = new CompassSpellChecker(dir, true);
                    spellChecker.clearIndex();
                }
                catch (IOException e) {
                    throw new SearchEngineException("Failed to create spell checker for sub index [" + subIndex + "]", e);
                }
                IndexWriter writer = null;
                try {
                    LuceneSearchEngineInternalSearch search = (LuceneSearchEngineInternalSearch)tr.getSearchEngine().internalSearch(new String[]{subIndex}, null);
                    if (search.getSearcher() != null) {
                        writer = DefaultLuceneSpellCheckManager.this.searchEngineFactory.getLuceneIndexManager().openIndexWriter(DefaultLuceneSpellCheckManager.this.spellCheckSettings, dir, true, true, null, (Analyzer)new WhitespaceAnalyzer());
                        for (String property : (Set)DefaultLuceneSpellCheckManager.this.properties.get(subIndex)) {
                            spellChecker.indexDictionary(writer, new HighFrequencyDictionary(search.getReader(), property, DefaultLuceneSpellCheckManager.this.defaultDictionaryThreshold));
                        }
                        writer.optimize();
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("No data found in sub index [" + subIndex + "], skipping building spell index"));
                    }
                }
                catch (LockObtainFailedException e) {
                    log.debug((Object)("Failed to obtain lock, assuming indexing of spell index is in process for sub index [" + subIndex + "]"));
                    Boolean bl = null;
                    return bl;
                }
                catch (IOException e) {
                    throw new SearchEngineException("Failed to index spell index for sub index [" + subIndex + "]", e);
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            log.warn((Object)("Failed to close specll check index writer for sub index [" + subIndex + "]"), (Throwable)e);
                        }
                    }
                }
                DefaultLuceneSpellCheckManager.this.closeAndRefresh(subIndex);
                DefaultLuceneSpellCheckManager.this.writeSpellCheckIndexVersion(subIndex, indexVersion);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Finished rebuilding spell index for sub index [" + subIndex + "]"));
                }
                return true;
            }
        });
    }

    @Override
    public void deleteIndex() throws SearchEngineException {
        for (String subIndex : this.indexStore.getSubIndexes()) {
            this.deleteIndex(subIndex);
        }
    }

    @Override
    public void deleteIndex(String subIndex) throws SearchEngineException {
        this.close(subIndex);
        this.spellCheckStore.deleteIndex(this.spellIndexSubContext, subIndex);
    }

    @Override
    public SearchEngineSpellCheckSuggestBuilder suggestBuilder(String word) {
        return new DefaultLuceneSearchEngineSpellCheckSuggestBuilder(word, this);
    }

    @Override
    public CompassQuery suggest(CompassQuery query) {
        DefaultCompassQuery defaultCompassQuery = (DefaultCompassQuery)query;
        LuceneSearchEngineQuery searchEngineQuery = (LuceneSearchEngineQuery)defaultCompassQuery.getSearchEngineQuery();
        final CompassSpellChecker spellChecker = this.createSpellChecker(searchEngineQuery.getSubIndexes(), searchEngineQuery.getAliases());
        if (spellChecker == null) {
            return query;
        }
        final AtomicBoolean suggestedQuery = new AtomicBoolean(false);
        try {
            Query replacedQ = QueryParserUtils.visit(searchEngineQuery.getQuery(), new QueryParserUtils.QueryTermVisitor(){

                public Term replaceTerm(Term term) throws SearchEngineException {
                    try {
                        if (spellChecker.exist(term.text())) {
                            return term;
                        }
                        String[] similarWords = spellChecker.suggestSimilar(term.text(), 1);
                        if (similarWords.length == 0) {
                            return term;
                        }
                        suggestedQuery.set(true);
                        return term.createTerm(similarWords[0]);
                    }
                    catch (IOException e) {
                        throw new SearchEngineException("Failed to suggest for query", e);
                    }
                }
            });
            if (!suggestedQuery.get()) {
                CompassQuery compassQuery = query;
                return compassQuery;
            }
            CompassQuery suggested = (CompassQuery)query.clone();
            LuceneSearchEngineQuery suggestedSEQ = (LuceneSearchEngineQuery)((DefaultCompassQuery)suggested).getSearchEngineQuery();
            suggestedSEQ.setQuery(replacedQ);
            suggestedSEQ.setSuggested(suggestedQuery.get());
            CompassQuery compassQuery = suggested;
            return compassQuery;
        }
        finally {
            spellChecker.close();
        }
    }

    @Override
    public <T> T execute(final String[] subIndexes, final String[] aliases, final SpellCheckerCallback<T> callback) {
        return this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallbackWithTr<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T doInTransaction(InternalCompassTransaction tr) throws CompassException {
                CompassSpellChecker spellChecker = DefaultLuceneSpellCheckManager.this.createSpellChecker(subIndexes, aliases);
                if (spellChecker == null) {
                    return callback.execute(null, null);
                }
                try {
                    LuceneSearchEngineInternalSearch search = (LuceneSearchEngineInternalSearch)tr.getSearchEngine().internalSearch(subIndexes, aliases);
                    Object t = callback.execute(spellChecker, search.getReader());
                    return t;
                }
                finally {
                    spellChecker.close();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompassSpellChecker createSpellChecker(String[] subIndexes, String[] aliases) {
        MultiSearcher searcher;
        String[] calcSubIndexes = this.indexStore.calcSubIndexes(subIndexes, aliases);
        ArrayList<IndexSearcher> searchers = new ArrayList<IndexSearcher>(calcSubIndexes.length);
        ArrayList<IndexReader> readers = new ArrayList<IndexReader>(calcSubIndexes.length);
        for (String subIndex : calcSubIndexes) {
            Object object = this.indexLocks.get(subIndex);
            synchronized (object) {
                IndexSearcher searcher2 = this.searcherMap.get(subIndex);
                if (searcher2 != null) {
                    searchers.add(searcher2);
                    readers.add(searcher2.getIndexReader());
                }
            }
        }
        if (searchers.isEmpty()) {
            return null;
        }
        try {
            searcher = new MultiSearcher(searchers.toArray(new Searchable[searchers.size()]));
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to open searcher for spell check", e);
        }
        MultiReader reader = new MultiReader(readers.toArray(new IndexReader[readers.size()]), false);
        return new CompassSpellChecker((Searcher)searcher, (IndexReader)reader);
    }

    private void writeSpellCheckIndexVersion(String subIndex, long version) {
        Directory dir = this.spellCheckStore.openDirectory(this.spellIndexSubContext, subIndex);
        try {
            if (dir.fileExists(SPELL_CHECK_VERSION_FILENAME)) {
                dir.deleteFile(SPELL_CHECK_VERSION_FILENAME);
            }
            IndexOutput indexOutput = dir.createOutput(SPELL_CHECK_VERSION_FILENAME);
            indexOutput.writeLong(version);
            indexOutput.close();
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to write spell check index version for sub index [" + subIndex + "]", e);
        }
    }

    private long readSpellCheckIndexVersion(String subIndex) {
        long l;
        Directory dir = this.spellCheckStore.openDirectory(this.spellIndexSubContext, subIndex);
        IndexInput input = null;
        try {
            if (!dir.fileExists(SPELL_CHECK_VERSION_FILENAME)) {
                long l2 = -1L;
                return l2;
            }
            input = dir.openInput(SPELL_CHECK_VERSION_FILENAME);
            l = input.readLong();
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to read spell check index version for sub index [" + subIndex + "]", e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {}
        }
        return l;
    }

    private void closeAndRefresh() {
        for (String subIndex : this.indexStore.getSubIndexes()) {
            this.closeAndRefresh(subIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndRefresh(String subIndex) {
        Object object = this.indexLocks.get(subIndex);
        synchronized (object) {
            this.close(subIndex);
            this.refresh(subIndex);
        }
    }

    private void checkIfStarted() throws IllegalStateException {
        if (!this.started) {
            throw new IllegalStateException("Spell check manager must be started to perform this operation");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RefreshTask
    implements Callable<Object> {
        private String subIndex;

        public RefreshTask(String subIndex) {
            this.subIndex = subIndex;
        }

        @Override
        public Object call() throws Exception {
            DefaultLuceneSpellCheckManager.this.refresh(this.subIndex);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RebuildTask
    implements Callable<Boolean> {
        private String subIndex;

        public RebuildTask(String subIndex) {
            this.subIndex = subIndex;
        }

        @Override
        public Boolean call() throws Exception {
            return DefaultLuceneSpellCheckManager.this.rebuild(this.subIndex);
        }
    }
}

