/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.store.localcache;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.store.localcache.LocalDirectoryCache;
import org.compass.core.lucene.util.LuceneUtils;

public class LocalDirectoryCacheManager
implements CompassConfigurable {
    private static final Log log = LogFactory.getLog(LocalDirectoryCacheManager.class);
    private boolean disableLocalCache = false;
    private Map<String, CompassSettings> subIndexLocalCacheGroups;
    private LuceneSearchEngineFactory searchEngineFactory;

    public LocalDirectoryCacheManager(LuceneSearchEngineFactory searchEngineFactory) {
        this.searchEngineFactory = searchEngineFactory;
    }

    public LuceneSearchEngineFactory getSearchEngineFactory() {
        return this.searchEngineFactory;
    }

    public void configure(CompassSettings settings) throws CompassException {
        this.disableLocalCache = settings.getSettingAsBoolean("compass.engine.disableLocalCache", false);
        this.subIndexLocalCacheGroups = settings.getSettingGroups("compass.engine.localCache");
        for (Map.Entry<String, CompassSettings> entry : this.subIndexLocalCacheGroups.entrySet()) {
            String connection = entry.getValue().getSetting("connection", "ram://");
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Local Cache for [" + entry.getKey() + "] configured with connection [" + connection + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Directory createLocalCache(String subContext, String subIndex, Directory dir) throws SearchEngineException {
        RAMDirectory localCacheDirectory;
        if (this.disableLocalCache) {
            return dir;
        }
        CompassSettings settings = this.subIndexLocalCacheGroups.get(subIndex);
        if (settings == null && (settings = this.subIndexLocalCacheGroups.get("__default__")) == null) {
            return dir;
        }
        String connection = settings.getSetting("connection", "ram://");
        if (connection.startsWith("ram://")) {
            localCacheDirectory = new RAMDirectory();
        } else {
            if (connection.startsWith("file://") || connection.startsWith("mmap://") || connection.indexOf("://") == -1) {
                String path = connection.indexOf("://") != -1 ? connection.substring("file://".length()) : connection;
                path = path + "/" + subContext + "/" + subIndex;
                File filePath = new File(path);
                LuceneUtils.deleteDir(filePath);
                if (!filePath.exists()) {
                    LocalDirectoryCacheManager localDirectoryCacheManager = this;
                    synchronized (localDirectoryCacheManager) {
                        boolean created = filePath.mkdirs();
                        if (!created) {
                            throw new SearchEngineException("Failed to create directory for local cache with path [" + path + "]");
                        }
                    }
                }
                try {
                    localCacheDirectory = FSDirectory.getDirectory((String)path, (LockFactory)new SingleInstanceLockFactory());
                }
                catch (IOException e) {
                    throw new SearchEngineException("Failed to create direcotry with path [" + path + "]", e);
                }
            }
            throw new SearchEngineException("Local cache does not supprt the following connection [" + connection + "]");
        }
        return new LocalDirectoryCache(subIndex, dir, (Directory)localCacheDirectory, this);
    }

    public void close() {
    }
}

