/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineHits;
import org.compass.core.engine.SearchEngineInternalSearch;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.lucene.engine.LuceneDelegatedClose;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineHits;
import org.compass.core.lucene.engine.LuceneSearchEngineInternalSearch;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.engine.analyzer.LuceneAnalyzerManager;
import org.compass.core.lucene.engine.manager.LuceneIndexHolder;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.transaction.LuceneSearchEngineTransaction;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.ResourceKey;

public abstract class AbstractTransaction
implements LuceneSearchEngineTransaction {
    protected LuceneSearchEngine searchEngine;
    protected LuceneSearchEngineIndexManager indexManager;
    protected CompassMapping mapping;
    protected LuceneAnalyzerManager analyzerManager;
    private ArrayList<LuceneDelegatedClose> delegateClose = new ArrayList();
    protected boolean dirty;

    public void configure(LuceneSearchEngine searchEngine) {
        this.searchEngine = searchEngine;
        this.indexManager = searchEngine.getSearchEngineFactory().getLuceneIndexManager();
        this.mapping = searchEngine.getSearchEngineFactory().getMapping();
        this.analyzerManager = searchEngine.getSearchEngineFactory().getAnalyzerManager();
    }

    public void begin() throws SearchEngineException {
        this.closeDelegateClosed();
        this.doBegin();
    }

    protected abstract void doBegin() throws SearchEngineException;

    public void rollback() throws SearchEngineException {
        this.closeDelegateClosed();
        this.doRollback();
    }

    protected abstract void doRollback() throws SearchEngineException;

    public void prepare() throws SearchEngineException {
        this.doPrepare();
    }

    protected abstract void doPrepare() throws SearchEngineException;

    public void commit(boolean onePhase) throws SearchEngineException {
        this.closeDelegateClosed();
        this.doCommit(onePhase);
    }

    protected abstract void doCommit(boolean var1) throws SearchEngineException;

    public SearchEngineHits find(SearchEngineQuery query) throws SearchEngineException {
        LuceneSearchEngineHits hits = this.doFind((LuceneSearchEngineQuery)query);
        this.delegateClose.add(hits);
        return hits;
    }

    protected abstract LuceneSearchEngineHits doFind(LuceneSearchEngineQuery var1) throws SearchEngineException;

    public SearchEngineInternalSearch internalSearch(String[] subIndexes, String[] aliases) throws SearchEngineException {
        LuceneSearchEngineInternalSearch internalSearch = this.doInternalSearch(subIndexes, aliases);
        this.delegateClose.add(internalSearch);
        return internalSearch;
    }

    protected LuceneSearchEngineInternalSearch doInternalSearch(String[] subIndexes, String[] aliases) throws SearchEngineException {
        ArrayList<LuceneIndexHolder> indexHoldersToClose = new ArrayList<LuceneIndexHolder>();
        try {
            String[] calcSubIndexes = this.indexManager.getStore().calcSubIndexes(subIndexes, aliases);
            ArrayList<IndexReader> readers = new ArrayList<IndexReader>(calcSubIndexes.length);
            LuceneIndexHolder lastNonEmptyIndexHolder = null;
            for (String subIndex : calcSubIndexes) {
                LuceneIndexHolder indexHolder = this.indexManager.openIndexHolderBySubIndex(subIndex);
                indexHoldersToClose.add(indexHolder);
                if (indexHolder.getIndexReader().numDocs() <= 0) continue;
                readers.add(indexHolder.getIndexReader());
                lastNonEmptyIndexHolder = indexHolder;
            }
            if (readers.size() == 0) {
                return new LuceneSearchEngineInternalSearch(null, null, null);
            }
            if (readers.size() == 1) {
                return new LuceneSearchEngineInternalSearch(lastNonEmptyIndexHolder, indexHoldersToClose);
            }
            MultiReader reader = new MultiReader(readers.toArray(new IndexReader[readers.size()]), false);
            return new LuceneSearchEngineInternalSearch((IndexReader)reader, (Searcher)new IndexSearcher((IndexReader)reader), indexHoldersToClose);
        }
        catch (Exception e) {
            for (LuceneIndexHolder indexHolder : indexHoldersToClose) {
                indexHolder.release();
            }
            throw new SearchEngineException("Failed to open Lucene reader/searcher", e);
        }
    }

    public void create(InternalResource resource, Analyzer analyzer) throws SearchEngineException {
        this.dirty = true;
        this.doCreate(resource, analyzer);
    }

    protected abstract void doCreate(InternalResource var1, Analyzer var2) throws SearchEngineException;

    public void delete(ResourceKey resourceKey) throws SearchEngineException {
        this.dirty = true;
        this.doDelete(resourceKey);
    }

    protected abstract void doDelete(ResourceKey var1) throws SearchEngineException;

    public void update(InternalResource resource, Analyzer analyzer) throws SearchEngineException {
        this.dirty = true;
        this.doUpdate(resource, analyzer);
    }

    protected void doUpdate(InternalResource resource, Analyzer analyzer) throws SearchEngineException {
        this.doDelete(resource.resourceKey());
        this.doCreate(resource, analyzer);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected void closeDelegateClosed() throws SearchEngineException {
        for (LuceneDelegatedClose delegatedClose : this.delegateClose) {
            try {
                delegatedClose.close();
            }
            catch (Exception exception) {}
        }
        this.delegateClose.clear();
    }

    protected ResourceMapping getResourceMapping(String alias) {
        return this.mapping.getRootMappingByAlias(alias);
    }

    protected Hits findByQuery(LuceneSearchEngineInternalSearch internalSearch, LuceneSearchEngineQuery searchEngineQuery, Filter filter) throws SearchEngineException {
        Hits hits;
        Query query = searchEngineQuery.getQuery();
        if (searchEngineQuery.isRewrite()) {
            try {
                query = query.rewrite(internalSearch.getReader());
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to rewrite query [" + query.toString() + "]", e);
            }
        }
        Sort sort = searchEngineQuery.getSort();
        try {
            hits = filter == null ? internalSearch.getSearcher().search(query, sort) : internalSearch.getSearcher().search(query, filter, sort);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to search with query [" + query + "]", e);
        }
        return hits;
    }
}

