/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer;

import java.io.File;
import java.io.FileOutputStream;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.enhancer.DataNucleusEnhancer;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.MetaDataManager;

public abstract class AbstractImplementationGenerator {
    protected final MetaDataManager metaDataMgr;
    protected final AbstractClassMetaData inputCmd;
    protected final String className;
    protected final String fullClassName;
    protected String fullSuperclassName = "java.lang.Object";
    protected byte[] bytes;

    public AbstractImplementationGenerator(InterfaceMetaData interfaceMetaData, String implClassName, MetaDataManager mmgr) {
        this.className = implClassName;
        this.fullClassName = interfaceMetaData.getPackageName() + '.' + this.className;
        this.inputCmd = interfaceMetaData;
        this.metaDataMgr = mmgr;
    }

    public AbstractImplementationGenerator(ClassMetaData classMetaData, String implClassName, MetaDataManager mmgr) {
        this.className = implClassName;
        this.fullClassName = classMetaData.getPackageName() + '.' + this.className;
        this.inputCmd = classMetaData;
        this.metaDataMgr = mmgr;
    }

    public abstract void enhance(ClassLoaderResolver var1);

    public byte[] getBytes() {
        return this.bytes;
    }

    protected void createPropertyFields() {
        AbstractClassMetaData acmd = this.inputCmd;
        do {
            this.createPropertyFields(acmd);
        } while ((acmd = acmd.getSuperAbstractClassMetaData()) != null);
    }

    protected abstract void createPropertyFields(AbstractClassMetaData var1);

    protected void createPropertyMethods() {
        AbstractClassMetaData acmd = this.inputCmd;
        do {
            this.createPropertyMethods(acmd);
        } while ((acmd = acmd.getSuperAbstractClassMetaData()) != null);
    }

    protected void createPropertyMethods(AbstractClassMetaData acmd) {
        if (acmd == null) {
            return;
        }
        AbstractMemberMetaData[] memberMetaData = acmd.getManagedMembers();
        for (int i = 0; i < memberMetaData.length; ++i) {
            this.createGetter(memberMetaData[i]);
            this.createSetter(memberMetaData[i]);
        }
    }

    protected abstract void createGetter(AbstractMemberMetaData var1);

    protected abstract void createSetter(AbstractMemberMetaData var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpToFile(String filename) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File(filename));
            out.write(this.getBytes());
            DataNucleusEnhancer.LOGGER.info((Object)("Generated class for " + this.fullClassName + " dumped to " + filename));
        }
        catch (Exception e) {
            DataNucleusEnhancer.LOGGER.error((Object)"Failure to dump generated class to file", (Throwable)e);
        }
        finally {
            try {
                out.close();
                out = null;
            }
            catch (Exception exception) {}
        }
    }
}

