/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.ErrorMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongArrayAssert
extends ArrayAssert<LongArrayAssert, long[]> {
    protected LongArrayAssert(long ... actual) {
        super(LongArrayAssert.class, actual);
    }

    public LongArrayAssert contains(long ... values) {
        this.assertContains(ArrayInspection.copy(values));
        return this;
    }

    public LongArrayAssert containsOnly(long ... values) {
        this.assertContainsOnly(ArrayInspection.copy(values));
        return this;
    }

    public LongArrayAssert excludes(long ... values) {
        this.assertExcludes(ArrayInspection.copy(values));
        return this;
    }

    @Override
    public LongArrayAssert isEqualTo(long[] expected) {
        if (Arrays.equals((long[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    @Override
    public LongArrayAssert isNotEqualTo(long[] array) {
        if (!Arrays.equals((long[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }
}

