/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.openliberty;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class OpenLibertyUtils {
    private static final String SERVER_CONFIG_FILE_PATH = "src/main/liberty/config/server.xml";

    private OpenLibertyUtils() {
    }

    public static boolean isMicroProfileHealthEnabled(JavaProject javaProject) {
        return OpenLibertyUtils.hasAnyFeatureMatching(javaProject, "microProfile-") || OpenLibertyUtils.hasAnyFeatureMatching(javaProject, "mpHealth-");
    }

    public static boolean hasAnyFeatureMatching(JavaProject javaProject, String feature) {
        try {
            File serverXml = new File(javaProject.getBaseDirectory(), SERVER_CONFIG_FILE_PATH);
            Document serverConfig = XMLUtil.readXML((File)serverXml);
            return XMLUtil.evaluateExpressionForItem((Object)serverConfig, (String)String.format("/server/featureManager/feature[contains(text(),'%s')]", feature)).getLength() > 0;
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException exception) {
            return false;
        }
    }
}

