/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.director;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.tycho.core.resolver.shared.DependencySeed;

public final class Product {
    private String id;
    private String attachId;
    private String rootFolder;
    private Map<String, String> rootFolders;
    private String archiveFileName;
    private List<DependencySeed> extraInstallationSeeds;

    public Product() {
    }

    Product(String id) {
        this.id = id;
    }

    Product(String id, String attachId) {
        this.id = id;
        this.attachId = attachId;
    }

    public String getId() {
        return this.id;
    }

    public String getAttachId() {
        return this.attachId;
    }

    public String getRootFolder(String os) {
        String result = null;
        result = this.rootFolders == null ? this.rootFolder : (this.rootFolders.get(os) == null ? this.rootFolder : this.rootFolders.get(os));
        if ("macosx".equals(os)) {
            if (result == null) {
                result = "Eclipse.app";
            } else if (!result.endsWith(".app")) {
                result = result + ".app";
            }
        }
        return result;
    }

    public String getArchiveFileName() {
        return this.archiveFileName;
    }

    public void addInstallationSeed(DependencySeed seed) {
        if (this.extraInstallationSeeds == null) {
            this.extraInstallationSeeds = new ArrayList<DependencySeed>();
        }
        this.extraInstallationSeeds.add(seed);
    }

    public List<DependencySeed> getAdditionalInstallationSeeds() {
        if (this.extraInstallationSeeds == null) {
            return Collections.emptyList();
        }
        return this.extraInstallationSeeds;
    }

    public String toString() {
        return "Product [id=" + this.id + ", attachId=" + this.attachId + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attachId == null ? 0 : this.attachId.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.archiveFileName == null ? 0 : this.archiveFileName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Product) {
            Product other = (Product)obj;
            return this.equals(this.id, other.id) && this.equals(this.attachId, other.attachId) && this.equals(this.archiveFileName, other.archiveFileName);
        }
        return false;
    }

    private <T> boolean equals(T left, T right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        return left.equals(right);
    }
}

