/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot;

import java.util.Set;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.TypeLiteral;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.proxy.Proxy;

public final class Value {
    final Object receiver;
    final AbstractPolyglotImpl.AbstractValueImpl impl;

    Value(AbstractPolyglotImpl.AbstractValueImpl impl, Object value) {
        this.impl = impl;
        this.receiver = value;
    }

    public Value getMetaObject() {
        return this.impl.getMetaObject(this.receiver);
    }

    public boolean hasArrayElements() {
        return this.impl.hasArrayElements(this.receiver);
    }

    public Value getArrayElement(long index) {
        return this.impl.getArrayElement(this.receiver, index);
    }

    public void setArrayElement(long index, Object value) {
        this.impl.setArrayElement(this.receiver, index, value);
    }

    public boolean removeArrayElement(long index) {
        return this.impl.removeArrayElement(this.receiver, index);
    }

    public long getArraySize() {
        return this.impl.getArraySize(this.receiver);
    }

    public boolean hasMembers() {
        return this.impl.hasMembers(this.receiver);
    }

    public boolean hasMember(String identifier) {
        return this.impl.hasMember(this.receiver, identifier);
    }

    public Value getMember(String identifier) {
        return this.impl.getMember(this.receiver, identifier);
    }

    public Set<String> getMemberKeys() {
        return this.impl.getMemberKeys(this.receiver);
    }

    public void putMember(String identifier, Object value) {
        this.impl.putMember(this.receiver, identifier, value);
    }

    public boolean removeMember(String identifier) {
        return this.impl.removeMember(this.receiver, identifier);
    }

    public boolean canExecute() {
        return this.impl.canExecute(this.receiver);
    }

    public Value execute(Object ... arguments) {
        if (arguments.length == 0) {
            return this.impl.execute(this.receiver);
        }
        return this.impl.execute(this.receiver, arguments);
    }

    public void executeVoid(Object ... arguments) {
        if (arguments.length == 0) {
            this.impl.executeVoid(this.receiver);
        } else {
            this.impl.executeVoid(this.receiver, arguments);
        }
    }

    public boolean canInstantiate() {
        return this.impl.canInstantiate(this.receiver);
    }

    public Value newInstance(Object ... arguments) {
        return this.impl.newInstance(this.receiver, arguments);
    }

    public boolean isString() {
        return this.impl.isString(this.receiver);
    }

    public String asString() {
        return this.impl.asString(this.receiver);
    }

    public boolean fitsInInt() {
        return this.impl.fitsInInt(this.receiver);
    }

    public int asInt() {
        return this.impl.asInt(this.receiver);
    }

    public boolean isBoolean() {
        return this.impl.isBoolean(this.receiver);
    }

    public boolean asBoolean() {
        return this.impl.asBoolean(this.receiver);
    }

    public boolean isNumber() {
        return this.impl.isNumber(this.receiver);
    }

    public boolean fitsInLong() {
        return this.impl.fitsInLong(this.receiver);
    }

    public long asLong() {
        return this.impl.asLong(this.receiver);
    }

    public boolean fitsInDouble() {
        return this.impl.fitsInDouble(this.receiver);
    }

    public double asDouble() {
        return this.impl.asDouble(this.receiver);
    }

    public boolean fitsInFloat() {
        return this.impl.fitsInFloat(this.receiver);
    }

    public float asFloat() {
        return this.impl.asFloat(this.receiver);
    }

    public boolean fitsInByte() {
        return this.impl.fitsInByte(this.receiver);
    }

    public byte asByte() {
        return this.impl.asByte(this.receiver);
    }

    public boolean fitsInShort() {
        return this.impl.fitsInShort(this.receiver);
    }

    public short asShort() {
        return this.impl.asShort(this.receiver);
    }

    public boolean isNull() {
        return this.impl.isNull(this.receiver);
    }

    public boolean isNativePointer() {
        return this.impl.isNativePointer(this.receiver);
    }

    public long asNativePointer() {
        return this.impl.asNativePointer(this.receiver);
    }

    public boolean isHostObject() {
        return this.impl.isHostObject(this.receiver);
    }

    public <T> T asHostObject() {
        return (T)this.impl.asHostObject(this.receiver);
    }

    public boolean isProxyObject() {
        return this.impl.isProxyObject(this.receiver);
    }

    public <T extends Proxy> T asProxyObject() {
        return (T)((Proxy)this.impl.asProxyObject(this.receiver));
    }

    public <T> T as(Class<T> targetType) throws ClassCastException, IllegalStateException, PolyglotException {
        if (targetType == Value.class) {
            return targetType.cast(this);
        }
        return this.impl.as(this.receiver, targetType);
    }

    public <T> T as(TypeLiteral<T> targetType) {
        return this.impl.as(this.receiver, targetType);
    }

    public String toString() {
        return this.impl.toString(this.receiver);
    }
}

