// CheckStyle: start generated
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.runtime.BigInt;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link JSSubtractNode#doInt}
 *     Activation probability: 0.32000
 *     With/without class size: 7/0 bytes
 *   Specialization {@link JSSubtractNode#doDouble}
 *     Activation probability: 0.26000
 *     With/without class size: 7/0 bytes
 *   Specialization {@link JSSubtractNode#doBigInt}
 *     Activation probability: 0.20000
 *     With/without class size: 6/0 bytes
 *   Specialization {@link JSSubtractNode#doOverloaded}
 *     Activation probability: 0.14000
 *     With/without class size: 6/4 bytes
 *   Specialization {@link JSSubtractNode#doGeneric}
 *     Activation probability: 0.08000
 *     With/without class size: 6/13 bytes
 * </pre>
 */
@GeneratedBy(JSSubtractNode.class)
@SuppressWarnings("javadoc")
public final class JSSubtractNodeGen extends JSSubtractNode {

    private static final StateField GENERIC__J_S_SUBTRACT_NODE_GENERIC_STATE_0_UPDATER = StateField.create(GenericData.lookup_(), "generic_state_0_");
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSSubtractNode#doGeneric}
     *   Parameter: {@link InlinedBranchProfile} mixedNumericTypes
     *   Inline method: {@link InlinedBranchProfile#inline}</pre>
     */
    private static final InlinedBranchProfile INLINED_GENERIC_MIXED_NUMERIC_TYPES_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, GENERIC__J_S_SUBTRACT_NODE_GENERIC_STATE_0_UPDATER.subUpdater(0, 1)));

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link JSSubtractNode#doInt}
     *   1: SpecializationExcluded {@link JSSubtractNode#doInt}
     *   2: SpecializationActive {@link JSSubtractNode#doDouble}
     *   3: SpecializationActive {@link JSSubtractNode#doBigInt}
     *   4: SpecializationActive {@link JSSubtractNode#doGeneric}
     *   5: SpecializationActive {@link JSSubtractNode#doOverloaded}
     *   6-8: ImplicitCast[type=double, index=0]
     *   9-11: ImplicitCast[type=double, index=1]
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSSubtractNode#doOverloaded}
     *   Parameter: {@link JSOverloadedBinaryNode} overloadedOperatorNode</pre>
     */
    @Child private JSOverloadedBinaryNode overloaded_overloadedOperatorNode_;
    @Child private GenericData generic_cache;

    private JSSubtractNodeGen(boolean truncate, JavaScriptNode left, JavaScriptNode right) {
        super(truncate, left, right);
    }

    @Override
    public Object execute(Object leftNodeValue, Object rightNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b111101) != 0 /* is SpecializationActive[JSSubtractNode.doInt(int, int)] || SpecializationActive[JSSubtractNode.doDouble(double, double)] || SpecializationActive[JSSubtractNode.doBigInt(BigInt, BigInt)] || SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] || SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSSubtractNode.doInt(int, int)] */ && leftNodeValue instanceof Integer) {
                int leftNodeValue_ = (int) leftNodeValue;
                if (rightNodeValue instanceof Integer) {
                    int rightNodeValue_ = (int) rightNodeValue;
                    try {
                        return doInt(leftNodeValue_, rightNodeValue_);
                    } catch (ArithmeticException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[JSSubtractNode.doInt(int, int)] */;
                        state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                    }
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSSubtractNode.doDouble(double, double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue)) {
                double leftNodeValue_ = JSTypesGen.asImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue);
                if (JSTypesGen.isImplicitDouble((state_0 & 0b111000000000) >>> 9 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue)) {
                    double rightNodeValue_ = JSTypesGen.asImplicitDouble((state_0 & 0b111000000000) >>> 9 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue);
                    return doDouble(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSSubtractNode.doBigInt(BigInt, BigInt)] */ && leftNodeValue instanceof BigInt) {
                BigInt leftNodeValue_ = (BigInt) leftNodeValue;
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_ = (BigInt) rightNodeValue;
                    return doBigInt(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((state_0 & 0b110000) != 0 /* is SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] || SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */) {
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] */) {
                    {
                        JSOverloadedBinaryNode overloadedOperatorNode__ = this.overloaded_overloadedOperatorNode_;
                        if (overloadedOperatorNode__ != null) {
                            if ((hasOverloadedOperators(leftNodeValue) || hasOverloadedOperators(rightNodeValue))) {
                                return doOverloaded(leftNodeValue, rightNodeValue, overloadedOperatorNode__);
                            }
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */) {
                    GenericData s4_ = this.generic_cache;
                    if (s4_ != null) {
                        if ((!(hasOverloadedOperators(leftNodeValue))) && (!(hasOverloadedOperators(rightNodeValue)))) {
                            Node node__ = (s4_);
                            return JSSubtractNode.doGeneric(leftNodeValue, rightNodeValue, node__, s4_.toNumericA_, s4_.toNumericB_, s4_.subtract_, INLINED_GENERIC_MIXED_NUMERIC_TYPES_);
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue, rightNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b111100) == 0 /* only-active SpecializationActive[JSSubtractNode.doInt(int, int)] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSSubtractNode.doInt(int, int)] && SpecializationActive[JSSubtractNode.doDouble(double, double)] && SpecializationActive[JSSubtractNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */)) {
            return execute_int_int0(state_0, frameValue);
        } else if ((state_0 & 0b111001) == 0 /* only-active SpecializationActive[JSSubtractNode.doDouble(double, double)] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSSubtractNode.doInt(int, int)] && SpecializationActive[JSSubtractNode.doDouble(double, double)] && SpecializationActive[JSSubtractNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */)) {
            return execute_double_double1(state_0, frameValue);
        } else {
            return execute_generic2(state_0, frameValue);
        }
    }

    private Object execute_int_int0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int leftNodeValue_;
        try {
            leftNodeValue_ = super.leftNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_;
        try {
            rightNodeValue_ = super.rightNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert (state_0 & 0b1) != 0 /* is SpecializationActive[JSSubtractNode.doInt(int, int)] */;
        try {
            return doInt(leftNodeValue_, rightNodeValue_);
        } catch (ArithmeticException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            state_0 = this.state_0_;
            state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[JSSubtractNode.doInt(int, int)] */;
            state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
            this.state_0_ = state_0;
            return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }
    }

    private Object execute_double_double1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int leftNodeValue_int = 0;
        double leftNodeValue_;
        try {
            if ((state_0 & 0b110000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSSubtractNode.doInt(int, int)] && SpecializationActive[JSSubtractNode.doDouble(double, double)] && SpecializationActive[JSSubtractNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */)) {
                leftNodeValue_ = super.leftNode.executeDouble(frameValue);
            } else if ((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSSubtractNode.doInt(int, int)] && SpecializationActive[JSSubtractNode.doDouble(double, double)] && SpecializationActive[JSSubtractNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */)) {
                leftNodeValue_int = super.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else {
                Object leftNodeValue__ = super.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_int = 0;
        double rightNodeValue_;
        try {
            if ((state_0 & 0b110000000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSSubtractNode.doInt(int, int)] && SpecializationActive[JSSubtractNode.doDouble(double, double)] && SpecializationActive[JSSubtractNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */)) {
                rightNodeValue_ = super.rightNode.executeDouble(frameValue);
            } else if ((state_0 & 0b101000000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSSubtractNode.doInt(int, int)] && SpecializationActive[JSSubtractNode.doDouble(double, double)] && SpecializationActive[JSSubtractNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */)) {
                rightNodeValue_int = super.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else {
                Object rightNodeValue__ = super.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b111000000000) >>> 9 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSSubtractNode.doInt(int, int)] && SpecializationActive[JSSubtractNode.doDouble(double, double)] && SpecializationActive[JSSubtractNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */) ? (Object) leftNodeValue_int : (Object) leftNodeValue_), ex.getResult());
        }
        assert (state_0 & 0b100) != 0 /* is SpecializationActive[JSSubtractNode.doDouble(double, double)] */;
        return doDouble(leftNodeValue_, rightNodeValue_);
    }

    private Object execute_generic2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object leftNodeValue_ = super.leftNode.execute(frameValue);
        Object rightNodeValue_ = super.rightNode.execute(frameValue);
        if ((state_0 & 0b111101) != 0 /* is SpecializationActive[JSSubtractNode.doInt(int, int)] || SpecializationActive[JSSubtractNode.doDouble(double, double)] || SpecializationActive[JSSubtractNode.doBigInt(BigInt, BigInt)] || SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] || SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSSubtractNode.doInt(int, int)] */ && leftNodeValue_ instanceof Integer) {
                int leftNodeValue__ = (int) leftNodeValue_;
                if (rightNodeValue_ instanceof Integer) {
                    int rightNodeValue__ = (int) rightNodeValue_;
                    try {
                        return doInt(leftNodeValue__, rightNodeValue__);
                    } catch (ArithmeticException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[JSSubtractNode.doInt(int, int)] */;
                        state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        return executeAndSpecialize(leftNodeValue__, rightNodeValue__);
                    }
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSSubtractNode.doDouble(double, double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue_)) {
                double leftNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue_);
                if (JSTypesGen.isImplicitDouble((state_0 & 0b111000000000) >>> 9 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue_)) {
                    double rightNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0b111000000000) >>> 9 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue_);
                    return doDouble(leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSSubtractNode.doBigInt(BigInt, BigInt)] */ && leftNodeValue_ instanceof BigInt) {
                BigInt leftNodeValue__ = (BigInt) leftNodeValue_;
                if (rightNodeValue_ instanceof BigInt) {
                    BigInt rightNodeValue__ = (BigInt) rightNodeValue_;
                    return doBigInt(leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 0b110000) != 0 /* is SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] || SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */) {
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] */) {
                    {
                        JSOverloadedBinaryNode overloadedOperatorNode__ = this.overloaded_overloadedOperatorNode_;
                        if (overloadedOperatorNode__ != null) {
                            if ((hasOverloadedOperators(leftNodeValue_) || hasOverloadedOperators(rightNodeValue_))) {
                                return doOverloaded(leftNodeValue_, rightNodeValue_, overloadedOperatorNode__);
                            }
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */) {
                    GenericData s4_ = this.generic_cache;
                    if (s4_ != null) {
                        if ((!(hasOverloadedOperators(leftNodeValue_))) && (!(hasOverloadedOperators(rightNodeValue_)))) {
                            Node node__ = (s4_);
                            return JSSubtractNode.doGeneric(leftNodeValue_, rightNodeValue_, node__, s4_.toNumericA_, s4_.toNumericB_, s4_.subtract_, INLINED_GENERIC_MIXED_NUMERIC_TYPES_);
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110000) != 0 /* is SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] || SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */) {
            return JSTypesGen.expectDouble(execute(frameValue));
        }
        int leftNodeValue_int = 0;
        double leftNodeValue_;
        try {
            if ((state_0 & 0b110000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSSubtractNode.doInt(int, int)] && SpecializationActive[JSSubtractNode.doDouble(double, double)] && SpecializationActive[JSSubtractNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */)) {
                leftNodeValue_ = super.leftNode.executeDouble(frameValue);
            } else if ((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSSubtractNode.doInt(int, int)] && SpecializationActive[JSSubtractNode.doDouble(double, double)] && SpecializationActive[JSSubtractNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */)) {
                leftNodeValue_int = super.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else {
                Object leftNodeValue__ = super.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return JSTypesGen.expectDouble(executeAndSpecialize(ex.getResult(), rightNodeValue));
        }
        int rightNodeValue_int = 0;
        double rightNodeValue_;
        try {
            if ((state_0 & 0b110000000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSSubtractNode.doInt(int, int)] && SpecializationActive[JSSubtractNode.doDouble(double, double)] && SpecializationActive[JSSubtractNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */)) {
                rightNodeValue_ = super.rightNode.executeDouble(frameValue);
            } else if ((state_0 & 0b101000000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSSubtractNode.doInt(int, int)] && SpecializationActive[JSSubtractNode.doDouble(double, double)] && SpecializationActive[JSSubtractNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */)) {
                rightNodeValue_int = super.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else {
                Object rightNodeValue__ = super.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b111000000000) >>> 9 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectDouble(executeAndSpecialize(((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSSubtractNode.doInt(int, int)] && SpecializationActive[JSSubtractNode.doDouble(double, double)] && SpecializationActive[JSSubtractNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */) ? (Object) leftNodeValue_int : (Object) leftNodeValue_), ex.getResult()));
        }
        if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSSubtractNode.doDouble(double, double)] */) {
            return doDouble(leftNodeValue_, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(executeAndSpecialize(((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSSubtractNode.doInt(int, int)] && SpecializationActive[JSSubtractNode.doDouble(double, double)] && SpecializationActive[JSSubtractNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */) ? (Object) leftNodeValue_int : (Object) leftNodeValue_), ((state_0 & 0b101000000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSSubtractNode.doInt(int, int)] && SpecializationActive[JSSubtractNode.doDouble(double, double)] && SpecializationActive[JSSubtractNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */) ? (Object) rightNodeValue_int : (Object) rightNodeValue_)));
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110000) != 0 /* is SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] || SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */) {
            return JSTypesGen.expectInteger(execute(frameValue));
        }
        int leftNodeValue_;
        try {
            leftNodeValue_ = super.leftNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return JSTypesGen.expectInteger(executeAndSpecialize(ex.getResult(), rightNodeValue));
        }
        int rightNodeValue_;
        try {
            rightNodeValue_ = super.rightNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(executeAndSpecialize(leftNodeValue_, ex.getResult()));
        }
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSSubtractNode.doInt(int, int)] */) {
            try {
                return doInt(leftNodeValue_, rightNodeValue_);
            } catch (ArithmeticException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                state_0 = this.state_0_;
                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[JSSubtractNode.doInt(int, int)] */;
                state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                this.state_0_ = state_0;
                return JSTypesGen.expectInteger(executeAndSpecialize(leftNodeValue_, rightNodeValue_));
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(executeAndSpecialize(leftNodeValue_, rightNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        try {
            if ((state_0 & 0b111100) == 0 /* only-active SpecializationActive[JSSubtractNode.doInt(int, int)] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSSubtractNode.doInt(int, int)] && SpecializationActive[JSSubtractNode.doDouble(double, double)] && SpecializationActive[JSSubtractNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */)) {
                executeInt(frameValue);
                return;
            } else if ((state_0 & 0b111001) == 0 /* only-active SpecializationActive[JSSubtractNode.doDouble(double, double)] */ && ((state_0 & 0b111101) != 0  /* is-not SpecializationActive[JSSubtractNode.doInt(int, int)] && SpecializationActive[JSSubtractNode.doDouble(double, double)] && SpecializationActive[JSSubtractNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */)) {
                executeDouble(frameValue);
                return;
            }
            execute(frameValue);
            return;
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return;
        }
    }

    private Object executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        int state_0 = this.state_0_;
        if (((state_0 & 0b10100)) == 0 /* is-not SpecializationActive[JSSubtractNode.doDouble(double, double)] && SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */ && ((state_0 & 0b10)) == 0 /* is-not SpecializationExcluded  */ && leftNodeValue instanceof Integer) {
            int leftNodeValue_ = (int) leftNodeValue;
            if (rightNodeValue instanceof Integer) {
                int rightNodeValue_ = (int) rightNodeValue;
                state_0 = state_0 | 0b1 /* add SpecializationActive[JSSubtractNode.doInt(int, int)] */;
                this.state_0_ = state_0;
                try {
                    return doInt(leftNodeValue_, rightNodeValue_);
                } catch (ArithmeticException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[JSSubtractNode.doInt(int, int)] */;
                    state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                    this.state_0_ = state_0;
                    return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                }
            }
        }
        if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */) {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                double leftNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, leftNodeValue);
                int doubleCast1;
                if ((doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue)) != 0) {
                    double rightNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                    state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[JSSubtractNode.doInt(int, int)] */;
                    state_0 = (state_0 | (doubleCast0 << 6) /* set-int ImplicitCast[type=double, index=0] */);
                    state_0 = (state_0 | (doubleCast1 << 9) /* set-int ImplicitCast[type=double, index=1] */);
                    state_0 = state_0 | 0b100 /* add SpecializationActive[JSSubtractNode.doDouble(double, double)] */;
                    this.state_0_ = state_0;
                    return doDouble(leftNodeValue_, rightNodeValue_);
                }
            }
        }
        if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */ && leftNodeValue instanceof BigInt) {
            BigInt leftNodeValue_ = (BigInt) leftNodeValue;
            if (rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_ = (BigInt) rightNodeValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[JSSubtractNode.doBigInt(BigInt, BigInt)] */;
                this.state_0_ = state_0;
                return doBigInt(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((hasOverloadedOperators(leftNodeValue) || hasOverloadedOperators(rightNodeValue))) {
            JSOverloadedBinaryNode overloadedOperatorNode__ = this.insert((JSOverloadedBinaryNode.createNumeric(getOverloadedOperatorName())));
            Objects.requireNonNull(overloadedOperatorNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.overloaded_overloadedOperatorNode_ = overloadedOperatorNode__;
            state_0 = state_0 | 0b100000 /* add SpecializationActive[JSSubtractNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] */;
            this.state_0_ = state_0;
            return doOverloaded(leftNodeValue, rightNodeValue, overloadedOperatorNode__);
        }
        {
            Node node__ = null;
            if ((!(hasOverloadedOperators(leftNodeValue))) && (!(hasOverloadedOperators(rightNodeValue)))) {
                GenericData s4_ = this.insert(new GenericData());
                node__ = (s4_);
                JSToNumericNode toNumericA__ = s4_.insert((JSToNumericNode.create()));
                Objects.requireNonNull(toNumericA__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s4_.toNumericA_ = toNumericA__;
                JSToNumericNode toNumericB__ = s4_.insert((JSToNumericNode.create()));
                Objects.requireNonNull(toNumericB__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s4_.toNumericB_ = toNumericB__;
                s4_.subtract_ = s4_.insert((copyRecursive()));
                VarHandle.storeStoreFence();
                this.generic_cache = s4_;
                state_0 = state_0 & 0xfffffff2 /* remove SpecializationActive[JSSubtractNode.doInt(int, int)], SpecializationActive[JSSubtractNode.doDouble(double, double)], SpecializationActive[JSSubtractNode.doBigInt(BigInt, BigInt)] */;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[JSSubtractNode.doGeneric(Object, Object, Node, JSToNumericNode, JSToNumericNode, JavaScriptNode, InlinedBranchProfile)] */;
                this.state_0_ = state_0;
                return JSSubtractNode.doGeneric(leftNodeValue, rightNodeValue, node__, toNumericA__, toNumericB__, s4_.subtract_, INLINED_GENERIC_MIXED_NUMERIC_TYPES_);
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {super.leftNode, super.rightNode}, leftNodeValue, rightNodeValue);
    }

    @NeverDefault
    public static JSSubtractNode create(boolean truncate, JavaScriptNode left, JavaScriptNode right) {
        return new JSSubtractNodeGen(truncate, left, right);
    }

    @GeneratedBy(JSSubtractNode.class)
    @DenyReplace
    private static final class GenericData extends Node implements SpecializationDataNode {

        /**
         * State Info: <pre>
         *   0: InlinedCache
         *        Specialization: {@link JSSubtractNode#doGeneric}
         *        Parameter: {@link InlinedBranchProfile} mixedNumericTypes
         *        Inline method: {@link InlinedBranchProfile#inline}
         * </pre>
         */
        @CompilationFinal @UnsafeAccessedField private int generic_state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSSubtractNode#doGeneric}
         *   Parameter: {@link JSToNumericNode} toNumericA</pre>
         */
        @Child JSToNumericNode toNumericA_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSSubtractNode#doGeneric}
         *   Parameter: {@link JSToNumericNode} toNumericB</pre>
         */
        @Child JSToNumericNode toNumericB_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSSubtractNode#doGeneric}
         *   Parameter: {@link JavaScriptNode} subtract</pre>
         */
        @Child JavaScriptNode subtract_;

        GenericData() {
        }

        private static Lookup lookup_() {
            return MethodHandles.lookup();
        }

    }
}
