/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.builtins.temporal.TemporalPlainTimePrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.temporal.UnsupportedValueOfNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsIntNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerWithTruncationNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.temporal.GetDifferenceSettingsNode;
import com.oracle.truffle.js.nodes.temporal.GetRoundingIncrementOptionNode;
import com.oracle.truffle.js.nodes.temporal.GetTemporalUnitNode;
import com.oracle.truffle.js.nodes.temporal.IsPartialTemporalObjectNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.ToFractionalSecondDigitsNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDurationNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalTimeNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPrecisionRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.EnumSet;

public class TemporalPlainTimePrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalPlainTimePrototype> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalPlainTimePrototypeBuiltins();

    protected TemporalPlainTimePrototypeBuiltins() {
        super(JSTemporalPlainTime.PROTOTYPE_NAME, TemporalPlainTimePrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalPlainTimePrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return TemporalPlainTimePrototypeBuiltinsFactory.JSTemporalPlainTimeGetterNodeGen.create(context, builtin, builtinEnum, TemporalPlainTimePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 7: {
                return TemporalPlainTimePrototypeBuiltinsFactory.JSTemporalPlainTimeAddSubNodeGen.create(context, builtin, 1, TemporalPlainTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 8: {
                return TemporalPlainTimePrototypeBuiltinsFactory.JSTemporalPlainTimeAddSubNodeGen.create(context, builtin, -1, TemporalPlainTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 9: {
                return TemporalPlainTimePrototypeBuiltinsFactory.JSTemporalPlainTimeWithNodeGen.create(context, builtin, TemporalPlainTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 10: {
                return TemporalPlainTimePrototypeBuiltinsFactory.JSTemporalPlainTimeUntilSinceNodeGen.create(context, builtin, 1, TemporalPlainTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 11: {
                return TemporalPlainTimePrototypeBuiltinsFactory.JSTemporalPlainTimeUntilSinceNodeGen.create(context, builtin, -1, TemporalPlainTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 12: {
                return TemporalPlainTimePrototypeBuiltinsFactory.JSTemporalPlainTimeRoundNodeGen.create(context, builtin, TemporalPlainTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 13: {
                return TemporalPlainTimePrototypeBuiltinsFactory.JSTemporalPlainTimeEqualsNodeGen.create(context, builtin, TemporalPlainTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 14: {
                return TemporalPlainTimePrototypeBuiltinsFactory.JSTemporalPlainTimeToStringNodeGen.create(context, builtin, TemporalPlainTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 15: 
            case 16: {
                return TemporalPlainTimePrototypeBuiltinsFactory.JSTemporalPlainTimeToLocaleStringNodeGen.create(context, builtin, TemporalPlainTimePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 17: {
                return UnsupportedValueOfNodeGen.create(context, builtin, TemporalPlainTimePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TemporalPlainTimePrototype implements BuiltinEnum<TemporalPlainTimePrototype>
    {
        calendar(0),
        hour(0),
        minute(0),
        second(0),
        millisecond(0),
        microsecond(0),
        nanosecond(0),
        add(1),
        subtract(1),
        with(1),
        until(1),
        since(1),
        round(1),
        equals(1),
        toString(0),
        toLocaleString(0),
        toJSON(0),
        valueOf(0);

        private final int length;

        private TemporalPlainTimePrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return EnumSet.of(calendar, new TemporalPlainTimePrototype[]{hour, minute, second, millisecond, microsecond, nanosecond}).contains(this);
        }
    }

    public static abstract class JSTemporalPlainTimeGetterNode
    extends JSBuiltinNode {
        public final TemporalPlainTimePrototype property;

        public JSTemporalPlainTimeGetterNode(JSContext context, JSBuiltin builtin, TemporalPlainTimePrototype property) {
            super(context, builtin);
            this.property = property;
        }

        @Specialization
        protected final Object timeGetter(JSTemporalPlainTimeObject temporalTime) {
            switch (this.property.ordinal()) {
                case 0: {
                    return temporalTime.getCalendar();
                }
                case 1: {
                    return temporalTime.getHour();
                }
                case 2: {
                    return temporalTime.getMinute();
                }
                case 3: {
                    return temporalTime.getSecond();
                }
                case 4: {
                    return temporalTime.getMillisecond();
                }
                case 5: {
                    return temporalTime.getMicrosecond();
                }
                case 6: {
                    return temporalTime.getNanosecond();
                }
            }
            throw Errors.shouldNotReachHere();
        }

        @Specialization(guards={"!isJSTemporalPlainTime(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainTimeExpected();
        }
    }

    public static abstract class JSTemporalPlainTimeAddSubNode
    extends JSTemporalBuiltinOperation {
        private final int sign;

        protected JSTemporalPlainTimeAddSubNode(JSContext context, JSBuiltin builtin, int sign) {
            super(context, builtin);
            this.sign = sign;
        }

        @Specialization
        public JSTemporalPlainTimeObject addDurationToOrSubtractDurationFromPlainTime(JSTemporalPlainTimeObject temporalTime, Object temporalDurationLike, @Cached ToTemporalDurationNode toTemporalDurationNode, @Cached InlinedBranchProfile errorBranch) {
            JSTemporalDurationObject duration = toTemporalDurationNode.execute(temporalDurationLike);
            TimeRecord result = TemporalUtil.addTimeDouble(temporalTime.getHour(), temporalTime.getMinute(), temporalTime.getSecond(), temporalTime.getMillisecond(), temporalTime.getMicrosecond(), temporalTime.getNanosecond(), (double)this.sign * duration.getHours(), (double)this.sign * duration.getMinutes(), (double)this.sign * duration.getSeconds(), (double)this.sign * duration.getMilliseconds(), (double)this.sign * duration.getMicroseconds(), (double)this.sign * duration.getNanoseconds());
            assert (TemporalUtil.isValidTime(result.hour(), result.minute(), result.second(), result.millisecond(), result.microsecond(), result.nanosecond()));
            return JSTemporalPlainTime.create(this.getContext(), this.getRealm(), result.hour(), result.minute(), result.second(), result.millisecond(), result.microsecond(), result.nanosecond(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalPlainTime(thisObj)"})
        protected static JSTemporalPlainTimeObject invalidReceiver(Object thisObj, Object temporalDurationLike) {
            throw TemporalErrors.createTypeErrorTemporalPlainTimeExpected();
        }
    }

    public static abstract class JSTemporalPlainTimeWith
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainTimeWith(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalPlainTimeObject with(JSTemporalPlainTimeObject temporalTime, Object temporalTimeLike, Object options, @Cached IsPartialTemporalObjectNode isPartialTemporalObjectNode, @Cached JSToIntegerWithTruncationNode toIntegerWithTruncation, @Cached JSToIntegerAsIntNode toInt, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            if (!isPartialTemporalObjectNode.execute(temporalTimeLike)) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createTypeErrorPartialTemporalObjectExpected();
            }
            JSDynamicObject partialTime = JSTemporalPlainTime.toPartialTime(temporalTimeLike, toIntegerWithTruncation, this.getContext());
            Object tempValue = JSObject.get(partialTime, TemporalConstants.HOUR);
            int hour = tempValue != Undefined.instance ? toInt.executeInt(tempValue) : temporalTime.getHour();
            tempValue = JSObject.get(partialTime, TemporalConstants.MINUTE);
            int minute = tempValue != Undefined.instance ? toInt.executeInt(tempValue) : temporalTime.getMinute();
            tempValue = JSObject.get(partialTime, TemporalConstants.SECOND);
            int second = tempValue != Undefined.instance ? toInt.executeInt(tempValue) : temporalTime.getSecond();
            tempValue = JSObject.get(partialTime, TemporalConstants.MILLISECOND);
            int millisecond = tempValue != Undefined.instance ? toInt.executeInt(tempValue) : temporalTime.getMillisecond();
            tempValue = JSObject.get(partialTime, TemporalConstants.MICROSECOND);
            int microsecond = tempValue != Undefined.instance ? toInt.executeInt(tempValue) : temporalTime.getMicrosecond();
            tempValue = JSObject.get(partialTime, TemporalConstants.NANOSECOND);
            int nanosecond = tempValue != Undefined.instance ? toInt.executeInt(tempValue) : temporalTime.getNanosecond();
            JSDynamicObject resolvedOptions = this.getOptionsObject(options, this, errorBranch, optionUndefined);
            TemporalUtil.Overflow overflow = TemporalUtil.toTemporalOverflow((Object)resolvedOptions, getOptionNode);
            JSTemporalDurationRecord result = TemporalUtil.regulateTime(hour, minute, second, millisecond, microsecond, nanosecond, overflow);
            return JSTemporalPlainTime.create(this.getContext(), this.getRealm(), TemporalUtil.dtoi(result.getHours()), TemporalUtil.dtoi(result.getMinutes()), TemporalUtil.dtoi(result.getSeconds()), TemporalUtil.dtoi(result.getMilliseconds()), TemporalUtil.dtoi(result.getMicroseconds()), TemporalUtil.dtoi(result.getNanoseconds()), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalPlainTime(thisObj)"})
        protected static JSTemporalPlainTimeObject invalidReceiver(Object thisObj, Object temporalTimeLike, Object options) {
            throw TemporalErrors.createTypeErrorTemporalPlainTimeExpected();
        }
    }

    public static abstract class JSTemporalPlainTimeUntilSinceNode
    extends JSTemporalBuiltinOperation {
        private final int sign;

        protected JSTemporalPlainTimeUntilSinceNode(JSContext context, JSBuiltin builtin, int sign) {
            super(context, builtin);
            this.sign = sign;
        }

        @Specialization
        public JSTemporalDurationObject differenceTemporalPlainTime(JSTemporalPlainTimeObject temporalTime, Object otherObj, Object options, @Cached ToTemporalTimeNode toTemporalTime, @Cached GetDifferenceSettingsNode getDifferenceSettings, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSTemporalPlainTimeObject other = toTemporalTime.execute(otherObj, (Object)Undefined.instance);
            JSDynamicObject resolvedOptions = this.getOptionsObject(options, this, errorBranch, optionUndefined);
            GetDifferenceSettingsNode.GetDifferenceSettingsResult settings = getDifferenceSettings.execute(this.sign, resolvedOptions, TemporalUtil.unitMappingTimeOrAuto, TemporalUtil.unitMappingTime, TemporalUtil.Unit.NANOSECOND, TemporalUtil.Unit.HOUR);
            BigInt norm = TemporalUtil.differenceTime(temporalTime.getHour(), temporalTime.getMinute(), temporalTime.getSecond(), temporalTime.getMillisecond(), temporalTime.getMicrosecond(), temporalTime.getNanosecond(), other.getHour(), other.getMinute(), other.getSecond(), other.getMillisecond(), other.getMicrosecond(), other.getNanosecond());
            if (settings.smallestUnit() != TemporalUtil.Unit.NANOSECOND || settings.roundingIncrement() != 1) {
                TemporalUtil.NormalizedDurationWithTotalRecord roundRecord = TemporalUtil.roundTimeDuration(0.0, norm, settings.roundingIncrement(), settings.smallestUnit(), settings.roundingMode());
                norm = roundRecord.normalizedDuration().normalizedTimeTotalNanoseconds();
            }
            JSRealm realm = this.getRealm();
            TimeDurationRecord result = TemporalUtil.balanceTimeDuration(norm, settings.largestUnit());
            return JSTemporalDuration.createTemporalDuration(this.getContext(), realm, 0.0, 0.0, 0.0, 0.0, (double)this.sign * result.hours(), (double)this.sign * result.minutes(), (double)this.sign * result.seconds(), (double)this.sign * result.milliseconds(), (double)this.sign * result.microseconds(), (double)this.sign * result.nanoseconds(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalPlainTime(thisObj)"})
        protected static JSTemporalDurationObject invalidReceiver(Object thisObj, Object otherObj, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainTimeExpected();
        }
    }

    public static abstract class JSTemporalPlainTimeRound
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainTimeRound(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalPlainTimeObject round(JSTemporalPlainTimeObject temporalTime, Object roundToParam, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached GetTemporalUnitNode getSmallestUnit, @Cached GetRoundingIncrementOptionNode getRoundingIncrementOption, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSDynamicObject roundTo;
            if (roundToParam == Undefined.instance) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createTypeErrorOptionsUndefined();
            }
            if (Strings.isTString(roundToParam)) {
                roundTo = JSOrdinary.createWithNullPrototype(this.getContext());
                JSRuntime.createDataPropertyOrThrow(roundTo, TemporalConstants.SMALLEST_UNIT, roundToParam);
            } else {
                roundTo = this.getOptionsObject(roundToParam, this, errorBranch, optionUndefined);
            }
            int roundingIncrement = getRoundingIncrementOption.execute((Object)roundTo);
            TemporalUtil.RoundingMode roundingMode = JSTemporalPlainTimeRound.toTemporalRoundingMode(roundTo, TemporalConstants.HALF_EXPAND, equalNode, getOptionNode);
            TemporalUtil.Unit smallestUnit = getSmallestUnit.execute(roundTo, TemporalConstants.SMALLEST_UNIT, TemporalUtil.unitMappingTime, TemporalUtil.Unit.REQUIRED);
            int maximum = TemporalUtil.maximumTemporalDurationRoundingIncrement(smallestUnit);
            TemporalUtil.validateTemporalRoundingIncrement(roundingIncrement, maximum, false, this, errorBranch);
            TimeRecord result = TemporalUtil.roundTime(temporalTime.getHour(), temporalTime.getMinute(), temporalTime.getSecond(), temporalTime.getMillisecond(), temporalTime.getMicrosecond(), temporalTime.getNanosecond(), roundingIncrement, smallestUnit, roundingMode);
            return JSTemporalPlainTime.create(this.getContext(), this.getRealm(), result.hour(), result.minute(), result.second(), result.millisecond(), result.microsecond(), result.nanosecond(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalPlainTime(thisObj)"})
        protected static JSTemporalPlainTimeObject invalidReceiver(Object thisObj, Object roundToParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainTimeExpected();
        }
    }

    public static abstract class JSTemporalPlainTimeEquals
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainTimeEquals(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean equalsOtherObj(JSTemporalPlainTimeObject thisTime, JSTemporalPlainTimeObject otherObj) {
            return JSTemporalPlainTimeEquals.equalsIntl(thisTime, otherObj);
        }

        @Specialization(guards={"!isJSTemporalPlainTime(other)"})
        protected boolean equalsGeneric(JSTemporalPlainTimeObject thisTime, Object other, @Cached ToTemporalTimeNode toTemporalTime) {
            JSTemporalPlainTimeObject otherTime = toTemporalTime.execute(other, (Object)Undefined.instance);
            return JSTemporalPlainTimeEquals.equalsIntl(thisTime, otherTime);
        }

        private static boolean equalsIntl(JSTemporalPlainTimeObject thisTime, JSTemporalPlainTimeObject otherTime) {
            if (thisTime.getHour() != otherTime.getHour()) {
                return false;
            }
            if (thisTime.getMinute() != otherTime.getMinute()) {
                return false;
            }
            if (thisTime.getSecond() != otherTime.getSecond()) {
                return false;
            }
            if (thisTime.getMillisecond() != otherTime.getMillisecond()) {
                return false;
            }
            if (thisTime.getMicrosecond() != otherTime.getMicrosecond()) {
                return false;
            }
            return thisTime.getNanosecond() == otherTime.getNanosecond();
        }

        @Specialization(guards={"!isJSTemporalPlainTime(thisObj)"})
        protected static boolean invalidReceiver(Object thisObj, Object otherObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainTimeExpected();
        }
    }

    public static abstract class JSTemporalPlainTimeToString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainTimeToString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected final TruffleString toString(JSTemporalPlainTimeObject temporalTime, Object optionsParam, @Cached ToFractionalSecondDigitsNode toFractionalSecondDigitsNode, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached GetTemporalUnitNode getSmallestUnit, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            int digits = toFractionalSecondDigitsNode.execute((Object)options);
            TemporalUtil.RoundingMode roundingMode = JSTemporalPlainTimeToString.toTemporalRoundingMode(options, TemporalConstants.TRUNC, equalNode, getOptionNode);
            TemporalUtil.Unit smallestUnit = getSmallestUnit.execute(options, TemporalConstants.SMALLEST_UNIT, TemporalUtil.unitMappingTime, TemporalUtil.Unit.EMPTY);
            if (smallestUnit == TemporalUtil.Unit.HOUR) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createRangeErrorSmallestUnitOutOfRange();
            }
            JSTemporalPrecisionRecord precision = TemporalUtil.toSecondsStringPrecisionRecord(smallestUnit, digits);
            TimeRecord roundResult = TemporalUtil.roundTime(temporalTime.getHour(), temporalTime.getMinute(), temporalTime.getSecond(), temporalTime.getMillisecond(), temporalTime.getMicrosecond(), temporalTime.getNanosecond(), precision.getIncrement(), precision.getUnit(), roundingMode);
            return JSTemporalPlainTime.temporalTimeToString(roundResult.hour(), roundResult.minute(), roundResult.second(), roundResult.millisecond(), roundResult.microsecond(), roundResult.nanosecond(), precision.getPrecision());
        }

        @Specialization(guards={"!isJSTemporalPlainTime(thisObj)"})
        protected static TruffleString invalidReceiver(Object thisObj, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainTimeExpected();
        }
    }

    public static abstract class JSTemporalPlainTimeToLocaleString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainTimeToLocaleString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static TruffleString toLocaleString(JSTemporalPlainTimeObject time) {
            return JSTemporalPlainTime.temporalTimeToString(time.getHour(), time.getMinute(), time.getSecond(), time.getMillisecond(), time.getMicrosecond(), time.getNanosecond(), TemporalConstants.AUTO);
        }

        @Specialization(guards={"!isJSTemporalPlainTime(thisObj)"})
        protected static TruffleString invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainTimeExpected();
        }
    }
}

