/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.wasm;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.access.GetIteratorNode;
import com.oracle.truffle.js.nodes.access.IterableToListNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.wasm.ToJSValueNode;
import com.oracle.truffle.js.nodes.wasm.ToWebAssemblyValueNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.wasm.WasmFunctionTypeInfo;
import com.oracle.truffle.js.runtime.builtins.wasm.WebAssemblyValueType;
import com.oracle.truffle.js.runtime.interop.InteropArray;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;

@ExportLibrary(value=InteropLibrary.class)
public class WebAssemblyHostFunction
implements TruffleObject {
    private final Object fn;
    private final WasmFunctionTypeInfo type;

    public WebAssemblyHostFunction(Object fn, WasmFunctionTypeInfo type) {
        assert (JSRuntime.isCallable(fn));
        this.fn = fn;
        this.type = type;
    }

    @ExportMessage
    public static final boolean isExecutable(WebAssemblyHostFunction receiver) {
        return true;
    }

    @ExportMessage
    public final Object execute(Object[] args, @Bind Node node, @Cached ToWebAssemblyValueNode toWebAssemblyValueNode, @Cached ToJSValueNode toJSValueNode, @Cached(value="createCall()", uncached="getUncachedCall()") JSFunctionCallNode callNode, @Cached InlinedBranchProfile errorBranch, @Cached(inline=true) GetIteratorNode getIteratorNode, @Cached IterableToListNode iterableToListNode, @CachedLibrary(value="this") InteropLibrary self) {
        JSContext context = JavaScriptLanguage.get((Node)self).getJSContext();
        if (!context.getLanguageOptions().wasmBigInt() && this.type.anyTypeIsI64() || this.type.anyTypeIsV128()) {
            errorBranch.enter(node);
            throw Errors.createTypeError("wasm function signature contains illegal type");
        }
        Object[] jsArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            jsArgs[i] = toJSValueNode.execute(args[i]);
        }
        Object result = callNode.executeCall(JSArguments.create((Object)Undefined.instance, this.fn, jsArgs));
        WebAssemblyValueType[] resultTypes = this.type.resultTypes();
        if (resultTypes.length == 0) {
            return Undefined.instance;
        }
        if (resultTypes.length == 1) {
            return toWebAssemblyValueNode.execute(result, resultTypes[0]);
        }
        IteratorRecord iterator = getIteratorNode.execute(node, result);
        SimpleArrayList<Object> values = iterableToListNode.execute(iterator);
        if (resultTypes.length != values.size()) {
            errorBranch.enter(node);
            throw Errors.createTypeError("invalid result array arity");
        }
        Object[] wasmValues = new Object[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            wasmValues[i] = toWebAssemblyValueNode.execute(values.get(i), resultTypes[i]);
        }
        return InteropArray.create(wasmValues);
    }
}

