/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.LanguageCache;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class FileSystems {
    static final org.graalvm.polyglot.io.FileSystem INVALID_FILESYSTEM = new InvalidFileSystem();

    private FileSystems() {
        throw new IllegalStateException("No instance allowed");
    }

    static org.graalvm.polyglot.io.FileSystem newDefaultFileSystem(String hostTmpDirPath) {
        return new NIOFileSystem(FileSystems.findDefaultFileSystem(), hostTmpDirPath, true);
    }

    static org.graalvm.polyglot.io.FileSystem newNIOFileSystem(FileSystem fileSystem) {
        return new NIOFileSystem(fileSystem, null, false);
    }

    static org.graalvm.polyglot.io.FileSystem allowLanguageHomeAccess(org.graalvm.polyglot.io.FileSystem fileSystem) {
        return new LanguageHomeFileSystem(FileSystems.newDefaultFileSystem(null), fileSystem);
    }

    static org.graalvm.polyglot.io.FileSystem newReadOnlyFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
        return new ReadOnlyFileSystem(fileSystem);
    }

    static org.graalvm.polyglot.io.FileSystem newNoIOFileSystem() {
        return new DeniedIOFileSystem();
    }

    static org.graalvm.polyglot.io.FileSystem newLanguageHomeFileSystem() {
        org.graalvm.polyglot.io.FileSystem defaultFS = FileSystems.newDefaultFileSystem(null);
        return new LanguageHomeFileSystem(new ReadOnlyFileSystem(defaultFS), new PathOperationsOnlyFileSystem(defaultFS));
    }

    static boolean hasNoAccess(org.graalvm.polyglot.io.FileSystem fileSystem) {
        return fileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)fileSystem).hasNoAccess();
    }

    static boolean isInternal(AbstractPolyglotImpl polyglot, org.graalvm.polyglot.io.FileSystem fileSystem) {
        return fileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)fileSystem).isInternal(polyglot);
    }

    static boolean isHostFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
        return fileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)fileSystem).isHost();
    }

    static Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> newFileTypeDetectorsSupplier(Iterable<LanguageCache> languageCaches) {
        return new FileTypeDetectorsSupplier(languageCaches);
    }

    static String getRelativePathInLanguageHome(TruffleFile file) {
        Object engineObject = EngineAccessor.LANGUAGE.getFileSystemEngineObject(EngineAccessor.LANGUAGE.getFileSystemContext(file));
        if (engineObject instanceof PolyglotLanguageContext) {
            Path path;
            PolyglotLanguageContext languageContext = (PolyglotLanguageContext)engineObject;
            org.graalvm.polyglot.io.FileSystem fs = EngineAccessor.LANGUAGE.getFileSystem(file);
            String result = FileSystems.relativizeToLanguageHome(fs, path = EngineAccessor.LANGUAGE.getPath(file), languageContext.language);
            if (result != null) {
                return result;
            }
            Map<String, LanguageInfo> accessibleLanguages = languageContext.getAccessibleLanguages(true);
            if (accessibleLanguages != null) {
                for (LanguageInfo language : accessibleLanguages.values()) {
                    PolyglotLanguage lang = languageContext.context.engine.idToLanguage.get(language.getId());
                    result = FileSystems.relativizeToLanguageHome(fs, path, lang);
                    if (result == null) continue;
                    return result;
                }
            }
            return null;
        }
        if (engineObject instanceof PolyglotEngineImpl) {
            return null;
        }
        if (engineObject instanceof PolyglotImpl.EmbedderFileSystemContext) {
            return null;
        }
        throw new AssertionError();
    }

    static org.graalvm.polyglot.io.FileSystem newInternalResourceFileSystem(Supplier<Path> rootSupplier) {
        return FileSystems.newReadOnlyFileSystem(new InternalResourceFileSystem(rootSupplier));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isInternalResourceFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
        if (!(fileSystem instanceof ReadOnlyFileSystem)) return false;
        ReadOnlyFileSystem readOnlyFileSystem = (ReadOnlyFileSystem)fileSystem;
        if (!(readOnlyFileSystem.delegateFileSystem instanceof InternalResourceFileSystem)) return false;
        return true;
    }

    static Supplier<Path> getInternalResourceFileSystemRoot(org.graalvm.polyglot.io.FileSystem fileSystem) {
        if (FileSystems.isInternalResourceFileSystem(fileSystem)) {
            return ((InternalResourceFileSystem)((ReadOnlyFileSystem)fileSystem).delegateFileSystem).rootSupplier;
        }
        throw new IllegalArgumentException(Objects.toString(fileSystem));
    }

    private static String relativizeToLanguageHome(org.graalvm.polyglot.io.FileSystem fs, Path path, PolyglotLanguage language) {
        String languageHome = language.cache.getLanguageHome();
        if (languageHome == null) {
            return null;
        }
        Path languageHomePath = fs.parsePath(language.cache.getLanguageHome());
        if (path.startsWith(languageHomePath)) {
            return languageHomePath.relativize(path).toString();
        }
        return null;
    }

    private static FileSystem findDefaultFileSystem() {
        FileSystem fs = java.nio.file.FileSystems.getDefault();
        assert ("file".equals(fs.provider().getScheme()));
        return fs;
    }

    private static FileSystemProvider findDefaultFileSystemProvider() {
        for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
            if (!"file".equals(provider.getScheme())) continue;
            return provider;
        }
        return null;
    }

    private static boolean isFollowLinks(LinkOption ... linkOptions) {
        for (LinkOption lo : linkOptions) {
            if (Objects.requireNonNull(lo) != LinkOption.NOFOLLOW_LINKS) continue;
            return false;
        }
        return true;
    }

    private static void validateLinkOptions(LinkOption ... linkOptions) {
        for (LinkOption linkOption : linkOptions) {
            Objects.requireNonNull(linkOption);
        }
    }

    private static SecurityException forbidden(Path path) {
        throw new SecurityException((String)(path == null ? "Operation is not allowed." : "Operation is not allowed for: " + path));
    }

    private static final class NIOFileSystem
    implements PolyglotFileSystem {
        private final FileSystem fileSystem;
        private final FileSystemProvider fileSystemProvider;
        private final boolean isDefault;
        private final String hostTmpDirPath;
        private volatile Path userDir;
        private volatile Path tmpDir;

        NIOFileSystem(FileSystem fileSystem, String hostTmpDirPath, boolean isDefault) {
            Objects.requireNonNull(fileSystem, "FileSystem must be non null.");
            this.fileSystem = fileSystem;
            this.fileSystemProvider = fileSystem.provider();
            this.hostTmpDirPath = hostTmpDirPath;
            this.isDefault = isDefault;
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return this.isDefault;
        }

        @Override
        public boolean hasNoAccess() {
            return false;
        }

        @Override
        public boolean isHost() {
            return this.isDefault;
        }

        public Path parsePath(URI uri) {
            if (!this.fileSystemProvider.getScheme().equals(uri.getScheme())) {
                throw new UnsupportedOperationException("Unsupported URI scheme " + uri.getScheme());
            }
            try {
                return this.fileSystemProvider.getPath(uri);
            }
            catch (FileSystemNotFoundException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        public Path parsePath(String path) {
            Objects.requireNonNull(path);
            return this.fileSystem.getPath(path, new String[0]);
        }

        public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            Objects.requireNonNull(path);
            Objects.requireNonNull(modes);
            if (FileSystems.isFollowLinks(linkOptions)) {
                this.fileSystemProvider.checkAccess(this.resolveRelative(path), modes.toArray(new AccessMode[0]));
            } else if (modes.isEmpty()) {
                this.fileSystemProvider.readAttributes(path, "isRegularFile", LinkOption.NOFOLLOW_LINKS);
            } else {
                throw new UnsupportedOperationException("CheckAccess for NIO Provider is unsupported with non empty AccessMode and NOFOLLOW_LINKS.");
            }
        }

        public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
            Objects.requireNonNull(dir);
            Objects.requireNonNull(attrs);
            this.fileSystemProvider.createDirectory(this.resolveRelative(dir), attrs);
        }

        public void delete(Path path) throws IOException {
            Objects.requireNonNull(path);
            this.fileSystemProvider.delete(this.resolveRelative(path));
        }

        public void copy(Path source, Path target, CopyOption ... options) throws IOException {
            Objects.requireNonNull(source);
            Objects.requireNonNull(target);
            Objects.requireNonNull(options);
            this.fileSystemProvider.copy(this.resolveRelative(source), this.resolveRelative(target), options);
        }

        public void move(Path source, Path target, CopyOption ... options) throws IOException {
            Objects.requireNonNull(source);
            Objects.requireNonNull(target);
            Objects.requireNonNull(options);
            this.fileSystemProvider.move(this.resolveRelative(source), this.resolveRelative(target), options);
        }

        public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            Objects.requireNonNull(path);
            Objects.requireNonNull(options);
            Objects.requireNonNull(attrs);
            Path resolved = this.resolveRelative(path);
            try {
                return this.fileSystemProvider.newFileChannel(resolved, options, attrs);
            }
            catch (UnsupportedOperationException uoe) {
                return this.fileSystemProvider.newByteChannel(resolved, options, attrs);
            }
        }

        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
            boolean relativize;
            Path resolvedPath;
            Objects.requireNonNull(dir);
            Path cwd = this.userDir;
            if (!dir.isAbsolute() && cwd != null) {
                resolvedPath = cwd.resolve(dir);
                relativize = true;
            } else {
                resolvedPath = dir;
                relativize = false;
            }
            RelativizeDirectoryStream result = this.fileSystemProvider.newDirectoryStream(resolvedPath, filter);
            if (relativize) {
                result = new RelativizeDirectoryStream(cwd, result);
            }
            return result;
        }

        public void createLink(Path link, Path existing) throws IOException {
            Objects.requireNonNull(link);
            Objects.requireNonNull(existing);
            this.fileSystemProvider.createLink(this.resolveRelative(link), this.resolveRelative(existing));
        }

        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
            Objects.requireNonNull(link);
            Objects.requireNonNull(target);
            Objects.requireNonNull(attrs);
            this.fileSystemProvider.createSymbolicLink(this.resolveRelative(link), target, attrs);
        }

        public Path readSymbolicLink(Path link) throws IOException {
            Objects.requireNonNull(link);
            return this.fileSystemProvider.readSymbolicLink(this.resolveRelative(link));
        }

        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
            Objects.requireNonNull(path);
            FileSystems.validateLinkOptions(options);
            return this.fileSystemProvider.readAttributes(this.resolveRelative(path), attributes, options);
        }

        public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
            Objects.requireNonNull(path);
            FileSystems.validateLinkOptions(options);
            this.fileSystemProvider.setAttribute(this.resolveRelative(path), attribute, value, options);
        }

        public Path toAbsolutePath(Path path) {
            Objects.requireNonNull(path);
            if (path.isAbsolute()) {
                return path;
            }
            Path cwd = this.userDir;
            if (cwd == null) {
                return path.toAbsolutePath();
            }
            return cwd.resolve(path);
        }

        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            boolean nonDirectory;
            Objects.requireNonNull(currentWorkingDirectory, "Current working directory must be non null.");
            if (!currentWorkingDirectory.isAbsolute()) {
                throw new IllegalArgumentException("Current working directory must be absolute.");
            }
            try {
                nonDirectory = Boolean.FALSE.equals(this.fileSystemProvider.readAttributes(currentWorkingDirectory, "isDirectory", new LinkOption[0]).get("isDirectory"));
            }
            catch (IOException ioe) {
                nonDirectory = false;
            }
            if (nonDirectory) {
                throw new IllegalArgumentException("Current working directory must be directory.");
            }
            this.userDir = currentWorkingDirectory;
        }

        public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
            Objects.requireNonNull(path);
            FileSystems.validateLinkOptions(linkOptions);
            Path resolvedPath = this.resolveRelative(path);
            return resolvedPath.toRealPath(linkOptions);
        }

        public Path getTempDirectory() {
            Path result = this.tmpDir;
            if (result == null) {
                if (this.hostTmpDirPath != null) {
                    this.tmpDir = result = this.parsePath(this.hostTmpDirPath);
                } else {
                    throw new UnsupportedOperationException("Temporary directories not supported");
                }
            }
            return result;
        }

        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            Objects.requireNonNull(path1);
            Objects.requireNonNull(path2);
            if (FileSystems.isFollowLinks(options)) {
                Path absolutePath1 = this.resolveRelative(path1);
                Path absolutePath2 = this.resolveRelative(path2);
                return this.fileSystemProvider.isSameFile(absolutePath1, absolutePath2);
            }
            return PolyglotFileSystem.super.isSameFile(path1, path2, options);
        }

        private Path resolveRelative(Path path) {
            return !path.isAbsolute() && this.userDir != null ? this.toAbsolutePath(path) : path;
        }

        private static final class RelativizeDirectoryStream
        implements DirectoryStream<Path> {
            private final Path folder;
            private final DirectoryStream<? extends Path> delegateDirectoryStream;

            RelativizeDirectoryStream(Path folder, DirectoryStream<? extends Path> delegateDirectoryStream) {
                this.folder = folder;
                this.delegateDirectoryStream = delegateDirectoryStream;
            }

            @Override
            public Iterator<Path> iterator() {
                return new RelativizeIterator(this.folder, this.delegateDirectoryStream.iterator());
            }

            @Override
            public void close() throws IOException {
                this.delegateDirectoryStream.close();
            }

            private static final class RelativizeIterator
            implements Iterator<Path> {
                private final Path folder;
                private final Iterator<? extends Path> delegateIterator;

                RelativizeIterator(Path folder, Iterator<? extends Path> delegateIterator) {
                    this.folder = folder;
                    this.delegateIterator = delegateIterator;
                }

                @Override
                public boolean hasNext() {
                    return this.delegateIterator.hasNext();
                }

                @Override
                public Path next() {
                    return this.folder.relativize(this.delegateIterator.next());
                }
            }
        }
    }

    private static final class LanguageHomeFileSystem
    implements PolyglotFileSystem {
        private final org.graalvm.polyglot.io.FileSystem languageHomeFileSystem;
        private final org.graalvm.polyglot.io.FileSystem delegateFileSystem;
        private volatile Set<Path> languageHomes;

        LanguageHomeFileSystem(org.graalvm.polyglot.io.FileSystem languageHomeFileSystem, org.graalvm.polyglot.io.FileSystem delegateFileSystem) {
            this.languageHomeFileSystem = languageHomeFileSystem;
            this.delegateFileSystem = delegateFileSystem;
            Class<?> languageHomeFileSystemPathType = this.languageHomeFileSystem.parsePath("").getClass();
            Class<?> customFileSystemPathType = delegateFileSystem.parsePath("").getClass();
            if (languageHomeFileSystemPathType != customFileSystemPathType) {
                throw new IllegalArgumentException("Given FileSystem must have the same Path type as the default FileSystem.");
            }
            if (!languageHomeFileSystem.getSeparator().equals(delegateFileSystem.getSeparator())) {
                throw new IllegalArgumentException("Given FileSystem must use the same separator character as the default FileSystem.");
            }
            if (!languageHomeFileSystem.getPathSeparator().equals(delegateFileSystem.getPathSeparator())) {
                throw new IllegalArgumentException("Given FileSystem must use the same path separator character as the default FileSystem.");
            }
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return polyglot.isInternalFileSystem(this.delegateFileSystem);
        }

        @Override
        public boolean hasNoAccess() {
            return this.delegateFileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegateFileSystem).hasNoAccess();
        }

        @Override
        public boolean isHost() {
            return this.delegateFileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegateFileSystem).isHost();
        }

        public Path parsePath(URI uri) {
            return this.delegateFileSystem.parsePath(uri);
        }

        public Path parsePath(String path) {
            return this.delegateFileSystem.parsePath(path);
        }

        public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(path);
            if (this.inLanguageHome(absolutePath)) {
                this.languageHomeFileSystem.checkAccess(absolutePath, modes, linkOptions);
            } else {
                this.delegateFileSystem.checkAccess(path, modes, linkOptions);
            }
        }

        public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(dir);
            if (this.inLanguageHome(absolutePath)) {
                this.languageHomeFileSystem.createDirectory(absolutePath, (FileAttribute[])attrs);
            } else {
                this.delegateFileSystem.createDirectory(dir, (FileAttribute[])attrs);
            }
        }

        public void delete(Path path) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(path);
            if (this.inLanguageHome(absolutePath)) {
                this.languageHomeFileSystem.delete(absolutePath);
            } else {
                this.delegateFileSystem.delete(path);
            }
        }

        public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(path);
            if (this.inLanguageHome(absolutePath)) {
                return this.languageHomeFileSystem.newByteChannel(absolutePath, options, (FileAttribute[])attrs);
            }
            return this.delegateFileSystem.newByteChannel(path, options, (FileAttribute[])attrs);
        }

        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(dir);
            if (this.inLanguageHome(absolutePath)) {
                return this.languageHomeFileSystem.newDirectoryStream(absolutePath, filter);
            }
            return this.delegateFileSystem.newDirectoryStream(dir, filter);
        }

        public Path toAbsolutePath(Path path) {
            return this.delegateFileSystem.toAbsolutePath(path);
        }

        public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(path);
            if (this.inLanguageHome(absolutePath)) {
                return this.languageHomeFileSystem.toRealPath(path, new LinkOption[0]);
            }
            return this.delegateFileSystem.toRealPath(path, new LinkOption[0]);
        }

        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(path);
            if (this.inLanguageHome(absolutePath)) {
                return this.languageHomeFileSystem.readAttributes(absolutePath, attributes, options);
            }
            return this.delegateFileSystem.readAttributes(path, attributes, options);
        }

        public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(path);
            if (this.inLanguageHome(absolutePath)) {
                this.languageHomeFileSystem.setAttribute(absolutePath, attribute, value, options);
            } else {
                this.delegateFileSystem.setAttribute(path, attribute, value, options);
            }
        }

        public void createLink(Path link, Path existing) throws IOException {
            Path absoluteLink = this.toNormalizedAbsolutePath(link);
            Path absoluteExisting = this.toNormalizedAbsolutePath(existing);
            boolean linkInHome = this.inLanguageHome(absoluteLink);
            boolean existingInHome = this.inLanguageHome(absoluteExisting);
            if (linkInHome && existingInHome) {
                this.languageHomeFileSystem.createLink(absoluteLink, absoluteExisting);
            } else if (!linkInHome && !existingInHome) {
                this.delegateFileSystem.createLink(link, existing);
            } else {
                throw new IOException("Cross file system linking is not supported.");
            }
        }

        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
            Path absoluteLink = this.toNormalizedAbsolutePath(link);
            Path absoluteTarget = this.toNormalizedAbsolutePath(target);
            boolean linkInHome = this.inLanguageHome(absoluteLink);
            boolean targetInHome = this.inLanguageHome(absoluteTarget);
            if (linkInHome && targetInHome) {
                this.languageHomeFileSystem.createSymbolicLink(absoluteLink, target, new FileAttribute[0]);
            } else if (!linkInHome && !targetInHome) {
                this.delegateFileSystem.createSymbolicLink(link, target, new FileAttribute[0]);
            } else {
                throw new IOException("Cross file system linking is not supported.");
            }
        }

        public Path readSymbolicLink(Path link) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(link);
            if (this.inLanguageHome(absolutePath)) {
                return this.languageHomeFileSystem.readSymbolicLink(absolutePath);
            }
            return this.delegateFileSystem.readSymbolicLink(link);
        }

        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            this.languageHomeFileSystem.setCurrentWorkingDirectory(currentWorkingDirectory);
            this.delegateFileSystem.setCurrentWorkingDirectory(currentWorkingDirectory);
        }

        public String getSeparator() {
            return this.delegateFileSystem.getSeparator();
        }

        public String getPathSeparator() {
            return this.delegateFileSystem.getPathSeparator();
        }

        public String getMimeType(Path path) {
            Path absolutePath = this.toNormalizedAbsolutePath(path);
            if (this.inLanguageHome(absolutePath)) {
                return this.languageHomeFileSystem.getMimeType(absolutePath);
            }
            return this.delegateFileSystem.getMimeType(path);
        }

        public Charset getEncoding(Path path) {
            Path absolutePath = this.toNormalizedAbsolutePath(path);
            if (this.inLanguageHome(absolutePath)) {
                return this.languageHomeFileSystem.getEncoding(absolutePath);
            }
            return this.delegateFileSystem.getEncoding(path);
        }

        public Path getTempDirectory() {
            return this.delegateFileSystem.getTempDirectory();
        }

        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            Path absolutePath1 = this.toNormalizedAbsolutePath(path1);
            Path absolutePath2 = this.toNormalizedAbsolutePath(path2);
            boolean path1InHome = this.inLanguageHome(absolutePath1);
            boolean path2InHome = this.inLanguageHome(absolutePath2);
            if (path1InHome && path2InHome) {
                return this.languageHomeFileSystem.isSameFile(absolutePath1, absolutePath2, options);
            }
            if (!path1InHome && !path2InHome) {
                return this.delegateFileSystem.isSameFile(path1, path2, new LinkOption[0]);
            }
            return false;
        }

        private Path toNormalizedAbsolutePath(Path path) {
            if (path.isAbsolute()) {
                return path;
            }
            Path absolutePath = this.languageHomeFileSystem.toAbsolutePath(path);
            if (LanguageHomeFileSystem.isNormalized(path)) {
                return absolutePath;
            }
            return absolutePath.normalize();
        }

        private static boolean isNormalized(Path path) {
            for (Path name : path) {
                String strName = name.toString();
                if (!".".equals(strName) && !"..".equals(strName)) continue;
                return false;
            }
            return true;
        }

        private boolean inLanguageHome(Path path) {
            if (!path.isAbsolute() || !LanguageHomeFileSystem.isNormalized(path)) {
                throw new IllegalArgumentException("The path must be normalized absolute path.");
            }
            for (Path home : this.getLanguageHomes()) {
                if (!path.startsWith(home)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<Path> getLanguageHomes() {
            Set<Path> res = this.languageHomes;
            if (res == null) {
                LanguageHomeFileSystem languageHomeFileSystem = this;
                synchronized (languageHomeFileSystem) {
                    res = this.languageHomes;
                    if (res == null) {
                        res = new HashSet<Path>();
                        for (LanguageCache cache : LanguageCache.languages().values()) {
                            String languageHome = cache.getLanguageHome();
                            if (languageHome == null) continue;
                            res.add(Paths.get(languageHome, new String[0]));
                        }
                        this.languageHomes = res;
                    }
                }
            }
            return res;
        }
    }

    private static class ReadOnlyFileSystem
    extends DeniedIOFileSystem {
        private static final List<AccessMode> READ_MODES = Arrays.asList(AccessMode.READ, AccessMode.EXECUTE);
        private static final List<StandardOpenOption> READ_OPTIONS = Arrays.asList(StandardOpenOption.READ, StandardOpenOption.DSYNC, StandardOpenOption.SPARSE, StandardOpenOption.SYNC, StandardOpenOption.TRUNCATE_EXISTING);
        private final org.graalvm.polyglot.io.FileSystem delegateFileSystem;

        ReadOnlyFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
            this.delegateFileSystem = fileSystem;
        }

        @Override
        public Path parsePath(URI uri) {
            return this.delegateFileSystem.parsePath(uri);
        }

        @Override
        public Path parsePath(String path) {
            return this.delegateFileSystem.parsePath(path);
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return polyglot.isInternalFileSystem(this.delegateFileSystem);
        }

        @Override
        public boolean hasNoAccess() {
            return this.delegateFileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegateFileSystem).hasNoAccess();
        }

        @Override
        public boolean isHost() {
            return this.delegateFileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegateFileSystem).isHost();
        }

        @Override
        public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            HashSet<? extends AccessMode> writeModes = new HashSet<AccessMode>(modes);
            writeModes.removeAll(READ_MODES);
            if (!writeModes.isEmpty()) {
                throw new IOException("Read-only file");
            }
            this.delegateFileSystem.checkAccess(path, modes, linkOptions);
        }

        @Override
        public SeekableByteChannel newByteChannel(Path inPath, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            boolean write;
            HashSet<? extends OpenOption> copy = new HashSet<OpenOption>(options);
            HashSet<? extends OpenOption> writeOptions = new HashSet<OpenOption>(copy);
            boolean read = writeOptions.contains(StandardOpenOption.READ);
            writeOptions.removeAll(READ_OPTIONS);
            if (read) {
                writeOptions.remove(StandardOpenOption.APPEND);
            }
            boolean bl = write = !writeOptions.isEmpty();
            if (write) {
                throw FileSystems.forbidden(inPath);
            }
            return this.delegateFileSystem.newByteChannel(inPath, copy, (FileAttribute[])attrs);
        }

        @Override
        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
            return this.delegateFileSystem.newDirectoryStream(dir, filter);
        }

        @Override
        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
            return this.delegateFileSystem.readAttributes(path, attributes, options);
        }

        @Override
        public Path toAbsolutePath(Path path) {
            return this.delegateFileSystem.toAbsolutePath(path);
        }

        @Override
        public Path readSymbolicLink(Path link) throws IOException {
            return this.delegateFileSystem.readSymbolicLink(link);
        }

        @Override
        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            this.delegateFileSystem.setCurrentWorkingDirectory(currentWorkingDirectory);
            super.setCurrentWorkingDirectory(currentWorkingDirectory);
        }

        @Override
        public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
            return this.delegateFileSystem.toRealPath(path, linkOptions);
        }

        @Override
        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            return this.delegateFileSystem.isSameFile(path1, path2, options);
        }

        public String getMimeType(Path path) {
            return this.delegateFileSystem.getMimeType(path);
        }

        public Charset getEncoding(Path path) {
            return this.delegateFileSystem.getEncoding(path);
        }
    }

    private static class DeniedIOFileSystem
    implements PolyglotFileSystem {
        private final FileSystemProvider defaultFileSystemProvider = FileSystems.findDefaultFileSystemProvider();

        DeniedIOFileSystem() {
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return true;
        }

        @Override
        public boolean hasNoAccess() {
            return true;
        }

        @Override
        public boolean isHost() {
            return false;
        }

        public Path parsePath(URI uri) {
            if (!this.defaultFileSystemProvider.getScheme().equals(uri.getScheme())) {
                throw new UnsupportedOperationException("Unsupported URI scheme " + uri.getScheme());
            }
            try {
                return this.defaultFileSystemProvider.getPath(uri);
            }
            catch (FileSystemNotFoundException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        public Path parsePath(String path) {
            return Paths.get(path, new String[0]);
        }

        public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            throw FileSystems.forbidden(path);
        }

        public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
            throw FileSystems.forbidden(dir);
        }

        public void delete(Path path) throws IOException {
            throw FileSystems.forbidden(path);
        }

        public void copy(Path source, Path target, CopyOption ... options) throws IOException {
            throw FileSystems.forbidden(source);
        }

        public void move(Path source, Path target, CopyOption ... options) throws IOException {
            throw FileSystems.forbidden(source);
        }

        public SeekableByteChannel newByteChannel(Path inPath, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            throw FileSystems.forbidden(inPath);
        }

        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
            throw FileSystems.forbidden(dir);
        }

        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
            throw FileSystems.forbidden(path);
        }

        public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
            throw FileSystems.forbidden(path);
        }

        public Path toAbsolutePath(Path path) {
            throw FileSystems.forbidden(path);
        }

        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
        }

        public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
            throw FileSystems.forbidden(path);
        }

        public Path getTempDirectory() {
            throw FileSystems.forbidden(null);
        }

        public void createLink(Path link, Path existing) {
            throw FileSystems.forbidden(link);
        }

        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) {
            throw FileSystems.forbidden(link);
        }

        public Path readSymbolicLink(Path link) throws IOException {
            throw FileSystems.forbidden(link);
        }

        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            throw FileSystems.forbidden(path1);
        }
    }

    private static final class PathOperationsOnlyFileSystem
    extends DeniedIOFileSystem {
        private final org.graalvm.polyglot.io.FileSystem delegateFileSystem;

        PathOperationsOnlyFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
            this.delegateFileSystem = fileSystem;
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return polyglot.isInternalFileSystem(this.delegateFileSystem);
        }

        @Override
        public boolean hasNoAccess() {
            return this.delegateFileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegateFileSystem).hasNoAccess();
        }

        @Override
        public Path toAbsolutePath(Path path) {
            return this.delegateFileSystem.toAbsolutePath(path);
        }

        @Override
        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            this.delegateFileSystem.setCurrentWorkingDirectory(currentWorkingDirectory);
            super.setCurrentWorkingDirectory(currentWorkingDirectory);
        }

        @Override
        public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
            return this.delegateFileSystem.toRealPath(path, linkOptions);
        }

        @Override
        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            return this.delegateFileSystem.isSameFile(path1, path2, options);
        }
    }

    private static interface PolyglotFileSystem
    extends org.graalvm.polyglot.io.FileSystem {
        public boolean isInternal(AbstractPolyglotImpl var1);

        public boolean hasNoAccess();

        public boolean isHost();
    }

    private static final class FileTypeDetectorsSupplier
    implements Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> {
        private final Iterable<LanguageCache> languageCaches;

        FileTypeDetectorsSupplier(Iterable<LanguageCache> languageCaches) {
            this.languageCaches = languageCaches;
        }

        @Override
        public Map<String, Collection<? extends TruffleFile.FileTypeDetector>> get() {
            HashMap<String, Collection<? extends TruffleFile.FileTypeDetector>> detectors = new HashMap<String, Collection<? extends TruffleFile.FileTypeDetector>>();
            for (LanguageCache cache : this.languageCaches) {
                for (String mimeType : cache.getMimeTypes()) {
                    List<? extends TruffleFile.FileTypeDetector> languageDetectors = cache.getFileTypeDetectors();
                    Collection mimeTypeDetectors = (Collection)detectors.get(mimeType);
                    if (mimeTypeDetectors != null) {
                        if (languageDetectors.isEmpty()) continue;
                        ArrayList<? extends TruffleFile.FileTypeDetector> mergedDetectors = new ArrayList<TruffleFile.FileTypeDetector>(mimeTypeDetectors);
                        mergedDetectors.addAll(languageDetectors);
                        detectors.put(mimeType, mergedDetectors);
                        continue;
                    }
                    detectors.put(mimeType, languageDetectors);
                }
            }
            return detectors;
        }
    }

    private static final class InternalResourceFileSystem
    implements PolyglotFileSystem {
        private final org.graalvm.polyglot.io.FileSystem delegate;
        private final Supplier<Path> rootSupplier;

        InternalResourceFileSystem(Supplier<Path> rootSupplier) {
            Objects.requireNonNull(rootSupplier, "The rootSupplier must be non-null.");
            this.delegate = FileSystems.newDefaultFileSystem(null);
            this.rootSupplier = rootSupplier;
        }

        public Path parsePath(URI uri) {
            throw new UnsupportedOperationException();
        }

        public Path parsePath(String path) {
            return new InternalResourcePath(this.delegate.parsePath(path));
        }

        public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            Path normalized = InternalResourcePath.as(path).resolveDelegateAbsolutePath();
            this.delegate.checkAccess(normalized, modes, linkOptions);
        }

        public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
            Path normalized = InternalResourcePath.as(dir).resolveDelegateAbsolutePath();
            this.delegate.createDirectory(normalized, (FileAttribute[])attrs);
        }

        public void delete(Path path) throws IOException {
            Path normalized = InternalResourcePath.as(path).resolveDelegateAbsolutePath();
            this.delegate.delete(normalized);
        }

        public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            Path normalized = InternalResourcePath.as(path).resolveDelegateAbsolutePath();
            return this.delegate.newByteChannel(normalized, options, (FileAttribute[])attrs);
        }

        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
            final InternalResourcePath castedPath = InternalResourcePath.as(dir);
            Path normalized = castedPath.resolveDelegateAbsolutePath();
            final DirectoryStream delegateStream = this.delegate.newDirectoryStream(normalized, filter);
            return new DirectoryStream<Path>(){

                @Override
                public Iterator<Path> iterator() {
                    return new ForwardingPath.ForwardingPathIterator<InternalResourcePath>(delegateStream.iterator(), castedPath::wrap);
                }

                @Override
                public void close() throws IOException {
                    delegateStream.close();
                }
            };
        }

        public Path toAbsolutePath(Path path) {
            return path.toAbsolutePath();
        }

        public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
            return path.toRealPath(linkOptions);
        }

        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
            Path normalized = InternalResourcePath.as(path).resolveDelegateAbsolutePath();
            return this.delegate.readAttributes(normalized, attributes, options);
        }

        public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
            Path normalized = InternalResourcePath.as(path).resolveDelegateAbsolutePath();
            this.delegate.setAttribute(normalized, attribute, value, options);
        }

        public void createLink(Path link, Path existing) throws IOException {
            Path normalizedLink = InternalResourcePath.as(link).resolveDelegateAbsolutePath();
            Path normalizedExisting = InternalResourcePath.as(existing).resolveDelegateAbsolutePath();
            this.delegate.createLink(normalizedLink, normalizedExisting);
        }

        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
            Path normalizedLink = InternalResourcePath.as(link).resolveDelegateAbsolutePath();
            Path normalizedTarget = InternalResourcePath.as(target).resolveDelegateAbsolutePath();
            this.delegate.createSymbolicLink(normalizedLink, normalizedTarget, (FileAttribute[])attrs);
        }

        public Path readSymbolicLink(Path link) throws IOException {
            InternalResourcePath castedPath = InternalResourcePath.as(link);
            Path normalizedLink = castedPath.resolveDelegateAbsolutePath();
            InternalResourcePath result = castedPath.wrap(this.delegate.readSymbolicLink(normalizedLink));
            result.resolveDelegateAbsolutePath();
            return result;
        }

        public String getSeparator() {
            return this.delegate.getSeparator();
        }

        public String getPathSeparator() {
            return this.delegate.getPathSeparator();
        }

        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) {
            Path normalized1 = InternalResourcePath.as(path1).resolveDelegateAbsolutePath();
            Path normalized2 = InternalResourcePath.as(path2).resolveDelegateAbsolutePath();
            return normalized1.equals(normalized2);
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return true;
        }

        @Override
        public boolean hasNoAccess() {
            return false;
        }

        @Override
        public boolean isHost() {
            return false;
        }

        private final class InternalResourcePath
        extends ForwardingPath<InternalResourcePath>
        implements ResetablePath {
            private final Path delegate;

            private InternalResourcePath(Path delegate) {
                this.delegate = delegate;
            }

            @Override
            InternalResourcePath wrap(Path path) {
                return path == null ? null : new InternalResourcePath(path);
            }

            @Override
            Path unwrap() {
                return this.delegate;
            }

            static InternalResourcePath as(Path path) {
                return (InternalResourcePath)path;
            }

            @Override
            public Path resolve(Path other) {
                if (this.isRelativeResourceRoot()) {
                    return other;
                }
                return super.resolve(other);
            }

            @Override
            public Path resolve(String other) {
                if (this.isRelativeResourceRoot()) {
                    return this.wrap(this.delegate.getFileSystem().getPath(other, new String[0]));
                }
                return super.resolve(other);
            }

            @Override
            public Path toAbsolutePath() {
                if (this.isAbsolute()) {
                    return this;
                }
                Path root = InternalResourceFileSystem.this.rootSupplier.get();
                Path resolvedAbsolute = this.isRelativeResourceRoot() ? root : root.resolve(this.delegate);
                return this.wrap(resolvedAbsolute);
            }

            @Override
            public Path toRealPath(LinkOption ... options) throws IOException {
                return this.wrap(this.resolveDelegateAbsolutePath().toRealPath(options));
            }

            @Override
            public URI toUri() {
                if (this.delegate.isAbsolute()) {
                    return super.toUri();
                }
                return this.toAbsolutePath().toUri();
            }

            Path resolveDelegateAbsolutePath() {
                Path root = InternalResourceFileSystem.this.rootSupplier.get();
                Path absolutePath = this.delegate.isAbsolute() ? this.delegate : root.resolve(this.delegate);
                if (!(absolutePath = absolutePath.normalize()).startsWith(root)) {
                    throw new SecurityException(this.delegate.toString());
                }
                return absolutePath;
            }

            boolean isRelativeResourceRoot() {
                if (!this.delegate.isAbsolute() && this.delegate.getNameCount() == 1) {
                    Path name = this.delegate.getFileName();
                    if (name == null) {
                        throw CompilerDirectives.shouldNotReachHere("Path has a name component but has no file name " + this.delegate);
                    }
                    return ".".equals(name.toString());
                }
                return false;
            }

            @Override
            public String getReinitializedPath() {
                return this.toAbsolutePath().toString();
            }

            @Override
            public URI getReinitializedURI() {
                return this.toUri();
            }
        }
    }

    private static final class InvalidFileSystem
    implements PolyglotFileSystem {
        private InvalidFileSystem() {
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return true;
        }

        @Override
        public boolean hasNoAccess() {
            return true;
        }

        @Override
        public boolean isHost() {
            return false;
        }

        public Path parsePath(URI uri) {
            throw new UnsupportedOperationException("ParsePath not supported on InvalidFileSystem");
        }

        public Path parsePath(String path) {
            throw new UnsupportedOperationException("ParsePath not supported on InvalidFileSystem");
        }

        public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) {
            throw FileSystems.forbidden(path);
        }

        public void createDirectory(Path dir, FileAttribute<?> ... attrs) {
            throw FileSystems.forbidden(dir);
        }

        public void delete(Path path) {
            throw FileSystems.forbidden(path);
        }

        public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
            throw FileSystems.forbidden(path);
        }

        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) {
            throw FileSystems.forbidden(dir);
        }

        public Path toAbsolutePath(Path path) {
            throw FileSystems.forbidden(path);
        }

        public Path toRealPath(Path path, LinkOption ... linkOptions) {
            throw FileSystems.forbidden(path);
        }

        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) {
            throw FileSystems.forbidden(path);
        }

        public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) {
            throw FileSystems.forbidden(path);
        }

        public void copy(Path source, Path target, CopyOption ... options) {
            throw FileSystems.forbidden(source);
        }

        public void move(Path source, Path target, CopyOption ... options) {
            throw FileSystems.forbidden(source);
        }

        public void createLink(Path link, Path existing) {
            throw FileSystems.forbidden(link);
        }

        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) {
            throw FileSystems.forbidden(link);
        }

        public Path readSymbolicLink(Path link) {
            throw FileSystems.forbidden(link);
        }

        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            throw FileSystems.forbidden(currentWorkingDirectory);
        }
    }

    static final class PreInitializeContextFileSystem
    implements PolyglotFileSystem {
        private org.graalvm.polyglot.io.FileSystem delegate;
        private Function<Path, PreInitializePath> factory;

        PreInitializeContextFileSystem(String tmpDir) {
            this.delegate = FileSystems.newDefaultFileSystem(tmpDir);
            this.factory = new ImageBuildTimeFactory();
        }

        void onPreInitializeContextEnd() {
            if (this.factory == null) {
                throw new IllegalStateException("Context pre-initialization already finished.");
            }
            ((ImageBuildTimeFactory)this.factory).onPreInitializeContextEnd();
            this.factory = null;
            this.delegate = INVALID_FILESYSTEM;
        }

        void onLoadPreinitializedContext(org.graalvm.polyglot.io.FileSystem newDelegate) {
            Objects.requireNonNull(newDelegate, "NewDelegate must be non null.");
            if (this.factory != null) {
                throw new IllegalStateException("Pre-initialized context already loaded.");
            }
            this.delegate = newDelegate;
            this.factory = new ImageExecutionTimeFactory();
        }

        private static void verifyImageState() {
            if (ImageInfo.inImageBuildtimeCode()) {
                throw CompilerDirectives.shouldNotReachHere("Reintroducing absolute path into an image heap.");
            }
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return polyglot.isInternalFileSystem(this.delegate);
        }

        @Override
        public boolean hasNoAccess() {
            return this.delegate instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegate).hasNoAccess();
        }

        @Override
        public boolean isHost() {
            return this.delegate instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegate).isHost();
        }

        public Path parsePath(URI path) {
            return this.factory.apply(this.delegate.parsePath(path));
        }

        public Path parsePath(String path) {
            return this.factory.apply(this.delegate.parsePath(path));
        }

        public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            this.delegate.checkAccess(PreInitializePath.unwrap(path), modes, linkOptions);
        }

        public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
            this.delegate.createDirectory(PreInitializePath.unwrap(dir), (FileAttribute[])attrs);
        }

        public void delete(Path path) throws IOException {
            this.delegate.delete(PreInitializePath.unwrap(path));
        }

        public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            return this.delegate.newByteChannel(PreInitializePath.unwrap(path), options, (FileAttribute[])attrs);
        }

        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
            final DirectoryStream delegateStream = this.delegate.newDirectoryStream(PreInitializePath.unwrap(dir), filter);
            return new DirectoryStream<Path>(){

                @Override
                public Iterator<Path> iterator() {
                    return new ForwardingPath.ForwardingPathIterator<PreInitializePath>(delegateStream.iterator(), factory);
                }

                @Override
                public void close() throws IOException {
                    delegateStream.close();
                }
            };
        }

        public Path toAbsolutePath(Path path) {
            return this.factory.apply(this.delegate.toAbsolutePath(PreInitializePath.unwrap(path)));
        }

        public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
            return this.factory.apply(this.delegate.toRealPath(PreInitializePath.unwrap(path), linkOptions));
        }

        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
            return this.delegate.readAttributes(PreInitializePath.unwrap(path), attributes, options);
        }

        public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
            this.delegate.setAttribute(PreInitializePath.unwrap(path), attribute, value, options);
        }

        public void copy(Path source, Path target, CopyOption ... options) throws IOException {
            this.delegate.copy(PreInitializePath.unwrap(source), PreInitializePath.unwrap(target), options);
        }

        public void move(Path source, Path target, CopyOption ... options) throws IOException {
            this.delegate.move(PreInitializePath.unwrap(source), PreInitializePath.unwrap(target), options);
        }

        public void createLink(Path link, Path existing) throws IOException {
            this.delegate.createLink(PreInitializePath.unwrap(link), PreInitializePath.unwrap(existing));
        }

        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
            this.delegate.createSymbolicLink(PreInitializePath.unwrap(link), PreInitializePath.unwrap(target), (FileAttribute[])attrs);
        }

        public Path readSymbolicLink(Path link) throws IOException {
            return this.factory.apply(this.delegate.readSymbolicLink(PreInitializePath.unwrap(link)));
        }

        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            this.delegate.setCurrentWorkingDirectory(PreInitializePath.unwrap(currentWorkingDirectory));
        }

        public String getSeparator() {
            return this.delegate.getSeparator();
        }

        public Charset getEncoding(Path path) {
            return this.delegate.getEncoding(PreInitializePath.unwrap(path));
        }

        public String getMimeType(Path path) {
            return this.delegate.getMimeType(PreInitializePath.unwrap(path));
        }

        public Path getTempDirectory() {
            return this.factory.apply(this.delegate.getTempDirectory());
        }

        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            return this.delegate.isSameFile(PreInitializePath.unwrap(path1), PreInitializePath.unwrap(path2), options);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof PreInitializeContextFileSystem)) {
                return false;
            }
            return this.delegate.equals(((PreInitializeContextFileSystem)other).delegate);
        }

        private final class ImageBuildTimeFactory
        extends ImageExecutionTimeFactory {
            private final Collection<Reference<PreInitializePath>> emittedPaths;

            private ImageBuildTimeFactory() {
                this.emittedPaths = new ArrayList<Reference<PreInitializePath>>();
            }

            @Override
            public PreInitializePath apply(Path path) {
                if (path == null) {
                    return null;
                }
                PreInitializePath preInitPath = super.apply(path);
                this.emittedPaths.add(new WeakReference<PreInitializePath>(preInitPath));
                return preInitPath;
            }

            void onPreInitializeContextEnd() {
                HashMap<String, Path> languageHomes = new HashMap<String, Path>();
                for (LanguageCache languageCache : LanguageCache.languages().values()) {
                    String languageHome = languageCache.getLanguageHome();
                    if (languageHome == null) continue;
                    languageHomes.put(languageCache.getId(), PreInitializeContextFileSystem.this.delegate.parsePath(languageHome));
                }
                for (Reference reference : this.emittedPaths) {
                    PreInitializePath path = (PreInitializePath)reference.get();
                    if (path == null) continue;
                    path.onPreInitializeContextEnd(languageHomes);
                }
            }
        }

        private class ImageExecutionTimeFactory
        implements Function<Path, PreInitializePath> {
            private ImageExecutionTimeFactory() {
            }

            @Override
            public PreInitializePath apply(Path path) {
                return path == null ? null : new PreInitializePath(path);
            }
        }

        private final class PreInitializePath
        extends ForwardingPath<PreInitializePath>
        implements ResetablePath {
            private volatile Object delegatePath;

            PreInitializePath(Path delegatePath) {
                this.delegatePath = delegatePath;
            }

            @Override
            PreInitializePath wrap(Path path) {
                return PreInitializeContextFileSystem.this.factory.apply(path);
            }

            @Override
            Path unwrap() {
                Path result = this.resolve(PreInitializeContextFileSystem.this.delegate);
                this.delegatePath = result;
                return result;
            }

            private Path resolve(org.graalvm.polyglot.io.FileSystem fs) {
                Object current = this.delegatePath;
                if (current instanceof Path) {
                    return (Path)current;
                }
                if (current instanceof ImageHeapPath) {
                    String newLanguageHome;
                    ImageHeapPath imageHeapPath = (ImageHeapPath)current;
                    String languageId = imageHeapPath.languageId;
                    String path = imageHeapPath.path;
                    Path result = languageId != null && (newLanguageHome = LanguageCache.languages().get(languageId).getLanguageHome()) != null ? fs.parsePath(newLanguageHome).resolve(path) : fs.parsePath(path);
                    return result;
                }
                throw new IllegalStateException("Unknown delegate " + current);
            }

            void onPreInitializeContextEnd(Map<String, Path> languageHomes) {
                Path internalPath = (Path)this.delegatePath;
                String languageId = null;
                for (Map.Entry<String, Path> e : languageHomes.entrySet()) {
                    if (!internalPath.startsWith(e.getValue())) continue;
                    internalPath = e.getValue().relativize(internalPath);
                    languageId = e.getKey();
                    break;
                }
                this.delegatePath = new ImageHeapPath(languageId, internalPath.toString(), internalPath.isAbsolute());
            }

            @Override
            public boolean isAbsolute() {
                if (PreInitializeContextFileSystem.this.delegate == INVALID_FILESYSTEM) {
                    return ((ImageHeapPath)this.delegatePath).absolute;
                }
                return super.isAbsolute();
            }

            @Override
            public String toString() {
                if (PreInitializeContextFileSystem.this.delegate == INVALID_FILESYSTEM) {
                    ImageHeapPath imageHeapPath = (ImageHeapPath)this.delegatePath;
                    if (imageHeapPath.languageId != null) {
                        throw new UnsupportedOperationException("ToString in the image heap form is supported only for files outside language homes.");
                    }
                    return imageHeapPath.path;
                }
                return super.toString();
            }

            @Override
            public String getReinitializedPath() {
                if (PreInitializeContextFileSystem.this.delegate != INVALID_FILESYSTEM) {
                    return this.toString();
                }
                PreInitializeContextFileSystem.verifyImageState();
                return this.resolve(FileSystems.newDefaultFileSystem(null)).toString();
            }

            @Override
            public URI getReinitializedURI() {
                if (PreInitializeContextFileSystem.this.delegate != INVALID_FILESYSTEM) {
                    return this.toUri();
                }
                PreInitializeContextFileSystem.verifyImageState();
                Path resolved = this.resolve(FileSystems.newDefaultFileSystem(null));
                if (!resolved.isAbsolute()) {
                    throw new IllegalArgumentException("Path must be absolute.");
                }
                return resolved.toUri();
            }
        }

        private record ImageHeapPath(String languageId, String path, boolean absolute) {
            private ImageHeapPath {
                assert (path != null);
            }
        }
    }

    static interface ResetablePath
    extends Path {
        public String getReinitializedPath();

        public URI getReinitializedURI();
    }

    private static abstract class ForwardingPath<T extends ForwardingPath<T>>
    implements Path {
        private ForwardingPath() {
        }

        abstract T wrap(Path var1);

        abstract Path unwrap();

        static Path unwrap(Path path) {
            if (path instanceof ForwardingPath) {
                ForwardingPath forwardingPath = (ForwardingPath)path;
                return forwardingPath.unwrap();
            }
            return path;
        }

        @Override
        public FileSystem getFileSystem() {
            return null;
        }

        @Override
        public boolean isAbsolute() {
            return this.unwrap().isAbsolute();
        }

        @Override
        public Path getRoot() {
            return this.wrap(this.unwrap().getRoot());
        }

        @Override
        public Path getFileName() {
            return this.wrap(this.unwrap().getFileName());
        }

        @Override
        public Path getParent() {
            return this.wrap(this.unwrap().getParent());
        }

        @Override
        public int getNameCount() {
            return this.unwrap().getNameCount();
        }

        @Override
        public Path getName(int index) {
            return this.wrap(this.unwrap().getName(index));
        }

        @Override
        public Path subpath(int beginIndex, int endIndex) {
            return this.wrap(this.unwrap().subpath(beginIndex, endIndex));
        }

        @Override
        public boolean startsWith(Path other) {
            return this.unwrap().startsWith(ForwardingPath.unwrap(other));
        }

        @Override
        public boolean startsWith(String other) {
            return this.unwrap().startsWith(other);
        }

        @Override
        public boolean endsWith(Path other) {
            return this.unwrap().endsWith(ForwardingPath.unwrap(other));
        }

        @Override
        public boolean endsWith(String other) {
            return this.unwrap().endsWith(other);
        }

        @Override
        public Path normalize() {
            return this.wrap(this.unwrap().normalize());
        }

        @Override
        public Path resolve(Path other) {
            return this.wrap(this.unwrap().resolve(ForwardingPath.unwrap(other)));
        }

        @Override
        public Path resolve(String other) {
            return this.wrap(this.unwrap().resolve(other));
        }

        @Override
        public Path resolveSibling(Path other) {
            return this.wrap(this.unwrap().resolveSibling(ForwardingPath.unwrap(other)));
        }

        @Override
        public Path resolveSibling(String other) {
            return this.wrap(this.unwrap().resolveSibling(other));
        }

        @Override
        public Path relativize(Path other) {
            return this.wrap(this.unwrap().relativize(ForwardingPath.unwrap(other)));
        }

        @Override
        public URI toUri() {
            return this.unwrap().toUri();
        }

        @Override
        public Path toAbsolutePath() {
            return this.wrap(this.unwrap().toAbsolutePath());
        }

        @Override
        public Path toRealPath(LinkOption ... options) throws IOException {
            return this.wrap(this.unwrap().toRealPath(options));
        }

        @Override
        public File toFile() {
            return this.unwrap().toFile();
        }

        @Override
        public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Path> iterator() {
            return new ForwardingPathIterator<ForwardingPath>(this.unwrap().iterator(), this::wrap);
        }

        @Override
        public int compareTo(Path other) {
            return this.unwrap().compareTo(ForwardingPath.unwrap(other));
        }

        @Override
        public int hashCode() {
            return this.unwrap().hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof ForwardingPath)) {
                return false;
            }
            return this.unwrap().equals(ForwardingPath.unwrap((Path)other));
        }

        @Override
        public String toString() {
            return this.unwrap().toString();
        }

        private static final class ForwardingPathIterator<T extends ForwardingPath<T>>
        implements Iterator<Path> {
            private final Iterator<Path> delegateIterator;
            private final Function<Path, T> wrap;

            ForwardingPathIterator(Iterator<Path> delegateIterator, Function<Path, T> wrap) {
                Objects.requireNonNull(delegateIterator, "DelegateIterator must be non-null.");
                Objects.requireNonNull(delegateIterator, "Wrap function must be non-null.");
                this.delegateIterator = delegateIterator;
                this.wrap = wrap;
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public Path next() {
                return (Path)this.wrap.apply(this.delegateIterator.next());
            }
        }
    }
}

