/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSMessageEndpoint;
import com.oracle.truffle.polyglot.enterprise.HSMessageEndpointGen;
import com.oracle.truffle.polyglot.enterprise.HSMessageTransport;
import com.oracle.truffle.polyglot.enterprise.NativeMessageEndpointGen;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.io.IOException;
import java.net.URI;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNICalls;
import org.graalvm.jniutils.JNIEntryPoint;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIClassCache;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativebridge.NativeIsolate;
import org.graalvm.nativebridge.NativeObjectHandles;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.polyglot.io.MessageEndpoint;
import org.graalvm.polyglot.io.MessageTransport;
import org.graalvm.word.PointerBase;

final class HSMessageTransportGen {
    HSMessageTransportGen() {
    }

    static HSMessageTransport createNativeToHS(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
        return new StartPoint(jNIEnv, jObject);
    }

    private static final class StartPoint
    extends HSMessageTransport {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        private static final BinaryMarshaller<URI> uRIMarshaller;
        final JNIData jniMethods_;

        StartPoint(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
            super(jNIEnv, jObject);
            JNIData jNIData = JNIData.cache_;
            if (jNIData == null) {
                jNIData = JNIData.cache_ = new JNIData(jNIEnv);
            }
            this.jniMethods_ = jNIData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MessageEndpoint open(URI uRI, MessageEndpoint messageEndpoint) throws IOException, MessageTransport.VetoException {
            HSMessageEndpoint hSMessageEndpoint;
            block15: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)256);
                int n3 = uRIMarshaller.inferSize((Object)uRI);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        uRIMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, (Object)uRI);
                        int n4 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n4);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n4, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)4, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setLong(CurrentIsolate.getIsolate().rawValue());
                    cCharPointerBinaryOutput.addressOf(2).setLong(NativeObjectHandles.create((Object)messageEndpoint));
                    cCharPointerBinaryOutput.addressOf(3).setJObject((JNI.JObject)jByteArray);
                    JNI.JObject jObject = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.openMethod, (JNI.JValue)cCharPointerBinaryOutput);
                    HSMessageEndpoint hSMessageEndpoint2 = hSMessageEndpoint = jObject.isNonNull() ? HSMessageEndpointGen.createNativeToHS(jNIEnv, jObject) : null;
                    if (cCharPointer == cCharPointer2) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free((PointerBase)cCharPointer);
            }
            return hSMessageEndpoint;
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
            uRIMarshaller = jNIConfig.lookupMarshaller(URI.class, new Class[0]);
        }

        static final class JNIData {
            static JNIData cache_;
            final JNI.JClass endPointClass;
            final JNICalls.JNIMethod openMethod;

            JNIData(JNI.JNIEnv jNIEnv) {
                this.endPointClass = JNIClassCache.lookupClass((JNI.JNIEnv)jNIEnv, EndPoint.class);
                this.openMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"open", (String)"(Lorg/graalvm/polyglot/io/MessageTransport;JJ[B)Lorg/graalvm/polyglot/io/MessageEndpoint;");
            }
        }
    }

    private static class EndPoint {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        private static final BinaryMarshaller<URI> uRIMarshaller;

        private EndPoint() {
        }

        @JNIEntryPoint
        static MessageEndpoint open(MessageTransport messageTransport, long l2, long l3, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                URI uRI = (URI)uRIMarshaller.read(binaryInput);
                MessageEndpoint messageEndpoint = messageTransport.open(uRI, l3 != 0L ? NativeMessageEndpointGen.create(NativeIsolate.get((long)l2), l3) : null);
                return messageEndpoint;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
            uRIMarshaller = jNIConfig.lookupMarshaller(URI.class, new Class[0]);
        }
    }
}

