/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.validation.constraints;

import org.apache.commons.validator.routines.CreditCardValidator;
import org.grails.datastore.gorm.validation.constraints.AbstractConstraint;
import org.springframework.context.MessageSource;
import org.springframework.validation.Errors;

public class CreditCardConstraint
extends AbstractConstraint {
    private final boolean creditCard;

    public CreditCardConstraint(Class<?> constraintOwningClass, String constraintPropertyName, Object constraintParameter, MessageSource messageSource) {
        super(constraintOwningClass, constraintPropertyName, constraintParameter, messageSource);
        this.creditCard = (Boolean)constraintParameter;
    }

    @Override
    protected void processValidate(Object target, Object propertyValue, Errors errors) {
        if (!this.creditCard) {
            return;
        }
        CreditCardValidator validator = new CreditCardValidator();
        if (!validator.isValid(propertyValue.toString())) {
            Object[] args = new Object[]{this.constraintPropertyName, this.constraintOwningClass, propertyValue};
            this.rejectValue(target, errors, "default.invalid.creditCard.message", "creditCard.invalid", args);
        }
    }

    @Override
    protected Object validateParameter(Object constraintParameter) {
        if (!(constraintParameter instanceof Boolean)) {
            throw new IllegalArgumentException("Parameter for constraint [creditCard] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must be a boolean value");
        }
        return constraintParameter;
    }

    @Override
    public String getName() {
        return "creditCard";
    }

    @Override
    public boolean supports(Class type) {
        return type != null && String.class.isAssignableFrom(type);
    }
}

